"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilePersistentOverrideAdapter = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _PersistentOverrideAdapter = require("./PersistentOverrideAdapter");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * FileOverrideAdapter provides file system based persistence for feature gate, dynamic config,
 * experiment, and layer overrides. It is designed for local development and CLI environments,
 * where browser-specific storage mechanisms (like localStorage) are not available.
 */
var FilePersistentOverrideAdapter = exports.FilePersistentOverrideAdapter = /*#__PURE__*/function (_PersistentOverrideAd) {
  function FilePersistentOverrideAdapter(filePath) {
    var _this;
    (0, _classCallCheck2.default)(this, FilePersistentOverrideAdapter);
    // Provide a dummy key since file persistence is used instead of localStorage.
    _this = _callSuper(this, FilePersistentOverrideAdapter, ['unused']);
    (0, _defineProperty2.default)(_this, "_browserWarningShown", false);
    _this._filePath = _path.default.resolve(filePath);

    // Check if the path exists and is a directory
    if (_fs.default.existsSync(_this._filePath)) {
      var stats = _fs.default.statSync(_this._filePath);
      if (stats.isDirectory()) {
        throw new Error("Path ".concat(_this._filePath, " is a directory, but a file is expected"));
      }
    }
    var dir = _path.default.dirname(_this._filePath);
    if (!_fs.default.existsSync(dir)) {
      _fs.default.mkdirSync(dir, {
        recursive: true
      });
    }
    _this.initFromStoredOverrides();
    return _this;
  }

  /**
   * Warns if the adapter is being used in a browser environment.
   * This is a non-blocking warning that will only be shown once.
   */
  (0, _inherits2.default)(FilePersistentOverrideAdapter, _PersistentOverrideAd);
  return (0, _createClass2.default)(FilePersistentOverrideAdapter, [{
    key: "warnIfBrowserEnvironment",
    value: function warnIfBrowserEnvironment() {
      // Check if we're in a browser environment
      if (typeof window !== 'undefined' && !this._browserWarningShown && window.console && window.console.warn) {
        this._browserWarningShown = true;

        // eslint-disable-next-line no-console
        window.console.warn('FilePersistentOverrideAdapter is being used in a browser environment. ' + 'This adapter is designed for local development and CLI environments. ' + 'For browser environments, use PersistentOverrideAdapter instead, which uses localStorage for persistence.');
      }
    }
  }, {
    key: "readStoredOverrides",
    value: function readStoredOverrides() {
      this.warnIfBrowserEnvironment();
      try {
        if (!_fs.default.existsSync(this._filePath)) {
          return {};
        }
        var data = _fs.default.readFileSync(this._filePath, 'utf8');
        return JSON.parse(data);
      } catch (_unused) {
        return {};
      }
    }
  }, {
    key: "saveOverridesToFile",
    value: function saveOverridesToFile(overrides) {
      this.warnIfBrowserEnvironment();
      try {
        _fs.default.writeFileSync(this._filePath, JSON.stringify(overrides, null, 2));
      } catch (error) {
        throw new Error("Failed to save overrides to file: ".concat(error));
      }
    }
  }, {
    key: "initFromStoredOverrides",
    value: function initFromStoredOverrides() {
      var storedOverrides = this.readStoredOverrides();
      this.applyOverrides(storedOverrides);
    }
  }, {
    key: "saveOverrides",
    value: function saveOverrides() {
      // Instead of saving to localStorage, persist using the file system.
      var overrides = this.getOverrides();
      this.saveOverridesToFile(overrides);
    }
  }, {
    key: "removeAllOverrides",
    value: function removeAllOverrides() {
      this.applyOverrides({});
      try {
        if (_fs.default.existsSync(this._filePath)) {
          _fs.default.unlinkSync(this._filePath);
        }
      } catch (error) {
        throw new Error("Failed to remove overrides file: ".concat(this._filePath, ": ").concat(error));
      }
    }
  }]);
}(_PersistentOverrideAdapter.PersistentOverrideAdapter);