import { type DynamicConfig, type Experiment, type FeatureGate, type Layer, type OverrideAdapter, type StatsigUser } from '@statsig/client-core';
export declare const LOCAL_STORAGE_KEY = "STATSIG_OVERRIDES";
export type LocalOverrides = {
    gates: Record<string, boolean>;
    configs: Record<string, Record<string, unknown>>;
    layers: LocalOverrides['configs'];
};
/**
 * Custom implementation of `@statsig/js-local-overrides` package with support for local storage
 * so we can keep the existing behavior where overrides are cached locally. Also designed for
 * compatibility with the old override system (eg. no `experiments` field, `configs` is used
 * instead).
 *
 * [Reference](https://github.com/statsig-io/js-client-monorepo/blob/main/packages/js-local-overrides/src/LocalOverrideAdapter.ts)
 */
export declare class PersistentOverrideAdapter implements OverrideAdapter {
    private _overrides;
    private _localStorageKey;
    private _djb2Map;
    constructor(localStorageKey: string);
    private parseStoredOverrides;
    private mergeOverrides;
    initFromStoredOverrides(): void;
    saveOverrides(): void;
    getOverrides(): LocalOverrides;
    protected applyOverrides(overrides: Partial<LocalOverrides>): void;
    setOverrides(overrides: Partial<LocalOverrides>): void;
    overrideGate(name: string, value: boolean): void;
    removeGateOverride(name: string): void;
    getGateOverride(current: FeatureGate, _user: StatsigUser): FeatureGate | null;
    overrideDynamicConfig(name: string, value: Record<string, unknown>): void;
    removeDynamicConfigOverride(name: string): void;
    getDynamicConfigOverride(current: DynamicConfig, _user: StatsigUser): DynamicConfig | null;
    overrideExperiment(name: string, value: Record<string, unknown>): void;
    removeExperimentOverride(name: string): void;
    getExperimentOverride(current: Experiment, _user: StatsigUser): Experiment | null;
    overrideLayer(name: string, value: Record<string, unknown>): void;
    removeLayerOverride(name: string): void;
    removeAllOverrides(): void;
    getLayerOverride(current: Layer, _user: StatsigUser): Layer | null;
    private _getConfigOverride;
}
