"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fg = fg;
exports.getBooleanFF = getBooleanFF;
exports.setBooleanFeatureFlagResolver = setBooleanFeatureFlagResolver;
var _resolvers = require("./resolvers");
/**
 * This creates a boolean flag resolver that allows calls to `getBooleanFF` inside of Platform components to use a Product's
 * feature flag client and LD project, rather than installing a feature flag client of their own, or passing those flags in via props.
 *
 * @param flagResolver
 */
function setBooleanFeatureFlagResolver(flagResolver) {
  (0, _resolvers.setBooleanResolver)(flagResolver);
}

/**
 * Returns the value of a feature flag. If the flag does not resolve, it returns the "false" as a default value.
 *
 * @deprecated Use {@link fg} function instead.
 * @param name
 */
function getBooleanFF(name) {
  return (0, _resolvers.resolveBooleanFlag)(name);
}

/**
 * Returns the value of a feature flag. If the flag does not resolve, it returns the "false" as a default value.
 *
 * @param name
 */
function fg(name) {
  return (0, _resolvers.resolveBooleanFlag)(name);
}