import type { Position } from '@atlaskit/pragmatic-drag-and-drop/types';
import type { Scrollable, Viewport } from './types';
type CanPartiallyScrollArgs = {
    max: Position;
    current: Position;
    change: Position;
};
type GetRemainderArgs = {
    current: Position;
    max: Position;
    change: Position;
};
export declare const getOverlap: ({ current, max, change }: GetRemainderArgs) => Position | null;
export declare const canPartiallyScroll: ({ max: rawMax, current, change, }: CanPartiallyScrollArgs) => boolean;
export declare const canScrollWindow: (viewport: Viewport, change: Position) => boolean;
export declare const getWindowOverlap: (viewport: Viewport, change: Position) => Position | null;
export declare const canScrollScrollable: (scrollable: Scrollable, change: Position) => boolean;
export declare const getScrollableOverlap: (scrollable: Scrollable, change: Position) => Position | null;
export {};
