"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.idleState = void 0;
exports.reducer = reducer;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _draggableLocation = require("../drag-drop-context/draggable-location");
var _rbdInvariant = require("../drag-drop-context/rbd-invariant");
var _constants = require("../droppable/drop-indicator/constants");
var _constants2 = require("./constants");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /**
 * All state for the Draggable in one place.
 *
 * This avoids rerenders (caused by unbatched state updates),
 * but also keeps state logic together.
 */
/**
 * The state of a draggable that is currently being dragged.
 * It does not have a clone.
 */

/**
 * The state of a draggable that is currently hiding,
 * because it its clone is being rendered instead.
 */

var idleState = exports.idleState = {
  type: 'idle',
  draggingOver: null
};
function getHidingState(mode) {
  return {
    type: 'hiding',
    draggingOver: null,
    mode: mode
  };
}
var getKeyboardPreviewOffset = {
  initial: function initial(_ref) {
    var direction = _ref.direction;
    /**
     * The initial offset doesn't use a base offset,
     * as no scrolling should have ocurred yet.
     */
    var _directionMapping$dir = _constants.directionMapping[direction],
      mainAxis = _directionMapping$dir.mainAxis,
      crossAxis = _directionMapping$dir.crossAxis;
    return (0, _defineProperty2.default)((0, _defineProperty2.default)({}, mainAxis.name, 0), crossAxis.name, _constants2.keyboardPreviewCrossAxisOffset);
  },
  home: function home(_ref3) {
    var direction = _ref3.droppable.direction,
      placeholderRect = _ref3.placeholderRect,
      draggableDimensions = _ref3.draggableDimensions;
    (0, _rbdInvariant.rbdInvariant)(placeholderRect, 'the placeholder should exist if in home position');

    /**
     * This base offset will result in the preview being over the placeholder
     * (same x and y coordinates).
     *
     * Consider this as `currentPosition - initialPosition` to find an offset.
     *
     * The `placeholderRect` is the **current** viewport-relative position of the
     * gap where the draggable originated from.
     *
     * The `draggableDimensions.rect` is the **initial** viewport-relative position
     * of the draggable.
     */
    var baseOffset = {
      x: placeholderRect.x - draggableDimensions.rect.x,
      y: placeholderRect.y - draggableDimensions.rect.y
    };
    var _directionMapping$dir2 = _constants.directionMapping[direction],
      mainAxis = _directionMapping$dir2.mainAxis,
      crossAxis = _directionMapping$dir2.crossAxis;
    return (0, _defineProperty2.default)((0, _defineProperty2.default)({}, mainAxis.name, baseOffset[mainAxis.name]), crossAxis.name, baseOffset[crossAxis.name] + _constants2.keyboardPreviewCrossAxisOffset);
  },
  away: function away(_ref5) {
    var direction = _ref5.droppable.direction,
      dropIndicatorRect = _ref5.dropIndicatorRect,
      draggableDimensions = _ref5.draggableDimensions;
    (0, _rbdInvariant.rbdInvariant)(dropIndicatorRect, 'the drop indicator should exist if in away position');

    /**
     * This base offset will result in the preview being over the drop indicator
     * (same x and y coordinates).
     *
     * Consider this as `currentPosition - initialPosition` to find an offset.
     *
     * The `dropIndicatorRect` is the **current** viewport-relative position of the
     * drop indicator.
     *
     * The `draggableDimensions.rect` is the **initial** viewport-relative position
     * of the draggable.
     */
    var baseOffset = {
      x: dropIndicatorRect.x - draggableDimensions.rect.x,
      y: dropIndicatorRect.y - draggableDimensions.rect.y
    };
    var _directionMapping$dir3 = _constants.directionMapping[direction],
      mainAxis = _directionMapping$dir3.mainAxis,
      crossAxis = _directionMapping$dir3.crossAxis;
    return (0, _defineProperty2.default)((0, _defineProperty2.default)({}, mainAxis.name, baseOffset[mainAxis.name] - 0.5 * draggableDimensions.rect[mainAxis.style.length]), crossAxis.name, baseOffset[crossAxis.name] + _constants2.keyboardPreviewCrossAxisOffset);
  }
};

/**
 * Determines the offset for the drag preview for keyboard drags.
 *
 * Unlike mouse drags, during which the drag preview follows the cursor,
 * the drag preview will follow the drop indicator for keyboard drags.
 */
function updateKeyboardPreview(state, _ref7) {
  var _update$destination;
  var update = _ref7.update,
    droppable = _ref7.droppable,
    draggableDimensions = _ref7.draggableDimensions,
    placeholderRect = _ref7.placeholderRect,
    dropIndicatorRect = _ref7.dropIndicatorRect;
  if (!droppable || !draggableDimensions) {
    return state;
  }
  var data = {
    droppable: droppable,
    draggableDimensions: draggableDimensions,
    placeholderRect: placeholderRect,
    dropIndicatorRect: dropIndicatorRect
  };
  var isHome = (0, _draggableLocation.isSameLocation)(update.source, (_update$destination = update.destination) !== null && _update$destination !== void 0 ? _update$destination : null);
  var previewOffset = isHome ? getKeyboardPreviewOffset.home(data) : getKeyboardPreviewOffset.away(data);
  if (!previewOffset) {
    return state;
  }
  return _objectSpread(_objectSpread({}, state), {}, {
    previewOffset: previewOffset
  });
}
function startDrag(state, _ref8) {
  var start = _ref8.start,
    previewOffset = _ref8.previewOffset;
  (0, _rbdInvariant.rbdInvariant)(state.type === 'idle', 'The draggable is idle.');
  var draggingOver = start.source.droppableId;
  var nextState = {
    type: 'dragging',
    draggingOver: draggingOver,
    location: null,
    start: start.source,
    draggableId: start.draggableId,
    mode: start.mode,
    previewOffset: previewOffset
  };
  return nextState;
}
function reducer(state, action) {
  if (action.type === 'START_POINTER_DRAG') {
    return startDrag(state, _objectSpread(_objectSpread({}, action.payload), {}, {
      previewOffset: {
        x: 0,
        y: 0
      }
    }));
  }
  if (action.type === 'START_KEYBOARD_DRAG') {
    var _action$payload = action.payload,
      draggableDimensions = _action$payload.draggableDimensions,
      droppable = _action$payload.droppable;
    return startDrag(state, _objectSpread(_objectSpread({}, action.payload), {}, {
      previewOffset: getKeyboardPreviewOffset.initial({
        draggableDimensions: draggableDimensions,
        direction: droppable.direction
      })
    }));
  }
  if (action.type === 'UPDATE_DRAG') {
    (0, _rbdInvariant.rbdInvariant)(state.type === 'dragging', 'The draggable is dragging.');
    var update = action.payload.update;
    var draggingOver = update.destination ? update.destination.droppableId : null;
    if (draggingOver === state.draggingOver) {
      // Save on an unnecessary rerender
      return state;
    }
    var nextState = _objectSpread(_objectSpread({}, state), {}, {
      draggingOver: draggingOver
    });
    return nextState;
  }
  if (action.type === 'UPDATE_POINTER_PREVIEW') {
    (0, _rbdInvariant.rbdInvariant)(state.type === 'dragging', 'The draggable is dragging.');
    var pointerLocation = action.payload.pointerLocation;
    var _nextState = _objectSpread(_objectSpread({}, state), {}, {
      previewOffset: {
        x: pointerLocation.current.input.clientX - pointerLocation.initial.input.clientX,
        y: pointerLocation.current.input.clientY - pointerLocation.initial.input.clientY
      }
    });
    return _nextState;
  }
  if (action.type === 'UPDATE_KEYBOARD_PREVIEW') {
    (0, _rbdInvariant.rbdInvariant)(state.type === 'dragging', 'The draggable is dragging.');
    if (state.type !== 'dragging') {
      return state;
    }
    var _nextState2 = updateKeyboardPreview(state, action.payload);
    return _nextState2;
  }
  if (action.type === 'DROP') {
    (0, _rbdInvariant.rbdInvariant)(state.type === 'dragging', 'The draggable is dragging.');
    return idleState;
  }
  if (action.type === 'START_HIDING') {
    (0, _rbdInvariant.rbdInvariant)(state.type === 'idle' || state.type === 'hiding');
    return getHidingState(action.payload.mode);
  }
  if (action.type === 'STOP_HIDING') {
    (0, _rbdInvariant.rbdInvariant)(state.type === 'hiding');
    return idleState;
  }
  return state;
}