import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import { useState } from 'react';
function createDroppableRegistry() {
  var droppableMap = new Map();
  var getEntry = function getEntry(_ref) {
    var _droppableMap$get;
    var droppableId = _ref.droppableId;
    return (_droppableMap$get = droppableMap.get(droppableId)) !== null && _droppableMap$get !== void 0 ? _droppableMap$get : null;
  };
  var updateListener = null;
  var setUpdateListener = function setUpdateListener(listener) {
    updateListener = listener;
  };
  var register = function register(entry) {
    var _updateListener;
    droppableMap.set(entry.droppableId, entry);
    (_updateListener = updateListener) === null || _updateListener === void 0 || _updateListener(entry);
    return function () {
      droppableMap.delete(entry.droppableId);
    };
  };
  return {
    getEntry: getEntry,
    register: register,
    setUpdateListener: setUpdateListener
  };
}
export function useDroppableRegistry() {
  var _useState = useState(createDroppableRegistry),
    _useState2 = _slicedToArray(_useState, 1),
    droppableRegistry = _useState2[0];
  return droppableRegistry;
}