/**
 * This is a vastly simplified version of the style marshal in `react-beautiful-dnd`.
 *
 * Most of the styles have been removed, as they are not required for native dragging.
 * They were only required in `react-beautiful-dnd` because it emulated dragging.
 */
import type { ContextId } from 'react-beautiful-dnd';
/**
 * Returns the rule string for drag handle styles.
 */
export declare function getDragHandleRuleString(contextId: ContextId): string;
type ContextIdAndNonce = {
    contextId: ContextId;
    nonce?: string;
};
export default function useStyleMarshal({ contextId, nonce }: ContextIdAndNonce): void;
export {};
