"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAFE_buildBelowMediaQueryCSS = exports.UNSAFE_buildAboveMediaQueryCSS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _constants = require("./constants");
var _mediaHelper = require("./media-helper");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } // eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
/**
 * Build a map of breakpoints to css with media queries and nested styles.
 *
 * @internal Not intended to be used outside of DST at this stage.
 * @experimental Not intended to be used outside of DST at this stage.
 *
 * @example
 * A map to build optional `display:none` for consumption on a div.
 * ```ts
 * const hideMediaQueries = buildAboveMediaQueryCSS({ display: 'none' });
 *
 * const Component = ({ hideAtBreakpoints: ('xs' | 'sm')[], children: ReactNode }) => {
 *   return <div css={hideAtBreakpoints.map(b => hideMediaQueries[b])}>{children}</div>;
 * }
 * ```
 *
 * This roughly builds a map that will look roughly like this (if done manually):
 * ```ts
 * {
 *   xxs: css({ '@media all': { display: 'none' } }),
 *   xs: css({ '@media (min-width: 30rem)': { display: 'none' } }),
 *   sm: css({ '@media (min-width: 48rem)': { display: 'none' } }),
 * }
 * ```
 */
var UNSAFE_buildAboveMediaQueryCSS = exports.UNSAFE_buildAboveMediaQueryCSS = function UNSAFE_buildAboveMediaQueryCSS(input) {
  return _constants.UNSAFE_BREAKPOINTS_ORDERED_LIST.reduce(function (acc, breakpoint) {
    return _objectSpread(_objectSpread({}, acc), {}, (0, _defineProperty2.default)({}, breakpoint, (0, _react.css)((0, _defineProperty2.default)({}, _mediaHelper.media.above[breakpoint], typeof input === 'function' ? input(breakpoint) : input))));
  }, {});
};

/**
 * Build a map of breakpoints to css with media queries and nested styles.
 *
 * @internal Not intended to be used outside of DST at this stage.
 * @experimental Not intended to be used outside of DST at this stage.
 *
 * @example
 * A map to build optional `display:none` for consumption on a div.
 * ```ts
 * const hideMediaQueries = buildBelowMediaQueryCSS({ display: 'none' });
 *
 * const Component = ({ hideAtBreakpoints: ('xs' | 'sm')[], children: ReactNode }) => {
 *   return <div css={hideAtBreakpoints.map(b => hideMediaQueries[b])}>{children}</div>;
 * }
 * ```
 *
 * This roughly builds a map that will look roughly like this (if done manually):
 * ```ts
 * {
 *   xs: css({ '@media not all and (min-width: 30rem)': { display: 'none' } }),
 *   sm: css({ '@media not all and (min-width: 48rem)': { display: 'none' } }),
 * }
 * ```
 */
var UNSAFE_buildBelowMediaQueryCSS = exports.UNSAFE_buildBelowMediaQueryCSS = function UNSAFE_buildBelowMediaQueryCSS(input) {
  return _constants.UNSAFE_BREAKPOINTS_ORDERED_LIST.reduce(function (acc, breakpoint) {
    if (breakpoint === 'xxs') {
      return acc;
    }
    return _objectSpread(_objectSpread({}, acc), {}, (0, _defineProperty2.default)({}, breakpoint, (0, _react.css)((0, _defineProperty2.default)({}, _mediaHelper.UNSAFE_media.below[breakpoint], typeof input === 'function' ? input(breakpoint) : input))));
  }, {});
};