/**
 * @jsxRuntime classic
 * @jsx jsx
 */

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { css, jsx } from '@emotion/react';
import { parseXcss } from '../xcss/xcss';
import { UNSAFE_buildAboveMediaQueryCSS, UNSAFE_buildBelowMediaQueryCSS } from './build-media-query-css';
const showAboveQueries = UNSAFE_buildAboveMediaQueryCSS({
  display: 'revert'
});
const showBelowQueries = UNSAFE_buildBelowMediaQueryCSS({
  display: 'revert'
});
const defaultHiddenStyles = css({
  display: 'none'
});
/**
 * Shows the content at a given breakpoint.  By default, content is hidden.  The primary use case is for visual presentation.
 * Mix `<Show above="md">` with `<Hide above="md">` to achieve content that shifts at a breakpoint.
 *
 * Please note:
 * - This only uses `display: none` and `display: revert` to show/hide, it does not skip rendering of children trees.
 * - As this is rendered at all times, there is little performance savings here (just that this is not painted).
 */
export const Show = ({
  above,
  below,
  children,
  as: AsElement = 'div',
  xcss
}) => {
  const resolvedStyles = parseXcss(xcss);
  return jsx(AsElement
  // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
  , {
    className: resolvedStyles.static,
    css: [defaultHiddenStyles, above && showAboveQueries[above], below && showBelowQueries[below], resolvedStyles.emotion]
  }, children);
};