// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// StorageLister helps list Storages.
// All objects returned here must be treated as read-only.
type StorageLister interface {
	// List lists all Storages in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Storage, err error)
	// Get retrieves the Storage from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Storage, error)
	StorageListerExpansion
}

// storageLister implements the StorageLister interface.
type storageLister struct {
	indexer cache.Indexer
}

// NewStorageLister returns a new StorageLister.
func NewStorageLister(indexer cache.Indexer) StorageLister {
	return &storageLister{indexer: indexer}
}

// List lists all Storages in the indexer.
func (s *storageLister) List(selector labels.Selector) (ret []*v1.Storage, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Storage))
	})
	return ret, err
}

// Get retrieves the Storage from the index for a given name.
func (s *storageLister) Get(name string) (*v1.Storage, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("storage"), name)
	}
	return obj.(*v1.Storage), nil
}
