/*  $Id: tlanguage.c,v 1.10 2005/03/14 21:18:27 marcusva Exp $
 *  
 *  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2004 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include "lingoteach.h"
#include <stdio.h>
#include <string.h>

#define FOK() fprintf(stdout,"Ok\n")

int 
main (int argc, char *argv[])
{
     lingConfig *settings = NULL;
     lingchar **langs = NULL;
     lingchar **trans = NULL;
     lingchar *single = NULL;
     lingchar *orig = NULL;
     int i = 0;
     int j = 0;
     int max = 0;

     if (argc != 5)
     {
	  printf ("Usage: %s name file lang_dtd lesson_dtd\n", argv[0]);
	  return -1;
     }

     /* get the settings */
     settings = ling_conf_init_config (argv[1], argv[2], argv[3], argv[4]);
     if (!settings)
     {
	  printf ("Error: settings not initialized!\n");
	  return -1;
     }
     
     /* get amount of languages */
     printf ("Testing ling_lang_get_max_languages()...");
     max = ling_lang_get_language_amount (settings);
     if (max == -1)
     {
	  printf ("Error: Could not retrieve amount of languages from %s!\n",
                  settings->langfile);
	  return -1;
     }
     FOK ();
     
     /* get the languages */
     printf ("Testing ling_lang_get_languages()...");
     langs = ling_lang_get_languages (settings);
     if (!langs)
     {
	  printf ("Error: Could not retrieve languages from %s!\n",
                  settings->langfile);
	  return -1;
     }
     FOK ();

     printf ("\tDumping %i languages:\n", max);
     while (langs[i])
     {
	  printf ("\t%i: %s \n", i, langs[i]);
	  i++;
     }

     /* get the language translations */
     i = 0;
     printf ("\nTesting ling_lang_get_lang_translations ()...");
     trans = ling_lang_get_lang_translations (settings, langs, langs[i]);
     if (!trans)
     {
	  printf ("Error: Could not retrieve the translations using language "
                  "%s\n",langs[i]);
	  return -1;
     }
     ling_strings_free (trans);
     FOK ();

     printf ("\tGetting the language translation for each language:\n");
     while (langs[i])
     {
	  /* get translations */
	  trans = ling_lang_get_lang_translations (settings, langs, langs[i]);
	  if (!trans)
	  {
	       printf ("Error: Could not retrieve the translations using "
                       "language %s\n",langs[i]);
	       return -1;
	  }
	  
	  /* print translations */
	  j = 0;
	  printf ("\tDumping translations:\n");
	  printf ("\tTranslation language: %s\n", langs[i]);
	  while (trans[j])
	  {
	       printf ("\t%i: %s <-> %s\n", j, langs[j], trans[j]);
	       j++;
	  }
          ling_strings_free (trans);
     	  i++;
     }
     
     /* get the language translations one after each other */
     i = 0;
     j = 0;
     printf ("\nTesting ling_lang_get_lang_translation...");
     single = ling_lang_get_lang_translation (settings, langs[0], langs[0]);
     if (!single)
     {
	  printf ("Error: Could not retrieve the translation using language "
                  "%s\n", langs[0]);
	  return -1;
     }
     FOK();

     printf ("\nTesting ling_lang_get_trans_language...");
     orig = ling_lang_get_trans_language (settings, langs[0], single);
     if (!orig)
     {
          fprintf (stdout, "Error: Could not retrieve the original "
		   "using language %s, translation %s\n", langs[0], single);
     }
     printf ("%s: %s <-> %s\n", langs[0], single, orig);
     
     ling_free (single);
     ling_free (orig);
     FOK ();

     printf ("\tGetting the language translation for each language\n");
     printf ("\tlanguage (using ling_lang_get_lang_translation()):\n");
     while (langs[i])
     {
	  j = 0;
	  printf ("\tLanguage to translate: %s\n", langs[i]);
	  while (langs[j])
	  {
	       single = ling_lang_get_lang_translation (settings, langs[i], 
							langs[j]);
	       if (!single)
	       {
		    printf ("Error: Could not retrieve the translation "
                            "using language %s and tranlation language "
                            "%s\n", langs[i], langs[j]);
		    return -1;
	       }
	       printf ("\t%i: %s <-> %s\n", i, langs[j], single);
	       ling_free (single);
	       j++;
	  }
	  i++;
     }

     printf ("All language tests OK.\n");
     printf ("Cleaning up...");
     ling_strings_free (langs);
     ling_conf_free_config (settings);
     FOK ();
     return 0;
}
