package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecStrategy invokes the aegis.ExecStrategy API synchronously
// api document: https://help.aliyun.com/api/aegis/execstrategy.html
func (client *Client) ExecStrategy(request *ExecStrategyRequest) (response *ExecStrategyResponse, err error) {
	response = CreateExecStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// ExecStrategyWithChan invokes the aegis.ExecStrategy API asynchronously
// api document: https://help.aliyun.com/api/aegis/execstrategy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecStrategyWithChan(request *ExecStrategyRequest) (<-chan *ExecStrategyResponse, <-chan error) {
	responseChan := make(chan *ExecStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecStrategyWithCallback invokes the aegis.ExecStrategy API asynchronously
// api document: https://help.aliyun.com/api/aegis/execstrategy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecStrategyWithCallback(request *ExecStrategyRequest, callback func(response *ExecStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecStrategyResponse
		var err error
		defer close(result)
		response, err = client.ExecStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecStrategyRequest is the request struct for api ExecStrategy
type ExecStrategyRequest struct {
	*requests.RpcRequest
	SourceIp   string           `position:"Query" name:"SourceIp"`
	StrategyId requests.Integer `position:"Query" name:"StrategyId"`
}

// ExecStrategyResponse is the response struct for api ExecStrategy
type ExecStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateExecStrategyRequest creates a request to invoke ExecStrategy API
func CreateExecStrategyRequest() (request *ExecStrategyRequest) {
	request = &ExecStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ExecStrategy", "vipaegis", "openAPI")
	return
}

// CreateExecStrategyResponse creates a response to parse from ExecStrategy response
func CreateExecStrategyResponse() (response *ExecStrategyResponse) {
	response = &ExecStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
