package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRecordingByContactId invokes the cloudcallcenter.ListRecordingByContactId API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecordingbycontactid.html
func (client *Client) ListRecordingByContactId(request *ListRecordingByContactIdRequest) (response *ListRecordingByContactIdResponse, err error) {
	response = CreateListRecordingByContactIdResponse()
	err = client.DoAction(request, response)
	return
}

// ListRecordingByContactIdWithChan invokes the cloudcallcenter.ListRecordingByContactId API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecordingbycontactid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecordingByContactIdWithChan(request *ListRecordingByContactIdRequest) (<-chan *ListRecordingByContactIdResponse, <-chan error) {
	responseChan := make(chan *ListRecordingByContactIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRecordingByContactId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRecordingByContactIdWithCallback invokes the cloudcallcenter.ListRecordingByContactId API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecordingbycontactid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecordingByContactIdWithCallback(request *ListRecordingByContactIdRequest, callback func(response *ListRecordingByContactIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRecordingByContactIdResponse
		var err error
		defer close(result)
		response, err = client.ListRecordingByContactId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRecordingByContactIdRequest is the request struct for api ListRecordingByContactId
type ListRecordingByContactIdRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	ContactId  string `position:"Query" name:"ContactId"`
}

// ListRecordingByContactIdResponse is the response struct for api ListRecordingByContactId
type ListRecordingByContactIdResponse struct {
	*responses.BaseResponse
	RequestId      string                               `json:"RequestId" xml:"RequestId"`
	Success        bool                                 `json:"Success" xml:"Success"`
	Code           string                               `json:"Code" xml:"Code"`
	Message        string                               `json:"Message" xml:"Message"`
	HttpStatusCode int                                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Recordings     RecordingsInListRecordingByContactId `json:"Recordings" xml:"Recordings"`
}

// CreateListRecordingByContactIdRequest creates a request to invoke ListRecordingByContactId API
func CreateListRecordingByContactIdRequest() (request *ListRecordingByContactIdRequest) {
	request = &ListRecordingByContactIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListRecordingByContactId", "", "")
	request.Method = requests.POST
	return
}

// CreateListRecordingByContactIdResponse creates a response to parse from ListRecordingByContactId response
func CreateListRecordingByContactIdResponse() (response *ListRecordingByContactIdResponse) {
	response = &ListRecordingByContactIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
