package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DispatchGameSlot invokes the cloudgameapi.DispatchGameSlot API synchronously
func (client *Client) DispatchGameSlot(request *DispatchGameSlotRequest) (response *DispatchGameSlotResponse, err error) {
	response = CreateDispatchGameSlotResponse()
	err = client.DoAction(request, response)
	return
}

// DispatchGameSlotWithChan invokes the cloudgameapi.DispatchGameSlot API asynchronously
func (client *Client) DispatchGameSlotWithChan(request *DispatchGameSlotRequest) (<-chan *DispatchGameSlotResponse, <-chan error) {
	responseChan := make(chan *DispatchGameSlotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DispatchGameSlot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DispatchGameSlotWithCallback invokes the cloudgameapi.DispatchGameSlot API asynchronously
func (client *Client) DispatchGameSlotWithCallback(request *DispatchGameSlotRequest, callback func(response *DispatchGameSlotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DispatchGameSlotResponse
		var err error
		defer close(result)
		response, err = client.DispatchGameSlot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DispatchGameSlotRequest is the request struct for api DispatchGameSlot
type DispatchGameSlotRequest struct {
	*requests.RpcRequest
	GameId         string           `position:"Body" name:"GameId"`
	Cancel         requests.Boolean `position:"Body" name:"Cancel"`
	GameSession    string           `position:"Body" name:"GameSession"`
	SystemInfo     string           `position:"Body" name:"SystemInfo"`
	UserId         string           `position:"Body" name:"UserId"`
	Reconnect      requests.Boolean `position:"Body" name:"Reconnect"`
	AccessKey      string           `position:"Body" name:"AccessKey"`
	ClientIp       string           `position:"Body" name:"ClientIp"`
	RegionName     string           `position:"Body" name:"RegionName"`
	GameCommand    string           `position:"Body" name:"GameCommand"`
	BizParam       string           `position:"Body" name:"BizParam"`
	GameStartParam string           `position:"Body" name:"GameStartParam"`
}

// DispatchGameSlotResponse is the response struct for api DispatchGameSlot
type DispatchGameSlotResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	GameId      string `json:"GameId" xml:"GameId"`
	GameSession string `json:"GameSession" xml:"GameSession"`
	QueueState  int    `json:"QueueState" xml:"QueueState"`
	QueueCode   int    `json:"QueueCode" xml:"QueueCode"`
	Message     string `json:"Message" xml:"Message"`
	RegionName  string `json:"RegionName" xml:"RegionName"`
	UserId      string `json:"UserId" xml:"UserId"`
}

// CreateDispatchGameSlotRequest creates a request to invoke DispatchGameSlot API
func CreateDispatchGameSlotRequest() (request *DispatchGameSlotRequest) {
	request = &DispatchGameSlotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "DispatchGameSlot", "", "")
	request.Method = requests.POST
	return
}

// CreateDispatchGameSlotResponse creates a response to parse from DispatchGameSlot response
func CreateDispatchGameSlotResponse() (response *DispatchGameSlotResponse) {
	response = &DispatchGameSlotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
