package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGroupMember invokes the codeup.AddGroupMember API synchronously
func (client *Client) AddGroupMember(request *AddGroupMemberRequest) (response *AddGroupMemberResponse, err error) {
	response = CreateAddGroupMemberResponse()
	err = client.DoAction(request, response)
	return
}

// AddGroupMemberWithChan invokes the codeup.AddGroupMember API asynchronously
func (client *Client) AddGroupMemberWithChan(request *AddGroupMemberRequest) (<-chan *AddGroupMemberResponse, <-chan error) {
	responseChan := make(chan *AddGroupMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGroupMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGroupMemberWithCallback invokes the codeup.AddGroupMember API asynchronously
func (client *Client) AddGroupMemberWithCallback(request *AddGroupMemberRequest, callback func(response *AddGroupMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGroupMemberResponse
		var err error
		defer close(result)
		response, err = client.AddGroupMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGroupMemberRequest is the request struct for api AddGroupMember
type AddGroupMemberRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	ClientToken    string           `position:"Query" name:"ClientToken"`
	GroupId        requests.Integer `position:"Path" name:"GroupId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
}

// AddGroupMemberResponse is the response struct for api AddGroupMember
type AddGroupMemberResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateAddGroupMemberRequest creates a request to invoke AddGroupMember API
func CreateAddGroupMemberRequest() (request *AddGroupMemberRequest) {
	request = &AddGroupMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "AddGroupMember", "/api/v4/groups/[GroupId]/members", "", "")
	request.Method = requests.POST
	return
}

// CreateAddGroupMemberResponse creates a response to parse from AddGroupMember response
func CreateAddGroupMemberResponse() (response *AddGroupMemberResponse) {
	response = &AddGroupMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
