package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMergeRequestComment invokes the codeup.UpdateMergeRequestComment API synchronously
func (client *Client) UpdateMergeRequestComment(request *UpdateMergeRequestCommentRequest) (response *UpdateMergeRequestCommentResponse, err error) {
	response = CreateUpdateMergeRequestCommentResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMergeRequestCommentWithChan invokes the codeup.UpdateMergeRequestComment API asynchronously
func (client *Client) UpdateMergeRequestCommentWithChan(request *UpdateMergeRequestCommentRequest) (<-chan *UpdateMergeRequestCommentResponse, <-chan error) {
	responseChan := make(chan *UpdateMergeRequestCommentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMergeRequestComment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMergeRequestCommentWithCallback invokes the codeup.UpdateMergeRequestComment API asynchronously
func (client *Client) UpdateMergeRequestCommentWithCallback(request *UpdateMergeRequestCommentRequest, callback func(response *UpdateMergeRequestCommentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMergeRequestCommentResponse
		var err error
		defer close(result)
		response, err = client.UpdateMergeRequestComment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMergeRequestCommentRequest is the request struct for api UpdateMergeRequestComment
type UpdateMergeRequestCommentRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	MergeRequestId requests.Integer `position:"Path" name:"MergeRequestId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	NoteId         requests.Integer `position:"Path" name:"NoteId"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// UpdateMergeRequestCommentResponse is the response struct for api UpdateMergeRequestComment
type UpdateMergeRequestCommentResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateUpdateMergeRequestCommentRequest creates a request to invoke UpdateMergeRequestComment API
func CreateUpdateMergeRequestCommentRequest() (request *UpdateMergeRequestCommentRequest) {
	request = &UpdateMergeRequestCommentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "UpdateMergeRequestComment", "/api/v3/projects/[ProjectId]/merge_requests/[MergeRequestId]/notes/[NoteId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateMergeRequestCommentResponse creates a response to parse from UpdateMergeRequestComment response
func CreateUpdateMergeRequestCommentResponse() (response *UpdateMergeRequestCommentResponse) {
	response = &UpdateMergeRequestCommentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
