package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTagsBatch invokes the dbfs.DeleteTagsBatch API synchronously
func (client *Client) DeleteTagsBatch(request *DeleteTagsBatchRequest) (response *DeleteTagsBatchResponse, err error) {
	response = CreateDeleteTagsBatchResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTagsBatchWithChan invokes the dbfs.DeleteTagsBatch API asynchronously
func (client *Client) DeleteTagsBatchWithChan(request *DeleteTagsBatchRequest) (<-chan *DeleteTagsBatchResponse, <-chan error) {
	responseChan := make(chan *DeleteTagsBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTagsBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTagsBatchWithCallback invokes the dbfs.DeleteTagsBatch API asynchronously
func (client *Client) DeleteTagsBatchWithCallback(request *DeleteTagsBatchRequest, callback func(response *DeleteTagsBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTagsBatchResponse
		var err error
		defer close(result)
		response, err = client.DeleteTagsBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTagsBatchRequest is the request struct for api DeleteTagsBatch
type DeleteTagsBatchRequest struct {
	*requests.RpcRequest
	DbfsList string `position:"Query" name:"DbfsList"`
	Tags     string `position:"Query" name:"Tags"`
}

// DeleteTagsBatchResponse is the response struct for api DeleteTagsBatch
type DeleteTagsBatchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTagsBatchRequest creates a request to invoke DeleteTagsBatch API
func CreateDeleteTagsBatchRequest() (request *DeleteTagsBatchRequest) {
	request = &DeleteTagsBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "DeleteTagsBatch", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTagsBatchResponse creates a response to parse from DeleteTagsBatch response
func CreateDeleteTagsBatchResponse() (response *DeleteTagsBatchResponse) {
	response = &DeleteTagsBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
