package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelImagePipelineExecution invokes the ecs.CancelImagePipelineExecution API synchronously
func (client *Client) CancelImagePipelineExecution(request *CancelImagePipelineExecutionRequest) (response *CancelImagePipelineExecutionResponse, err error) {
	response = CreateCancelImagePipelineExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// CancelImagePipelineExecutionWithChan invokes the ecs.CancelImagePipelineExecution API asynchronously
func (client *Client) CancelImagePipelineExecutionWithChan(request *CancelImagePipelineExecutionRequest) (<-chan *CancelImagePipelineExecutionResponse, <-chan error) {
	responseChan := make(chan *CancelImagePipelineExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelImagePipelineExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelImagePipelineExecutionWithCallback invokes the ecs.CancelImagePipelineExecution API asynchronously
func (client *Client) CancelImagePipelineExecutionWithCallback(request *CancelImagePipelineExecutionRequest, callback func(response *CancelImagePipelineExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelImagePipelineExecutionResponse
		var err error
		defer close(result)
		response, err = client.CancelImagePipelineExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelImagePipelineExecutionRequest is the request struct for api CancelImagePipelineExecution
type CancelImagePipelineExecutionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                           `position:"Query" name:"ResourceOwnerId"`
	ExecutionId          string                                     `position:"Query" name:"ExecutionId"`
	TemplateTag          *[]CancelImagePipelineExecutionTemplateTag `position:"Query" name:"TemplateTag"  type:"Repeated"`
	ResourceOwnerAccount string                                     `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                     `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                           `position:"Query" name:"OwnerId"`
}

// CancelImagePipelineExecutionTemplateTag is a repeated param struct in CancelImagePipelineExecutionRequest
type CancelImagePipelineExecutionTemplateTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CancelImagePipelineExecutionResponse is the response struct for api CancelImagePipelineExecution
type CancelImagePipelineExecutionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelImagePipelineExecutionRequest creates a request to invoke CancelImagePipelineExecution API
func CreateCancelImagePipelineExecutionRequest() (request *CancelImagePipelineExecutionRequest) {
	request = &CancelImagePipelineExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CancelImagePipelineExecution", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelImagePipelineExecutionResponse creates a response to parse from CancelImagePipelineExecution response
func CreateCancelImagePipelineExecutionResponse() (response *CancelImagePipelineExecutionResponse) {
	response = &CancelImagePipelineExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
