package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLocalitySetting invokes the edas.UpdateLocalitySetting API synchronously
func (client *Client) UpdateLocalitySetting(request *UpdateLocalitySettingRequest) (response *UpdateLocalitySettingResponse, err error) {
	response = CreateUpdateLocalitySettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLocalitySettingWithChan invokes the edas.UpdateLocalitySetting API asynchronously
func (client *Client) UpdateLocalitySettingWithChan(request *UpdateLocalitySettingRequest) (<-chan *UpdateLocalitySettingResponse, <-chan error) {
	responseChan := make(chan *UpdateLocalitySettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLocalitySetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLocalitySettingWithCallback invokes the edas.UpdateLocalitySetting API asynchronously
func (client *Client) UpdateLocalitySettingWithCallback(request *UpdateLocalitySettingRequest, callback func(response *UpdateLocalitySettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLocalitySettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateLocalitySetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLocalitySettingRequest is the request struct for api UpdateLocalitySetting
type UpdateLocalitySettingRequest struct {
	*requests.RoaRequest
	NamespaceId string           `position:"Query" name:"NamespaceId"`
	AppId       string           `position:"Query" name:"AppId"`
	Threshold   requests.Float   `position:"Query" name:"Threshold"`
	Region      string           `position:"Query" name:"Region"`
	Enabled     requests.Boolean `position:"Query" name:"Enabled"`
}

// UpdateLocalitySettingResponse is the response struct for api UpdateLocalitySetting
type UpdateLocalitySettingResponse struct {
	*responses.BaseResponse
	Code           int    `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateUpdateLocalitySettingRequest creates a request to invoke UpdateLocalitySetting API
func CreateUpdateLocalitySettingRequest() (request *UpdateLocalitySettingRequest) {
	request = &UpdateLocalitySettingRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateLocalitySetting", "/pop/sp/applications/locality/setting", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLocalitySettingResponse creates a response to parse from UpdateLocalitySetting response
func CreateUpdateLocalitySettingResponse() (response *UpdateLocalitySettingResponse) {
	response = &UpdateLocalitySettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
