package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecoverableTimeRange invokes the hbase.DescribeRecoverableTimeRange API synchronously
func (client *Client) DescribeRecoverableTimeRange(request *DescribeRecoverableTimeRangeRequest) (response *DescribeRecoverableTimeRangeResponse, err error) {
	response = CreateDescribeRecoverableTimeRangeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecoverableTimeRangeWithChan invokes the hbase.DescribeRecoverableTimeRange API asynchronously
func (client *Client) DescribeRecoverableTimeRangeWithChan(request *DescribeRecoverableTimeRangeRequest) (<-chan *DescribeRecoverableTimeRangeResponse, <-chan error) {
	responseChan := make(chan *DescribeRecoverableTimeRangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecoverableTimeRange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecoverableTimeRangeWithCallback invokes the hbase.DescribeRecoverableTimeRange API asynchronously
func (client *Client) DescribeRecoverableTimeRangeWithCallback(request *DescribeRecoverableTimeRangeRequest, callback func(response *DescribeRecoverableTimeRangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecoverableTimeRangeResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecoverableTimeRange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecoverableTimeRangeRequest is the request struct for api DescribeRecoverableTimeRange
type DescribeRecoverableTimeRangeRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeRecoverableTimeRangeResponse is the response struct for api DescribeRecoverableTimeRange
type DescribeRecoverableTimeRangeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TimeBegin string `json:"TimeBegin" xml:"TimeBegin"`
	TimeEnd   string `json:"TimeEnd" xml:"TimeEnd"`
}

// CreateDescribeRecoverableTimeRangeRequest creates a request to invoke DescribeRecoverableTimeRange API
func CreateDescribeRecoverableTimeRangeRequest() (request *DescribeRecoverableTimeRangeRequest) {
	request = &DescribeRecoverableTimeRangeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeRecoverableTimeRange", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRecoverableTimeRangeResponse creates a response to parse from DescribeRecoverableTimeRange response
func CreateDescribeRecoverableTimeRangeResponse() (response *DescribeRecoverableTimeRangeResponse) {
	response = &DescribeRecoverableTimeRangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
