package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelJoinPermissionAuthOrder invokes the linkwan.CancelJoinPermissionAuthOrder API synchronously
func (client *Client) CancelJoinPermissionAuthOrder(request *CancelJoinPermissionAuthOrderRequest) (response *CancelJoinPermissionAuthOrderResponse, err error) {
	response = CreateCancelJoinPermissionAuthOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CancelJoinPermissionAuthOrderWithChan invokes the linkwan.CancelJoinPermissionAuthOrder API asynchronously
func (client *Client) CancelJoinPermissionAuthOrderWithChan(request *CancelJoinPermissionAuthOrderRequest) (<-chan *CancelJoinPermissionAuthOrderResponse, <-chan error) {
	responseChan := make(chan *CancelJoinPermissionAuthOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelJoinPermissionAuthOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelJoinPermissionAuthOrderWithCallback invokes the linkwan.CancelJoinPermissionAuthOrder API asynchronously
func (client *Client) CancelJoinPermissionAuthOrderWithCallback(request *CancelJoinPermissionAuthOrderRequest, callback func(response *CancelJoinPermissionAuthOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelJoinPermissionAuthOrderResponse
		var err error
		defer close(result)
		response, err = client.CancelJoinPermissionAuthOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelJoinPermissionAuthOrderRequest is the request struct for api CancelJoinPermissionAuthOrder
type CancelJoinPermissionAuthOrderRequest struct {
	*requests.RpcRequest
	OrderId     string `position:"Query" name:"OrderId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// CancelJoinPermissionAuthOrderResponse is the response struct for api CancelJoinPermissionAuthOrder
type CancelJoinPermissionAuthOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCancelJoinPermissionAuthOrderRequest creates a request to invoke CancelJoinPermissionAuthOrder API
func CreateCancelJoinPermissionAuthOrderRequest() (request *CancelJoinPermissionAuthOrderRequest) {
	request = &CancelJoinPermissionAuthOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "CancelJoinPermissionAuthOrder", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelJoinPermissionAuthOrderResponse creates a response to parse from CancelJoinPermissionAuthOrder response
func CreateCancelJoinPermissionAuthOrderResponse() (response *CancelJoinPermissionAuthOrderResponse) {
	response = &CancelJoinPermissionAuthOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
