package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayTransferPackets invokes the linkwan.ListGatewayTransferPackets API synchronously
func (client *Client) ListGatewayTransferPackets(request *ListGatewayTransferPacketsRequest) (response *ListGatewayTransferPacketsResponse, err error) {
	response = CreateListGatewayTransferPacketsResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayTransferPacketsWithChan invokes the linkwan.ListGatewayTransferPackets API asynchronously
func (client *Client) ListGatewayTransferPacketsWithChan(request *ListGatewayTransferPacketsRequest) (<-chan *ListGatewayTransferPacketsResponse, <-chan error) {
	responseChan := make(chan *ListGatewayTransferPacketsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayTransferPackets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayTransferPacketsWithCallback invokes the linkwan.ListGatewayTransferPackets API asynchronously
func (client *Client) ListGatewayTransferPacketsWithCallback(request *ListGatewayTransferPacketsRequest, callback func(response *ListGatewayTransferPacketsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayTransferPacketsResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayTransferPackets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayTransferPacketsRequest is the request struct for api ListGatewayTransferPackets
type ListGatewayTransferPacketsRequest struct {
	*requests.RpcRequest
	EndMillis     requests.Integer `position:"Query" name:"EndMillis"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	GwEui         string           `position:"Query" name:"GwEui"`
	Ascending     requests.Boolean `position:"Query" name:"Ascending"`
	DevEui        string           `position:"Query" name:"DevEui"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	Category      string           `position:"Query" name:"Category"`
	BeginMillis   requests.Integer `position:"Query" name:"BeginMillis"`
	SortingField  string           `position:"Query" name:"SortingField"`
}

// ListGatewayTransferPacketsResponse is the response struct for api ListGatewayTransferPackets
type ListGatewayTransferPacketsResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"RequestId" xml:"RequestId"`
	Success   bool                             `json:"Success" xml:"Success"`
	Data      DataInListGatewayTransferPackets `json:"Data" xml:"Data"`
}

// CreateListGatewayTransferPacketsRequest creates a request to invoke ListGatewayTransferPackets API
func CreateListGatewayTransferPacketsRequest() (request *ListGatewayTransferPacketsRequest) {
	request = &ListGatewayTransferPacketsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListGatewayTransferPackets", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayTransferPacketsResponse creates a response to parse from ListGatewayTransferPackets response
func CreateListGatewayTransferPacketsResponse() (response *ListGatewayTransferPacketsResponse) {
	response = &ListGatewayTransferPacketsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
