package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableAndCleanRecycleBin invokes the nas.DisableAndCleanRecycleBin API synchronously
func (client *Client) DisableAndCleanRecycleBin(request *DisableAndCleanRecycleBinRequest) (response *DisableAndCleanRecycleBinResponse, err error) {
	response = CreateDisableAndCleanRecycleBinResponse()
	err = client.DoAction(request, response)
	return
}

// DisableAndCleanRecycleBinWithChan invokes the nas.DisableAndCleanRecycleBin API asynchronously
func (client *Client) DisableAndCleanRecycleBinWithChan(request *DisableAndCleanRecycleBinRequest) (<-chan *DisableAndCleanRecycleBinResponse, <-chan error) {
	responseChan := make(chan *DisableAndCleanRecycleBinResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableAndCleanRecycleBin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableAndCleanRecycleBinWithCallback invokes the nas.DisableAndCleanRecycleBin API asynchronously
func (client *Client) DisableAndCleanRecycleBinWithCallback(request *DisableAndCleanRecycleBinRequest, callback func(response *DisableAndCleanRecycleBinResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableAndCleanRecycleBinResponse
		var err error
		defer close(result)
		response, err = client.DisableAndCleanRecycleBin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableAndCleanRecycleBinRequest is the request struct for api DisableAndCleanRecycleBin
type DisableAndCleanRecycleBinRequest struct {
	*requests.RpcRequest
	FileSystemId string `position:"Query" name:"FileSystemId"`
}

// DisableAndCleanRecycleBinResponse is the response struct for api DisableAndCleanRecycleBin
type DisableAndCleanRecycleBinResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableAndCleanRecycleBinRequest creates a request to invoke DisableAndCleanRecycleBin API
func CreateDisableAndCleanRecycleBinRequest() (request *DisableAndCleanRecycleBinRequest) {
	request = &DisableAndCleanRecycleBinRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DisableAndCleanRecycleBin", "", "")
	request.Method = requests.GET
	return
}

// CreateDisableAndCleanRecycleBinResponse creates a response to parse from DisableAndCleanRecycleBin response
func CreateDisableAndCleanRecycleBinResponse() (response *DisableAndCleanRecycleBinResponse) {
	response = &DisableAndCleanRecycleBinResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
