package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResolverRule invokes the pvtz.DescribeResolverRule API synchronously
func (client *Client) DescribeResolverRule(request *DescribeResolverRuleRequest) (response *DescribeResolverRuleResponse, err error) {
	response = CreateDescribeResolverRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResolverRuleWithChan invokes the pvtz.DescribeResolverRule API asynchronously
func (client *Client) DescribeResolverRuleWithChan(request *DescribeResolverRuleRequest) (<-chan *DescribeResolverRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeResolverRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResolverRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResolverRuleWithCallback invokes the pvtz.DescribeResolverRule API asynchronously
func (client *Client) DescribeResolverRuleWithCallback(request *DescribeResolverRuleRequest, callback func(response *DescribeResolverRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResolverRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeResolverRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResolverRuleRequest is the request struct for api DescribeResolverRule
type DescribeResolverRuleRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
	RuleId       string `position:"Query" name:"RuleId"`
}

// DescribeResolverRuleResponse is the response struct for api DescribeResolverRule
type DescribeResolverRuleResponse struct {
	*responses.BaseResponse
	RequestId       string      `json:"RequestId" xml:"RequestId"`
	CreateTime      string      `json:"CreateTime" xml:"CreateTime"`
	Name            string      `json:"Name" xml:"Name"`
	ZoneName        string      `json:"ZoneName" xml:"ZoneName"`
	Type            string      `json:"Type" xml:"Type"`
	EndpointName    string      `json:"EndpointName" xml:"EndpointName"`
	EndpointId      string      `json:"EndpointId" xml:"EndpointId"`
	UpdateTime      string      `json:"UpdateTime" xml:"UpdateTime"`
	UpdateTimestamp int64       `json:"UpdateTimestamp" xml:"UpdateTimestamp"`
	Id              string      `json:"Id" xml:"Id"`
	CreateTimestamp int64       `json:"CreateTimestamp" xml:"CreateTimestamp"`
	ForwardIps      []ForwardIp `json:"ForwardIps" xml:"ForwardIps"`
	BindVpcs        []Vpc       `json:"BindVpcs" xml:"BindVpcs"`
}

// CreateDescribeResolverRuleRequest creates a request to invoke DescribeResolverRule API
func CreateDescribeResolverRuleRequest() (request *DescribeResolverRuleRequest) {
	request = &DescribeResolverRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeResolverRule", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeResolverRuleResponse creates a response to parse from DescribeResolverRule response
func CreateDescribeResolverRuleResponse() (response *DescribeResolverRuleResponse) {
	response = &DescribeResolverRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
