package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHotWordsTasks invokes the qualitycheck.ListHotWordsTasks API synchronously
func (client *Client) ListHotWordsTasks(request *ListHotWordsTasksRequest) (response *ListHotWordsTasksResponse, err error) {
	response = CreateListHotWordsTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListHotWordsTasksWithChan invokes the qualitycheck.ListHotWordsTasks API asynchronously
func (client *Client) ListHotWordsTasksWithChan(request *ListHotWordsTasksRequest) (<-chan *ListHotWordsTasksResponse, <-chan error) {
	responseChan := make(chan *ListHotWordsTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHotWordsTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHotWordsTasksWithCallback invokes the qualitycheck.ListHotWordsTasks API asynchronously
func (client *Client) ListHotWordsTasksWithCallback(request *ListHotWordsTasksRequest, callback func(response *ListHotWordsTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHotWordsTasksResponse
		var err error
		defer close(result)
		response, err = client.ListHotWordsTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHotWordsTasksRequest is the request struct for api ListHotWordsTasks
type ListHotWordsTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// ListHotWordsTasksResponse is the response struct for api ListHotWordsTasks
type ListHotWordsTasksResponse struct {
	*responses.BaseResponse
	RequestId  string                  `json:"RequestId" xml:"RequestId"`
	Success    bool                    `json:"Success" xml:"Success"`
	Code       string                  `json:"Code" xml:"Code"`
	Message    string                  `json:"Message" xml:"Message"`
	PageNumber int                     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                     `json:"PageSize" xml:"PageSize"`
	Count      int                     `json:"Count" xml:"Count"`
	Data       DataInListHotWordsTasks `json:"Data" xml:"Data"`
}

// CreateListHotWordsTasksRequest creates a request to invoke ListHotWordsTasks API
func CreateListHotWordsTasksRequest() (request *ListHotWordsTasksRequest) {
	request = &ListHotWordsTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListHotWordsTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateListHotWordsTasksResponse creates a response to parse from ListHotWordsTasks response
func CreateListHotWordsTasksResponse() (response *ListHotWordsTasksResponse) {
	response = &ListHotWordsTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
