package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRdsAccounts invokes the retailcloud.DescribeRdsAccounts API synchronously
func (client *Client) DescribeRdsAccounts(request *DescribeRdsAccountsRequest) (response *DescribeRdsAccountsResponse, err error) {
	response = CreateDescribeRdsAccountsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRdsAccountsWithChan invokes the retailcloud.DescribeRdsAccounts API asynchronously
func (client *Client) DescribeRdsAccountsWithChan(request *DescribeRdsAccountsRequest) (<-chan *DescribeRdsAccountsResponse, <-chan error) {
	responseChan := make(chan *DescribeRdsAccountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRdsAccounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRdsAccountsWithCallback invokes the retailcloud.DescribeRdsAccounts API asynchronously
func (client *Client) DescribeRdsAccountsWithCallback(request *DescribeRdsAccountsRequest, callback func(response *DescribeRdsAccountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRdsAccountsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRdsAccounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRdsAccountsRequest is the request struct for api DescribeRdsAccounts
type DescribeRdsAccountsRequest struct {
	*requests.RpcRequest
	AccountName  string `position:"Query" name:"AccountName"`
	DbInstanceId string `position:"Query" name:"DbInstanceId"`
}

// DescribeRdsAccountsResponse is the response struct for api DescribeRdsAccounts
type DescribeRdsAccountsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeRdsAccountsRequest creates a request to invoke DescribeRdsAccounts API
func CreateDescribeRdsAccountsRequest() (request *DescribeRdsAccountsRequest) {
	request = &DescribeRdsAccountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DescribeRdsAccounts", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeRdsAccountsResponse creates a response to parse from DescribeRdsAccounts response
func CreateDescribeRdsAccountsResponse() (response *DescribeRdsAccountsResponse) {
	response = &DescribeRdsAccountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
