package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyService invokes the retailcloud.ModifyService API synchronously
func (client *Client) ModifyService(request *ModifyServiceRequest) (response *ModifyServiceResponse, err error) {
	response = CreateModifyServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyServiceWithChan invokes the retailcloud.ModifyService API asynchronously
func (client *Client) ModifyServiceWithChan(request *ModifyServiceRequest) (<-chan *ModifyServiceResponse, <-chan error) {
	responseChan := make(chan *ModifyServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyServiceWithCallback invokes the retailcloud.ModifyService API asynchronously
func (client *Client) ModifyServiceWithCallback(request *ModifyServiceRequest, callback func(response *ModifyServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyServiceResponse
		var err error
		defer close(result)
		response, err = client.ModifyService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyServiceRequest is the request struct for api ModifyService
type ModifyServiceRequest struct {
	*requests.RpcRequest
	Name         string                       `position:"Query" name:"Name"`
	PortMappings *[]ModifyServicePortMappings `position:"Body" name:"PortMappings"  type:"Repeated"`
	ServiceId    requests.Integer             `position:"Query" name:"ServiceId"`
}

// ModifyServicePortMappings is a repeated param struct in ModifyServiceRequest
type ModifyServicePortMappings struct {
	Protocol   string `name:"Protocol"`
	Port       string `name:"Port"`
	Name       string `name:"Name"`
	NodePort   string `name:"NodePort"`
	TargetPort string `name:"TargetPort"`
}

// ModifyServiceResponse is the response struct for api ModifyService
type ModifyServiceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyServiceRequest creates a request to invoke ModifyService API
func CreateModifyServiceRequest() (request *ModifyServiceRequest) {
	request = &ModifyServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "ModifyService", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyServiceResponse creates a response to parse from ModifyService response
func CreateModifyServiceResponse() (response *ModifyServiceResponse) {
	response = &ModifyServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
