package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeChangeSets invokes the ros.DescribeChangeSets API synchronously
// api document: https://help.aliyun.com/api/ros/describechangesets.html
func (client *Client) DescribeChangeSets(request *DescribeChangeSetsRequest) (response *DescribeChangeSetsResponse, err error) {
	response = CreateDescribeChangeSetsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeChangeSetsWithChan invokes the ros.DescribeChangeSets API asynchronously
// api document: https://help.aliyun.com/api/ros/describechangesets.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChangeSetsWithChan(request *DescribeChangeSetsRequest) (<-chan *DescribeChangeSetsResponse, <-chan error) {
	responseChan := make(chan *DescribeChangeSetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeChangeSets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeChangeSetsWithCallback invokes the ros.DescribeChangeSets API asynchronously
// api document: https://help.aliyun.com/api/ros/describechangesets.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChangeSetsWithCallback(request *DescribeChangeSetsRequest, callback func(response *DescribeChangeSetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeChangeSetsResponse
		var err error
		defer close(result)
		response, err = client.DescribeChangeSets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeChangeSetsRequest is the request struct for api DescribeChangeSets
type DescribeChangeSetsRequest struct {
	*requests.RoaRequest
	StackId   string `position:"Path" name:"StackId"`
	StackName string `position:"Path" name:"StackName"`
}

// DescribeChangeSetsResponse is the response struct for api DescribeChangeSets
type DescribeChangeSetsResponse struct {
	*responses.BaseResponse
	Dummy string `json:"Dummy" xml:"Dummy"`
}

// CreateDescribeChangeSetsRequest creates a request to invoke DescribeChangeSets API
func CreateDescribeChangeSetsRequest() (request *DescribeChangeSetsRequest) {
	request = &DescribeChangeSetsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "DescribeChangeSets", "/stacks/[StackName]/[StackId]/changeSets", "ROS", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeChangeSetsResponse creates a response to parse from DescribeChangeSets response
func CreateDescribeChangeSetsResponse() (response *DescribeChangeSetsResponse) {
	response = &DescribeChangeSetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
