package sas_api

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTotalAndRateLine invokes the sas_api.DescribeTotalAndRateLine API synchronously
// api document: https://help.aliyun.com/api/sas-api/describetotalandrateline.html
func (client *Client) DescribeTotalAndRateLine(request *DescribeTotalAndRateLineRequest) (response *DescribeTotalAndRateLineResponse, err error) {
	response = CreateDescribeTotalAndRateLineResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTotalAndRateLineWithChan invokes the sas_api.DescribeTotalAndRateLine API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describetotalandrateline.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTotalAndRateLineWithChan(request *DescribeTotalAndRateLineRequest) (<-chan *DescribeTotalAndRateLineResponse, <-chan error) {
	responseChan := make(chan *DescribeTotalAndRateLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTotalAndRateLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTotalAndRateLineWithCallback invokes the sas_api.DescribeTotalAndRateLine API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describetotalandrateline.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTotalAndRateLineWithCallback(request *DescribeTotalAndRateLineRequest, callback func(response *DescribeTotalAndRateLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTotalAndRateLineResponse
		var err error
		defer close(result)
		response, err = client.DescribeTotalAndRateLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTotalAndRateLineRequest is the request struct for api DescribeTotalAndRateLine
type DescribeTotalAndRateLineRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	ApiType  requests.Integer `position:"Query" name:"ApiType"`
}

// DescribeTotalAndRateLineResponse is the response struct for api DescribeTotalAndRateLine
type DescribeTotalAndRateLineResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Categories []string `json:"Categories" xml:"Categories"`
	Items      []Item   `json:"Items" xml:"Items"`
}

// CreateDescribeTotalAndRateLineRequest creates a request to invoke DescribeTotalAndRateLine API
func CreateDescribeTotalAndRateLineRequest() (request *DescribeTotalAndRateLineRequest) {
	request = &DescribeTotalAndRateLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas-api", "2017-07-05", "DescribeTotalAndRateLine", "sas-api", "openAPI")
	return
}

// CreateDescribeTotalAndRateLineResponse creates a response to parse from DescribeTotalAndRateLine response
func CreateDescribeTotalAndRateLineResponse() (response *DescribeTotalAndRateLineResponse) {
	response = &DescribeTotalAndRateLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
