package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteStorageBundle invokes the sgw.DeleteStorageBundle API synchronously
func (client *Client) DeleteStorageBundle(request *DeleteStorageBundleRequest) (response *DeleteStorageBundleResponse, err error) {
	response = CreateDeleteStorageBundleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteStorageBundleWithChan invokes the sgw.DeleteStorageBundle API asynchronously
func (client *Client) DeleteStorageBundleWithChan(request *DeleteStorageBundleRequest) (<-chan *DeleteStorageBundleResponse, <-chan error) {
	responseChan := make(chan *DeleteStorageBundleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteStorageBundle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteStorageBundleWithCallback invokes the sgw.DeleteStorageBundle API asynchronously
func (client *Client) DeleteStorageBundleWithCallback(request *DeleteStorageBundleRequest, callback func(response *DeleteStorageBundleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteStorageBundleResponse
		var err error
		defer close(result)
		response, err = client.DeleteStorageBundle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteStorageBundleRequest is the request struct for api DeleteStorageBundle
type DeleteStorageBundleRequest struct {
	*requests.RpcRequest
	SecurityToken   string `position:"Query" name:"SecurityToken"`
	StorageBundleId string `position:"Query" name:"StorageBundleId"`
}

// DeleteStorageBundleResponse is the response struct for api DeleteStorageBundle
type DeleteStorageBundleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteStorageBundleRequest creates a request to invoke DeleteStorageBundle API
func CreateDeleteStorageBundleRequest() (request *DeleteStorageBundleRequest) {
	request = &DeleteStorageBundleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DeleteStorageBundle", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteStorageBundleResponse creates a response to parse from DeleteStorageBundle response
func CreateDeleteStorageBundleResponse() (response *DeleteStorageBundleResponse) {
	response = &DeleteStorageBundleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
