package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEnterpriseCode invokes the smartag.ListEnterpriseCode API synchronously
func (client *Client) ListEnterpriseCode(request *ListEnterpriseCodeRequest) (response *ListEnterpriseCodeResponse, err error) {
	response = CreateListEnterpriseCodeResponse()
	err = client.DoAction(request, response)
	return
}

// ListEnterpriseCodeWithChan invokes the smartag.ListEnterpriseCode API asynchronously
func (client *Client) ListEnterpriseCodeWithChan(request *ListEnterpriseCodeRequest) (<-chan *ListEnterpriseCodeResponse, <-chan error) {
	responseChan := make(chan *ListEnterpriseCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEnterpriseCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEnterpriseCodeWithCallback invokes the smartag.ListEnterpriseCode API asynchronously
func (client *Client) ListEnterpriseCodeWithCallback(request *ListEnterpriseCodeRequest, callback func(response *ListEnterpriseCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEnterpriseCodeResponse
		var err error
		defer close(result)
		response, err = client.ListEnterpriseCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEnterpriseCodeRequest is the request struct for api ListEnterpriseCode
type ListEnterpriseCodeRequest struct {
	*requests.RpcRequest
	EnterpriseCode string           `position:"Query" name:"EnterpriseCode"`
	NextToken      string           `position:"Query" name:"NextToken"`
	IsDefault      requests.Boolean `position:"Query" name:"IsDefault"`
	MaxResults     requests.Integer `position:"Query" name:"MaxResults"`
}

// ListEnterpriseCodeResponse is the response struct for api ListEnterpriseCode
type ListEnterpriseCodeResponse struct {
	*responses.BaseResponse
	TotalCount      int              `json:"TotalCount" xml:"TotalCount"`
	NextToken       string           `json:"NextToken" xml:"NextToken"`
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	MaxResults      int              `json:"MaxResults" xml:"MaxResults"`
	EnterpriseCodes []EnterpriseCode `json:"EnterpriseCodes" xml:"EnterpriseCodes"`
}

// CreateListEnterpriseCodeRequest creates a request to invoke ListEnterpriseCode API
func CreateListEnterpriseCodeRequest() (request *ListEnterpriseCodeRequest) {
	request = &ListEnterpriseCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ListEnterpriseCode", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEnterpriseCodeResponse creates a response to parse from ListEnterpriseCode response
func CreateListEnterpriseCodeResponse() (response *ListEnterpriseCodeResponse) {
	response = &ListEnterpriseCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
