package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUnionTaskStatus invokes the unimkt.GetUnionTaskStatus API synchronously
func (client *Client) GetUnionTaskStatus(request *GetUnionTaskStatusRequest) (response *GetUnionTaskStatusResponse, err error) {
	response = CreateGetUnionTaskStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetUnionTaskStatusWithChan invokes the unimkt.GetUnionTaskStatus API asynchronously
func (client *Client) GetUnionTaskStatusWithChan(request *GetUnionTaskStatusRequest) (<-chan *GetUnionTaskStatusResponse, <-chan error) {
	responseChan := make(chan *GetUnionTaskStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUnionTaskStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUnionTaskStatusWithCallback invokes the unimkt.GetUnionTaskStatus API asynchronously
func (client *Client) GetUnionTaskStatusWithCallback(request *GetUnionTaskStatusRequest, callback func(response *GetUnionTaskStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUnionTaskStatusResponse
		var err error
		defer close(result)
		response, err = client.GetUnionTaskStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUnionTaskStatusRequest is the request struct for api GetUnionTaskStatus
type GetUnionTaskStatusRequest struct {
	*requests.RpcRequest
	UserNick     string           `position:"Query" name:"UserNick"`
	Sign         string           `position:"Query" name:"Sign"`
	AlipayOpenId requests.Integer `position:"Query" name:"AlipayOpenId"`
	UserId       requests.Integer `position:"Query" name:"UserId"`
	TaskId       requests.Integer `position:"Query" name:"TaskId"`
}

// GetUnionTaskStatusResponse is the response struct for api GetUnionTaskStatus
type GetUnionTaskStatusResponse struct {
	*responses.BaseResponse
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       bool   `json:"Result" xml:"Result"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateGetUnionTaskStatusRequest creates a request to invoke GetUnionTaskStatus API
func CreateGetUnionTaskStatusRequest() (request *GetUnionTaskStatusRequest) {
	request = &GetUnionTaskStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "GetUnionTaskStatus", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUnionTaskStatusResponse creates a response to parse from GetUnionTaskStatus response
func CreateGetUnionTaskStatusResponse() (response *GetUnionTaskStatusResponse) {
	response = &GetUnionTaskStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
