package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConvertHdrVideo invokes the videoenhan.ConvertHdrVideo API synchronously
func (client *Client) ConvertHdrVideo(request *ConvertHdrVideoRequest) (response *ConvertHdrVideoResponse, err error) {
	response = CreateConvertHdrVideoResponse()
	err = client.DoAction(request, response)
	return
}

// ConvertHdrVideoWithChan invokes the videoenhan.ConvertHdrVideo API asynchronously
func (client *Client) ConvertHdrVideoWithChan(request *ConvertHdrVideoRequest) (<-chan *ConvertHdrVideoResponse, <-chan error) {
	responseChan := make(chan *ConvertHdrVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConvertHdrVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConvertHdrVideoWithCallback invokes the videoenhan.ConvertHdrVideo API asynchronously
func (client *Client) ConvertHdrVideoWithCallback(request *ConvertHdrVideoRequest, callback func(response *ConvertHdrVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConvertHdrVideoResponse
		var err error
		defer close(result)
		response, err = client.ConvertHdrVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConvertHdrVideoRequest is the request struct for api ConvertHdrVideo
type ConvertHdrVideoRequest struct {
	*requests.RpcRequest
	HDRFormat      string           `position:"Body" name:"HDRFormat"`
	MaxIlluminance requests.Integer `position:"Body" name:"MaxIlluminance"`
	Bitrate        requests.Integer `position:"Body" name:"Bitrate"`
	Async          requests.Boolean `position:"Body" name:"Async"`
	VideoURL       string           `position:"Body" name:"VideoURL"`
}

// ConvertHdrVideoResponse is the response struct for api ConvertHdrVideo
type ConvertHdrVideoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateConvertHdrVideoRequest creates a request to invoke ConvertHdrVideo API
func CreateConvertHdrVideoRequest() (request *ConvertHdrVideoRequest) {
	request = &ConvertHdrVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "ConvertHdrVideo", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConvertHdrVideoResponse creates a response to parse from ConvertHdrVideo response
func CreateConvertHdrVideoResponse() (response *ConvertHdrVideoResponse) {
	response = &ConvertHdrVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
