package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InterpolateVideoFrame invokes the videoenhan.InterpolateVideoFrame API synchronously
func (client *Client) InterpolateVideoFrame(request *InterpolateVideoFrameRequest) (response *InterpolateVideoFrameResponse, err error) {
	response = CreateInterpolateVideoFrameResponse()
	err = client.DoAction(request, response)
	return
}

// InterpolateVideoFrameWithChan invokes the videoenhan.InterpolateVideoFrame API asynchronously
func (client *Client) InterpolateVideoFrameWithChan(request *InterpolateVideoFrameRequest) (<-chan *InterpolateVideoFrameResponse, <-chan error) {
	responseChan := make(chan *InterpolateVideoFrameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InterpolateVideoFrame(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InterpolateVideoFrameWithCallback invokes the videoenhan.InterpolateVideoFrame API asynchronously
func (client *Client) InterpolateVideoFrameWithCallback(request *InterpolateVideoFrameRequest, callback func(response *InterpolateVideoFrameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InterpolateVideoFrameResponse
		var err error
		defer close(result)
		response, err = client.InterpolateVideoFrame(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InterpolateVideoFrameRequest is the request struct for api InterpolateVideoFrame
type InterpolateVideoFrameRequest struct {
	*requests.RpcRequest
	FrameRate requests.Integer `position:"Body" name:"FrameRate"`
	Bitrate   requests.Integer `position:"Body" name:"Bitrate"`
	Async     requests.Boolean `position:"Body" name:"Async"`
	VideoURL  string           `position:"Body" name:"VideoURL"`
}

// InterpolateVideoFrameResponse is the response struct for api InterpolateVideoFrame
type InterpolateVideoFrameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateInterpolateVideoFrameRequest creates a request to invoke InterpolateVideoFrame API
func CreateInterpolateVideoFrameRequest() (request *InterpolateVideoFrameRequest) {
	request = &InterpolateVideoFrameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "InterpolateVideoFrame", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInterpolateVideoFrameResponse creates a response to parse from InterpolateVideoFrame response
func CreateInterpolateVideoFrameResponse() (response *InterpolateVideoFrameResponse) {
	response = &InterpolateVideoFrameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
