package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConversationDetails invokes the voicenavigator.ListConversationDetails API synchronously
func (client *Client) ListConversationDetails(request *ListConversationDetailsRequest) (response *ListConversationDetailsResponse, err error) {
	response = CreateListConversationDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// ListConversationDetailsWithChan invokes the voicenavigator.ListConversationDetails API asynchronously
func (client *Client) ListConversationDetailsWithChan(request *ListConversationDetailsRequest) (<-chan *ListConversationDetailsResponse, <-chan error) {
	responseChan := make(chan *ListConversationDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConversationDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConversationDetailsWithCallback invokes the voicenavigator.ListConversationDetails API asynchronously
func (client *Client) ListConversationDetailsWithCallback(request *ListConversationDetailsRequest, callback func(response *ListConversationDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConversationDetailsResponse
		var err error
		defer close(result)
		response, err = client.ListConversationDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConversationDetailsRequest is the request struct for api ListConversationDetails
type ListConversationDetailsRequest struct {
	*requests.RpcRequest
	ConversationId string `position:"Query" name:"ConversationId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// ListConversationDetailsResponse is the response struct for api ListConversationDetails
type ListConversationDetailsResponse struct {
	*responses.BaseResponse
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	ConversationDetails []ConversationDetail `json:"ConversationDetails" xml:"ConversationDetails"`
}

// CreateListConversationDetailsRequest creates a request to invoke ListConversationDetails API
func CreateListConversationDetailsRequest() (request *ListConversationDetailsRequest) {
	request = &ListConversationDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "ListConversationDetails", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListConversationDetailsResponse creates a response to parse from ListConversationDetails response
func CreateListConversationDetailsResponse() (response *ListConversationDetailsResponse) {
	response = &ListConversationDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
