package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNewBargeInSwitch invokes the voicenavigator.UpdateNewBargeInSwitch API synchronously
func (client *Client) UpdateNewBargeInSwitch(request *UpdateNewBargeInSwitchRequest) (response *UpdateNewBargeInSwitchResponse, err error) {
	response = CreateUpdateNewBargeInSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNewBargeInSwitchWithChan invokes the voicenavigator.UpdateNewBargeInSwitch API asynchronously
func (client *Client) UpdateNewBargeInSwitchWithChan(request *UpdateNewBargeInSwitchRequest) (<-chan *UpdateNewBargeInSwitchResponse, <-chan error) {
	responseChan := make(chan *UpdateNewBargeInSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNewBargeInSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNewBargeInSwitchWithCallback invokes the voicenavigator.UpdateNewBargeInSwitch API asynchronously
func (client *Client) UpdateNewBargeInSwitchWithCallback(request *UpdateNewBargeInSwitchRequest, callback func(response *UpdateNewBargeInSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNewBargeInSwitchResponse
		var err error
		defer close(result)
		response, err = client.UpdateNewBargeInSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNewBargeInSwitchRequest is the request struct for api UpdateNewBargeInSwitch
type UpdateNewBargeInSwitchRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	Enable     requests.Boolean `position:"Query" name:"Enable"`
}

// UpdateNewBargeInSwitchResponse is the response struct for api UpdateNewBargeInSwitch
type UpdateNewBargeInSwitchResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateUpdateNewBargeInSwitchRequest creates a request to invoke UpdateNewBargeInSwitch API
func CreateUpdateNewBargeInSwitchRequest() (request *UpdateNewBargeInSwitchRequest) {
	request = &UpdateNewBargeInSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "UpdateNewBargeInSwitch", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateNewBargeInSwitchResponse creates a response to parse from UpdateNewBargeInSwitch response
func CreateUpdateNewBargeInSwitchResponse() (response *UpdateNewBargeInSwitchResponse) {
	response = &UpdateNewBargeInSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
