/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import jlibs.core.lang.ByteSequence;

public class ByteArrayOutputStream2
extends ByteArrayOutputStream {
    public ByteArrayOutputStream2() {
    }

    public ByteArrayOutputStream2(int size) {
        super(size);
    }

    public ByteArrayOutputStream2(InputStream is, int readBuffSize, boolean close) throws IOException {
        this.readFrom(is, readBuffSize, close);
    }

    public ByteSequence toByteSequence() {
        return new ByteSequence(this.buf, 0, this.size());
    }

    public int readFrom(InputStream is, int readBuffSize, boolean close) throws IOException {
        int oldSize = this.size();
        try {
            while (true) {
                int read;
                int bufAvailable = this.buf.length - this.size();
                int readAvailable = is.available();
                if (readAvailable == 0) {
                    readAvailable = Math.max(readBuffSize, bufAvailable);
                }
                if (bufAvailable < readAvailable) {
                    this.buf = Arrays.copyOf(this.buf, this.size() + readAvailable);
                    bufAvailable = readAvailable;
                }
                if ((read = is.read(this.buf, this.size(), bufAvailable)) == -1) {
                    int n = this.size() - oldSize;
                    return n;
                }
                this.count += read;
            }
        }
        finally {
            if (close) {
                is.close();
            }
        }
    }
}

