/*
 * distimmo.c --- distance package.
 *
 * Copyright (c) 2000, 2001, 2002 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2002-05-07 18:33:46 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"common.h"

#include	"distimmo.h"

#include	"pcpj.h"	/* for `CasesInterdites[]' */
#include	"distance.h"

#include	<assert.h>

/*--------------------------------------------------------------------------*/

typedef struct
{
    square_t		case_interdite ;
    piece_index_t	index ;
    distance_t		tableau_distance[ 6 * SIZE_PIECE ];
} Tableau_Piece_Potentiellement_Immobile_t ;

#define IMMOBILE_TABLE_SIZE	16
static	Tableau_Piece_Potentiellement_Immobile_t
	Tableaux_Distance_Pieces_Potentiellement_Immobiles[
	    IMMOBILE_TABLE_SIZE ];
static	unsigned int	Nombre_Pieces_Potentiellement_Immobiles = 0;

typedef struct
{
    square_t		case_interdite;
    piece_index_t	index;
    distance_t*		tableau_distance;
    bool_t		est_immobile;
} Tableau_Piece_Immobile_t;

static	Tableau_Piece_Immobile_t Tableau_Pieces_Actuellement_Immobiles[
    IMMOBILE_TABLE_SIZE ];
static	unsigned int		 Nombre_Pieces_Actuellement_Immobiles = 0;

/*--------------------------------------------------------------------------*/

void
distance_raz_tableaux_si_immobile()
{
    Nombre_Pieces_Potentiellement_Immobiles = 0;
    Nombre_Pieces_Actuellement_Immobiles    = 0;
}

void
distance_cree_tableau_si_immobile(
    square_t 		nouvelle_case_interdite,
    piece_index_t 	index)
{
    distance_t* tableau = Tableaux_Distance_Pieces_Potentiellement_Immobiles
	[Nombre_Pieces_Potentiellement_Immobiles].tableau_distance;

    Tableaux_Distance_Pieces_Potentiellement_Immobiles
	[Nombre_Pieces_Potentiellement_Immobiles].case_interdite =
	nouvelle_case_interdite;
    Tableaux_Distance_Pieces_Potentiellement_Immobiles
	[Nombre_Pieces_Potentiellement_Immobiles].index =
	index;

    Nombre_Pieces_Potentiellement_Immobiles++;

    CasesInterdites[nouvelle_case_interdite] = TRUE;

    distance_create_table(tableau);

    CasesInterdites[nouvelle_case_interdite] = FALSE;
}

void
distance_ajouter_tableau_pour_case(square_t case_potentiellement_bloquee)
{
    int		i;

    for (i=0; i<Nombre_Pieces_Potentiellement_Immobiles; i++)
    {
	if (Tableaux_Distance_Pieces_Potentiellement_Immobiles[i].case_interdite
	    == case_potentiellement_bloquee)
	{
	    assert(Nombre_Pieces_Actuellement_Immobiles < IMMOBILE_TABLE_SIZE);
	    Tableau_Pieces_Actuellement_Immobiles
		[ Nombre_Pieces_Actuellement_Immobiles ].case_interdite
		= case_potentiellement_bloquee;
	    Tableau_Pieces_Actuellement_Immobiles
		[ Nombre_Pieces_Actuellement_Immobiles ].tableau_distance
		= Tableaux_Distance_Pieces_Potentiellement_Immobiles[ i ]
		.tableau_distance;
	    Tableau_Pieces_Actuellement_Immobiles
		[ Nombre_Pieces_Actuellement_Immobiles ].index
		= Tableaux_Distance_Pieces_Potentiellement_Immobiles[i].index;
	    Tableau_Pieces_Actuellement_Immobiles
		[ Nombre_Pieces_Actuellement_Immobiles ].est_immobile = TRUE;
	    Nombre_Pieces_Actuellement_Immobiles++;
	    break;
	}
    }
}

void
distance_supprimer_dernier_tableau_pour_case_potentiellement_bloquee()
{
    assert( Nombre_Pieces_Actuellement_Immobiles > 0 );
    Nombre_Pieces_Actuellement_Immobiles--;
}

void
distance_reimmobilise_pieces(
    piece_index_t	pieces_ayant_du_bouger[],
    int			nombre_pieces_ayant_du_bouger)
{
    int		i, j;
    piece_t*	p;

    for (i=0; i<nombre_pieces_ayant_du_bouger; i++)
    {
	p = TabIndexPiece[pieces_ayant_du_bouger[i]];
	p->nbDestination    = 1;
	p->destination[0]   = p->destination[1];
	p->distance[0]      = 0;

	if (p->camp == BLANC)
	{
	    NbCoupsBlancsRestants += 2;
	}
	else
	{
	    NbCoupsNoirsRestants  += 2;
	}

	for (j=0; j<Nombre_Pieces_Actuellement_Immobiles; j++)
	{
	    if ( pieces_ayant_du_bouger[ i ]
		 == Tableau_Pieces_Actuellement_Immobiles[ j ].index )
	    {
		Tableau_Pieces_Actuellement_Immobiles[j].est_immobile = TRUE;
		break;
	    }
	}
    }
}

distance_t
distance_avec_obstacle(
    piece_type_t	piece,
    colour_t		camp,
    square_t		case_depart,
    square_t		case_arrivee,
    bool_t		checkAvailableMoves,
    piece_index_t	pieces_ayant_du_bouger[],
    int*		nombre_pieces_ayant_du_bouger)
{
    int		i;
    distance_t	dist_immobile;
    distance_t	dist;
    piece_t*	p;

    *nombre_pieces_ayant_du_bouger = 0;

    dist = distance(piece, camp, case_depart, case_arrivee);

    if ((camp == BLANC && dist > NbCoupsBlancsRestants) ||
	(camp == NOIR  && dist > NbCoupsNoirsRestants) )
    {
	return INFINI;
    }

    for (i=0; i<Nombre_Pieces_Actuellement_Immobiles; i++)
    {
	if ( ! Tableau_Pieces_Actuellement_Immobiles[ i ].est_immobile )
	{
	    continue;
	}

	dist_immobile
	    = Tableau_Pieces_Actuellement_Immobiles[ i ].tableau_distance
	    [ piece * SIZE_PIECE
	      + ( camp == BLANC ? 0 : SIZE_PIECE / 2 )
	      + ( ( row( case_depart ) >> 1 )
		  + column( case_depart ) ) * SIZE_ECHIQUIER
	      + case_arrivee ];

	if ((camp == BLANC && dist_immobile > NbCoupsBlancsRestants) ||
	    (camp == NOIR  && dist_immobile > NbCoupsNoirsRestants) )
	{
	    p = TabIndexPiece[Tableau_Pieces_Actuellement_Immobiles[i].index];

	    if (camp == p->camp)
	    {
		if ((camp == BLANC && dist + 2 > NbCoupsBlancsRestants) ||
		    (camp == NOIR  && dist + 2 > NbCoupsNoirsRestants) )
		{
		    distance_reimmobilise_pieces(
			pieces_ayant_du_bouger,
			*nombre_pieces_ayant_du_bouger );
		    *nombre_pieces_ayant_du_bouger = 0;
		    return INFINI;
		}
	    }
	    else
	    {
		if ((p->camp == BLANC && 2 > NbCoupsBlancsRestants) ||
		    (p->camp == NOIR  && 2 > NbCoupsNoirsRestants) )
		{
		    distance_reimmobilise_pieces(
			pieces_ayant_du_bouger,
			*nombre_pieces_ayant_du_bouger );
		    *nombre_pieces_ayant_du_bouger = 0;
		    return INFINI;
		}
	    }
	    p->nbDestination    = 2;
	    p->destination[1]   = p->destination[0];
	    p->pieceCapturee[1] = PAS_DE_CAPTURE;
	    p->distance[1]      = 1;
	    p->destination[0]   = CASE_ARRIVEE_QUELCONQUE;
	    p->pieceCapturee[0] = PAS_DE_CAPTURE;
	    p->distance[0]      = 1;
	    pieces_ayant_du_bouger[*nombre_pieces_ayant_du_bouger] =
		Tableau_Pieces_Actuellement_Immobiles[i].index;
	    (*nombre_pieces_ayant_du_bouger)++;
	    Tableau_Pieces_Actuellement_Immobiles[i].est_immobile = FALSE;

	    if (p->camp == BLANC)
	    {
		NbCoupsBlancsRestants -= 2;
	    }
	    else
	    {
		NbCoupsNoirsRestants  -= 2;
	    }
	}
    }

    return dist;
}

bool_t	distance_desimmobilise_piece_sur_case(
    square_t		square )
{
    int		i;

    for ( i = 0; i < Nombre_Pieces_Actuellement_Immobiles; i++ )
    {
	if ( Tableau_Pieces_Actuellement_Immobiles[ i ].case_interdite
	     == square )
	{
	    if ( Tableau_Pieces_Actuellement_Immobiles[ i ].est_immobile )
	    {
		Tableau_Pieces_Actuellement_Immobiles[ i ].est_immobile
		    = FALSE ;
		return TRUE ;
	    }
	    return FALSE ;
	}
    }
    return FALSE ;
}

void		distance_reimmobilise_piece_sur_case(
    square_t		square )
{
    int		i;

    for ( i = 0; i < Nombre_Pieces_Actuellement_Immobiles; i++ )
    {
	if ( Tableau_Pieces_Actuellement_Immobiles[ i ].case_interdite
	     == square )
	{
	    Tableau_Pieces_Actuellement_Immobiles[ i ].est_immobile = TRUE ;
	    return ;
	}
    }
}

void
distance_libere_case(
    square_t	laCase,
    void	(*function)(int indice),
    int		indice)
{
    piece_t*		p;
    int			i;

    for (i=0; i<Nombre_Pieces_Actuellement_Immobiles; i++)
    {
	if (Tableau_Pieces_Actuellement_Immobiles[i].case_interdite == laCase &&
	    Tableau_Pieces_Actuellement_Immobiles[i].est_immobile)
	{
	    p = TabIndexPiece[Tableau_Pieces_Actuellement_Immobiles[i].index];

	    if ((p->camp == BLANC && 2 > NbCoupsBlancsRestants) ||
		(p->camp == NOIR  && 2 > NbCoupsNoirsRestants) )
	    {
		return;
	    }

	    p->nbDestination    = 2;
	    p->destination[1]   = p->destination[0];
	    p->pieceCapturee[1] = PAS_DE_CAPTURE;
	    p->distance[1]      = 1;
	    p->destination[0]   = CASE_ARRIVEE_QUELCONQUE;
	    p->pieceCapturee[0] = PAS_DE_CAPTURE;
	    p->distance[0]      = 1;
	    Tableau_Pieces_Actuellement_Immobiles[i].est_immobile = FALSE;

	    if (p->camp == BLANC)
	    {
		NbCoupsBlancsRestants -= 2;
	    }
	    else
	    {
		NbCoupsNoirsRestants  -= 2;
	    }

	    (*function)(indice);

	    p->nbDestination    = 1;
	    p->destination[0]   = p->destination[1];
	    p->distance[0]      = 0;
	    Tableau_Pieces_Actuellement_Immobiles[i].est_immobile = TRUE;

	    if (p->camp == BLANC)
	    {
		NbCoupsBlancsRestants += 2;
	    }
	    else
	    {
		NbCoupsNoirsRestants  += 2;
	    }
	    return;
	}
    }
    (*function)(indice);
}
