/*
 * pcpj.h --- position searching package.
 *
 * Copyright (c) 1997, 98, 99, 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2001-04-16 18:23:40 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef PCPJ_H
#define PCPJ_H

/*------------------------------------------------------------------*/

#include	"types.h"
#include	"main.h"			/* Uniquement pour NOMBRE_MAXIMUM_DE_PIECES */

#define	not_yet_looked_at(piece)	((piece).nbDestination == 0)

/*------------------------------------------------------------------*/

void	majEchiquier( void );
void	initAssociation( int nbCoups );
void	creeAssociation( int number_of_half_moves );

/*------------------------------------------------------------------*/

#ifndef	EXTERN_PCPJ
#define	EXTERN_PCPJ		extern

extern	piece_t		ListeNonTraitees[32];

#else /* not EXTERN_PCPJ */

piece_t	ListeNonTraitees[32] =
{
    {ROI,	BLANC, e1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, ROI,	INDEX_ROI_BLANC,           FALSE,
     NO_CASTLING, 0, 0, 0},

    {TOUR,	BLANC, a1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, TOUR,	INDEX_TOUR_DAME_BLANC,     FALSE,
     NO_CASTLING, 0, 0, 0},

    {CAVALIER,	BLANC, b1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, CAVALIER,	INDEX_CAVALIER_DAME_BLANC, FALSE,
     NO_CASTLING, 0, 0, 0},

    {FOU,	BLANC, c1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, FOU,	INDEX_FOU_DAME_BLANC,      FALSE,
     NO_CASTLING, 0, 0, 0},

    {DAME,	BLANC, d1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, DAME,	INDEX_DAME_BLANC,          FALSE,
     NO_CASTLING, 0, 0, 0},

    {FOU,	BLANC, f1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, FOU,	INDEX_FOU_ROI_BLANC,       FALSE,
     NO_CASTLING, 0, 0, 0},

    {CAVALIER,	BLANC, g1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, CAVALIER,	INDEX_CAVALIER_ROI_BLANC,  FALSE,
     NO_CASTLING, 0, 0, 0},

    {TOUR,	BLANC, h1, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, TOUR,	INDEX_TOUR_ROI_BLANC,      FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, a2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_A,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, b2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_B,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, c2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_C,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, d2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_D,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, e2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_E,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, f2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_F,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, g2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_G,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	BLANC, h2, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_BLANC_H,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {ROI,	NOIR,  e8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, ROI,	INDEX_ROI_NOIR,            FALSE,
     NO_CASTLING, 0, 0, 0},

    {TOUR,	NOIR,  a8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, TOUR,	INDEX_TOUR_DAME_NOIR,      FALSE,
     NO_CASTLING, 0, 0, 0},

    {CAVALIER,	NOIR,  b8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, CAVALIER,	INDEX_CAVALIER_DAME_NOIR,  FALSE,
     NO_CASTLING, 0, 0, 0},

    {FOU,	NOIR,  c8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, FOU,	INDEX_FOU_DAME_NOIR,       FALSE,
     NO_CASTLING, 0, 0, 0},

    {DAME,	NOIR,  d8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, DAME,	INDEX_DAME_NOIR,           FALSE,
     NO_CASTLING, 0, 0, 0},

    {FOU,	NOIR,  f8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, FOU,	INDEX_FOU_ROI_NOIR,        FALSE,
     NO_CASTLING, 0, 0, 0},

    {CAVALIER,	NOIR,  g8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, CAVALIER,	INDEX_CAVALIER_ROI_NOIR,   FALSE,
     NO_CASTLING, 0, 0, 0},

    {TOUR,	NOIR,  h8, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, TOUR,	INDEX_TOUR_ROI_NOIR,       FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  a7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_A,         FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  b7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_B,         FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  c7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_C,         FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  d7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_D,         FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  e7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_E,         FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  f7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_F,         FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  g7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_G,         FALSE,
     NO_CASTLING, 0, 0, 0},

    {PION,	NOIR,  h7, CASE_ARRIVEE_QUELCONQUE, PIECE_PAS_CAPTUREE,
     CASE_PAS_DE_PROMOTION, PION,	INDEX_PION_NOIR_H,         FALSE,
     NO_CASTLING, 0, 0, 0}
};

#endif /* EXTERN_PCPJ */

/*------------------------------------------------------------------*/

EXTERN_PCPJ	unsigned int	NbNonTraites;
EXTERN_PCPJ	unsigned int	NbImmobiles;
EXTERN_PCPJ	unsigned int	NbSures;
EXTERN_PCPJ	unsigned int	NbRestantes;
EXTERN_PCPJ	piece_t		ListeImmobiles[32];
EXTERN_PCPJ	piece_t		ListeSures[32];

/* ListeRestantes est un pointeur dans le tableau ListeSures.
 * Les pieces NON SURES sont stockes a la suite des pieces SURES.
 */
EXTERN_PCPJ	piece_t*	ListeRestantes;

/* Flag a TRUE si aucune piece ne peut jamais jouer sur cette case.
 * Elle est occupee par une piece qui n'a jamais jouee.
 * Pour les cases hors de l'echiquier, le tableau vaut aussi FALSE,
 * ce qui permet des tests rapides.
 */
EXTERN_PCPJ	bool_t		CasesInterdites[ 256 ];

EXTERN_PCPJ	piece_t*	TabIndexPiece[NOMBRE_MAXIMUM_DE_PIECES];

EXTERN_PCPJ	unsigned int	NbCoupsBlancs;
EXTERN_PCPJ	unsigned int	NbCoupsNoirs;
EXTERN_PCPJ	unsigned int	NbCoupsBlancsRestants;
EXTERN_PCPJ	unsigned int	NbCoupsNoirsRestants;

EXTERN_PCPJ	unsigned int	NbTotalCaptureesBlanches;
EXTERN_PCPJ	unsigned int	NbTotalCaptureesNoires;
EXTERN_PCPJ	unsigned int	NbResteACapturerBlanches;
EXTERN_PCPJ	unsigned int	NbResteACapturerNoires;

EXTERN_PCPJ	unsigned int	NbDemiCoups;
EXTERN_PCPJ	square_t	EchiquierFinal[8 * 16];
EXTERN_PCPJ	piece_type_t	Type_Pieces_Final[NOMBRE_MAXIMUM_DE_PIECES];
EXTERN_PCPJ	square_t	Position_Pieces_Final[NOMBRE_MAXIMUM_DE_PIECES];

EXTERN_PCPJ	piece_type_t*	Type_Pieces_Blanches_Final;
EXTERN_PCPJ	piece_type_t*	Type_Pieces_Noires_Final;
EXTERN_PCPJ	square_t*	Position_Pieces_Blanches_Final;
EXTERN_PCPJ	square_t*	Position_Pieces_Noires_Final;


EXTERN_PCPJ	UCHAR		CoupsListe[1000]; /* Solution en cours */
EXTERN_PCPJ	unsigned int	CoupsNb; /* Nombre de coups de la solution en cours */

#endif /* PCPJ_H */
