/*
 * pcpjtool.c --- toolbox.
 *
 * Copyright (c) 1997-2003, 2005 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2005-02-18 14:03:55 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"common.h"

#include	"pcpjtool.h"
#include	"langues.h"
#include	"screen.h"
#include	"pcpj.h"

#include	<string.h>	/* for strcat(...) */
#include	<time.h>	/* for `clock()' & `clock_t' & time_t, etc...*/

void
printEchiquier(int nbHalfMoves)
{
    int			i, j;
    piece_index_t	c;
    int			nbBlancs = 0;
    int			nbNoirs = 0;
    char		forsythe[100];
    int			nb_forsythe = 0;
    int			nb_libre = 0;
    const char*		separation_line = "+---+---+---+---+---+---+---+---+\n";

    fprintf( MainFD, separation_line );
    for (i=7; i>=0; i--)
    {
	fputc( '|', MainFD );
	for (j=0; j<8; j++)
	{
	    if ((c = EchiquierFinal[i*16+j]))
	    {
		if (nb_libre)
		{
		    forsythe[nb_forsythe] = '0' + nb_libre;
		    nb_forsythe++;
		    nb_libre = 0;
		}
		if (is_white(c))
		{
		    fputc(' ', MainFD);
		    nbBlancs++;
		    forsythe[nb_forsythe] =
			InitialePieces[Type_Pieces_Final[c]];
		}
		else
		{
		    fputc('*', MainFD);
		    nbNoirs++;
		    forsythe[nb_forsythe] = InitialePieces[Type_Pieces_Final[c]]
			+ ( 'a' - 'A' );
		}
		fputc(InitialePieces[Type_Pieces_Final[c]], MainFD);
		nb_forsythe++;
	    }
	    else	/* case vide */
	    {
		if ((i+j) & 1)
		{
		    fputc(' ', MainFD);
		    fputc(' ', MainFD);
		}
		else
		{
		    fputc(' ', MainFD);
		    fputc('.', MainFD);
		}
		nb_libre++;
	    }
	    fputc( ' ', MainFD );
	    fputc( '|', MainFD );
	}
	fputc('\n', MainFD);
	fprintf( MainFD, separation_line );
	if (nb_libre)
	{
	    forsythe[nb_forsythe] = '0' + nb_libre;
	    nb_forsythe++;
	    nb_libre = 0;
	}
	forsythe[nb_forsythe] = '/';
	nb_forsythe++;
    }
    forsythe[nb_forsythe - 1] = '\0';
    fprintf(MainFD,
	    "%s\n%d %s.\t%d + %d\n",
	    forsythe,
	    nbHalfMoves, langGetString(eStrHalfMoves),
	    nbBlancs, nbNoirs);
}

char*
move_to_string(const UCHAR* coup, char* s)
{
    const char* texte      = "abcdefgh";
    const char* petitRoque = "  O-O    ";
    const char* grandRoque = "O-O-O    ";
    char*	ptr        = s;

    if (coup[TYPE_DEPART] == ROI)
    {
	if (coup[CASE_DEPART] == e1)
	{
	    if (coup[CASE_ARRIVEE] == g1)
	    {
		strcpy(s, petitRoque);
		return s;
	    }
	    else if (coup[CASE_ARRIVEE] == c1)
	    {
		strcpy(s, grandRoque);
		return s;
	    }
	}
	else if (coup[CASE_DEPART] == e8)
	{
	    if (coup[CASE_ARRIVEE] == g8)
	    {
		strcpy(s, petitRoque);
		return s;
	    }
	    else if (coup[CASE_ARRIVEE] == c8)
	    {
		strcpy(s, grandRoque);
		return s;
	    }
	}
    }

    *(ptr++) = InitialePieces[ coup[ TYPE_DEPART ] ];
    *(ptr++) = texte[ column(coup[ CASE_DEPART ]) ];
    *(ptr++) = ( coup[ CASE_DEPART ] >> 4 ) + '1';
    *(ptr++) = coup[ PIECE_CAPTUREE ] == PAS_DE_CAPTURE ? '-' : 'x';
    *(ptr++) = texte[ column(coup[ CASE_ARRIVEE ]) ];
    *(ptr++) = ( coup[ CASE_ARRIVEE ] >> 4 ) + '1';
    if (coup[TYPE_DEPART] != coup[TYPE_ARRIVEE])
    {
	*(ptr++) = '=';
	*(ptr++) = InitialePieces[coup[TYPE_ARRIVEE]];
    }
    else
    {
	*(ptr++) = ' ';
	*(ptr++) = ' ';
    }
    *(ptr++) = ' ';
    *ptr = '\0';

    return s;
}

char*
move_to_short_string(const UCHAR* coup, char* s)
{
    const char*	texte      = "abcdefgh";
    const char*	petitRoque = "OO  ";
    const char*	grandRoque = "OOO ";
    char*	ptr        = s;

    if (coup[TYPE_DEPART] == ROI)
    {
	if (coup[CASE_DEPART] == e1)
	{
	    if (coup[CASE_ARRIVEE] == g1)
	    {
		strcpy(s, petitRoque);
		return s;
	    }
	    else if (coup[CASE_ARRIVEE] == c1)
	    {
		strcpy(s, grandRoque);
		return s;
	    }
	}
	else if (coup[CASE_DEPART] == e8)
	{
	    if (coup[CASE_ARRIVEE] == g8)
	    {
		strcpy(s, petitRoque);
		return s;
	    }
	    else if (coup[CASE_ARRIVEE] == c8)
	    {
		strcpy(s, grandRoque);
		return s;
	    }
	}
    }

    *(ptr++) = InitialePieces[ coup[ TYPE_DEPART ] ];
    *(ptr++) = texte[ column(coup[ CASE_ARRIVEE ]) ];
    *(ptr++) = ( coup[ CASE_ARRIVEE ] >> 4 ) + '1';
    *(ptr++) = ' ';
    *ptr = '\0';

    return s;
}

void
printCoup(const UCHAR* coup)
{
    char		s[12];

    fprintf(MainFD, move_to_string(coup, s));
}

void
getOneAssociation(const piece_t* p, char* s)
{
    char*	ptr                   = s;
    char*	texte                 = "abcdefgh";
    bool_t	already_promoted      = FALSE;
    int		total_number_of_moves = 0;
    int		i;

    *(ptr++) = InitialePieces[p->typePiece];
    *(ptr++) = texte[column(p->caseInitiale)];
    *(ptr++) = (p->caseInitiale >> 4) + '1';

    for (i=0; i<p->nbDestination; i++)
    {
	total_number_of_moves += p->distance[i];

	if ( i == 0 && p->typePiece == ROI && p->distance[ 0 ] == 1
	     && p->destination[ 0 ] != CASE_ARRIVEE_QUELCONQUE
	     && ( column( p->destination[ 0 ] ) == g1
		  || column( p->destination[ 0 ] ) == c1
		  || column( p->destination[ 0 ] ) == g8
		  || column( p->destination[ 0 ] ) == c8 ) )
	{
	    *(ptr++) = '-';
	    *(ptr++) = 'O';
	    *(ptr++) = 'O';
	    if ( column( p->destination[ 0 ] ) == c1
		 || column( p->destination[ 0 ] ) == c8 )
	    {
		*(ptr++) = 'O';
	    }
	}
	else
	{
	    if (p->pieceCapturee[i] != PAS_DE_CAPTURE)
	    {
		piece_t*		p2;

		*(ptr++) = 'x';
		p2 = TabIndexPiece[p->pieceCapturee[i]];
		*(ptr++) = InitialePieces[p2->typePiece];
	    }
	    else
	    {
		*(ptr++) = '-';
	    }
	    if (p->destination[i] != CASE_ARRIVEE_QUELCONQUE)
	    {
		*(ptr++) = texte[column(p->destination[i])];
		*(ptr++) = (p->destination[i] >> 4) + '1';
		if (p->casePromotion == p->destination[i] && ! already_promoted)
		{
		    *(ptr++) = '=';
		    *(ptr++) = InitialePieces[p->typePromotion];
		    already_promoted = TRUE;
		}
	    }
	    else
	    {
		*(ptr++) = '?';
		*(ptr++) = '?';
	    }
	}
    }

    /* Nombre minimum de coups */
    *(ptr++) = '(';
    if (total_number_of_moves >= 10)
    {
	*(ptr++) = '0' + total_number_of_moves / 10;
	*(ptr++) = '0' + total_number_of_moves - 10;
    }
    else
    {
	*(ptr++) = '0' + total_number_of_moves;
    }
    *(ptr++) = ')';

    /* Si la piece a ete capturee */
    if (p->pieceCapturante != PIECE_PAS_CAPTUREE)
    {
	*(ptr++) = '*';
	if (p->pieceCapturante == PIECE_CAPTURANTE_INCONNUE)
	{
	    *(ptr++) = '?';
	}
	else
	{
	    p = TabIndexPiece[p->pieceCapturante];
	    *(ptr++) = InitialePieces[p->typePiece]; /* Intitule piece */
	    *(ptr++) = texte[column(p->caseInitiale)]; /* Case initiale */
	    *(ptr++) = (p->caseInitiale >> 4) + '1';
	}
    }

    *ptr = '\0';
}

void
writeAssociation( const char* comment )
{
    int		i, j;
    char	s[600];
    int		line_length = 0;
    int		current_length;
    int		total_piece;
    int		total_white = 0;
    int		total_black = 0;

    if ( *comment != '\0' )
    {
	fprintf( MainFD, "%s\n", comment );
    }

    for (i=0; i<NbSures+NbRestantes; i++)
    {
	getOneAssociation(&ListeSures[i], s);
	current_length = strlen(s);
	if (line_length + current_length > 72)
	{
	    fprintf(MainFD, "\n");
	    line_length = 0;
	}
	fprintf(MainFD, "%s   ", s);
	line_length += current_length + 3;

	total_piece = 0;
	for (j=0; j<ListeSures[i].nbDestination; j++)
	{
	    total_piece += ListeSures[i].distance[j];
	}
	if ( colour( ListeSures[i].index ) == BLANC )
	{
	    total_white += total_piece;
	}
	else
	{
	    total_black += total_piece;
	}
    }

    fprintf(MainFD, "\n");
    fprintf(MainFD, langGetString(eStrCoupsRestants),
	    NbCoupsBlancsRestants, NbCoupsNoirsRestants);
    fprintf(MainFD,
	    " (%d, %d)\n",
	    total_white + NbCoupsBlancsRestants,
	    total_black + NbCoupsNoirsRestants);
}

static void
convert_Time(char* output, float seconds, float totalSeconds)
{
    int		minutes    = seconds / 60. ;
    int		percentage = -1		   ;
    char	text[ 50 ]		   ;

    *output = '\0';

    if (totalSeconds != 0)	percentage = 100. * seconds / totalSeconds;

    if (minutes > 0)
    {
	int		hours = minutes / 60;

	seconds -= minutes * 60.;

	if (hours > 0)
	{
	    sprintf(text, "%d h ", hours);
	    strcat(output, text);
	    minutes -= hours * 60;
	}

	sprintf(text, "%d mn ", minutes);
	strcat(output, text);
    }

    sprintf(text, "%.2f s", seconds);
    strcat(output, text);

    if (totalSeconds != 0)
    {
	sprintf(text, " (%d%%)", percentage);
	strcat(output, text);
    }
    strcat(output, ".");
}

static	time_t	Beginning_Time;
static  clock_t	Beginning_Clock_Ticks;
void
mainBeginning(int nbHalfMoves)
{
    time(&Beginning_Time);

    if (!MainVisualFlag || MainFD != stdout)
    {
	char	begin_time_str[100];
	sprintf(begin_time_str,
		langGetString(eStrBeginResolution),
		asctime(localtime(&Beginning_Time)));

	fprintf(MainFD, "%s %s      %s\n\n",
		PACKAGE,
		VERSION,
		langGetString(eStrCopyright));
	printEchiquier(nbHalfMoves);
	fprintf(MainFD, "\n%s\n", begin_time_str);
    }

    if ( MainContinueValue > 0 )
    {
	fprintf( MainFD,
		 langGetString( eStrContinueAt ),
		 MainContinueValue );
    }

    /* Depending on the system, this is the number of ticks since the
     * machine is up or since the first call of clock by the
     * program. We memorise the value and substract it from the end
     * value so we always have the correct result.
     */
    Beginning_Clock_Ticks = clock();

}

void
mainEnd( eStringId message, unsigned long after_solution )
{
    clock_t	clockTicks;
    float	totalSeconds;
    time_t	endTime;
    char	begin_time_str[100];
    char	end_time_str[100];
    char	stopped_str[100];
    char	total_time_str[50];
    char	text_total_time_str[100];

    clockTicks = clock();

    time(&endTime);

    sprintf(begin_time_str,
	    langGetString(eStrBeginResolution),
	    asctime(localtime(&Beginning_Time)));
    begin_time_str[strlen(begin_time_str) - 1] = '\0';
    sprintf(end_time_str,
	    langGetString(eStrEndResolution),
	    asctime(localtime(&endTime)));
    end_time_str[strlen(end_time_str) - 1] = '\0';
    if ( message > eStrEmpty && message < numberOfStrings )
    {
	sprintf( stopped_str ,
		 langGetString( message ),
		 after_solution );
    }
    else
    {
	stopped_str[0] = '\0';
    }

    /* Calcul des temps de resolution et autres durees. */
    totalSeconds = ( clockTicks - Beginning_Clock_Ticks )
	/ (double)CLOCKS_PER_SEC ;
    convert_Time(total_time_str, totalSeconds, 0);
    strcpy(text_total_time_str, langGetString(eStrResolutionTime));
    strcat(text_total_time_str, total_time_str);

    if (!MainVisualFlag || MainFD != stdout)
    {
	fprintf(MainFD, "\n%s\n", end_time_str);
	if ( message > eStrEmpty && message < numberOfStrings )
	{
	    fprintf(MainFD, "%s\n", stopped_str);
	}
	fprintf(MainFD, "%s\n", text_total_time_str);
    }

#ifdef HAVE_LIBNCURSES
    if ( MainVisualFlag )
    {
	screenEnd( begin_time_str,
		   end_time_str,
		   stopped_str,
		   text_total_time_str );
    }
#endif /* HAVE_LIBNCURSES */

/*      { */
/*  	float	seconds = MainTicks1 / (double)CLOCKS_PER_SEC; */
/*  	fprintf(MainFD, "seconds = %f\n", seconds); */
/*  	seconds = MainTicks2 / (double)CLOCKS_PER_SEC; */
/*  	fprintf(MainFD, "time hashing seconds = %f\n", seconds); */
/*      } */
/*
  if (clockTicks)
  {
  float	seconds;

  seconds = MainExploTicks / (double)CLOCKS_PER_SEC;
  printTime("Exploration time : ", seconds, totalSeconds);
  }
  fprintf(MainFD,
  "Number of positions : %ld\nNumber of finals tests : %ld\n",
  NbPosition, NbTestOK);
*/
    if (MainFD != stdout)		fclose(MainFD);

    if ( MainBeepFlag )
    {
	printf("");
    }
}
