grammar d2u; 
options{
	output=template;
}

@header{
package org.myorg.d2u;
}

@lexer::header {
package org.myorg.d2u;
}

@members{
	private String nl = "unix";
	
	public void setNewline(String s) { nl = s; };
	
	private void echo (String s) { System.out.print(s); }
}

// $<Parser

lines
@init{
	echo(%head(nl={nl}).toString());
	StringTemplate st = %MyTemplate();
	%st.x = "Test";
	echo(st.toString()); 
}
@after{
  echo(%tail(nl={nl}).toString());
}
	:	(l=line { echo($l.st.toString()); } NEWLINE )* (l=line { echo($l.st.toString()); }|EOF)
	;

line	:	chars -> write(s={$chars.text}, nl={nl})
	;

chars	:	(any+=ANY)* 
	;

// $>

// $<Lexer

NEWLINE	:	'\r'? '\n'
	;
	
ANY	:	.
	;

// $>
