#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1293
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 249
#define ALIAS_COUNT 1
#define TOKEN_COUNT 90
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 31
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 66

enum {
  sym_module_comment = 1,
  sym_statement_comment = 2,
  sym_comment = 3,
  anon_sym_if = 4,
  anon_sym_LBRACE = 5,
  anon_sym_RBRACE = 6,
  anon_sym_erlang = 7,
  anon_sym_javascript = 8,
  anon_sym_import = 9,
  anon_sym_DOT = 10,
  anon_sym_as = 11,
  anon_sym_SLASH = 12,
  anon_sym_COMMA = 13,
  anon_sym_const = 14,
  anon_sym_EQ = 15,
  anon_sym_POUND = 16,
  anon_sym_LPAREN = 17,
  anon_sym_RPAREN = 18,
  anon_sym_LBRACK = 19,
  anon_sym_RBRACK = 20,
  anon_sym_LT_LT = 21,
  anon_sym_GT_GT = 22,
  anon_sym_COLON = 23,
  anon_sym_DASH = 24,
  anon_sym_size = 25,
  anon_sym_external = 26,
  anon_sym_type = 27,
  anon_sym_fn = 28,
  anon_sym_DASH_GT = 29,
  anon_sym_try = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_LT = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_LT_DOT = 37,
  anon_sym_LT_EQ_DOT = 38,
  anon_sym_GT = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_GT_DOT = 41,
  anon_sym_GT_EQ_DOT = 42,
  anon_sym_PIPE_GT = 43,
  anon_sym_PLUS = 44,
  anon_sym_PLUS_DOT = 45,
  anon_sym_DASH_DOT = 46,
  anon_sym_STAR = 47,
  anon_sym_STAR_DOT = 48,
  anon_sym_SLASH_DOT = 49,
  anon_sym_PERCENT = 50,
  anon_sym_todo = 51,
  anon_sym_DOT_DOT = 52,
  anon_sym_case = 53,
  anon_sym_PIPE = 54,
  anon_sym_let = 55,
  anon_sym_assert = 56,
  anon_sym_BANG = 57,
  sym_visibility_modifier = 58,
  sym_opacity_modifier = 59,
  anon_sym_DQUOTE = 60,
  anon_sym_DQUOTE2 = 61,
  sym_escape_sequence = 62,
  sym_float = 63,
  sym__hex = 64,
  sym__decimal = 65,
  sym__octal = 66,
  sym__binary = 67,
  anon_sym_binary = 68,
  anon_sym_bytes = 69,
  anon_sym_int = 70,
  anon_sym_float = 71,
  anon_sym_bit_string = 72,
  anon_sym_bits = 73,
  anon_sym_utf8 = 74,
  anon_sym_utf16 = 75,
  anon_sym_utf32 = 76,
  anon_sym_utf8_codepoint = 77,
  anon_sym_utf16_codepoint = 78,
  anon_sym_utf32_codepoint = 79,
  anon_sym_signed = 80,
  anon_sym_unsigned = 81,
  anon_sym_big = 82,
  anon_sym_little = 83,
  anon_sym_native = 84,
  anon_sym_unit = 85,
  sym__discard_name = 86,
  sym__name = 87,
  sym__upname = 88,
  sym_quoted_content = 89,
  sym_source_file = 90,
  sym__statement = 91,
  sym_target_group = 92,
  sym_target = 93,
  sym_import = 94,
  sym_module = 95,
  sym_unqualified_imports = 96,
  sym_unqualified_import = 97,
  sym_constant = 98,
  sym__constant_value = 99,
  sym_constant_tuple = 100,
  sym_constant_list = 101,
  sym__constant_bit_string = 102,
  sym_constant_bit_string_segment = 103,
  sym_constant_bit_string_segment_options = 104,
  sym__constant_bit_string_segment_option = 105,
  sym__constant_bit_string_named_segment_option = 106,
  sym__constant_bit_string_segment_option_size = 107,
  sym_constant_record = 108,
  sym_constant_record_arguments = 109,
  sym_constant_record_argument = 110,
  sym__constant_type = 111,
  sym__constant_type_annotation = 112,
  sym_constant_tuple_type = 113,
  sym_constant_type = 114,
  sym_constant_type_arguments = 115,
  sym_constant_type_argument = 116,
  sym_external_type = 117,
  sym_external_function = 118,
  sym_external_function_parameters = 119,
  sym_external_function_parameter = 120,
  sym_external_function_body = 121,
  sym_function = 122,
  sym_function_parameters = 123,
  sym_function_parameter = 124,
  sym__labeled_discard_param = 125,
  sym__discard_param = 126,
  sym__labeled_name_param = 127,
  sym__name_param = 128,
  aux_sym__expression_seq = 129,
  sym_try = 130,
  sym__expression = 131,
  sym_binary_expression = 132,
  sym__expression_unit = 133,
  sym_record = 134,
  sym_todo = 135,
  sym_tuple = 136,
  sym_list = 137,
  sym__expression_bit_string = 138,
  sym_expression_bit_string_segment = 139,
  sym_expression_bit_string_segment_options = 140,
  sym__expression_bit_string_segment_option = 141,
  sym__expression_bit_string_named_segment_option = 142,
  sym__expression_bit_string_segment_option_size = 143,
  sym_anonymous_function = 144,
  sym_anonymous_function_parameters = 145,
  sym_anonymous_function_parameter = 146,
  sym_expression_group = 147,
  sym_case = 148,
  sym_case_subjects = 149,
  sym_case_clauses = 150,
  sym_case_clause = 151,
  sym_case_clause_patterns = 152,
  sym_case_clause_pattern = 153,
  sym_case_clause_guard = 154,
  sym__case_clause_guard_expression = 155,
  sym__case_clause_guard_binary_expression = 156,
  sym__case_clause_guard_unit = 157,
  sym__case_clause_tuple_access = 158,
  sym_let = 159,
  sym_assert = 160,
  sym_negation = 161,
  sym__assignment = 162,
  sym_record_update = 163,
  sym_record_update_arguments = 164,
  sym_record_update_argument = 165,
  sym__maybe_tuple_expression = 166,
  sym_tuple_access = 167,
  sym__maybe_record_expression = 168,
  sym_field_access = 169,
  sym__maybe_function_expression = 170,
  sym_arguments = 171,
  sym_argument = 172,
  sym_hole = 173,
  sym_function_call = 174,
  sym__pattern = 175,
  sym_record_pattern = 176,
  sym_record_pattern_arguments = 177,
  sym_record_pattern_argument = 178,
  sym_pattern_spread = 179,
  sym_tuple_pattern = 180,
  sym__pattern_bit_string = 181,
  sym_pattern_bit_string_segment = 182,
  sym_pattern_bit_string_segment_options = 183,
  sym__pattern_bit_string_segment_option = 184,
  sym__pattern_bit_string_named_segment_option = 185,
  sym__pattern_bit_string_segment_option_size = 186,
  sym__pattern_bit_string_segment_argument = 187,
  sym_list_pattern = 188,
  sym_list_pattern_tail = 189,
  sym_type_definition = 190,
  sym_data_constructors = 191,
  sym_data_constructor = 192,
  sym_data_constructor_arguments = 193,
  sym_data_constructor_argument = 194,
  sym_type_alias = 195,
  sym_string = 196,
  sym_integer = 197,
  sym__bit_string_segment_option = 198,
  sym__type = 199,
  sym__type_annotation = 200,
  sym_type_hole = 201,
  sym_tuple_type = 202,
  sym_function_type = 203,
  sym_function_parameter_types = 204,
  sym_type = 205,
  sym_type_arguments = 206,
  sym_type_argument = 207,
  sym_type_var = 208,
  sym_type_name = 209,
  sym_type_parameters = 210,
  sym_type_parameter = 211,
  sym_identifier = 212,
  sym_label = 213,
  sym_discard = 214,
  sym_type_identifier = 215,
  sym_remote_type_identifier = 216,
  sym_constructor_name = 217,
  sym_remote_constructor_name = 218,
  aux_sym_source_file_repeat1 = 219,
  aux_sym_target_group_repeat1 = 220,
  aux_sym_module_repeat1 = 221,
  aux_sym_unqualified_imports_repeat1 = 222,
  aux_sym_constant_tuple_repeat1 = 223,
  aux_sym__constant_bit_string_repeat1 = 224,
  aux_sym_constant_bit_string_segment_options_repeat1 = 225,
  aux_sym_constant_record_arguments_repeat1 = 226,
  aux_sym_constant_tuple_type_repeat1 = 227,
  aux_sym_constant_type_arguments_repeat1 = 228,
  aux_sym_external_function_parameters_repeat1 = 229,
  aux_sym_function_parameters_repeat1 = 230,
  aux_sym_tuple_repeat1 = 231,
  aux_sym__expression_bit_string_repeat1 = 232,
  aux_sym_expression_bit_string_segment_options_repeat1 = 233,
  aux_sym_anonymous_function_parameters_repeat1 = 234,
  aux_sym_case_clauses_repeat1 = 235,
  aux_sym_case_clause_patterns_repeat1 = 236,
  aux_sym_case_clause_pattern_repeat1 = 237,
  aux_sym_record_update_arguments_repeat1 = 238,
  aux_sym_arguments_repeat1 = 239,
  aux_sym_record_pattern_arguments_repeat1 = 240,
  aux_sym__pattern_bit_string_repeat1 = 241,
  aux_sym_pattern_bit_string_segment_options_repeat1 = 242,
  aux_sym_data_constructors_repeat1 = 243,
  aux_sym_data_constructor_arguments_repeat1 = 244,
  aux_sym_string_repeat1 = 245,
  aux_sym_tuple_type_repeat1 = 246,
  aux_sym_type_arguments_repeat1 = 247,
  aux_sym_type_parameters_repeat1 = 248,
  alias_sym_function_body = 249,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_module_comment] = "module_comment",
  [sym_statement_comment] = "statement_comment",
  [sym_comment] = "comment",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_erlang] = "erlang",
  [anon_sym_javascript] = "javascript",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_SLASH] = "/",
  [anon_sym_COMMA] = ",",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_POUND] = "#",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_COLON] = ":",
  [anon_sym_DASH] = "-",
  [anon_sym_size] = "size",
  [anon_sym_external] = "external",
  [anon_sym_type] = "type",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_try] = "try",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_DOT] = "<.",
  [anon_sym_LT_EQ_DOT] = "<=.",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_DOT] = ">.",
  [anon_sym_GT_EQ_DOT] = ">=.",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_PLUS] = "+",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_PERCENT] = "%",
  [anon_sym_todo] = "todo",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_case] = "case",
  [anon_sym_PIPE] = "|",
  [anon_sym_let] = "let",
  [anon_sym_assert] = "assert",
  [anon_sym_BANG] = "!",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_opacity_modifier] = "opacity_modifier",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [sym_escape_sequence] = "escape_sequence",
  [sym_float] = "float",
  [sym__hex] = "_hex",
  [sym__decimal] = "_decimal",
  [sym__octal] = "_octal",
  [sym__binary] = "_binary",
  [anon_sym_binary] = "binary",
  [anon_sym_bytes] = "bytes",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bit_string] = "bit_string",
  [anon_sym_bits] = "bits",
  [anon_sym_utf8] = "utf8",
  [anon_sym_utf16] = "utf16",
  [anon_sym_utf32] = "utf32",
  [anon_sym_utf8_codepoint] = "utf8_codepoint",
  [anon_sym_utf16_codepoint] = "utf16_codepoint",
  [anon_sym_utf32_codepoint] = "utf32_codepoint",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_big] = "big",
  [anon_sym_little] = "little",
  [anon_sym_native] = "native",
  [anon_sym_unit] = "unit",
  [sym__discard_name] = "_discard_name",
  [sym__name] = "_name",
  [sym__upname] = "_upname",
  [sym_quoted_content] = "quoted_content",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym_target_group] = "target_group",
  [sym_target] = "target",
  [sym_import] = "import",
  [sym_module] = "module",
  [sym_unqualified_imports] = "unqualified_imports",
  [sym_unqualified_import] = "unqualified_import",
  [sym_constant] = "constant",
  [sym__constant_value] = "_constant_value",
  [sym_constant_tuple] = "tuple",
  [sym_constant_list] = "list",
  [sym__constant_bit_string] = "bit_string",
  [sym_constant_bit_string_segment] = "bit_string_segment",
  [sym_constant_bit_string_segment_options] = "bit_string_segment_options",
  [sym__constant_bit_string_segment_option] = "_constant_bit_string_segment_option",
  [sym__constant_bit_string_named_segment_option] = "_constant_bit_string_named_segment_option",
  [sym__constant_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_constant_record] = "record",
  [sym_constant_record_arguments] = "arguments",
  [sym_constant_record_argument] = "argument",
  [sym__constant_type] = "_constant_type",
  [sym__constant_type_annotation] = "_constant_type_annotation",
  [sym_constant_tuple_type] = "tuple_type",
  [sym_constant_type] = "type",
  [sym_constant_type_arguments] = "type_arguments",
  [sym_constant_type_argument] = "type_argument",
  [sym_external_type] = "external_type",
  [sym_external_function] = "external_function",
  [sym_external_function_parameters] = "function_parameters",
  [sym_external_function_parameter] = "function_parameter",
  [sym_external_function_body] = "external_function_body",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter] = "function_parameter",
  [sym__labeled_discard_param] = "_labeled_discard_param",
  [sym__discard_param] = "_discard_param",
  [sym__labeled_name_param] = "_labeled_name_param",
  [sym__name_param] = "_name_param",
  [aux_sym__expression_seq] = "_expression_seq",
  [sym_try] = "try",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression_unit] = "_expression_unit",
  [sym_record] = "record",
  [sym_todo] = "todo",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym__expression_bit_string] = "bit_string",
  [sym_expression_bit_string_segment] = "bit_string_segment",
  [sym_expression_bit_string_segment_options] = "bit_string_segment_options",
  [sym__expression_bit_string_segment_option] = "_expression_bit_string_segment_option",
  [sym__expression_bit_string_named_segment_option] = "_expression_bit_string_named_segment_option",
  [sym__expression_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_anonymous_function] = "anonymous_function",
  [sym_anonymous_function_parameters] = "function_parameters",
  [sym_anonymous_function_parameter] = "function_parameter",
  [sym_expression_group] = "expression_group",
  [sym_case] = "case",
  [sym_case_subjects] = "case_subjects",
  [sym_case_clauses] = "case_clauses",
  [sym_case_clause] = "case_clause",
  [sym_case_clause_patterns] = "case_clause_patterns",
  [sym_case_clause_pattern] = "case_clause_pattern",
  [sym_case_clause_guard] = "case_clause_guard",
  [sym__case_clause_guard_expression] = "_case_clause_guard_expression",
  [sym__case_clause_guard_binary_expression] = "binary_expression",
  [sym__case_clause_guard_unit] = "_case_clause_guard_unit",
  [sym__case_clause_tuple_access] = "tuple_access",
  [sym_let] = "let",
  [sym_assert] = "assert",
  [sym_negation] = "negation",
  [sym__assignment] = "_assignment",
  [sym_record_update] = "record_update",
  [sym_record_update_arguments] = "record_update_arguments",
  [sym_record_update_argument] = "record_update_argument",
  [sym__maybe_tuple_expression] = "_maybe_tuple_expression",
  [sym_tuple_access] = "tuple_access",
  [sym__maybe_record_expression] = "_maybe_record_expression",
  [sym_field_access] = "field_access",
  [sym__maybe_function_expression] = "_maybe_function_expression",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_hole] = "hole",
  [sym_function_call] = "function_call",
  [sym__pattern] = "_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_arguments] = "record_pattern_arguments",
  [sym_record_pattern_argument] = "record_pattern_argument",
  [sym_pattern_spread] = "pattern_spread",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__pattern_bit_string] = "bit_string_pattern",
  [sym_pattern_bit_string_segment] = "bit_string_segment",
  [sym_pattern_bit_string_segment_options] = "bit_string_segment_options",
  [sym__pattern_bit_string_segment_option] = "_pattern_bit_string_segment_option",
  [sym__pattern_bit_string_named_segment_option] = "_pattern_bit_string_named_segment_option",
  [sym__pattern_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym__pattern_bit_string_segment_argument] = "_pattern_bit_string_segment_argument",
  [sym_list_pattern] = "list_pattern",
  [sym_list_pattern_tail] = "list_pattern_tail",
  [sym_type_definition] = "type_definition",
  [sym_data_constructors] = "data_constructors",
  [sym_data_constructor] = "data_constructor",
  [sym_data_constructor_arguments] = "data_constructor_arguments",
  [sym_data_constructor_argument] = "data_constructor_argument",
  [sym_type_alias] = "type_alias",
  [sym_string] = "string",
  [sym_integer] = "integer",
  [sym__bit_string_segment_option] = "bit_string_segment_option",
  [sym__type] = "_type",
  [sym__type_annotation] = "_type_annotation",
  [sym_type_hole] = "type_hole",
  [sym_tuple_type] = "tuple_type",
  [sym_function_type] = "function_type",
  [sym_function_parameter_types] = "function_parameter_types",
  [sym_type] = "type",
  [sym_type_arguments] = "type_arguments",
  [sym_type_argument] = "type_argument",
  [sym_type_var] = "type_var",
  [sym_type_name] = "type_name",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_identifier] = "identifier",
  [sym_label] = "label",
  [sym_discard] = "discard",
  [sym_type_identifier] = "type_identifier",
  [sym_remote_type_identifier] = "remote_type_identifier",
  [sym_constructor_name] = "constructor_name",
  [sym_remote_constructor_name] = "remote_constructor_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_target_group_repeat1] = "target_group_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_unqualified_imports_repeat1] = "unqualified_imports_repeat1",
  [aux_sym_constant_tuple_repeat1] = "constant_tuple_repeat1",
  [aux_sym__constant_bit_string_repeat1] = "_constant_bit_string_repeat1",
  [aux_sym_constant_bit_string_segment_options_repeat1] = "constant_bit_string_segment_options_repeat1",
  [aux_sym_constant_record_arguments_repeat1] = "constant_record_arguments_repeat1",
  [aux_sym_constant_tuple_type_repeat1] = "constant_tuple_type_repeat1",
  [aux_sym_constant_type_arguments_repeat1] = "constant_type_arguments_repeat1",
  [aux_sym_external_function_parameters_repeat1] = "external_function_parameters_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym__expression_bit_string_repeat1] = "_expression_bit_string_repeat1",
  [aux_sym_expression_bit_string_segment_options_repeat1] = "expression_bit_string_segment_options_repeat1",
  [aux_sym_anonymous_function_parameters_repeat1] = "anonymous_function_parameters_repeat1",
  [aux_sym_case_clauses_repeat1] = "case_clauses_repeat1",
  [aux_sym_case_clause_patterns_repeat1] = "case_clause_patterns_repeat1",
  [aux_sym_case_clause_pattern_repeat1] = "case_clause_pattern_repeat1",
  [aux_sym_record_update_arguments_repeat1] = "record_update_arguments_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_record_pattern_arguments_repeat1] = "record_pattern_arguments_repeat1",
  [aux_sym__pattern_bit_string_repeat1] = "_pattern_bit_string_repeat1",
  [aux_sym_pattern_bit_string_segment_options_repeat1] = "pattern_bit_string_segment_options_repeat1",
  [aux_sym_data_constructors_repeat1] = "data_constructors_repeat1",
  [aux_sym_data_constructor_arguments_repeat1] = "data_constructor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [alias_sym_function_body] = "function_body",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_module_comment] = sym_module_comment,
  [sym_statement_comment] = sym_statement_comment,
  [sym_comment] = sym_comment,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_erlang] = anon_sym_erlang,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_DOT] = anon_sym_LT_DOT,
  [anon_sym_LT_EQ_DOT] = anon_sym_LT_EQ_DOT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_DOT] = anon_sym_GT_DOT,
  [anon_sym_GT_EQ_DOT] = anon_sym_GT_EQ_DOT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_todo] = anon_sym_todo,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_opacity_modifier] = sym_opacity_modifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_float] = sym_float,
  [sym__hex] = sym__hex,
  [sym__decimal] = sym__decimal,
  [sym__octal] = sym__octal,
  [sym__binary] = sym__binary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bit_string] = anon_sym_bit_string,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_utf16] = anon_sym_utf16,
  [anon_sym_utf32] = anon_sym_utf32,
  [anon_sym_utf8_codepoint] = anon_sym_utf8_codepoint,
  [anon_sym_utf16_codepoint] = anon_sym_utf16_codepoint,
  [anon_sym_utf32_codepoint] = anon_sym_utf32_codepoint,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_big] = anon_sym_big,
  [anon_sym_little] = anon_sym_little,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_unit] = anon_sym_unit,
  [sym__discard_name] = sym__discard_name,
  [sym__name] = sym__name,
  [sym__upname] = sym__upname,
  [sym_quoted_content] = sym_quoted_content,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym_target_group] = sym_target_group,
  [sym_target] = sym_target,
  [sym_import] = sym_import,
  [sym_module] = sym_module,
  [sym_unqualified_imports] = sym_unqualified_imports,
  [sym_unqualified_import] = sym_unqualified_import,
  [sym_constant] = sym_constant,
  [sym__constant_value] = sym__constant_value,
  [sym_constant_tuple] = sym_tuple,
  [sym_constant_list] = sym_list,
  [sym__constant_bit_string] = sym__constant_bit_string,
  [sym_constant_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_constant_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__constant_bit_string_segment_option] = sym__constant_bit_string_segment_option,
  [sym__constant_bit_string_named_segment_option] = sym__constant_bit_string_named_segment_option,
  [sym__constant_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_constant_record] = sym_record,
  [sym_constant_record_arguments] = sym_arguments,
  [sym_constant_record_argument] = sym_argument,
  [sym__constant_type] = sym__constant_type,
  [sym__constant_type_annotation] = sym__constant_type_annotation,
  [sym_constant_tuple_type] = sym_tuple_type,
  [sym_constant_type] = sym_type,
  [sym_constant_type_arguments] = sym_type_arguments,
  [sym_constant_type_argument] = sym_type_argument,
  [sym_external_type] = sym_external_type,
  [sym_external_function] = sym_external_function,
  [sym_external_function_parameters] = sym_function_parameters,
  [sym_external_function_parameter] = sym_function_parameter,
  [sym_external_function_body] = sym_external_function_body,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter] = sym_function_parameter,
  [sym__labeled_discard_param] = sym__labeled_discard_param,
  [sym__discard_param] = sym__discard_param,
  [sym__labeled_name_param] = sym__labeled_name_param,
  [sym__name_param] = sym__name_param,
  [aux_sym__expression_seq] = aux_sym__expression_seq,
  [sym_try] = sym_try,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression_unit] = sym__expression_unit,
  [sym_record] = sym_record,
  [sym_todo] = sym_todo,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym__expression_bit_string] = sym__constant_bit_string,
  [sym_expression_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_expression_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__expression_bit_string_segment_option] = sym__expression_bit_string_segment_option,
  [sym__expression_bit_string_named_segment_option] = sym__expression_bit_string_named_segment_option,
  [sym__expression_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_anonymous_function_parameters] = sym_function_parameters,
  [sym_anonymous_function_parameter] = sym_function_parameter,
  [sym_expression_group] = sym_expression_group,
  [sym_case] = sym_case,
  [sym_case_subjects] = sym_case_subjects,
  [sym_case_clauses] = sym_case_clauses,
  [sym_case_clause] = sym_case_clause,
  [sym_case_clause_patterns] = sym_case_clause_patterns,
  [sym_case_clause_pattern] = sym_case_clause_pattern,
  [sym_case_clause_guard] = sym_case_clause_guard,
  [sym__case_clause_guard_expression] = sym__case_clause_guard_expression,
  [sym__case_clause_guard_binary_expression] = sym_binary_expression,
  [sym__case_clause_guard_unit] = sym__case_clause_guard_unit,
  [sym__case_clause_tuple_access] = sym_tuple_access,
  [sym_let] = sym_let,
  [sym_assert] = sym_assert,
  [sym_negation] = sym_negation,
  [sym__assignment] = sym__assignment,
  [sym_record_update] = sym_record_update,
  [sym_record_update_arguments] = sym_record_update_arguments,
  [sym_record_update_argument] = sym_record_update_argument,
  [sym__maybe_tuple_expression] = sym__maybe_tuple_expression,
  [sym_tuple_access] = sym_tuple_access,
  [sym__maybe_record_expression] = sym__maybe_record_expression,
  [sym_field_access] = sym_field_access,
  [sym__maybe_function_expression] = sym__maybe_function_expression,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_hole] = sym_hole,
  [sym_function_call] = sym_function_call,
  [sym__pattern] = sym__pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_arguments] = sym_record_pattern_arguments,
  [sym_record_pattern_argument] = sym_record_pattern_argument,
  [sym_pattern_spread] = sym_pattern_spread,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__pattern_bit_string] = sym__pattern_bit_string,
  [sym_pattern_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_pattern_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__pattern_bit_string_segment_option] = sym__pattern_bit_string_segment_option,
  [sym__pattern_bit_string_named_segment_option] = sym__pattern_bit_string_named_segment_option,
  [sym__pattern_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym__pattern_bit_string_segment_argument] = sym__pattern_bit_string_segment_argument,
  [sym_list_pattern] = sym_list_pattern,
  [sym_list_pattern_tail] = sym_list_pattern_tail,
  [sym_type_definition] = sym_type_definition,
  [sym_data_constructors] = sym_data_constructors,
  [sym_data_constructor] = sym_data_constructor,
  [sym_data_constructor_arguments] = sym_data_constructor_arguments,
  [sym_data_constructor_argument] = sym_data_constructor_argument,
  [sym_type_alias] = sym_type_alias,
  [sym_string] = sym_string,
  [sym_integer] = sym_integer,
  [sym__bit_string_segment_option] = sym__constant_bit_string_segment_option_size,
  [sym__type] = sym__type,
  [sym__type_annotation] = sym__type_annotation,
  [sym_type_hole] = sym_type_hole,
  [sym_tuple_type] = sym_tuple_type,
  [sym_function_type] = sym_function_type,
  [sym_function_parameter_types] = sym_function_parameter_types,
  [sym_type] = sym_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_type_argument] = sym_type_argument,
  [sym_type_var] = sym_type_var,
  [sym_type_name] = sym_type_name,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_identifier] = sym_identifier,
  [sym_label] = sym_label,
  [sym_discard] = sym_discard,
  [sym_type_identifier] = sym_type_identifier,
  [sym_remote_type_identifier] = sym_remote_type_identifier,
  [sym_constructor_name] = sym_constructor_name,
  [sym_remote_constructor_name] = sym_remote_constructor_name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_target_group_repeat1] = aux_sym_target_group_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_unqualified_imports_repeat1] = aux_sym_unqualified_imports_repeat1,
  [aux_sym_constant_tuple_repeat1] = aux_sym_constant_tuple_repeat1,
  [aux_sym__constant_bit_string_repeat1] = aux_sym__constant_bit_string_repeat1,
  [aux_sym_constant_bit_string_segment_options_repeat1] = aux_sym_constant_bit_string_segment_options_repeat1,
  [aux_sym_constant_record_arguments_repeat1] = aux_sym_constant_record_arguments_repeat1,
  [aux_sym_constant_tuple_type_repeat1] = aux_sym_constant_tuple_type_repeat1,
  [aux_sym_constant_type_arguments_repeat1] = aux_sym_constant_type_arguments_repeat1,
  [aux_sym_external_function_parameters_repeat1] = aux_sym_external_function_parameters_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym__expression_bit_string_repeat1] = aux_sym__expression_bit_string_repeat1,
  [aux_sym_expression_bit_string_segment_options_repeat1] = aux_sym_expression_bit_string_segment_options_repeat1,
  [aux_sym_anonymous_function_parameters_repeat1] = aux_sym_anonymous_function_parameters_repeat1,
  [aux_sym_case_clauses_repeat1] = aux_sym_case_clauses_repeat1,
  [aux_sym_case_clause_patterns_repeat1] = aux_sym_case_clause_patterns_repeat1,
  [aux_sym_case_clause_pattern_repeat1] = aux_sym_case_clause_pattern_repeat1,
  [aux_sym_record_update_arguments_repeat1] = aux_sym_record_update_arguments_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_record_pattern_arguments_repeat1] = aux_sym_record_pattern_arguments_repeat1,
  [aux_sym__pattern_bit_string_repeat1] = aux_sym__pattern_bit_string_repeat1,
  [aux_sym_pattern_bit_string_segment_options_repeat1] = aux_sym_pattern_bit_string_segment_options_repeat1,
  [aux_sym_data_constructors_repeat1] = aux_sym_data_constructors_repeat1,
  [aux_sym_data_constructor_arguments_repeat1] = aux_sym_data_constructor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [alias_sym_function_body] = alias_sym_function_body,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_module_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erlang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_todo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_opacity_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_little] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [sym__discard_name] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym__upname] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_target_group] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_import] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_value] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_list] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_type] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_external_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_name_param] = {
    .visible = false,
    .named = true,
  },
  [sym__name_param] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__expression_seq] = {
    .visible = false,
    .named = false,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_unit] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_group] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_subjects] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_guard_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_record_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_tuple_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_record_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__bit_string_segment_option] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_type_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_var] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_target_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unqualified_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constant_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_record_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_external_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_update_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_body] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_assign = 3,
  field_body = 4,
  field_clauses = 5,
  field_constructor = 6,
  field_field = 7,
  field_function = 8,
  field_guard = 9,
  field_imports = 10,
  field_index = 11,
  field_label = 12,
  field_left = 13,
  field_message = 14,
  field_module = 15,
  field_name = 16,
  field_operator = 17,
  field_options = 18,
  field_parameter_types = 19,
  field_parameters = 20,
  field_pattern = 21,
  field_patterns = 22,
  field_record = 23,
  field_return_type = 24,
  field_right = 25,
  field_spread = 26,
  field_subjects = 27,
  field_target = 28,
  field_tuple = 29,
  field_type = 30,
  field_value = 31,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_assign] = "assign",
  [field_body] = "body",
  [field_clauses] = "clauses",
  [field_constructor] = "constructor",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_message] = "message",
  [field_module] = "module",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_options] = "options",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_patterns] = "patterns",
  [field_record] = "record",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_spread] = "spread",
  [field_subjects] = "subjects",
  [field_target] = "target",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 4},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 1},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 3},
  [11] = {.index = 19, .length = 2},
  [12] = {.index = 21, .length = 2},
  [13] = {.index = 23, .length = 2},
  [14] = {.index = 25, .length = 1},
  [15] = {.index = 26, .length = 2},
  [16] = {.index = 28, .length = 2},
  [17] = {.index = 30, .length = 2},
  [18] = {.index = 32, .length = 1},
  [19] = {.index = 33, .length = 3},
  [20] = {.index = 36, .length = 2},
  [21] = {.index = 38, .length = 2},
  [22] = {.index = 40, .length = 1},
  [23] = {.index = 41, .length = 2},
  [24] = {.index = 43, .length = 3},
  [25] = {.index = 46, .length = 2},
  [26] = {.index = 48, .length = 1},
  [27] = {.index = 49, .length = 1},
  [28] = {.index = 50, .length = 3},
  [29] = {.index = 53, .length = 3},
  [30] = {.index = 56, .length = 1},
  [31] = {.index = 57, .length = 1},
  [32] = {.index = 58, .length = 2},
  [33] = {.index = 60, .length = 3},
  [34] = {.index = 63, .length = 2},
  [35] = {.index = 65, .length = 1},
  [36] = {.index = 66, .length = 2},
  [37] = {.index = 68, .length = 2},
  [38] = {.index = 70, .length = 4},
  [39] = {.index = 74, .length = 4},
  [40] = {.index = 78, .length = 2},
  [41] = {.index = 80, .length = 4},
  [42] = {.index = 84, .length = 2},
  [43] = {.index = 86, .length = 2},
  [44] = {.index = 88, .length = 3},
  [45] = {.index = 91, .length = 1},
  [46] = {.index = 92, .length = 1},
  [47] = {.index = 93, .length = 3},
  [48] = {.index = 96, .length = 2},
  [49] = {.index = 98, .length = 3},
  [50] = {.index = 101, .length = 3},
  [51] = {.index = 104, .length = 2},
  [52] = {.index = 106, .length = 2},
  [53] = {.index = 108, .length = 3},
  [54] = {.index = 111, .length = 2},
  [55] = {.index = 113, .length = 1},
  [56] = {.index = 114, .length = 2},
  [57] = {.index = 116, .length = 2},
  [58] = {.index = 118, .length = 3},
  [59] = {.index = 121, .length = 3},
  [60] = {.index = 124, .length = 3},
  [61] = {.index = 127, .length = 3},
  [62] = {.index = 130, .length = 4},
  [63] = {.index = 134, .length = 4},
  [64] = {.index = 138, .length = 4},
  [65] = {.index = 130, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_module, 1},
  [2] =
    {field_value, 0},
  [3] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_arguments, 1},
    {field_name, 0},
  [11] =
    {field_name, 0},
    {field_parameters, 1},
  [13] =
    {field_name, 0, .inherited = true},
  [14] =
    {field_assign, 0, .inherited = true},
    {field_value, 0},
  [16] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [19] =
    {field_index, 2},
    {field_tuple, 0},
  [21] =
    {field_field, 2},
    {field_record, 0},
  [23] =
    {field_module, 0},
    {field_name, 2},
  [25] =
    {field_target, 1},
  [26] =
    {field_imports, 3},
    {field_module, 1},
  [28] =
    {field_alias, 3},
    {field_module, 1},
  [30] =
    {field_name, 1},
    {field_value, 3},
  [32] =
    {field_type, 1},
  [33] =
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [36] =
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [38] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [40] =
    {field_assign, 1, .inherited = true},
  [41] =
    {field_assign, 1},
    {field_assign, 2},
  [43] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1},
    {field_value, 3},
  [46] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
  [48] =
    {field_message, 2},
  [49] =
    {field_assign, 0, .inherited = true},
  [50] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_value, 2},
  [53] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [56] =
    {field_spread, 3},
  [57] =
    {field_type, 0},
  [58] =
    {field_body, 3},
    {field_parameters, 1},
  [60] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [63] =
    {field_label, 0},
    {field_name, 1},
  [65] =
    {field_assign, 2, .inherited = true},
  [66] =
    {field_assign, 1, .inherited = true},
    {field_assign, 2, .inherited = true},
  [68] =
    {field_assign, 0, .inherited = true},
    {field_assign, 1, .inherited = true},
  [70] =
    {field_assign, 0, .inherited = true},
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [74] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [78] =
    {field_clauses, 3},
    {field_subjects, 1},
  [80] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_type, 1, .inherited = true},
    {field_value, 3},
  [84] =
    {field_name, 2},
    {field_value, 4},
  [86] =
    {field_label, 0},
    {field_value, 2},
  [88] =
    {field_alias, 5},
    {field_imports, 3},
    {field_module, 1},
  [91] =
    {field_spread, 4},
  [92] =
    {field_return_type, 2},
  [93] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [96] =
    {field_assign, 2, .inherited = true},
    {field_assign, 3, .inherited = true},
  [98] =
    {field_assign, 2, .inherited = true},
    {field_label, 0},
    {field_pattern, 2},
  [101] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [104] =
    {field_index, 0, .inherited = true},
    {field_tuple, 0, .inherited = true},
  [106] =
    {field_patterns, 0},
    {field_value, 2},
  [108] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 5},
  [111] =
    {field_alias, 2},
    {field_name, 0},
  [113] =
    {field_spread, 5},
  [114] =
    {field_name, 0},
    {field_type, 2},
  [116] =
    {field_parameter_types, 1},
    {field_return_type, 3},
  [118] =
    {field_body, 5},
    {field_parameters, 1},
    {field_return_type, 3},
  [121] =
    {field_guard, 1},
    {field_patterns, 0},
    {field_value, 3},
  [124] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [127] =
    {field_arguments, 5},
    {field_constructor, 0},
    {field_spread, 3},
  [130] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [134] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [138] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [32] = {
    [3] = alias_sym_function_body,
  },
  [47] = {
    [4] = alias_sym_function_body,
  },
  [58] = {
    [5] = alias_sym_function_body,
  },
  [60] = {
    [5] = alias_sym_function_body,
  },
  [63] = {
    [6] = alias_sym_function_body,
  },
  [65] = {
    [7] = alias_sym_function_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__expression_seq, 2,
    aux_sym__expression_seq,
    alias_sym_function_body,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(151)
      if (lookahead == '\r') SKIP(151)
      if (lookahead == '!') ADVANCE(236);
      if (lookahead == '"') ADVANCE(242);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(191);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(209);
      if (lookahead == '=') ADVANCE(180);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(288);
      if (lookahead == 'a') ADVANCE(393);
      if (lookahead == 'b') ADVANCE(341);
      if (lookahead == 'c') ADVANCE(297);
      if (lookahead == 'e') ADVANCE(386);
      if (lookahead == 'f') ADVANCE(351);
      if (lookahead == 'i') ADVANCE(332);
      if (lookahead == 'j') ADVANCE(295);
      if (lookahead == 'l') ADVANCE(324);
      if (lookahead == 'n') ADVANCE(303);
      if (lookahead == 'o') ADVANCE(379);
      if (lookahead == 'p') ADVANCE(418);
      if (lookahead == 's') ADVANCE(342);
      if (lookahead == 't') ADVANCE(366);
      if (lookahead == 'u') ADVANCE(356);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(231);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 1:
      if (lookahead == '&') ADVANCE(206);
      END_STATE();
    case 2:
      if (lookahead == '.') ADVANCE(228);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '/') ADVANCE(158);
      END_STATE();
    case 5:
      if (lookahead == '1') ADVANCE(7);
      if (lookahead == '3') ADVANCE(6);
      if (lookahead == '8') ADVANCE(265);
      END_STATE();
    case 6:
      if (lookahead == '2') ADVANCE(268);
      END_STATE();
    case 7:
      if (lookahead == '6') ADVANCE(266);
      END_STATE();
    case 8:
      if (lookahead == '<') ADVANCE(186);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(208);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(207);
      END_STATE();
    case 11:
      if (lookahead == '>') ADVANCE(203);
      END_STATE();
    case 12:
      if (lookahead == '>') ADVANCE(187);
      END_STATE();
    case 13:
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 14:
      if (lookahead == '_') ADVANCE(107);
      if (lookahead == 's') ADVANCE(262);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(98);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 23:
      if (lookahead == 'b') ADVANCE(237);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(82);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(87);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(88);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(276);
      END_STATE();
    case 29:
      if (lookahead == 'd') ADVANCE(278);
      END_STATE();
    case 30:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(43);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(44);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(239);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(5);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(160);
      END_STATE();
    case 47:
      if (lookahead == 'f') ADVANCE(160);
      if (lookahead == 'm') ADVANCE(89);
      END_STATE();
    case 48:
      if (lookahead == 'g') ADVANCE(280);
      if (lookahead == 'n') ADVANCE(17);
      if (lookahead == 't') ADVANCE(14);
      END_STATE();
    case 49:
      if (lookahead == 'g') ADVANCE(164);
      END_STATE();
    case 50:
      if (lookahead == 'g') ADVANCE(260);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(74);
      if (lookahead == 'z') ADVANCE(33);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(76);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(48);
      if (lookahead == 'y') ADVANCE(108);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(93);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 's') ADVANCE(55);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(197);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(83);
      if (lookahead == 'n') ADVANCE(201);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(18);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(36);
      END_STATE();
    case 68:
      if (lookahead == 'm') ADVANCE(89);
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(201);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(116);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(117);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 82:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 83:
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(81);
      END_STATE();
    case 90:
      if (lookahead == 'p') ADVANCE(16);
      END_STATE();
    case 91:
      if (lookahead == 'p') ADVANCE(34);
      END_STATE();
    case 92:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(114);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(86);
      END_STATE();
    case 96:
      if (lookahead == 'q') ADVANCE(124);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(66);
      if (lookahead == 'x') ADVANCE(119);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 99:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(58);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(172);
      END_STATE();
    case 104:
      if (lookahead == 's') ADVANCE(254);
      END_STATE();
    case 105:
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(111);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(258);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(274);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(23);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 125:
      if (lookahead == 'v') ADVANCE(20);
      END_STATE();
    case 126:
      if (lookahead == 'v') ADVANCE(37);
      END_STATE();
    case 127:
      if (lookahead == 'x') ADVANCE(119);
      END_STATE();
    case 128:
      if (lookahead == 'y') ADVANCE(252);
      END_STATE();
    case 129:
      if (lookahead == 'y') ADVANCE(91);
      END_STATE();
    case 130:
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 131:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(251);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(132)
      if (lookahead == '\r') SKIP(132)
      if (lookahead == '!') ADVANCE(235);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(2);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '=') ADVANCE(179);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '_') ADVANCE(288);
      if (lookahead == 'a') ADVANCE(398);
      if (lookahead == 'c') ADVANCE(298);
      if (lookahead == 'f') ADVANCE(355);
      if (lookahead == 'l') ADVANCE(325);
      if (lookahead == 't') ADVANCE(368);
      if (lookahead == '{') ADVANCE(162);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 133:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(133)
      if (lookahead == '\r') SKIP(133)
      if (lookahead == '!') ADVANCE(236);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(192);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(209);
      if (lookahead == '=') ADVANCE(180);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(290);
      if (lookahead == 'a') ADVANCE(398);
      if (lookahead == 'c') ADVANCE(298);
      if (lookahead == 'f') ADVANCE(355);
      if (lookahead == 'l') ADVANCE(325);
      if (lookahead == 't') ADVANCE(367);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 134:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(134)
      if (lookahead == '\r') SKIP(134)
      if (lookahead == '!') ADVANCE(235);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(2);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '>') ADVANCE(12);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(290);
      if (lookahead == 'a') ADVANCE(398);
      if (lookahead == 'c') ADVANCE(298);
      if (lookahead == 'f') ADVANCE(355);
      if (lookahead == 'l') ADVANCE(325);
      if (lookahead == 't') ADVANCE(368);
      if (lookahead == '{') ADVANCE(162);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(136)
      if (lookahead == '\r') SKIP(136)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '"') ADVANCE(242);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(190);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(248);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(210);
      if (lookahead == '=') ADVANCE(180);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'b') ADVANCE(53);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(97);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 'j') ADVANCE(15);
      if (lookahead == 'l') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 's') ADVANCE(54);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == 'u') ADVANCE(70);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(249);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(136)
      if (lookahead == '\r') SKIP(136)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(190);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(248);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(210);
      if (lookahead == '=') ADVANCE(180);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'b') ADVANCE(53);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(97);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 'j') ADVANCE(15);
      if (lookahead == 'l') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 's') ADVANCE(54);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == 'u') ADVANCE(70);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(249);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 137:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(137)
      if (lookahead == '\r') SKIP(137)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == '-') ADVANCE(192);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == '<') ADVANCE(209);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(288);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 138:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(138)
      if (lookahead == '\r') SKIP(138)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(190);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(210);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(163);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(139)
      if (lookahead == '\r') SKIP(139)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '.') ADVANCE(170);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(210);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(127);
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(163);
      END_STATE();
    case 140:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(140)
      if (lookahead == '\r') SKIP(140)
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '-') ADVANCE(193);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '_') ADVANCE(288);
      if (lookahead == 'i') ADVANCE(334);
      if (lookahead == '|') ADVANCE(230);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(141)
      if (lookahead == '\r') SKIP(141)
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '>') ADVANCE(12);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(290);
      if (lookahead == '{') ADVANCE(162);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(142)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '.') ADVANCE(170);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '<') ADVANCE(210);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'i') ADVANCE(46);
      if (lookahead == '|') ADVANCE(232);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(143)
      if (lookahead == '\r') SKIP(143)
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '_') ADVANCE(289);
      if (lookahead == 'f') ADVANCE(355);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(144)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '=') ADVANCE(179);
      if (lookahead == '>') ADVANCE(12);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(127);
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(230);
      if (lookahead == '}') ADVANCE(163);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(145)
      if (lookahead == '\r') SKIP(145)
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(289);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(146)
      if (lookahead == '\r') SKIP(146)
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '-') ADVANCE(189);
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '0') ADVANCE(248);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(249);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(147)
      if (lookahead == '\r') SKIP(147)
      if (lookahead == '!') ADVANCE(236);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(192);
      if (lookahead == '.') ADVANCE(170);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(209);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(290);
      if (lookahead == 'a') ADVANCE(398);
      if (lookahead == 'c') ADVANCE(298);
      if (lookahead == 'f') ADVANCE(355);
      if (lookahead == 'l') ADVANCE(325);
      if (lookahead == 't') ADVANCE(367);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(13);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 148:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(243);
      END_STATE();
    case 149:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(250);
      END_STATE();
    case 150:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(245);
      END_STATE();
    case 151:
      if (eof) ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(151)
      if (lookahead == '\r') SKIP(151)
      if (lookahead == '!') ADVANCE(236);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == ')') ADVANCE(183);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '-') ADVANCE(191);
      if (lookahead == '.') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead == '<') ADVANCE(209);
      if (lookahead == '=') ADVANCE(180);
      if (lookahead == '>') ADVANCE(215);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '_') ADVANCE(288);
      if (lookahead == 'a') ADVANCE(393);
      if (lookahead == 'b') ADVANCE(341);
      if (lookahead == 'c') ADVANCE(297);
      if (lookahead == 'e') ADVANCE(386);
      if (lookahead == 'f') ADVANCE(351);
      if (lookahead == 'i') ADVANCE(332);
      if (lookahead == 'j') ADVANCE(295);
      if (lookahead == 'l') ADVANCE(324);
      if (lookahead == 'n') ADVANCE(303);
      if (lookahead == 'o') ADVANCE(379);
      if (lookahead == 'p') ADVANCE(418);
      if (lookahead == 's') ADVANCE(342);
      if (lookahead == 't') ADVANCE(366);
      if (lookahead == 'u') ADVANCE(356);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(231);
      if (lookahead == '}') ADVANCE(163);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 152:
      if (eof) ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(152)
      if (lookahead == '\r') SKIP(152)
      if (lookahead == '!') ADVANCE(236);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '%') ADVANCE(226);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(182);
      if (lookahead == '*') ADVANCE(223);
      if (lookahead == '+') ADVANCE(220);
      if (lookahead == '-') ADVANCE(192);
      if (lookahead == '.') ADVANCE(170);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == '<') ADVANCE(209);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '_') ADVANCE(290);
      if (lookahead == 'a') ADVANCE(398);
      if (lookahead == 'c') ADVANCE(297);
      if (lookahead == 'e') ADVANCE(422);
      if (lookahead == 'f') ADVANCE(355);
      if (lookahead == 'i') ADVANCE(333);
      if (lookahead == 'l') ADVANCE(325);
      if (lookahead == 'o') ADVANCE(379);
      if (lookahead == 'p') ADVANCE(418);
      if (lookahead == 't') ADVANCE(366);
      if (lookahead == '{') ADVANCE(162);
      if (lookahead == '|') ADVANCE(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 153:
      if (eof) ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ' ||
          lookahead == ';') SKIP(153)
      if (lookahead == '\r') SKIP(153)
      if (lookahead == '!') ADVANCE(235);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead == '#') ADVANCE(181);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(170);
      if (lookahead == '/') ADVANCE(175);
      if (lookahead == '0') ADVANCE(246);
      if (lookahead == '<') ADVANCE(8);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '_') ADVANCE(290);
      if (lookahead == 'a') ADVANCE(393);
      if (lookahead == 'c') ADVANCE(297);
      if (lookahead == 'e') ADVANCE(422);
      if (lookahead == 'f') ADVANCE(355);
      if (lookahead == 'i') ADVANCE(333);
      if (lookahead == 'l') ADVANCE(325);
      if (lookahead == 'o') ADVANCE(379);
      if (lookahead == 'p') ADVANCE(418);
      if (lookahead == 't') ADVANCE(366);
      if (lookahead == '{') ADVANCE(162);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(426);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(155);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(159);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(159);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_erlang);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_erlang);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_javascript);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(228);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(225);
      if (lookahead == '/') ADVANCE(158);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(158);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(207);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(222);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(222);
      if (lookahead == '>') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(3);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_size);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_external);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_try);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(212);
      if (lookahead == '<') ADVANCE(186);
      if (lookahead == '=') ADVANCE(211);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(212);
      if (lookahead == '=') ADVANCE(211);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.') ADVANCE(213);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LT_DOT);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_LT_EQ_DOT);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(217);
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(217);
      if (lookahead == '=') ADVANCE(216);
      if (lookahead == '>') ADVANCE(187);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.') ADVANCE(218);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_GT_DOT);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_GT_EQ_DOT);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(221);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(224);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_todo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(219);
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(205);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(208);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_visibility_modifier);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_visibility_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_opacity_modifier);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_opacity_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(244);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym__hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(245);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(244);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(131);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(149);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(247);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(247);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(131);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(149);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(249);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym__decimal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(249);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym__octal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(250);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym__binary);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(251);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_binary);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_bit_string);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_bit_string);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_bits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(306);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(24);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(26);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(308);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_signed);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_big);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_big);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_little);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_little);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_native);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_unit);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_unit);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym__discard_name);
      if (lookahead == '.') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(288);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym__discard_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '.') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(290);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '1') ADVANCE(293);
      if (lookahead == '3') ADVANCE(292);
      if (lookahead == '8') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '2') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '6') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '_') ADVANCE(400);
      if (lookahead == 's') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(397);
      if (lookahead == 'o') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'b') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(402);
      if (lookahead == 'i') ADVANCE(416);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'm') ADVANCE(378);
      if (lookahead == 'n') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'm') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(281);
      if (lookahead == 'n') ADVANCE(299);
      if (lookahead == 't') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(360);
      if (lookahead == 'z') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(425);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(336);
      if (lookahead == 'y') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(403);
      if (lookahead == 's') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(372);
      if (lookahead == 'n') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(348);
      if (lookahead == 't') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(312);
      if (lookahead == 'r') ADVANCE(423);
      if (lookahead == 'y') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(312);
      if (lookahead == 'r') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(392);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'q') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(353);
      if (lookahead == 'x') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'x') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(425);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__upname);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(426);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 152},
  [2] = {.lex_state = 152},
  [3] = {.lex_state = 152},
  [4] = {.lex_state = 152},
  [5] = {.lex_state = 152},
  [6] = {.lex_state = 152},
  [7] = {.lex_state = 152},
  [8] = {.lex_state = 152},
  [9] = {.lex_state = 152},
  [10] = {.lex_state = 132},
  [11] = {.lex_state = 152},
  [12] = {.lex_state = 152},
  [13] = {.lex_state = 132},
  [14] = {.lex_state = 133},
  [15] = {.lex_state = 132},
  [16] = {.lex_state = 152},
  [17] = {.lex_state = 152},
  [18] = {.lex_state = 152},
  [19] = {.lex_state = 152},
  [20] = {.lex_state = 152},
  [21] = {.lex_state = 152},
  [22] = {.lex_state = 152},
  [23] = {.lex_state = 152},
  [24] = {.lex_state = 152},
  [25] = {.lex_state = 152},
  [26] = {.lex_state = 152},
  [27] = {.lex_state = 132},
  [28] = {.lex_state = 152},
  [29] = {.lex_state = 152},
  [30] = {.lex_state = 132},
  [31] = {.lex_state = 132},
  [32] = {.lex_state = 152},
  [33] = {.lex_state = 152},
  [34] = {.lex_state = 132},
  [35] = {.lex_state = 132},
  [36] = {.lex_state = 132},
  [37] = {.lex_state = 152},
  [38] = {.lex_state = 152},
  [39] = {.lex_state = 152},
  [40] = {.lex_state = 152},
  [41] = {.lex_state = 132},
  [42] = {.lex_state = 132},
  [43] = {.lex_state = 152},
  [44] = {.lex_state = 132},
  [45] = {.lex_state = 152},
  [46] = {.lex_state = 152},
  [47] = {.lex_state = 152},
  [48] = {.lex_state = 132},
  [49] = {.lex_state = 152},
  [50] = {.lex_state = 132},
  [51] = {.lex_state = 132},
  [52] = {.lex_state = 132},
  [53] = {.lex_state = 132},
  [54] = {.lex_state = 152},
  [55] = {.lex_state = 133},
  [56] = {.lex_state = 133},
  [57] = {.lex_state = 152},
  [58] = {.lex_state = 152},
  [59] = {.lex_state = 152},
  [60] = {.lex_state = 152},
  [61] = {.lex_state = 152},
  [62] = {.lex_state = 152},
  [63] = {.lex_state = 133},
  [64] = {.lex_state = 133},
  [65] = {.lex_state = 133},
  [66] = {.lex_state = 133},
  [67] = {.lex_state = 152},
  [68] = {.lex_state = 133},
  [69] = {.lex_state = 152},
  [70] = {.lex_state = 133},
  [71] = {.lex_state = 147},
  [72] = {.lex_state = 152},
  [73] = {.lex_state = 133},
  [74] = {.lex_state = 152},
  [75] = {.lex_state = 152},
  [76] = {.lex_state = 152},
  [77] = {.lex_state = 152},
  [78] = {.lex_state = 133},
  [79] = {.lex_state = 152},
  [80] = {.lex_state = 152},
  [81] = {.lex_state = 152},
  [82] = {.lex_state = 152},
  [83] = {.lex_state = 133},
  [84] = {.lex_state = 133},
  [85] = {.lex_state = 152},
  [86] = {.lex_state = 147},
  [87] = {.lex_state = 133},
  [88] = {.lex_state = 147},
  [89] = {.lex_state = 133},
  [90] = {.lex_state = 152},
  [91] = {.lex_state = 152},
  [92] = {.lex_state = 152},
  [93] = {.lex_state = 133},
  [94] = {.lex_state = 152},
  [95] = {.lex_state = 152},
  [96] = {.lex_state = 133},
  [97] = {.lex_state = 152},
  [98] = {.lex_state = 147},
  [99] = {.lex_state = 152},
  [100] = {.lex_state = 152},
  [101] = {.lex_state = 133},
  [102] = {.lex_state = 152},
  [103] = {.lex_state = 133},
  [104] = {.lex_state = 133},
  [105] = {.lex_state = 133},
  [106] = {.lex_state = 152},
  [107] = {.lex_state = 133},
  [108] = {.lex_state = 133},
  [109] = {.lex_state = 133},
  [110] = {.lex_state = 133},
  [111] = {.lex_state = 133},
  [112] = {.lex_state = 133},
  [113] = {.lex_state = 133},
  [114] = {.lex_state = 133},
  [115] = {.lex_state = 133},
  [116] = {.lex_state = 133},
  [117] = {.lex_state = 133},
  [118] = {.lex_state = 133},
  [119] = {.lex_state = 133},
  [120] = {.lex_state = 133},
  [121] = {.lex_state = 147},
  [122] = {.lex_state = 133},
  [123] = {.lex_state = 133},
  [124] = {.lex_state = 133},
  [125] = {.lex_state = 133},
  [126] = {.lex_state = 133},
  [127] = {.lex_state = 133},
  [128] = {.lex_state = 133},
  [129] = {.lex_state = 134},
  [130] = {.lex_state = 147},
  [131] = {.lex_state = 147},
  [132] = {.lex_state = 134},
  [133] = {.lex_state = 147},
  [134] = {.lex_state = 134},
  [135] = {.lex_state = 134},
  [136] = {.lex_state = 134},
  [137] = {.lex_state = 147},
  [138] = {.lex_state = 134},
  [139] = {.lex_state = 147},
  [140] = {.lex_state = 147},
  [141] = {.lex_state = 147},
  [142] = {.lex_state = 147},
  [143] = {.lex_state = 132},
  [144] = {.lex_state = 134},
  [145] = {.lex_state = 134},
  [146] = {.lex_state = 147},
  [147] = {.lex_state = 147},
  [148] = {.lex_state = 147},
  [149] = {.lex_state = 147},
  [150] = {.lex_state = 147},
  [151] = {.lex_state = 147},
  [152] = {.lex_state = 134},
  [153] = {.lex_state = 134},
  [154] = {.lex_state = 147},
  [155] = {.lex_state = 134},
  [156] = {.lex_state = 134},
  [157] = {.lex_state = 147},
  [158] = {.lex_state = 147},
  [159] = {.lex_state = 134},
  [160] = {.lex_state = 147},
  [161] = {.lex_state = 147},
  [162] = {.lex_state = 147},
  [163] = {.lex_state = 147},
  [164] = {.lex_state = 147},
  [165] = {.lex_state = 147},
  [166] = {.lex_state = 134},
  [167] = {.lex_state = 134},
  [168] = {.lex_state = 134},
  [169] = {.lex_state = 134},
  [170] = {.lex_state = 134},
  [171] = {.lex_state = 134},
  [172] = {.lex_state = 134},
  [173] = {.lex_state = 134},
  [174] = {.lex_state = 134},
  [175] = {.lex_state = 147},
  [176] = {.lex_state = 147},
  [177] = {.lex_state = 147},
  [178] = {.lex_state = 134},
  [179] = {.lex_state = 134},
  [180] = {.lex_state = 134},
  [181] = {.lex_state = 134},
  [182] = {.lex_state = 134},
  [183] = {.lex_state = 134},
  [184] = {.lex_state = 134},
  [185] = {.lex_state = 134},
  [186] = {.lex_state = 134},
  [187] = {.lex_state = 134},
  [188] = {.lex_state = 134},
  [189] = {.lex_state = 134},
  [190] = {.lex_state = 134},
  [191] = {.lex_state = 134},
  [192] = {.lex_state = 134},
  [193] = {.lex_state = 134},
  [194] = {.lex_state = 134},
  [195] = {.lex_state = 134},
  [196] = {.lex_state = 134},
  [197] = {.lex_state = 134},
  [198] = {.lex_state = 134},
  [199] = {.lex_state = 134},
  [200] = {.lex_state = 134},
  [201] = {.lex_state = 134},
  [202] = {.lex_state = 134},
  [203] = {.lex_state = 134},
  [204] = {.lex_state = 134},
  [205] = {.lex_state = 134},
  [206] = {.lex_state = 134},
  [207] = {.lex_state = 134},
  [208] = {.lex_state = 134},
  [209] = {.lex_state = 134},
  [210] = {.lex_state = 134},
  [211] = {.lex_state = 134},
  [212] = {.lex_state = 134},
  [213] = {.lex_state = 134},
  [214] = {.lex_state = 134},
  [215] = {.lex_state = 134},
  [216] = {.lex_state = 134},
  [217] = {.lex_state = 134},
  [218] = {.lex_state = 134},
  [219] = {.lex_state = 134},
  [220] = {.lex_state = 134},
  [221] = {.lex_state = 134},
  [222] = {.lex_state = 134},
  [223] = {.lex_state = 134},
  [224] = {.lex_state = 134},
  [225] = {.lex_state = 134},
  [226] = {.lex_state = 134},
  [227] = {.lex_state = 134},
  [228] = {.lex_state = 134},
  [229] = {.lex_state = 134},
  [230] = {.lex_state = 134},
  [231] = {.lex_state = 134},
  [232] = {.lex_state = 134},
  [233] = {.lex_state = 134},
  [234] = {.lex_state = 134},
  [235] = {.lex_state = 134},
  [236] = {.lex_state = 134},
  [237] = {.lex_state = 134},
  [238] = {.lex_state = 134},
  [239] = {.lex_state = 134},
  [240] = {.lex_state = 134},
  [241] = {.lex_state = 134},
  [242] = {.lex_state = 147},
  [243] = {.lex_state = 147},
  [244] = {.lex_state = 147},
  [245] = {.lex_state = 147},
  [246] = {.lex_state = 147},
  [247] = {.lex_state = 147},
  [248] = {.lex_state = 147},
  [249] = {.lex_state = 134},
  [250] = {.lex_state = 134},
  [251] = {.lex_state = 134},
  [252] = {.lex_state = 134},
  [253] = {.lex_state = 134},
  [254] = {.lex_state = 134},
  [255] = {.lex_state = 147},
  [256] = {.lex_state = 147},
  [257] = {.lex_state = 147},
  [258] = {.lex_state = 134},
  [259] = {.lex_state = 134},
  [260] = {.lex_state = 134},
  [261] = {.lex_state = 147},
  [262] = {.lex_state = 147},
  [263] = {.lex_state = 147},
  [264] = {.lex_state = 134},
  [265] = {.lex_state = 134},
  [266] = {.lex_state = 134},
  [267] = {.lex_state = 147},
  [268] = {.lex_state = 147},
  [269] = {.lex_state = 134},
  [270] = {.lex_state = 134},
  [271] = {.lex_state = 134},
  [272] = {.lex_state = 134},
  [273] = {.lex_state = 134},
  [274] = {.lex_state = 134},
  [275] = {.lex_state = 134},
  [276] = {.lex_state = 134},
  [277] = {.lex_state = 134},
  [278] = {.lex_state = 134},
  [279] = {.lex_state = 134},
  [280] = {.lex_state = 147},
  [281] = {.lex_state = 147},
  [282] = {.lex_state = 147},
  [283] = {.lex_state = 147},
  [284] = {.lex_state = 147},
  [285] = {.lex_state = 147},
  [286] = {.lex_state = 147},
  [287] = {.lex_state = 147},
  [288] = {.lex_state = 147},
  [289] = {.lex_state = 147},
  [290] = {.lex_state = 147},
  [291] = {.lex_state = 147},
  [292] = {.lex_state = 135},
  [293] = {.lex_state = 135},
  [294] = {.lex_state = 135},
  [295] = {.lex_state = 135},
  [296] = {.lex_state = 135},
  [297] = {.lex_state = 135},
  [298] = {.lex_state = 135},
  [299] = {.lex_state = 137},
  [300] = {.lex_state = 137},
  [301] = {.lex_state = 137},
  [302] = {.lex_state = 137},
  [303] = {.lex_state = 137},
  [304] = {.lex_state = 137},
  [305] = {.lex_state = 137},
  [306] = {.lex_state = 137},
  [307] = {.lex_state = 137},
  [308] = {.lex_state = 137},
  [309] = {.lex_state = 137},
  [310] = {.lex_state = 137},
  [311] = {.lex_state = 137},
  [312] = {.lex_state = 137},
  [313] = {.lex_state = 137},
  [314] = {.lex_state = 137},
  [315] = {.lex_state = 137},
  [316] = {.lex_state = 137},
  [317] = {.lex_state = 137},
  [318] = {.lex_state = 137},
  [319] = {.lex_state = 137},
  [320] = {.lex_state = 137},
  [321] = {.lex_state = 137},
  [322] = {.lex_state = 137},
  [323] = {.lex_state = 137},
  [324] = {.lex_state = 137},
  [325] = {.lex_state = 137},
  [326] = {.lex_state = 137},
  [327] = {.lex_state = 137},
  [328] = {.lex_state = 137},
  [329] = {.lex_state = 137},
  [330] = {.lex_state = 137},
  [331] = {.lex_state = 137},
  [332] = {.lex_state = 137},
  [333] = {.lex_state = 137},
  [334] = {.lex_state = 137},
  [335] = {.lex_state = 137},
  [336] = {.lex_state = 137},
  [337] = {.lex_state = 137},
  [338] = {.lex_state = 137},
  [339] = {.lex_state = 137},
  [340] = {.lex_state = 137},
  [341] = {.lex_state = 137},
  [342] = {.lex_state = 137},
  [343] = {.lex_state = 137},
  [344] = {.lex_state = 137},
  [345] = {.lex_state = 137},
  [346] = {.lex_state = 137},
  [347] = {.lex_state = 137},
  [348] = {.lex_state = 137},
  [349] = {.lex_state = 137},
  [350] = {.lex_state = 137},
  [351] = {.lex_state = 137},
  [352] = {.lex_state = 137},
  [353] = {.lex_state = 137},
  [354] = {.lex_state = 137},
  [355] = {.lex_state = 137},
  [356] = {.lex_state = 137},
  [357] = {.lex_state = 153},
  [358] = {.lex_state = 153},
  [359] = {.lex_state = 138},
  [360] = {.lex_state = 153},
  [361] = {.lex_state = 135},
  [362] = {.lex_state = 135},
  [363] = {.lex_state = 138},
  [364] = {.lex_state = 138},
  [365] = {.lex_state = 135},
  [366] = {.lex_state = 153},
  [367] = {.lex_state = 138},
  [368] = {.lex_state = 135},
  [369] = {.lex_state = 138},
  [370] = {.lex_state = 138},
  [371] = {.lex_state = 138},
  [372] = {.lex_state = 138},
  [373] = {.lex_state = 138},
  [374] = {.lex_state = 138},
  [375] = {.lex_state = 138},
  [376] = {.lex_state = 138},
  [377] = {.lex_state = 138},
  [378] = {.lex_state = 135},
  [379] = {.lex_state = 135},
  [380] = {.lex_state = 138},
  [381] = {.lex_state = 135},
  [382] = {.lex_state = 138},
  [383] = {.lex_state = 152},
  [384] = {.lex_state = 138},
  [385] = {.lex_state = 138},
  [386] = {.lex_state = 135},
  [387] = {.lex_state = 138},
  [388] = {.lex_state = 138},
  [389] = {.lex_state = 138},
  [390] = {.lex_state = 138},
  [391] = {.lex_state = 138},
  [392] = {.lex_state = 138},
  [393] = {.lex_state = 138},
  [394] = {.lex_state = 138},
  [395] = {.lex_state = 152},
  [396] = {.lex_state = 152},
  [397] = {.lex_state = 135},
  [398] = {.lex_state = 153},
  [399] = {.lex_state = 137},
  [400] = {.lex_state = 137},
  [401] = {.lex_state = 137},
  [402] = {.lex_state = 138},
  [403] = {.lex_state = 138},
  [404] = {.lex_state = 152},
  [405] = {.lex_state = 138},
  [406] = {.lex_state = 138},
  [407] = {.lex_state = 138},
  [408] = {.lex_state = 138},
  [409] = {.lex_state = 138},
  [410] = {.lex_state = 138},
  [411] = {.lex_state = 138},
  [412] = {.lex_state = 153},
  [413] = {.lex_state = 138},
  [414] = {.lex_state = 137},
  [415] = {.lex_state = 152},
  [416] = {.lex_state = 138},
  [417] = {.lex_state = 153},
  [418] = {.lex_state = 138},
  [419] = {.lex_state = 138},
  [420] = {.lex_state = 138},
  [421] = {.lex_state = 138},
  [422] = {.lex_state = 138},
  [423] = {.lex_state = 135},
  [424] = {.lex_state = 138},
  [425] = {.lex_state = 137},
  [426] = {.lex_state = 138},
  [427] = {.lex_state = 138},
  [428] = {.lex_state = 138},
  [429] = {.lex_state = 138},
  [430] = {.lex_state = 138},
  [431] = {.lex_state = 138},
  [432] = {.lex_state = 138},
  [433] = {.lex_state = 135},
  [434] = {.lex_state = 135},
  [435] = {.lex_state = 153},
  [436] = {.lex_state = 152},
  [437] = {.lex_state = 138},
  [438] = {.lex_state = 137},
  [439] = {.lex_state = 137},
  [440] = {.lex_state = 153},
  [441] = {.lex_state = 137},
  [442] = {.lex_state = 153},
  [443] = {.lex_state = 137},
  [444] = {.lex_state = 152},
  [445] = {.lex_state = 152},
  [446] = {.lex_state = 152},
  [447] = {.lex_state = 152},
  [448] = {.lex_state = 152},
  [449] = {.lex_state = 152},
  [450] = {.lex_state = 152},
  [451] = {.lex_state = 152},
  [452] = {.lex_state = 152},
  [453] = {.lex_state = 139},
  [454] = {.lex_state = 152},
  [455] = {.lex_state = 152},
  [456] = {.lex_state = 152},
  [457] = {.lex_state = 152},
  [458] = {.lex_state = 152},
  [459] = {.lex_state = 152},
  [460] = {.lex_state = 152},
  [461] = {.lex_state = 152},
  [462] = {.lex_state = 152},
  [463] = {.lex_state = 152},
  [464] = {.lex_state = 152},
  [465] = {.lex_state = 152},
  [466] = {.lex_state = 152},
  [467] = {.lex_state = 152},
  [468] = {.lex_state = 152},
  [469] = {.lex_state = 152},
  [470] = {.lex_state = 152},
  [471] = {.lex_state = 152},
  [472] = {.lex_state = 152},
  [473] = {.lex_state = 152},
  [474] = {.lex_state = 152},
  [475] = {.lex_state = 152},
  [476] = {.lex_state = 152},
  [477] = {.lex_state = 152},
  [478] = {.lex_state = 152},
  [479] = {.lex_state = 152},
  [480] = {.lex_state = 152},
  [481] = {.lex_state = 152},
  [482] = {.lex_state = 152},
  [483] = {.lex_state = 152},
  [484] = {.lex_state = 152},
  [485] = {.lex_state = 152},
  [486] = {.lex_state = 152},
  [487] = {.lex_state = 152},
  [488] = {.lex_state = 152},
  [489] = {.lex_state = 152},
  [490] = {.lex_state = 152},
  [491] = {.lex_state = 152},
  [492] = {.lex_state = 152},
  [493] = {.lex_state = 152},
  [494] = {.lex_state = 152},
  [495] = {.lex_state = 152},
  [496] = {.lex_state = 152},
  [497] = {.lex_state = 152},
  [498] = {.lex_state = 152},
  [499] = {.lex_state = 152},
  [500] = {.lex_state = 152},
  [501] = {.lex_state = 152},
  [502] = {.lex_state = 152},
  [503] = {.lex_state = 140},
  [504] = {.lex_state = 141},
  [505] = {.lex_state = 140},
  [506] = {.lex_state = 141},
  [507] = {.lex_state = 140},
  [508] = {.lex_state = 137},
  [509] = {.lex_state = 138},
  [510] = {.lex_state = 137},
  [511] = {.lex_state = 141},
  [512] = {.lex_state = 141},
  [513] = {.lex_state = 141},
  [514] = {.lex_state = 141},
  [515] = {.lex_state = 141},
  [516] = {.lex_state = 140},
  [517] = {.lex_state = 141},
  [518] = {.lex_state = 141},
  [519] = {.lex_state = 137},
  [520] = {.lex_state = 141},
  [521] = {.lex_state = 138},
  [522] = {.lex_state = 139},
  [523] = {.lex_state = 139},
  [524] = {.lex_state = 139},
  [525] = {.lex_state = 139},
  [526] = {.lex_state = 139},
  [527] = {.lex_state = 137},
  [528] = {.lex_state = 137},
  [529] = {.lex_state = 139},
  [530] = {.lex_state = 139},
  [531] = {.lex_state = 139},
  [532] = {.lex_state = 137},
  [533] = {.lex_state = 139},
  [534] = {.lex_state = 139},
  [535] = {.lex_state = 139},
  [536] = {.lex_state = 138},
  [537] = {.lex_state = 139},
  [538] = {.lex_state = 138},
  [539] = {.lex_state = 137},
  [540] = {.lex_state = 139},
  [541] = {.lex_state = 139},
  [542] = {.lex_state = 139},
  [543] = {.lex_state = 138},
  [544] = {.lex_state = 139},
  [545] = {.lex_state = 139},
  [546] = {.lex_state = 141},
  [547] = {.lex_state = 137},
  [548] = {.lex_state = 137},
  [549] = {.lex_state = 137},
  [550] = {.lex_state = 137},
  [551] = {.lex_state = 141},
  [552] = {.lex_state = 141},
  [553] = {.lex_state = 137},
  [554] = {.lex_state = 141},
  [555] = {.lex_state = 137},
  [556] = {.lex_state = 137},
  [557] = {.lex_state = 141},
  [558] = {.lex_state = 141},
  [559] = {.lex_state = 137},
  [560] = {.lex_state = 137},
  [561] = {.lex_state = 137},
  [562] = {.lex_state = 137},
  [563] = {.lex_state = 138},
  [564] = {.lex_state = 138},
  [565] = {.lex_state = 137},
  [566] = {.lex_state = 137},
  [567] = {.lex_state = 137},
  [568] = {.lex_state = 138},
  [569] = {.lex_state = 137},
  [570] = {.lex_state = 138},
  [571] = {.lex_state = 138},
  [572] = {.lex_state = 137},
  [573] = {.lex_state = 141},
  [574] = {.lex_state = 141},
  [575] = {.lex_state = 141},
  [576] = {.lex_state = 138},
  [577] = {.lex_state = 141},
  [578] = {.lex_state = 137},
  [579] = {.lex_state = 138},
  [580] = {.lex_state = 137},
  [581] = {.lex_state = 137},
  [582] = {.lex_state = 137},
  [583] = {.lex_state = 138},
  [584] = {.lex_state = 141},
  [585] = {.lex_state = 141},
  [586] = {.lex_state = 141},
  [587] = {.lex_state = 141},
  [588] = {.lex_state = 138},
  [589] = {.lex_state = 141},
  [590] = {.lex_state = 138},
  [591] = {.lex_state = 138},
  [592] = {.lex_state = 138},
  [593] = {.lex_state = 138},
  [594] = {.lex_state = 141},
  [595] = {.lex_state = 141},
  [596] = {.lex_state = 138},
  [597] = {.lex_state = 138},
  [598] = {.lex_state = 138},
  [599] = {.lex_state = 141},
  [600] = {.lex_state = 138},
  [601] = {.lex_state = 141},
  [602] = {.lex_state = 138},
  [603] = {.lex_state = 141},
  [604] = {.lex_state = 138},
  [605] = {.lex_state = 141},
  [606] = {.lex_state = 141},
  [607] = {.lex_state = 138},
  [608] = {.lex_state = 141},
  [609] = {.lex_state = 141},
  [610] = {.lex_state = 138},
  [611] = {.lex_state = 138},
  [612] = {.lex_state = 141},
  [613] = {.lex_state = 141},
  [614] = {.lex_state = 138},
  [615] = {.lex_state = 138},
  [616] = {.lex_state = 138},
  [617] = {.lex_state = 141},
  [618] = {.lex_state = 141},
  [619] = {.lex_state = 141},
  [620] = {.lex_state = 141},
  [621] = {.lex_state = 141},
  [622] = {.lex_state = 141},
  [623] = {.lex_state = 141},
  [624] = {.lex_state = 141},
  [625] = {.lex_state = 141},
  [626] = {.lex_state = 141},
  [627] = {.lex_state = 133},
  [628] = {.lex_state = 142},
  [629] = {.lex_state = 142},
  [630] = {.lex_state = 142},
  [631] = {.lex_state = 142},
  [632] = {.lex_state = 143},
  [633] = {.lex_state = 135},
  [634] = {.lex_state = 135},
  [635] = {.lex_state = 142},
  [636] = {.lex_state = 142},
  [637] = {.lex_state = 143},
  [638] = {.lex_state = 142},
  [639] = {.lex_state = 135},
  [640] = {.lex_state = 143},
  [641] = {.lex_state = 143},
  [642] = {.lex_state = 143},
  [643] = {.lex_state = 143},
  [644] = {.lex_state = 143},
  [645] = {.lex_state = 143},
  [646] = {.lex_state = 143},
  [647] = {.lex_state = 143},
  [648] = {.lex_state = 143},
  [649] = {.lex_state = 143},
  [650] = {.lex_state = 143},
  [651] = {.lex_state = 143},
  [652] = {.lex_state = 143},
  [653] = {.lex_state = 143},
  [654] = {.lex_state = 143},
  [655] = {.lex_state = 143},
  [656] = {.lex_state = 143},
  [657] = {.lex_state = 143},
  [658] = {.lex_state = 143},
  [659] = {.lex_state = 143},
  [660] = {.lex_state = 143},
  [661] = {.lex_state = 143},
  [662] = {.lex_state = 138},
  [663] = {.lex_state = 143},
  [664] = {.lex_state = 143},
  [665] = {.lex_state = 143},
  [666] = {.lex_state = 143},
  [667] = {.lex_state = 143},
  [668] = {.lex_state = 143},
  [669] = {.lex_state = 143},
  [670] = {.lex_state = 143},
  [671] = {.lex_state = 143},
  [672] = {.lex_state = 144},
  [673] = {.lex_state = 144},
  [674] = {.lex_state = 143},
  [675] = {.lex_state = 143},
  [676] = {.lex_state = 143},
  [677] = {.lex_state = 143},
  [678] = {.lex_state = 143},
  [679] = {.lex_state = 143},
  [680] = {.lex_state = 143},
  [681] = {.lex_state = 139},
  [682] = {.lex_state = 143},
  [683] = {.lex_state = 139},
  [684] = {.lex_state = 139},
  [685] = {.lex_state = 144},
  [686] = {.lex_state = 143},
  [687] = {.lex_state = 143},
  [688] = {.lex_state = 143},
  [689] = {.lex_state = 143},
  [690] = {.lex_state = 139},
  [691] = {.lex_state = 143},
  [692] = {.lex_state = 143},
  [693] = {.lex_state = 143},
  [694] = {.lex_state = 143},
  [695] = {.lex_state = 139},
  [696] = {.lex_state = 139},
  [697] = {.lex_state = 143},
  [698] = {.lex_state = 139},
  [699] = {.lex_state = 138},
  [700] = {.lex_state = 139},
  [701] = {.lex_state = 139},
  [702] = {.lex_state = 144},
  [703] = {.lex_state = 139},
  [704] = {.lex_state = 145},
  [705] = {.lex_state = 145},
  [706] = {.lex_state = 138},
  [707] = {.lex_state = 138},
  [708] = {.lex_state = 138},
  [709] = {.lex_state = 144},
  [710] = {.lex_state = 145},
  [711] = {.lex_state = 144},
  [712] = {.lex_state = 144},
  [713] = {.lex_state = 144},
  [714] = {.lex_state = 145},
  [715] = {.lex_state = 145},
  [716] = {.lex_state = 135},
  [717] = {.lex_state = 144},
  [718] = {.lex_state = 144},
  [719] = {.lex_state = 144},
  [720] = {.lex_state = 144},
  [721] = {.lex_state = 144},
  [722] = {.lex_state = 135},
  [723] = {.lex_state = 144},
  [724] = {.lex_state = 144},
  [725] = {.lex_state = 144},
  [726] = {.lex_state = 135},
  [727] = {.lex_state = 145},
  [728] = {.lex_state = 145},
  [729] = {.lex_state = 144},
  [730] = {.lex_state = 144},
  [731] = {.lex_state = 144},
  [732] = {.lex_state = 145},
  [733] = {.lex_state = 144},
  [734] = {.lex_state = 144},
  [735] = {.lex_state = 144},
  [736] = {.lex_state = 145},
  [737] = {.lex_state = 144},
  [738] = {.lex_state = 144},
  [739] = {.lex_state = 144},
  [740] = {.lex_state = 144},
  [741] = {.lex_state = 144},
  [742] = {.lex_state = 144},
  [743] = {.lex_state = 145},
  [744] = {.lex_state = 144},
  [745] = {.lex_state = 144},
  [746] = {.lex_state = 144},
  [747] = {.lex_state = 144},
  [748] = {.lex_state = 144},
  [749] = {.lex_state = 135},
  [750] = {.lex_state = 144},
  [751] = {.lex_state = 144},
  [752] = {.lex_state = 144},
  [753] = {.lex_state = 145},
  [754] = {.lex_state = 144},
  [755] = {.lex_state = 144},
  [756] = {.lex_state = 145},
  [757] = {.lex_state = 144},
  [758] = {.lex_state = 144},
  [759] = {.lex_state = 144},
  [760] = {.lex_state = 144},
  [761] = {.lex_state = 144},
  [762] = {.lex_state = 144},
  [763] = {.lex_state = 144},
  [764] = {.lex_state = 145},
  [765] = {.lex_state = 144},
  [766] = {.lex_state = 144},
  [767] = {.lex_state = 144},
  [768] = {.lex_state = 144},
  [769] = {.lex_state = 135},
  [770] = {.lex_state = 144},
  [771] = {.lex_state = 146},
  [772] = {.lex_state = 144},
  [773] = {.lex_state = 135},
  [774] = {.lex_state = 135},
  [775] = {.lex_state = 135},
  [776] = {.lex_state = 135},
  [777] = {.lex_state = 135},
  [778] = {.lex_state = 135},
  [779] = {.lex_state = 135},
  [780] = {.lex_state = 135},
  [781] = {.lex_state = 135},
  [782] = {.lex_state = 135},
  [783] = {.lex_state = 135},
  [784] = {.lex_state = 135},
  [785] = {.lex_state = 135},
  [786] = {.lex_state = 145},
  [787] = {.lex_state = 145},
  [788] = {.lex_state = 144},
  [789] = {.lex_state = 135},
  [790] = {.lex_state = 135},
  [791] = {.lex_state = 135},
  [792] = {.lex_state = 135},
  [793] = {.lex_state = 135},
  [794] = {.lex_state = 135},
  [795] = {.lex_state = 135},
  [796] = {.lex_state = 135},
  [797] = {.lex_state = 145},
  [798] = {.lex_state = 135},
  [799] = {.lex_state = 135},
  [800] = {.lex_state = 135},
  [801] = {.lex_state = 135},
  [802] = {.lex_state = 135},
  [803] = {.lex_state = 135},
  [804] = {.lex_state = 135},
  [805] = {.lex_state = 145},
  [806] = {.lex_state = 144},
  [807] = {.lex_state = 146},
  [808] = {.lex_state = 135},
  [809] = {.lex_state = 146},
  [810] = {.lex_state = 146},
  [811] = {.lex_state = 146},
  [812] = {.lex_state = 146},
  [813] = {.lex_state = 135},
  [814] = {.lex_state = 146},
  [815] = {.lex_state = 146},
  [816] = {.lex_state = 135},
  [817] = {.lex_state = 146},
  [818] = {.lex_state = 146},
  [819] = {.lex_state = 146},
  [820] = {.lex_state = 135},
  [821] = {.lex_state = 135},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 146},
  [824] = {.lex_state = 146},
  [825] = {.lex_state = 146},
  [826] = {.lex_state = 144},
  [827] = {.lex_state = 146},
  [828] = {.lex_state = 146},
  [829] = {.lex_state = 146},
  [830] = {.lex_state = 135},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 144},
  [834] = {.lex_state = 145},
  [835] = {.lex_state = 132},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 135},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 145},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 144},
  [846] = {.lex_state = 146},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 144},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 144},
  [853] = {.lex_state = 135},
  [854] = {.lex_state = 135},
  [855] = {.lex_state = 135, .external_lex_state = 1},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 135, .external_lex_state = 1},
  [858] = {.lex_state = 135, .external_lex_state = 1},
  [859] = {.lex_state = 135},
  [860] = {.lex_state = 135},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 135},
  [863] = {.lex_state = 135, .external_lex_state = 1},
  [864] = {.lex_state = 135},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 135, .external_lex_state = 1},
  [869] = {.lex_state = 135},
  [870] = {.lex_state = 135},
  [871] = {.lex_state = 146},
  [872] = {.lex_state = 146},
  [873] = {.lex_state = 144},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 146},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 135, .external_lex_state = 1},
  [880] = {.lex_state = 135},
  [881] = {.lex_state = 135, .external_lex_state = 1},
  [882] = {.lex_state = 135, .external_lex_state = 1},
  [883] = {.lex_state = 135},
  [884] = {.lex_state = 135, .external_lex_state = 1},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 145},
  [890] = {.lex_state = 135, .external_lex_state = 1},
  [891] = {.lex_state = 135},
  [892] = {.lex_state = 146},
  [893] = {.lex_state = 144},
  [894] = {.lex_state = 144},
  [895] = {.lex_state = 146},
  [896] = {.lex_state = 135},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 135},
  [899] = {.lex_state = 135, .external_lex_state = 1},
  [900] = {.lex_state = 135},
  [901] = {.lex_state = 146},
  [902] = {.lex_state = 146},
  [903] = {.lex_state = 135},
  [904] = {.lex_state = 135},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 132},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 135},
  [910] = {.lex_state = 135},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 146},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 139},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 132},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 135},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 135},
  [933] = {.lex_state = 152},
  [934] = {.lex_state = 135},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 132},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 132},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 135},
  [946] = {.lex_state = 135},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 132},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 132},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 132},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 132},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 132},
  [969] = {.lex_state = 132},
  [970] = {.lex_state = 132},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 135},
  [978] = {.lex_state = 132},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 146},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 132},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 132},
  [991] = {.lex_state = 135},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 132},
  [995] = {.lex_state = 152},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 146},
  [1001] = {.lex_state = 132},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 132},
  [1009] = {.lex_state = 152},
  [1010] = {.lex_state = 132},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 146},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 135},
  [1019] = {.lex_state = 146},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 146},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 132},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 152},
  [1034] = {.lex_state = 132},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 144},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 146},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 146},
  [1053] = {.lex_state = 146},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 132},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 146},
  [1059] = {.lex_state = 146},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 146},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 132},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 135},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 146},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 146},
  [1088] = {.lex_state = 135},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 132},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 146},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 152},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 152},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 152},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 146},
  [1111] = {.lex_state = 146},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 132},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 146},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 146},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 152},
  [1134] = {.lex_state = 146},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 146},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 146},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 146},
  [1141] = {.lex_state = 135},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 146},
  [1144] = {.lex_state = 146},
  [1145] = {.lex_state = 152},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 146},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 152},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 146},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 135},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 132},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 146},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 146},
  [1164] = {.lex_state = 146},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 146},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 132},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 146},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 132},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 132},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 132},
  [1201] = {.lex_state = 132},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 132},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 135},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 132},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 146},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 132},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 132},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 132},
  [1242] = {.lex_state = 135},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 135},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 135},
  [1253] = {.lex_state = 132},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 146},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 132},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 132},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 132},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 132},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 132},
  [1292] = {.lex_state = 0},
};

enum {
  ts_external_token_quoted_content = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_quoted_content] = sym_quoted_content,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_quoted_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_erlang] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_DOT] = ACTIONS(1),
    [anon_sym_GT_EQ_DOT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_todo] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_visibility_modifier] = ACTIONS(1),
    [sym_opacity_modifier] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__hex] = ACTIONS(1),
    [sym__decimal] = ACTIONS(1),
    [sym__octal] = ACTIONS(1),
    [sym__binary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bit_string] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_utf8] = ACTIONS(1),
    [anon_sym_utf16] = ACTIONS(1),
    [anon_sym_utf32] = ACTIONS(1),
    [anon_sym_utf8_codepoint] = ACTIONS(1),
    [anon_sym_utf16_codepoint] = ACTIONS(1),
    [anon_sym_utf32_codepoint] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_big] = ACTIONS(1),
    [anon_sym_little] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_unit] = ACTIONS(1),
    [sym__discard_name] = ACTIONS(1),
    [sym__name] = ACTIONS(1),
    [sym__upname] = ACTIONS(1),
    [sym_quoted_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1187),
    [sym__statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__expression_seq] = STATE(5),
    [sym_try] = STATE(455),
    [sym__expression] = STATE(106),
    [sym_binary_expression] = STATE(106),
    [sym__expression_unit] = STATE(106),
    [sym_record] = STATE(39),
    [sym_todo] = STATE(106),
    [sym_tuple] = STATE(40),
    [sym_list] = STATE(106),
    [sym__expression_bit_string] = STATE(106),
    [sym_anonymous_function] = STATE(29),
    [sym_expression_group] = STATE(8),
    [sym_case] = STATE(8),
    [sym_let] = STATE(106),
    [sym_assert] = STATE(106),
    [sym_negation] = STATE(106),
    [sym_record_update] = STATE(39),
    [sym__maybe_tuple_expression] = STATE(1178),
    [sym_tuple_access] = STATE(8),
    [sym__maybe_record_expression] = STATE(1232),
    [sym_field_access] = STATE(8),
    [sym__maybe_function_expression] = STATE(1051),
    [sym_function_call] = STATE(8),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(106),
    [sym_integer] = STATE(106),
    [sym_identifier] = STATE(25),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_const] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_external] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_case] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [sym_visibility_modifier] = ACTIONS(43),
    [sym_opacity_modifier] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [sym_float] = ACTIONS(49),
    [sym__hex] = ACTIONS(51),
    [sym__decimal] = ACTIONS(53),
    [sym__octal] = ACTIONS(51),
    [sym__binary] = ACTIONS(51),
    [sym__name] = ACTIONS(55),
    [sym__upname] = ACTIONS(57),
  },
  [2] = {
    [sym__statement] = STATE(3),
    [sym_target_group] = STATE(3),
    [sym_import] = STATE(3),
    [sym_constant] = STATE(3),
    [sym_external_type] = STATE(3),
    [sym_external_function] = STATE(3),
    [sym_function] = STATE(3),
    [aux_sym__expression_seq] = STATE(5),
    [sym_try] = STATE(455),
    [sym__expression] = STATE(106),
    [sym_binary_expression] = STATE(106),
    [sym__expression_unit] = STATE(106),
    [sym_record] = STATE(39),
    [sym_todo] = STATE(106),
    [sym_tuple] = STATE(40),
    [sym_list] = STATE(106),
    [sym__expression_bit_string] = STATE(106),
    [sym_anonymous_function] = STATE(29),
    [sym_expression_group] = STATE(8),
    [sym_case] = STATE(8),
    [sym_let] = STATE(106),
    [sym_assert] = STATE(106),
    [sym_negation] = STATE(106),
    [sym_record_update] = STATE(39),
    [sym__maybe_tuple_expression] = STATE(1178),
    [sym_tuple_access] = STATE(8),
    [sym__maybe_record_expression] = STATE(1232),
    [sym_field_access] = STATE(8),
    [sym__maybe_function_expression] = STATE(1051),
    [sym_function_call] = STATE(8),
    [sym_type_definition] = STATE(3),
    [sym_type_alias] = STATE(3),
    [sym_string] = STATE(106),
    [sym_integer] = STATE(106),
    [sym_identifier] = STATE(25),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(59),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_const] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_external] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_try] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_case] = ACTIONS(35),
    [anon_sym_let] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [sym_visibility_modifier] = ACTIONS(43),
    [sym_opacity_modifier] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [sym_float] = ACTIONS(49),
    [sym__hex] = ACTIONS(51),
    [sym__decimal] = ACTIONS(53),
    [sym__octal] = ACTIONS(51),
    [sym__binary] = ACTIONS(51),
    [sym__name] = ACTIONS(55),
    [sym__upname] = ACTIONS(57),
  },
  [3] = {
    [sym__statement] = STATE(3),
    [sym_target_group] = STATE(3),
    [sym_import] = STATE(3),
    [sym_constant] = STATE(3),
    [sym_external_type] = STATE(3),
    [sym_external_function] = STATE(3),
    [sym_function] = STATE(3),
    [aux_sym__expression_seq] = STATE(5),
    [sym_try] = STATE(455),
    [sym__expression] = STATE(106),
    [sym_binary_expression] = STATE(106),
    [sym__expression_unit] = STATE(106),
    [sym_record] = STATE(39),
    [sym_todo] = STATE(106),
    [sym_tuple] = STATE(40),
    [sym_list] = STATE(106),
    [sym__expression_bit_string] = STATE(106),
    [sym_anonymous_function] = STATE(29),
    [sym_expression_group] = STATE(8),
    [sym_case] = STATE(8),
    [sym_let] = STATE(106),
    [sym_assert] = STATE(106),
    [sym_negation] = STATE(106),
    [sym_record_update] = STATE(39),
    [sym__maybe_tuple_expression] = STATE(1178),
    [sym_tuple_access] = STATE(8),
    [sym__maybe_record_expression] = STATE(1232),
    [sym_field_access] = STATE(8),
    [sym__maybe_function_expression] = STATE(1051),
    [sym_function_call] = STATE(8),
    [sym_type_definition] = STATE(3),
    [sym_type_alias] = STATE(3),
    [sym_string] = STATE(106),
    [sym_integer] = STATE(106),
    [sym_identifier] = STATE(25),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(61),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(66),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_const] = ACTIONS(72),
    [anon_sym_POUND] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(78),
    [anon_sym_LT_LT] = ACTIONS(81),
    [anon_sym_DASH] = ACTIONS(84),
    [anon_sym_external] = ACTIONS(87),
    [anon_sym_type] = ACTIONS(90),
    [anon_sym_fn] = ACTIONS(93),
    [anon_sym_try] = ACTIONS(96),
    [anon_sym_todo] = ACTIONS(99),
    [anon_sym_case] = ACTIONS(102),
    [anon_sym_let] = ACTIONS(105),
    [anon_sym_assert] = ACTIONS(108),
    [anon_sym_BANG] = ACTIONS(111),
    [sym_visibility_modifier] = ACTIONS(114),
    [sym_opacity_modifier] = ACTIONS(117),
    [anon_sym_DQUOTE] = ACTIONS(120),
    [sym_float] = ACTIONS(123),
    [sym__hex] = ACTIONS(126),
    [sym__decimal] = ACTIONS(129),
    [sym__octal] = ACTIONS(126),
    [sym__binary] = ACTIONS(126),
    [sym__name] = ACTIONS(132),
    [sym__upname] = ACTIONS(135),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(138), 1,
      ts_builtin_sym_end,
    ACTIONS(142), 1,
      anon_sym_LBRACE,
    ACTIONS(145), 1,
      anon_sym_POUND,
    ACTIONS(148), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      anon_sym_LT_LT,
    ACTIONS(154), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_fn,
    ACTIONS(160), 1,
      anon_sym_try,
    ACTIONS(163), 1,
      anon_sym_todo,
    ACTIONS(166), 1,
      anon_sym_case,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(172), 1,
      anon_sym_assert,
    ACTIONS(175), 1,
      anon_sym_BANG,
    ACTIONS(178), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      sym_float,
    ACTIONS(187), 1,
      sym__decimal,
    ACTIONS(190), 1,
      sym__name,
    ACTIONS(193), 1,
      sym__upname,
    STATE(4), 1,
      aux_sym__expression_seq,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(455), 1,
      sym_try,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(184), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    ACTIONS(140), 7,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      sym_visibility_modifier,
      sym_opacity_modifier,
    STATE(106), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [128] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(196), 1,
      ts_builtin_sym_end,
    ACTIONS(200), 1,
      anon_sym_LBRACE,
    ACTIONS(203), 1,
      anon_sym_POUND,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(212), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_fn,
    ACTIONS(218), 1,
      anon_sym_try,
    ACTIONS(221), 1,
      anon_sym_todo,
    ACTIONS(224), 1,
      anon_sym_case,
    ACTIONS(227), 1,
      anon_sym_let,
    ACTIONS(230), 1,
      anon_sym_assert,
    ACTIONS(233), 1,
      anon_sym_BANG,
    ACTIONS(236), 1,
      anon_sym_DQUOTE,
    ACTIONS(239), 1,
      sym_float,
    ACTIONS(245), 1,
      sym__decimal,
    ACTIONS(248), 1,
      sym__name,
    ACTIONS(251), 1,
      sym__upname,
    STATE(4), 1,
      aux_sym__expression_seq,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(455), 1,
      sym_try,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(242), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    ACTIONS(198), 7,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      sym_visibility_modifier,
      sym_opacity_modifier,
    STATE(106), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [256] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(38), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(256), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(254), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [324] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(262), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(260), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [387] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(268), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(264), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [454] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(273), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [517] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(293), 1,
      anon_sym_DOT_DOT,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(959), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [642] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(319), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(317), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [705] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(323), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(321), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [768] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(325), 1,
      anon_sym_RPAREN,
    ACTIONS(327), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(984), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [893] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(331), 19,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(329), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [956] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(333), 1,
      anon_sym_RPAREN,
    ACTIONS(335), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(952), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [1081] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(339), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(337), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1144] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(343), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(341), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1207] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(345), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1270] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(351), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(349), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1333] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(355), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(353), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1396] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(359), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(357), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1459] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(363), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(361), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1522] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(331), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(329), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1585] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(367), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(365), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1648] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(369), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(264), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1715] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(373), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1778] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(377), 1,
      anon_sym_RPAREN,
    ACTIONS(379), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1031), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [1903] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(381), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1966] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(264), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2030] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(385), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [2152] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(387), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [2274] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(391), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(389), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2336] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(395), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(393), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2398] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(377), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1031), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [2520] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(397), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [2642] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(399), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [2764] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(403), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(401), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2826] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(407), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(405), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2888] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(409), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(264), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2952] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(264), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3016] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(325), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(984), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [3138] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(959), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [3260] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(413), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3322] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(417), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [3444] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(423), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(421), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(419), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3508] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(427), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(425), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3570] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(431), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(429), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3632] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(433), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [3754] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(437), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(435), 26,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3816] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(333), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(952), 1,
      sym_argument,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [3938] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(439), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [4060] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(441), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [4182] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(305), 1,
      sym_float,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1160), 1,
      sym_argument,
    STATE(1168), 1,
      sym_hole,
    STATE(1189), 1,
      sym_label,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [4301] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(443), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4362] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(449), 1,
      anon_sym_RBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [4481] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(485), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [4600] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(489), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(487), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4661] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(493), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(491), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4722] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(503), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(505), 1,
      anon_sym_AMP_AMP,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(495), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(497), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [4803] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(521), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(519), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4864] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(525), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(523), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4925] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(529), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(527), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4986] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [5105] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(533), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [5224] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(535), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [5343] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(537), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [5462] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(539), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(541), 20,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5531] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(138), 1,
      anon_sym_RBRACE,
    ACTIONS(543), 1,
      anon_sym_LBRACE,
    ACTIONS(546), 1,
      anon_sym_POUND,
    ACTIONS(549), 1,
      anon_sym_LBRACK,
    ACTIONS(552), 1,
      anon_sym_LT_LT,
    ACTIONS(555), 1,
      anon_sym_DASH,
    ACTIONS(558), 1,
      anon_sym_fn,
    ACTIONS(561), 1,
      anon_sym_try,
    ACTIONS(564), 1,
      anon_sym_todo,
    ACTIONS(567), 1,
      anon_sym_case,
    ACTIONS(570), 1,
      anon_sym_let,
    ACTIONS(573), 1,
      anon_sym_assert,
    ACTIONS(576), 1,
      anon_sym_BANG,
    ACTIONS(579), 1,
      anon_sym_DQUOTE,
    ACTIONS(582), 1,
      sym_float,
    ACTIONS(588), 1,
      sym__decimal,
    ACTIONS(591), 1,
      sym__name,
    ACTIONS(594), 1,
      sym__upname,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(585), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [5650] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(539), 19,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(541), 20,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5721] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(597), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [5840] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(351), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(349), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5901] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(541), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5976] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(599), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [6095] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(603), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(601), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6156] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(541), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6233] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(607), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(605), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6294] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(611), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(609), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6355] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(613), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [6474] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(617), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(615), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6535] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(505), 1,
      anon_sym_AMP_AMP,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(541), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6614] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(539), 22,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(541), 22,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6679] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(619), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6740] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(623), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [6859] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(625), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [6978] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(541), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(539), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7039] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(363), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(361), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7100] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(627), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [7219] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(367), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(365), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7280] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(629), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [7399] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(503), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(505), 1,
      anon_sym_AMP_AMP,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(631), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(633), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7480] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(637), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(635), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7541] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(503), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(505), 1,
      anon_sym_AMP_AMP,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(639), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(641), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7622] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(643), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [7741] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(647), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(645), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7802] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(651), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(649), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7863] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(653), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [7982] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(657), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(655), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8043] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(345), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8104] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(661), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(659), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8165] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(503), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(505), 1,
      anon_sym_AMP_AMP,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(663), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(665), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8246] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(667), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [8365] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(671), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(669), 25,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8426] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(673), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [8545] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(675), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [8664] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(677), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [8783] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(503), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(505), 1,
      anon_sym_AMP_AMP,
    ACTIONS(513), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(499), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(501), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(507), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(515), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(517), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(509), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(511), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(679), 11,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(681), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8864] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(683), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [8983] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(104), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9099] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(63), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9215] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(78), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9331] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(64), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9447] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(101), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9563] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(66), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9679] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(103), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9795] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(105), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [9911] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(89), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10027] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(73), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10143] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(56), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10259] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(65), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10375] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(84), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10491] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(685), 1,
      anon_sym_LPAREN,
    STATE(162), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(256), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(254), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10555] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(70), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10671] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(83), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10787] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(55), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [10903] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(87), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [11019] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(93), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [11135] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(96), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [11251] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(461), 1,
      anon_sym_try,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(475), 1,
      sym_float,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    STATE(107), 1,
      aux_sym__expression_seq,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(627), 1,
      sym_try,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(290), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [11367] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(687), 1,
      anon_sym_RBRACK,
    ACTIONS(689), 1,
      anon_sym_DOT_DOT,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [11480] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(339), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(337), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11539] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(273), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11598] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(695), 1,
      anon_sym_RBRACK,
    ACTIONS(697), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [11711] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(699), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(264), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11774] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(703), 1,
      anon_sym_RBRACK,
    ACTIONS(705), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [11887] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(707), 1,
      anon_sym_RBRACK,
    ACTIONS(709), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [12000] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(711), 1,
      anon_sym_RBRACK,
    ACTIONS(713), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [12113] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(619), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12172] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(715), 1,
      anon_sym_RBRACK,
    ACTIONS(717), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [12285] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(319), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(317), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12344] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(323), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(321), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12403] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(262), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(260), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12462] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(373), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12521] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(311), 1,
      sym__discard_name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(719), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1175), 1,
      sym_hole,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(579), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [12634] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(721), 1,
      anon_sym_RBRACK,
    ACTIONS(723), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [12747] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(725), 1,
      anon_sym_RBRACK,
    ACTIONS(727), 1,
      anon_sym_DOT_DOT,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [12860] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(443), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12919] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(381), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12978] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(343), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(341), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13037] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(355), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(353), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13096] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(359), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(357), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13155] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(268), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(264), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13218] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(729), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    STATE(1267), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(568), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [13328] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(731), 1,
      anon_sym_RPAREN,
    ACTIONS(733), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [13438] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(391), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(389), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13496] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(735), 1,
      anon_sym_RBRACK,
    ACTIONS(737), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(538), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [13606] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(739), 1,
      anon_sym_RPAREN,
    ACTIONS(741), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(564), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [13716] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(395), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(393), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13774] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(413), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13832] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(743), 1,
      anon_sym_RBRACK,
    ACTIONS(745), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(521), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [13942] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(403), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(401), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14000] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(431), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(429), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14058] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(407), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(405), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14116] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(264), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14176] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(409), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(264), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14236] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(747), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(421), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(419), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14296] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(749), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [14406] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(751), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [14516] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(753), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [14626] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(755), 1,
      anon_sym_RBRACK,
    ACTIONS(757), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(536), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [14736] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(759), 1,
      anon_sym_RPAREN,
    ACTIONS(761), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(563), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [14846] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(763), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [14956] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(765), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [15066] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(767), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [15176] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(769), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [15286] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(264), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15346] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(437), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(435), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15404] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(427), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(425), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15462] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(771), 1,
      anon_sym_RPAREN,
    ACTIONS(773), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(571), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [15572] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(729), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1198), 1,
      sym_case_subjects,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(568), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [15682] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(729), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    STATE(1251), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(568), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [15792] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(775), 1,
      anon_sym_RBRACK,
    ACTIONS(777), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(543), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [15902] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(779), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16012] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(729), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    STATE(1263), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(568), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16122] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(783), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(69), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16229] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(785), 1,
      anon_sym_LBRACE,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16336] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(788), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(597), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16443] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(790), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(615), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16550] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(792), 1,
      anon_sym_GT_GT,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(930), 1,
      sym_expression_bit_string_segment,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16661] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(826), 1,
      sym_float,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(347), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16768] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(836), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(590), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16875] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(838), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(611), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [16982] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(840), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(616), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17089] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(842), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(588), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17196] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(844), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(607), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17303] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(846), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17410] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(848), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(592), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17517] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(850), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(602), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17624] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(852), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17731] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(854), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(614), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17838] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(856), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(604), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [17945] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(858), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(596), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18052] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(860), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(331), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18159] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(862), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(346), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18266] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(864), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(348), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18373] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(866), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(354), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18480] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(868), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(355), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18587] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(870), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(352), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18694] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(872), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(600), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18801] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(874), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(351), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [18908] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(876), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19019] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(878), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19130] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(880), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(961), 1,
      sym_expression_bit_string_segment,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19241] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(882), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19352] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(884), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19463] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(886), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(583), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19570] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(888), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(85), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19677] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(890), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(81), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19784] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(892), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [19895] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(894), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(80), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20002] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(896), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(75), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20109] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(898), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(72), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20216] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(900), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(67), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20323] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(902), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(989), 1,
      sym_expression_bit_string_segment,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20434] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(904), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(424), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20541] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(906), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(610), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20648] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(908), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20759] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(910), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(413), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20866] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(912), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(403), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [20973] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(914), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(402), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21080] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(916), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(422), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21187] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(918), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(405), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21294] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(920), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(406), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21401] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(922), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(407), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21508] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(924), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(408), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21615] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(926), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21726] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(928), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21837] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(930), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(591), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [21944] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [22051] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    ACTIONS(932), 1,
      anon_sym_GT_GT,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1004), 1,
      sym_expression_bit_string_segment,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [22162] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(934), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(593), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [22269] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(936), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(598), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [22376] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(493), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(491), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22433] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(521), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(519), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22490] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(603), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(601), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22547] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(529), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(527), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22604] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(607), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(605), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22661] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(525), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(523), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22718] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(611), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(609), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22775] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(938), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(284), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [22882] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(940), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(280), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [22989] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(942), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(283), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [23096] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(944), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(282), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [23203] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(946), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(281), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [23310] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(948), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(287), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [23417] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(671), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(669), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23474] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(637), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(635), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23531] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(617), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(615), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23588] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(950), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(356), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [23695] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(952), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(291), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [23802] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(954), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(285), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [23909] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(661), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(659), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23966] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(489), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(487), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24023] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(647), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(645), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24080] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(956), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(289), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [24187] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(958), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(90), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [24294] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(92), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [24401] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(651), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(649), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24458] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(657), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(655), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24515] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(962), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(286), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [24622] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(964), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(59), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [24729] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(966), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(288), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [24836] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(968), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(100), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [24943] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(691), 1,
      sym_float,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(970), 1,
      anon_sym_LBRACE,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 11,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [25050] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(800), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1120), 1,
      sym_expression_bit_string_segment,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [25158] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(794), 1,
      anon_sym_let,
    ACTIONS(796), 1,
      anon_sym_assert,
    ACTIONS(798), 1,
      anon_sym_BANG,
    ACTIONS(973), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(248), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [25263] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(802), 1,
      anon_sym_LBRACE,
    ACTIONS(804), 1,
      anon_sym_POUND,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    ACTIONS(808), 1,
      anon_sym_LT_LT,
    ACTIONS(810), 1,
      anon_sym_DASH,
    ACTIONS(812), 1,
      anon_sym_fn,
    ACTIONS(814), 1,
      anon_sym_todo,
    ACTIONS(816), 1,
      anon_sym_case,
    ACTIONS(818), 1,
      anon_sym_let,
    ACTIONS(820), 1,
      anon_sym_assert,
    ACTIONS(822), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      anon_sym_DQUOTE,
    ACTIONS(830), 1,
      sym__decimal,
    ACTIONS(832), 1,
      sym__name,
    ACTIONS(834), 1,
      sym__upname,
    ACTIONS(975), 1,
      sym_float,
    STATE(305), 1,
      sym_identifier,
    STATE(327), 1,
      sym_tuple,
    STATE(328), 1,
      sym_anonymous_function,
    STATE(1156), 1,
      sym__maybe_function_expression,
    STATE(1195), 1,
      sym__maybe_tuple_expression,
    STATE(1240), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(299), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(325), 2,
      sym_record,
      sym_record_update,
    ACTIONS(828), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(304), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(342), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [25368] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      anon_sym_LBRACK,
    ACTIONS(455), 1,
      anon_sym_LT_LT,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(459), 1,
      anon_sym_fn,
    ACTIONS(463), 1,
      anon_sym_todo,
    ACTIONS(465), 1,
      anon_sym_case,
    ACTIONS(467), 1,
      anon_sym_let,
    ACTIONS(469), 1,
      anon_sym_assert,
    ACTIONS(471), 1,
      anon_sym_BANG,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(973), 1,
      sym_float,
    STATE(133), 1,
      sym_identifier,
    STATE(163), 1,
      sym_tuple,
    STATE(175), 1,
      sym_anonymous_function,
    STATE(1100), 1,
      sym__maybe_function_expression,
    STATE(1199), 1,
      sym__maybe_record_expression,
    STATE(1231), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(121), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(164), 2,
      sym_record,
      sym_record_update,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(151), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(248), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [25473] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(277), 1,
      anon_sym_LBRACE,
    ACTIONS(279), 1,
      anon_sym_POUND,
    ACTIONS(283), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_LT_LT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_fn,
    ACTIONS(291), 1,
      anon_sym_todo,
    ACTIONS(295), 1,
      anon_sym_case,
    ACTIONS(297), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_assert,
    ACTIONS(301), 1,
      anon_sym_BANG,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(977), 1,
      sym_float,
    STATE(375), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(387), 1,
      sym_anonymous_function,
    STATE(1116), 1,
      sym__maybe_function_expression,
    STATE(1218), 1,
      sym__maybe_tuple_expression,
    STATE(1229), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(392), 2,
      sym_record,
      sym_record_update,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(374), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(426), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [25578] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LT_LT,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_case,
    ACTIONS(37), 1,
      anon_sym_let,
    ACTIONS(39), 1,
      anon_sym_assert,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(55), 1,
      sym__name,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(781), 1,
      anon_sym_fn,
    ACTIONS(979), 1,
      sym_float,
    STATE(25), 1,
      sym_identifier,
    STATE(29), 1,
      sym_anonymous_function,
    STATE(40), 1,
      sym_tuple,
    STATE(1051), 1,
      sym__maybe_function_expression,
    STATE(1178), 1,
      sym__maybe_tuple_expression,
    STATE(1232), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(39), 2,
      sym_record,
      sym_record_update,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(8), 5,
      sym_expression_group,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(77), 9,
      sym__expression_unit,
      sym_todo,
      sym_list,
      sym__expression_bit_string,
      sym_let,
      sym_assert,
      sym_negation,
      sym_string,
      sym_integer,
  [25683] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 15,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(539), 22,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25741] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(541), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(539), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25809] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(995), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(541), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(539), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25879] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(997), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(995), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(541), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(539), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25951] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(541), 17,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(539), 25,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26005] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(997), 1,
      anon_sym_AMP_AMP,
    ACTIONS(999), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(995), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(665), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(663), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26079] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(997), 1,
      anon_sym_AMP_AMP,
    ACTIONS(999), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(995), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(641), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(639), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26153] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 13,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(539), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26217] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(997), 1,
      anon_sym_AMP_AMP,
    ACTIONS(999), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(995), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(497), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(495), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26291] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(997), 1,
      anon_sym_AMP_AMP,
    ACTIONS(999), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(995), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(633), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(631), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26365] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(991), 1,
      anon_sym_PIPE_GT,
    ACTIONS(997), 1,
      anon_sym_AMP_AMP,
    ACTIONS(999), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(995), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(987), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(989), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(681), 9,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(679), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26439] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(981), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(985), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(993), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(983), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 13,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(539), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26501] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(367), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(365), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [26554] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(331), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(329), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [26607] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(351), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(349), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [26660] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(363), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(361), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [26713] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(345), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [26766] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(619), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [26817] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(443), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [26868] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1001), 1,
      anon_sym_LPAREN,
    STATE(320), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(256), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(254), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26922] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(381), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26971] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(343), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(341), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27020] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(373), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27069] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(273), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27118] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(268), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(264), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27171] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(264), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27224] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(363), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(361), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27273] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(331), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(329), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27322] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(339), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(337), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27371] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(359), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(357), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27420] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(367), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(365), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27469] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(355), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(353), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27518] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(319), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(317), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27567] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(351), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(349), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27616] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(323), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(321), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27665] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(262), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(260), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27714] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(345), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27763] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(437), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(435), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27811] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(427), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(425), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27859] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(403), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(401), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27907] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(407), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(405), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27955] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(413), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28003] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(391), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(389), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28051] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(431), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(429), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28099] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(395), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(393), 25,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28147] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(409), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(264), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28197] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1007), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(421), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(419), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28247] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(264), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28297] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(264), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28347] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(521), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(519), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28394] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(619), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28441] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(539), 19,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28496] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1017), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1019), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1021), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(497), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1025), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(495), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28563] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(529), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(527), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28610] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(525), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(523), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28657] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(443), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28704] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(651), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(649), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28751] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(493), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(491), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28798] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(657), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(655), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28845] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1017), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1019), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1021), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1031), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1023), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1025), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1029), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28912] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(603), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(601), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28959] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(607), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(605), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29006] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(611), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(609), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29053] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(617), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(615), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29100] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(489), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(487), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29147] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(637), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(635), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29194] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(539), 18,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29251] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1017), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1019), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1021), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1035), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1023), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1025), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1033), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29318] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(541), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1025), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 14,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29379] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(661), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(659), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29426] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(647), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(645), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29473] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(541), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(539), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29520] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 9,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(539), 21,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29571] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(671), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(669), 24,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29618] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1021), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(541), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1025), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 12,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29681] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1019), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1021), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(541), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1025), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 11,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29746] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1017), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1019), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1011), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1013), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1021), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(665), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1015), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1025), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(663), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29813] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1041), 1,
      anon_sym_SLASH,
    STATE(357), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1037), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1039), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [29861] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_SLASH,
    STATE(360), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1044), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1046), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [29909] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1050), 1,
      anon_sym_LPAREN,
    STATE(385), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(256), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(254), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [29957] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_SLASH,
    STATE(357), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1052), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1054), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [30005] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1060), 1,
      anon_sym_size,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1056), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(991), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [30062] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1070), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1068), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1018), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [30119] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(355), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(353), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30162] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(359), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(357), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30205] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1060), 1,
      anon_sym_size,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1072), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(991), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [30262] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1037), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1039), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [30305] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(339), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(337), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30348] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1070), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1074), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1018), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [30405] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(381), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30448] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(262), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(260), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30491] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(343), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(341), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30534] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(373), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30577] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(319), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(317), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30620] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(1076), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(264), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30667] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(1079), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(264), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30714] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(323), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(321), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30757] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(275), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(273), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30800] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1085), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1083), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(910), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [30857] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1085), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1087), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(910), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [30914] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1089), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(264), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [30958] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1085), 1,
      anon_sym_size,
    STATE(1077), 1,
      sym_pattern_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(903), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [31014] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(431), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(429), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31056] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1095), 1,
      anon_sym_LPAREN,
    STATE(446), 1,
      sym_type_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1091), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1093), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [31102] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(437), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(435), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31144] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(407), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(405), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31186] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1070), 1,
      anon_sym_size,
    STATE(1161), 1,
      sym_constant_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(891), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [31242] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(271), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(264), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31286] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(427), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(425), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31328] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(413), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31370] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(403), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(401), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31412] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(395), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(393), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31454] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1097), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(266), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(264), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31498] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1099), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(421), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(419), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31542] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(391), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(389), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [31584] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1105), 1,
      anon_sym_LPAREN,
    STATE(493), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1101), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1103), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [31630] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1111), 1,
      anon_sym_LPAREN,
    STATE(474), 1,
      sym_type_parameters,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1107), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1109), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [31676] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1060), 1,
      anon_sym_size,
    ACTIONS(1066), 1,
      anon_sym_unit,
    STATE(1128), 1,
      sym_expression_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(896), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [31732] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1117), 1,
      anon_sym_DOT,
    ACTIONS(1119), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1113), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1115), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [31778] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1123), 1,
      anon_sym_RPAREN,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1129), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(772), 1,
      sym_identifier,
    STATE(908), 1,
      sym__pattern,
    STATE(1046), 1,
      sym_record_pattern_argument,
    STATE(1191), 1,
      sym_label,
    STATE(1290), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31855] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(893), 1,
      sym_case_clause_pattern,
    STATE(919), 1,
      sym_case_clause_patterns,
    STATE(1204), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(443), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [31930] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(893), 1,
      sym_case_clause_pattern,
    STATE(919), 1,
      sym_case_clause_patterns,
    STATE(1292), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(443), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [32005] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(539), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DOT_DOT,
  [32056] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(539), 16,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DOT_DOT,
  [32105] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1159), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1161), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32146] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DOT_DOT,
  [32201] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 8,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_DOT,
  [32258] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(541), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
    ACTIONS(539), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DOT_DOT,
  [32303] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(541), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(539), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32344] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(657), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(655), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32385] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(651), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(649), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32426] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(489), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(487), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32467] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1171), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1173), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32508] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(495), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DOT_DOT,
  [32567] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1177), 1,
      anon_sym_RBRACE,
    ACTIONS(1179), 1,
      anon_sym_POUND,
    ACTIONS(1182), 1,
      anon_sym_LBRACK,
    ACTIONS(1185), 1,
      anon_sym_LT_LT,
    ACTIONS(1188), 1,
      anon_sym_DASH,
    ACTIONS(1191), 1,
      anon_sym_DQUOTE,
    ACTIONS(1194), 1,
      sym_float,
    ACTIONS(1200), 1,
      sym__decimal,
    ACTIONS(1203), 1,
      sym__discard_name,
    ACTIONS(1206), 1,
      sym__name,
    ACTIONS(1209), 1,
      sym__upname,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(893), 1,
      sym_case_clause_pattern,
    STATE(919), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(414), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1197), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [32642] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(329), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1212), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1214), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32685] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(647), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(645), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32726] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1216), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1218), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [32767] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(617), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(615), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32808] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(637), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(635), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32849] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(671), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(669), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32890] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(661), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(659), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [32931] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(539), 11,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DOT_DOT,
  [32984] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1085), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(910), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [33037] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(663), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_DOT_DOT,
  [33096] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(893), 1,
      sym_case_clause_pattern,
    STATE(919), 1,
      sym_case_clause_patterns,
    STATE(1180), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(443), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [33171] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(611), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(609), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33212] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(607), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(605), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33253] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(525), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(523), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33294] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(603), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(601), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33335] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(529), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(527), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33376] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(521), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(519), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33417] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(493), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(491), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33458] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1060), 1,
      anon_sym_size,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(991), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [33511] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(1058), 1,
      anon_sym_DASH,
    ACTIONS(1066), 1,
      anon_sym_unit,
    ACTIONS(1070), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1064), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1018), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1062), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [33564] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1224), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1220), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1222), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33607] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1226), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1228), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33648] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(353), 1,
      anon_sym_COLON,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(331), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(329), 19,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [33691] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(893), 1,
      sym_case_clause_pattern,
    STATE(919), 1,
      sym_case_clause_patterns,
    STATE(1237), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(443), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [33766] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1129), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1230), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      sym_identifier,
    STATE(844), 1,
      sym_record_pattern_argument,
    STATE(908), 1,
      sym__pattern,
    STATE(1191), 1,
      sym_label,
    STATE(1248), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [33843] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1234), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33884] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1129), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1236), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      sym_identifier,
    STATE(908), 1,
      sym__pattern,
    STATE(1046), 1,
      sym_record_pattern_argument,
    STATE(1191), 1,
      sym_label,
    STATE(1280), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [33961] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1238), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1240), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34002] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1242), 1,
      anon_sym_RBRACE,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(893), 1,
      sym_case_clause_pattern,
    STATE(919), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(414), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [34077] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1244), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1246), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34117] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1248), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1250), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34157] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1252), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1254), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34197] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1256), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1258), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34237] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1260), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1262), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34277] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1264), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1266), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34317] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1268), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1270), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34357] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1272), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1274), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34397] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1276), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1278), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34437] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1280), 1,
      anon_sym_LPAREN,
    STATE(542), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1103), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1101), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [34481] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1282), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1284), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34521] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(679), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(681), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34561] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1286), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1288), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34601] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1290), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1292), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34641] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1294), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1296), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34681] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1298), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1300), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34721] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1302), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1304), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34761] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1306), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1308), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34801] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1310), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1312), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34841] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1314), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1316), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34881] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1318), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1320), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34921] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1322), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1324), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34961] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1326), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1328), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35001] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1330), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1332), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35041] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1334), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1336), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35081] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1338), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1340), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35121] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1342), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1344), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35161] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1346), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1348), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35201] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1350), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1352), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35241] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1354), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1356), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35281] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1358), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1360), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35321] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1362), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1364), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35361] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1366), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1368), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35401] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1370), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1372), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35441] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1374), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1376), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35481] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1378), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1380), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35521] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1382), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1384), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35561] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1386), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1388), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35601] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1390), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1392), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35641] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1394), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1396), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35681] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1398), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1400), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35721] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1402), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1404), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35761] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1406), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1408), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35801] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1410), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1412), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35841] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1414), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1416), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35881] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1418), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1420), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35921] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1422), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1424), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35961] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1426), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1428), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36001] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1430), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1432), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36041] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1434), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1436), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36081] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1438), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1440), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36121] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1442), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1444), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36161] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1446), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1448), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36201] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1450), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1452), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36241] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1454), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1456), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36281] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1458), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1460), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36321] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1462), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1464), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36361] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1466), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1468), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36401] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1470), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1472), 16,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36441] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1474), 1,
      anon_sym_if,
    ACTIONS(1476), 1,
      anon_sym_DASH_GT,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(1036), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36512] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1486), 1,
      sym_float,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(695), 1,
      sym_identifier,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(703), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [36579] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1488), 1,
      anon_sym_if,
    STATE(806), 1,
      sym__pattern,
    STATE(826), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1490), 2,
      anon_sym_DASH_GT,
      anon_sym_PIPE,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36648] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1492), 1,
      sym_float,
    STATE(662), 1,
      sym_identifier,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(706), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [36715] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1494), 1,
      anon_sym_if,
    STATE(806), 1,
      sym__pattern,
    STATE(826), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1496), 2,
      anon_sym_DASH_GT,
      anon_sym_PIPE,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36784] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1498), 1,
      anon_sym_RBRACK,
    ACTIONS(1500), 1,
      anon_sym_DOT_DOT,
    STATE(772), 1,
      sym_identifier,
    STATE(806), 1,
      sym__pattern,
    STATE(1288), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36855] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1502), 5,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [36912] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1500), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1504), 1,
      anon_sym_RBRACK,
    STATE(772), 1,
      sym_identifier,
    STATE(839), 1,
      sym__pattern,
    STATE(1206), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36983] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1506), 1,
      sym_float,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(695), 1,
      sym_identifier,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(698), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37050] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1508), 1,
      sym_float,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(695), 1,
      sym_identifier,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(700), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37117] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1510), 1,
      sym_float,
    STATE(662), 1,
      sym_identifier,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(707), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37184] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1512), 1,
      sym_float,
    STATE(662), 1,
      sym_identifier,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(708), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37251] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1514), 1,
      sym_float,
    STATE(662), 1,
      sym_identifier,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37318] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1516), 1,
      anon_sym_if,
    ACTIONS(1518), 1,
      anon_sym_DASH_GT,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(1036), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37389] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    STATE(662), 1,
      sym_identifier,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(683), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37456] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1522), 1,
      sym_float,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(695), 1,
      sym_identifier,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(701), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37523] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1500), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1524), 1,
      anon_sym_RBRACK,
    STATE(772), 1,
      sym_identifier,
    STATE(806), 1,
      sym__pattern,
    STATE(1282), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37594] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1520), 1,
      sym_float,
    STATE(684), 1,
      sym__case_clause_guard_binary_expression,
    STATE(695), 1,
      sym_identifier,
    STATE(696), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(683), 9,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [37661] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1526), 1,
      anon_sym_COMMA,
    ACTIONS(1528), 1,
      anon_sym_RBRACK,
    ACTIONS(1530), 1,
      anon_sym_DOT_DOT,
    STATE(856), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [37723] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1388), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1386), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37761] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1396), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1394), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37799] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1340), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1338), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37837] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1328), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1326), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37875] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1316), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1314), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37913] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(772), 1,
      sym_identifier,
    STATE(908), 1,
      sym__pattern,
    STATE(1046), 1,
      sym_record_pattern_argument,
    STATE(1191), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37981] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1532), 1,
      anon_sym_GT_GT,
    STATE(772), 1,
      sym_identifier,
    STATE(981), 1,
      sym__pattern,
    STATE(1083), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38049] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1320), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1318), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38087] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1408), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1406), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38125] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1270), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1268), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38163] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1534), 1,
      anon_sym_GT_GT,
    STATE(772), 1,
      sym_identifier,
    STATE(981), 1,
      sym__pattern,
    STATE(1083), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38231] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1258), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1256), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38269] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1296), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1294), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38307] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1392), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1390), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38345] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1536), 1,
      anon_sym_COMMA,
    ACTIONS(1538), 1,
      anon_sym_RBRACK,
    ACTIONS(1540), 1,
      anon_sym_DOT_DOT,
    STATE(866), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [38407] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1356), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1354), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38445] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1542), 1,
      anon_sym_COMMA,
    ACTIONS(1544), 1,
      anon_sym_RBRACK,
    ACTIONS(1546), 1,
      anon_sym_DOT_DOT,
    STATE(876), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [38507] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1548), 1,
      anon_sym_GT_GT,
    STATE(772), 1,
      sym_identifier,
    STATE(980), 1,
      sym_pattern_bit_string_segment,
    STATE(981), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38575] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1368), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1366), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38613] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1278), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1276), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38651] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1436), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1434), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38689] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1550), 1,
      anon_sym_COMMA,
    ACTIONS(1552), 1,
      anon_sym_RBRACK,
    ACTIONS(1554), 1,
      anon_sym_DOT_DOT,
    STATE(867), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [38751] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1376), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1374), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38789] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1284), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1282), 22,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38827] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1556), 1,
      anon_sym_RPAREN,
    ACTIONS(1558), 1,
      sym_float,
    STATE(1098), 1,
      sym_constant_record_argument,
    STATE(1196), 1,
      sym_label,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1153), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [38892] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(341), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(958), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38957] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    STATE(826), 1,
      sym_identifier,
    STATE(850), 1,
      sym__pattern,
    STATE(1036), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39022] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(244), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(988), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39087] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1560), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      sym_identifier,
    STATE(913), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39152] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1558), 1,
      sym_float,
    ACTIONS(1562), 1,
      anon_sym_RPAREN,
    STATE(967), 1,
      sym_constant_record_argument,
    STATE(1196), 1,
      sym_label,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1153), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39217] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1558), 1,
      sym_float,
    ACTIONS(1564), 1,
      anon_sym_RPAREN,
    STATE(1025), 1,
      sym_constant_record_argument,
    STATE(1196), 1,
      sym_label,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1153), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39282] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(772), 1,
      sym_identifier,
    STATE(981), 1,
      sym__pattern,
    STATE(1083), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39347] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1558), 1,
      sym_float,
    ACTIONS(1566), 1,
      anon_sym_RPAREN,
    STATE(1098), 1,
      sym_constant_record_argument,
    STATE(1196), 1,
      sym_label,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1153), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39412] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(76), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(969), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39477] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(74), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(969), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39542] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1558), 1,
      sym_float,
    ACTIONS(1568), 1,
      anon_sym_RPAREN,
    STATE(1098), 1,
      sym_constant_record_argument,
    STATE(1196), 1,
      sym_label,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1153), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39607] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1558), 1,
      sym_float,
    ACTIONS(1570), 1,
      anon_sym_RPAREN,
    STATE(1098), 1,
      sym_constant_record_argument,
    STATE(1196), 1,
      sym_label,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1153), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [39672] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(246), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(988), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39737] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(427), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(988), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39802] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1572), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      sym_identifier,
    STATE(806), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39867] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1574), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      sym_identifier,
    STATE(806), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [39932] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1576), 1,
      anon_sym_COMMA,
    ACTIONS(1578), 1,
      anon_sym_RPAREN,
    STATE(948), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [39991] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1580), 1,
      anon_sym_COMMA,
    ACTIONS(1582), 1,
      anon_sym_RPAREN,
    STATE(1035), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40050] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(429), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(988), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [40115] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(340), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(958), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [40180] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(246), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(1010), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [40245] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1584), 1,
      anon_sym_LBRACE,
    ACTIONS(1586), 1,
      anon_sym_COMMA,
    STATE(973), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40304] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(244), 1,
      sym__assignment,
    STATE(772), 1,
      sym_identifier,
    STATE(1010), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [40369] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1588), 1,
      anon_sym_COMMA,
    ACTIONS(1590), 1,
      anon_sym_RPAREN,
    STATE(979), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40428] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1592), 1,
      anon_sym_COMMA,
    ACTIONS(1594), 1,
      anon_sym_RPAREN,
    STATE(935), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40487] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1133), 1,
      sym__discard_name,
    ACTIONS(1135), 1,
      anon_sym_DASH,
    ACTIONS(1137), 1,
      anon_sym_DQUOTE,
    ACTIONS(1139), 1,
      sym_float,
    ACTIONS(1143), 1,
      sym__decimal,
    ACTIONS(1145), 1,
      sym__name,
    ACTIONS(1147), 1,
      sym__upname,
    STATE(806), 1,
      sym__pattern,
    STATE(826), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1141), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(833), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [40549] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1596), 1,
      anon_sym_GT_GT,
    ACTIONS(1598), 1,
      sym_float,
    STATE(1170), 1,
      sym_constant_bit_string_segment,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(939), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40611] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1598), 1,
      sym_float,
    ACTIONS(1600), 1,
      anon_sym_GT_GT,
    STATE(1170), 1,
      sym_constant_bit_string_segment,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(939), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40673] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1598), 1,
      sym_float,
    ACTIONS(1602), 1,
      anon_sym_GT_GT,
    STATE(1170), 1,
      sym_constant_bit_string_segment,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(939), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40735] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1604), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40789] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(313), 1,
      sym__name,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1558), 1,
      sym_float,
    STATE(1098), 1,
      sym_constant_record_argument,
    STATE(1196), 1,
      sym_label,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1153), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [40851] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(772), 1,
      sym_identifier,
    STATE(806), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [40913] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1606), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [40967] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(772), 1,
      sym_identifier,
    STATE(1042), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41029] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(772), 1,
      sym_identifier,
    STATE(1034), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41091] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(693), 1,
      sym__name,
    ACTIONS(1121), 1,
      anon_sym_POUND,
    ACTIONS(1125), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_LT_LT,
    ACTIONS(1131), 1,
      sym_float,
    ACTIONS(1133), 1,
      sym__discard_name,
    STATE(772), 1,
      sym_identifier,
    STATE(1008), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(702), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(788), 7,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41153] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1608), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41207] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1598), 1,
      sym_float,
    ACTIONS(1610), 1,
      anon_sym_GT_GT,
    STATE(1170), 1,
      sym_constant_bit_string_segment,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(939), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41269] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1598), 1,
      sym_float,
    ACTIONS(1612), 1,
      anon_sym_GT_GT,
    STATE(940), 1,
      sym_constant_bit_string_segment,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(939), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41331] = 17,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1598), 1,
      sym_float,
    ACTIONS(1614), 1,
      anon_sym_GT_GT,
    STATE(1044), 1,
      sym_constant_bit_string_segment,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(939), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41393] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1616), 1,
      anon_sym_RBRACK,
    ACTIONS(1618), 1,
      sym_float,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41452] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1620), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41505] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    ACTIONS(1622), 1,
      anon_sym_RPAREN,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41564] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1624), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41617] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1626), 1,
      anon_sym_RPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41670] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1628), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41723] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1630), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41776] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1632), 1,
      anon_sym_RBRACK,
    ACTIONS(1634), 1,
      sym_float,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1043), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41835] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    ACTIONS(1636), 1,
      anon_sym_RPAREN,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [41894] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1638), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [41947] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1640), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42000] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1642), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42053] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    ACTIONS(1644), 1,
      anon_sym_RBRACK,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42112] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1646), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42165] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    ACTIONS(1648), 1,
      anon_sym_RBRACK,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42224] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1650), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42277] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1652), 1,
      anon_sym_RPAREN,
    ACTIONS(1654), 1,
      sym_float,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1030), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42336] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1656), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42389] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    ACTIONS(1658), 1,
      anon_sym_RPAREN,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42448] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1660), 1,
      anon_sym_RBRACK,
    ACTIONS(1662), 1,
      sym_float,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(938), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42507] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1664), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42560] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1666), 1,
      anon_sym_RPAREN,
    ACTIONS(1668), 1,
      sym_float,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1045), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42619] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    ACTIONS(1670), 1,
      anon_sym_RPAREN,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42678] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1672), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42731] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1674), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42784] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1598), 1,
      sym_float,
    STATE(1170), 1,
      sym_constant_bit_string_segment,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(939), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42843] = 16,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    ACTIONS(1676), 1,
      anon_sym_RBRACK,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [42902] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1678), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [42955] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1680), 1,
      anon_sym_COMMA,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43008] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1153), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1169), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1175), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1682), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1151), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1155), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1163), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1157), 3,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
    ACTIONS(1165), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1167), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43061] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1684), 1,
      sym_float,
    STATE(1183), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(800), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43117] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1686), 1,
      anon_sym_POUND,
    ACTIONS(1688), 1,
      anon_sym_LBRACK,
    ACTIONS(1690), 1,
      anon_sym_LT_LT,
    ACTIONS(1692), 1,
      sym_float,
    STATE(1182), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(395), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(496), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43173] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1686), 1,
      anon_sym_POUND,
    ACTIONS(1688), 1,
      anon_sym_LBRACK,
    ACTIONS(1690), 1,
      anon_sym_LT_LT,
    ACTIONS(1694), 1,
      sym_float,
    STATE(1182), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(395), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(488), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43229] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1696), 1,
      sym_float,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1131), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43285] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_DASH,
    ACTIONS(473), 1,
      anon_sym_DQUOTE,
    ACTIONS(479), 1,
      sym__decimal,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(483), 1,
      sym__upname,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1618), 1,
      sym_float,
    STATE(1243), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(477), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(975), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43341] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1698), 1,
      sym_float,
    STATE(1183), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(780), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43397] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1700), 1,
      sym_float,
    STATE(1183), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(804), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43453] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(309), 1,
      sym__decimal,
    ACTIONS(315), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1480), 1,
      anon_sym_POUND,
    ACTIONS(1482), 1,
      anon_sym_LBRACK,
    ACTIONS(1484), 1,
      anon_sym_LT_LT,
    ACTIONS(1702), 1,
      sym_float,
    STATE(1183), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(453), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(307), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(779), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43509] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1686), 1,
      anon_sym_POUND,
    ACTIONS(1688), 1,
      anon_sym_LBRACK,
    ACTIONS(1690), 1,
      anon_sym_LT_LT,
    ACTIONS(1704), 1,
      sym_float,
    STATE(1182), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(395), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(491), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43565] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(23), 1,
      anon_sym_DASH,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(53), 1,
      sym__decimal,
    ACTIONS(57), 1,
      sym__upname,
    ACTIONS(481), 1,
      sym__name,
    ACTIONS(1686), 1,
      anon_sym_POUND,
    ACTIONS(1688), 1,
      anon_sym_LBRACK,
    ACTIONS(1690), 1,
      anon_sym_LT_LT,
    ACTIONS(1706), 1,
      sym_float,
    STATE(1182), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(395), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(51), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(495), 7,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_string,
      sym_integer,
  [43621] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(681), 9,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      sym__decimal,
      sym__name,
    ACTIONS(679), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [43654] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(367), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(365), 13,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43684] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(331), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(329), 13,
      anon_sym_if,
      anon_sym_DOT,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43714] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(345), 13,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43744] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(619), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43773] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1710), 1,
      anon_sym_RPAREN,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1716), 1,
      sym__name,
    ACTIONS(1718), 1,
      sym__upname,
    STATE(1109), 1,
      sym_data_constructor_argument,
    STATE(1185), 1,
      sym_identifier,
    STATE(1246), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1099), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [43820] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1720), 1,
      anon_sym_RBRACE,
    ACTIONS(1722), 1,
      anon_sym_import,
    ACTIONS(1724), 1,
      anon_sym_const,
    ACTIONS(1726), 1,
      anon_sym_external,
    ACTIONS(1728), 1,
      anon_sym_type,
    ACTIONS(1730), 1,
      anon_sym_fn,
    ACTIONS(1732), 1,
      sym_visibility_modifier,
    ACTIONS(1734), 1,
      sym_opacity_modifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(639), 9,
      sym__statement,
      sym_import,
      sym_constant,
      sym_external_type,
      sym_external_function,
      sym_function,
      sym_type_definition,
      sym_type_alias,
      aux_sym_target_group_repeat1,
  [43863] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1736), 1,
      anon_sym_RBRACE,
    ACTIONS(1738), 1,
      anon_sym_import,
    ACTIONS(1741), 1,
      anon_sym_const,
    ACTIONS(1744), 1,
      anon_sym_external,
    ACTIONS(1747), 1,
      anon_sym_type,
    ACTIONS(1750), 1,
      anon_sym_fn,
    ACTIONS(1753), 1,
      sym_visibility_modifier,
    ACTIONS(1756), 1,
      sym_opacity_modifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(634), 9,
      sym__statement,
      sym_import,
      sym_constant,
      sym_external_type,
      sym_external_function,
      sym_function,
      sym_type_definition,
      sym_type_alias,
      aux_sym_target_group_repeat1,
  [43906] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(363), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(361), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43935] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(443), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [43964] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1716), 1,
      sym__name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1759), 1,
      anon_sym_RPAREN,
    STATE(1109), 1,
      sym_data_constructor_argument,
    STATE(1185), 1,
      sym_identifier,
    STATE(1246), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1099), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44011] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(351), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(349), 12,
      anon_sym_if,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [44040] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1722), 1,
      anon_sym_import,
    ACTIONS(1724), 1,
      anon_sym_const,
    ACTIONS(1726), 1,
      anon_sym_external,
    ACTIONS(1728), 1,
      anon_sym_type,
    ACTIONS(1730), 1,
      anon_sym_fn,
    ACTIONS(1732), 1,
      sym_visibility_modifier,
    ACTIONS(1734), 1,
      sym_opacity_modifier,
    ACTIONS(1761), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(634), 9,
      sym__statement,
      sym_import,
      sym_constant,
      sym_external_type,
      sym_external_function,
      sym_function,
      sym_type_definition,
      sym_type_alias,
      aux_sym_target_group_repeat1,
  [44083] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1716), 1,
      sym__name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1763), 1,
      anon_sym_RPAREN,
    STATE(998), 1,
      sym_data_constructor_argument,
    STATE(1185), 1,
      sym_identifier,
    STATE(1246), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1099), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44130] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1765), 1,
      anon_sym_RPAREN,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1149), 1,
      sym_external_function_parameter,
    STATE(1154), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1174), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44174] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1769), 1,
      anon_sym_RPAREN,
    STATE(1084), 1,
      sym_type_argument,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1091), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44218] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1716), 1,
      sym__name,
    ACTIONS(1718), 1,
      sym__upname,
    STATE(1109), 1,
      sym_data_constructor_argument,
    STATE(1185), 1,
      sym_identifier,
    STATE(1246), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1099), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44262] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1771), 1,
      anon_sym_RPAREN,
    STATE(1149), 1,
      sym_external_function_parameter,
    STATE(1154), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1174), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44306] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1773), 1,
      anon_sym_RPAREN,
    STATE(1007), 1,
      sym_type_argument,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1091), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44350] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1775), 1,
      anon_sym_RPAREN,
    STATE(1020), 1,
      sym_type_argument,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1091), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44394] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1777), 1,
      anon_sym_RPAREN,
    STATE(1084), 1,
      sym_type_argument,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1091), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44438] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1779), 1,
      anon_sym_RPAREN,
    STATE(1084), 1,
      sym_type_argument,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1091), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44482] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1781), 1,
      anon_sym_RPAREN,
    STATE(944), 1,
      sym_external_function_parameter,
    STATE(1154), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1174), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44526] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1783), 1,
      anon_sym_RPAREN,
    STATE(1084), 1,
      sym_type_argument,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1091), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44570] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1785), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1089), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44611] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1787), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(999), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44652] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1789), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1089), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44693] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1791), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1089), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44734] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1793), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1003), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44775] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1795), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1089), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44816] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1797), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1089), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44857] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1799), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1022), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44898] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1149), 1,
      sym_external_function_parameter,
    STATE(1154), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1174), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44939] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    ACTIONS(1801), 1,
      anon_sym_RPAREN,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1089), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [44980] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1084), 1,
      sym_type_argument,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1091), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45021] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1805), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1807), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1803), 9,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [45049] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1258), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45087] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1260), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45125] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1272), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45163] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1809), 1,
      anon_sym_POUND,
    ACTIONS(1811), 1,
      anon_sym_fn,
    ACTIONS(1813), 1,
      sym__discard_name,
    ACTIONS(1815), 1,
      sym__name,
    ACTIONS(1817), 1,
      sym__upname,
    STATE(1255), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(383), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(497), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45201] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(795), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45239] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(907), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45277] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1268), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45315] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(725), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45353] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1142), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45391] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1819), 1,
      anon_sym_LPAREN,
    STATE(713), 1,
      sym_type_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1091), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45419] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(329), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(1212), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45445] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1281), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45483] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1179), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45521] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1809), 1,
      anon_sym_POUND,
    ACTIONS(1811), 1,
      anon_sym_fn,
    ACTIONS(1813), 1,
      sym__discard_name,
    ACTIONS(1815), 1,
      sym__name,
    ACTIONS(1817), 1,
      sym__upname,
    STATE(1255), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(383), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(459), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45559] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1089), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45597] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(790), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45635] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1286), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45673] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(781), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45711] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1823), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1821), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [45737] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1223), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45775] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1827), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1825), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [45801] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1831), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1829), 10,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
  [45827] = 3,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1226), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_import,
      anon_sym_as,
      anon_sym_COMMA,
      anon_sym_const,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_external,
      anon_sym_type,
      anon_sym_fn,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [45851] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(1254), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45889] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1809), 1,
      anon_sym_POUND,
    ACTIONS(1811), 1,
      anon_sym_fn,
    ACTIONS(1813), 1,
      sym__discard_name,
    ACTIONS(1815), 1,
      sym__name,
    ACTIONS(1817), 1,
      sym__upname,
    STATE(1255), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(383), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(487), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45927] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1708), 1,
      anon_sym_POUND,
    ACTIONS(1712), 1,
      anon_sym_fn,
    ACTIONS(1714), 1,
      sym__discard_name,
    ACTIONS(1718), 1,
      sym__upname,
    ACTIONS(1767), 1,
      sym__name,
    STATE(1185), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(672), 2,
      sym_type_identifier,
      sym_remote_type_identifier,
    STATE(711), 6,
      sym__type,
      sym_type_hole,
      sym_tuple_type,
      sym_function_type,
      sym_type,
      sym_type_var,
  [45965] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(18