#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1174
#define LARGE_STATE_COUNT 690
#define SYMBOL_COUNT 133
#define ALIAS_COUNT 0
#define TOKEN_COUNT 80
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 14
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 15

enum {
  anon_sym_LF = 1,
  anon_sym_SEMI = 2,
  anon_sym_function = 3,
  anon_sym_BSLASH = 4,
  anon_sym_if = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_else = 8,
  anon_sym_while = 9,
  anon_sym_repeat = 10,
  anon_sym_for = 11,
  anon_sym_in = 12,
  anon_sym_switch = 13,
  anon_sym_COMMA = 14,
  anon_sym_EQ = 15,
  anon_sym_LBRACE = 16,
  anon_sym_RBRACE = 17,
  anon_sym_LT_DASH = 18,
  anon_sym_COLON_EQ = 19,
  anon_sym_LT_LT_DASH = 20,
  anon_sym_DASH_GT_GT = 21,
  anon_sym_DASH_GT = 22,
  anon_sym_LBRACK = 23,
  anon_sym_RBRACK = 24,
  anon_sym_LBRACK_LBRACK = 25,
  anon_sym_RBRACK_RBRACK = 26,
  anon_sym_DOLLAR = 27,
  anon_sym_AT = 28,
  anon_sym_COLON_COLON = 29,
  anon_sym_COLON_COLON_COLON = 30,
  anon_sym_QMARK = 31,
  sym_dots = 32,
  sym_placeholder = 33,
  anon_sym_PIPE_GT = 34,
  anon_sym_DASH = 35,
  anon_sym_PLUS = 36,
  anon_sym_BANG = 37,
  anon_sym_TILDE = 38,
  anon_sym_STAR = 39,
  anon_sym_SLASH = 40,
  anon_sym_CARET = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_LT_EQ = 44,
  anon_sym_GT_EQ = 45,
  anon_sym_EQ_EQ = 46,
  anon_sym_BANG_EQ = 47,
  anon_sym_PIPE_PIPE = 48,
  anon_sym_PIPE = 49,
  anon_sym_AMP_AMP = 50,
  anon_sym_AMP = 51,
  anon_sym_COLON = 52,
  sym_break = 53,
  sym_next = 54,
  sym_true = 55,
  sym_false = 56,
  sym_null = 57,
  sym_inf = 58,
  sym_nan = 59,
  anon_sym_NA = 60,
  anon_sym_NA_character_ = 61,
  anon_sym_NA_complex_ = 62,
  anon_sym_NA_integer_ = 63,
  anon_sym_NA_real_ = 64,
  aux_sym_identifier_token1 = 65,
  anon_sym_BQUOTE = 66,
  aux_sym_identifier_token2 = 67,
  sym_integer = 68,
  sym_float = 69,
  anon_sym_i = 70,
  sym_comment = 71,
  anon_sym_DQUOTE = 72,
  aux_sym_string_token1 = 73,
  anon_sym_SQUOTE = 74,
  aux_sym_string_token2 = 75,
  anon_sym_PERCENT = 76,
  aux_sym_special_token1 = 77,
  sym_escape_sequence = 78,
  sym__raw_string_literal = 79,
  sym_program = 80,
  sym_function_definition = 81,
  sym_lambda_function = 82,
  sym_if = 83,
  sym_while = 84,
  sym_repeat = 85,
  sym_for = 86,
  sym_switch = 87,
  sym_formal_parameters = 88,
  sym_default_parameter = 89,
  sym__formal_parameter = 90,
  sym_arguments = 91,
  sym_default_argument = 92,
  sym__argument = 93,
  sym_call = 94,
  sym__assignment = 95,
  sym_left_assignment = 96,
  sym_left_assignment2 = 97,
  sym_equals_assignment = 98,
  sym_super_assignment = 99,
  sym_super_right_assignment = 100,
  sym_right_assignment = 101,
  sym_brace_list = 102,
  sym_paren_list = 103,
  sym_subset = 104,
  sym_subset2 = 105,
  sym_dollar = 106,
  sym_slot = 107,
  sym_namespace_get = 108,
  sym_namespace_get_internal = 109,
  sym_help = 110,
  sym_pipe_placeholder_argument = 111,
  sym__pipe_rhs_argument = 112,
  sym_pipe_rhs_arguments = 113,
  sym_pipe_rhs = 114,
  sym_pipe = 115,
  sym_unary = 116,
  sym_binary = 117,
  sym_na = 118,
  sym__expression = 119,
  sym_identifier = 120,
  sym_complex = 121,
  sym_string = 122,
  sym_special = 123,
  aux_sym_program_repeat1 = 124,
  aux_sym_formal_parameters_repeat1 = 125,
  aux_sym_block_repeat1 = 126,
  aux_sym_arguments_repeat1 = 127,
  aux_sym_pipe_rhs_arguments_repeat1 = 128,
  aux_sym_identifier_repeat1 = 129,
  aux_sym_string_repeat1 = 130,
  aux_sym_string_repeat2 = 131,
  aux_sym_special_repeat1 = 132,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_function] = "function",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_if] = "if",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_switch] = "switch",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [anon_sym_QMARK] = "\?",
  [sym_dots] = "dots",
  [sym_placeholder] = "placeholder",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_AMP] = "&",
  [anon_sym_COLON] = ":",
  [sym_break] = "break",
  [sym_next] = "next",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_character_] = "NA_character_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [aux_sym_identifier_token1] = "identifier_token1",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_identifier_token2] = "identifier_token2",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_i] = "i",
  [sym_comment] = "comment",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_PERCENT] = "%",
  [aux_sym_special_token1] = "special_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__raw_string_literal] = "_raw_string_literal",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_lambda_function] = "lambda_function",
  [sym_if] = "if",
  [sym_while] = "while",
  [sym_repeat] = "repeat",
  [sym_for] = "for",
  [sym_switch] = "switch",
  [sym_formal_parameters] = "formal_parameters",
  [sym_default_parameter] = "default_parameter",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_arguments] = "arguments",
  [sym_default_argument] = "default_argument",
  [sym__argument] = "_argument",
  [sym_call] = "call",
  [sym__assignment] = "_assignment",
  [sym_left_assignment] = "left_assignment",
  [sym_left_assignment2] = "left_assignment2",
  [sym_equals_assignment] = "equals_assignment",
  [sym_super_assignment] = "super_assignment",
  [sym_super_right_assignment] = "super_right_assignment",
  [sym_right_assignment] = "right_assignment",
  [sym_brace_list] = "brace_list",
  [sym_paren_list] = "paren_list",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_dollar] = "dollar",
  [sym_slot] = "slot",
  [sym_namespace_get] = "namespace_get",
  [sym_namespace_get_internal] = "namespace_get_internal",
  [sym_help] = "help",
  [sym_pipe_placeholder_argument] = "default_argument",
  [sym__pipe_rhs_argument] = "_pipe_rhs_argument",
  [sym_pipe_rhs_arguments] = "arguments",
  [sym_pipe_rhs] = "call",
  [sym_pipe] = "pipe",
  [sym_unary] = "unary",
  [sym_binary] = "binary",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym_identifier] = "identifier",
  [sym_complex] = "complex",
  [sym_string] = "string",
  [sym_special] = "special",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_pipe_rhs_arguments_repeat1] = "pipe_rhs_arguments_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_special_repeat1] = "special_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_dots] = sym_dots,
  [sym_placeholder] = sym_placeholder,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_break] = sym_break,
  [sym_next] = sym_next,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_identifier_token2] = aux_sym_identifier_token2,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_i] = anon_sym_i,
  [sym_comment] = sym_comment,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym_special_token1] = aux_sym_special_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__raw_string_literal] = sym__raw_string_literal,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_lambda_function] = sym_lambda_function,
  [sym_if] = sym_if,
  [sym_while] = sym_while,
  [sym_repeat] = sym_repeat,
  [sym_for] = sym_for,
  [sym_switch] = sym_switch,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_default_parameter] = sym_default_parameter,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_arguments] = sym_arguments,
  [sym_default_argument] = sym_default_argument,
  [sym__argument] = sym__argument,
  [sym_call] = sym_call,
  [sym__assignment] = sym__assignment,
  [sym_left_assignment] = sym_left_assignment,
  [sym_left_assignment2] = sym_left_assignment2,
  [sym_equals_assignment] = sym_equals_assignment,
  [sym_super_assignment] = sym_super_assignment,
  [sym_super_right_assignment] = sym_super_right_assignment,
  [sym_right_assignment] = sym_right_assignment,
  [sym_brace_list] = sym_brace_list,
  [sym_paren_list] = sym_paren_list,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_dollar] = sym_dollar,
  [sym_slot] = sym_slot,
  [sym_namespace_get] = sym_namespace_get,
  [sym_namespace_get_internal] = sym_namespace_get_internal,
  [sym_help] = sym_help,
  [sym_pipe_placeholder_argument] = sym_default_argument,
  [sym__pipe_rhs_argument] = sym__pipe_rhs_argument,
  [sym_pipe_rhs_arguments] = sym_arguments,
  [sym_pipe_rhs] = sym_call,
  [sym_pipe] = sym_pipe,
  [sym_unary] = sym_unary,
  [sym_binary] = sym_binary,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym_identifier] = sym_identifier,
  [sym_complex] = sym_complex,
  [sym_string] = sym_string,
  [sym_special] = sym_special,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_pipe_rhs_arguments_repeat1] = aux_sym_pipe_rhs_arguments_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_special_repeat1] = aux_sym_special_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_special_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__raw_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_default_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_left_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_left_assignment2] = {
    .visible = true,
    .named = true,
  },
  [sym_equals_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_list] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_list] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_slot] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get_internal] = {
    .visible = true,
    .named = true,
  },
  [sym_help] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_placeholder_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__pipe_rhs_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_pipe_rhs_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_rhs] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym_unary] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_special] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pipe_rhs_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_special_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_function = 6,
  field_left = 7,
  field_name = 8,
  field_namespace = 9,
  field_operand = 10,
  field_operator = 11,
  field_right = 12,
  field_value = 13,
  field_vector = 14,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_value] = "value",
  [field_vector] = "vector",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 3},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 1},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 2},
  [13] = {.index = 22, .length = 4},
  [14] = {.index = 26, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 1},
  [1] =
    {field_operand, 1},
    {field_operator, 0},
  [3] =
    {field_function, 0},
  [4] =
    {field_name, 0},
    {field_value, 2},
  [6] =
    {field_name, 2},
    {field_value, 0},
  [8] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [11] =
    {field_function, 2},
    {field_namespace, 0},
  [13] =
    {field_name, 0},
  [14] =
    {field_arguments, 2},
    {field_function, 0},
  [16] =
    {field_condition, 2},
    {field_consequence, 4},
  [18] =
    {field_body, 4},
    {field_condition, 2},
  [20] =
    {field_body, 4},
    {field_value, 2},
  [22] =
    {field_alternative, 5},
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [26] =
    {field_body, 6},
    {field_name, 2},
    {field_vector, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool aux_sym_identifier_token1_character_set_1(int32_t c) {
  return (c < 43520
    ? (c < 4197
      ? (c < 2730
        ? (c < 2036
          ? (c < 1015
            ? (c < 750
              ? (c < 216
                ? (c < 181
                  ? (c < 170
                    ? (c >= 'A' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || (c < 192
                    ? c == 186
                    : c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || c == 748))))
              : (c <= 750 || (c < 902
                ? (c < 891
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 910
                  ? (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c >= 931 && c <= 1013)))))))
            : (c <= 1153 || (c < 1749
              ? (c < 1488
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c >= 1376 && c <= 1416)))
                : (c <= 1514 || (c < 1646
                  ? (c < 1568
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))))
              : (c <= 1749 || (c < 1808
                ? (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c >= 1994 && c <= 2026)))))))))
          : (c <= 2037 || (c < 2486
            ? (c < 2308
              ? (c < 2112
                ? (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || (c < 2088
                    ? c == 2084
                    : c <= 2088)))
                : (c <= 2136 || (c < 2185
                  ? (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)
                  : (c <= 2190 || (c >= 2208 && c <= 2249)))))
              : (c <= 2361 || (c < 2437
                ? (c < 2392
                  ? (c < 2384
                    ? c == 2365
                    : c <= 2384)
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))))))
            : (c <= 2489 || (c < 2602
              ? (c < 2544
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))
                : (c <= 2545 || (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))))
              : (c <= 2608 || (c < 2654
                ? (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))
                : (c <= 2654 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))))))))
        : (c <= 2736 || (c < 3253
          ? (c < 2969
            ? (c < 2866
              ? (c < 2809
                ? (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || (c < 2784
                    ? c == 2768
                    : c <= 2785)))
                : (c <= 2809 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))))
              : (c <= 2867 || (c < 2929
                ? (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))))))
            : (c <= 2970 || (c < 3114
              ? (c < 2990
                ? (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))
                : (c <= 3001 || (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))
              : (c <= 3129 || (c < 3200
                ? (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c >= 3242 && c <= 3251)))))))))
          : (c <= 3257 || (c < 3713
            ? (c < 3423
              ? (c < 3342
                ? (c < 3296
                  ? (c < 3293
                    ? c == 3261
                    : c <= 3294)
                  : (c <= 3297 || (c < 3332
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))))
              : (c <= 3425 || (c < 3517
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))))))
            : (c <= 3714 || (c < 3804
              ? (c < 3751
                ? (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))
                : (c <= 3760 || (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))
              : (c <= 3807 || (c < 4096
                ? (c < 3913
                  ? (c < 3904
                    ? c == 3840
                    : c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))
                : (c <= 4138 || (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || c == 4193))))))))))))
      : (c <= 4198 || (c < 8144
        ? (c < 6272
          ? (c < 4824
            ? (c < 4696
              ? (c < 4301
                ? (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))
                : (c <= 4301 || (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))))
              : (c <= 4696 || (c < 4786
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c >= 4808 && c <= 4822)))))))
            : (c <= 4880 || (c < 5870
              ? (c < 5112
                ? (c < 4992
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))))
              : (c <= 5880 || (c < 5998
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5905)
                    : c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))
                : (c <= 6000 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : c <= 6103)
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))))))))
          : (c <= 6312 || (c < 7357
            ? (c < 6917
              ? (c < 6528
                ? (c < 6400
                  ? (c < 6320
                    ? c == 6314
                    : c <= 6389)
                  : (c <= 6430 || (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)))
                : (c <= 6571 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6678)
                  : (c <= 6740 || c == 6823))))
              : (c <= 6963 || (c < 7168
                ? (c < 7086
                  ? (c < 7043
                    ? (c >= 6981 && c <= 6988)
                    : c <= 7072)
                  : (c <= 7087 || (c >= 7098 && c <= 7141)))
                : (c <= 7203 || (c < 7296
                  ? (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)
                  : (c <= 7304 || (c >= 7312 && c <= 7354)))))))
            : (c <= 7359 || (c < 8016
              ? (c < 7424
                ? (c < 7413
                  ? (c < 7406
                    ? (c >= 7401 && c <= 7404)
                    : c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c >= 8008 && c <= 8013)))))
              : (c <= 8023 || (c < 8064
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c >= 8031 && c <= 8061)))
                : (c <= 8116 || (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c >= 8134 && c <= 8140)))))))))))
        : (c <= 8147 || (c < 12344
          ? (c < 11264
            ? (c < 8469
              ? (c < 8319
                ? (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c < 8305
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8305)))
                : (c <= 8319 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))))
              : (c <= 8469 || (c < 8490
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))))
            : (c <= 11492 || (c < 11688
              ? (c < 11565
                ? (c < 11520
                  ? (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11648
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))))
              : (c <= 11694 || (c < 11728
                ? (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c >= 11720 && c <= 11726)))
                : (c <= 11734 || (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c >= 12337 && c <= 12341)))))))))
          : (c <= 12348 || (c < 42960
            ? (c < 42192
              ? (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c >= 19968 && c <= 42124)))))
              : (c <= 42237 || (c < 42623
                ? (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42954)))))))
            : (c <= 42961 || (c < 43259
              ? (c < 43015
                ? (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43138
                  ? (c < 43072
                    ? (c >= 43020 && c <= 43042)
                    : c <= 43123)
                  : (c <= 43187 || (c >= 43250 && c <= 43255)))))
              : (c <= 43259 || (c < 43396
                ? (c < 43312
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43494
                  ? (c < 43488
                    ? c == 43471
                    : c <= 43492)
                  : (c <= 43503 || (c >= 43514 && c <= 43518)))))))))))))))
    : (c <= 43560 || (c < 70751
      ? (c < 66964
        ? (c < 65008
          ? (c < 43888
            ? (c < 43739
              ? (c < 43697
                ? (c < 43616
                  ? (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)
                  : (c <= 43638 || (c < 43646
                    ? c == 43642
                    : c <= 43695)))
                : (c <= 43697 || (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))))
              : (c <= 43741 || (c < 43793
                ? (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))))))
            : (c <= 44002 || (c < 64298
              ? (c < 64112
                ? (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))))
              : (c <= 64310 || (c < 64326
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))))))))
          : (c <= 65017 || (c < 65616
            ? (c < 65440
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))))
              : (c <= 65470 || (c < 65536
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))))))
            : (c <= 65629 || (c < 66504
              ? (c < 66304
                ? (c < 66176
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66421)
                  : (c <= 66461 || (c >= 66464 && c <= 66499)))))
              : (c <= 66511 || (c < 66816
                ? (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c >= 66776 && c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))))))))))
        : (c <= 66965 || (c < 69248
          ? (c < 67840
            ? (c < 67584
              ? (c < 67392
                ? (c < 66995
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)
                  : (c <= 67001 || (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)))
                : (c <= 67413 || (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c >= 67506 && c <= 67514)))))
              : (c <= 67589 || (c < 67647
                ? (c < 67639
                  ? (c < 67594
                    ? c == 67592
                    : c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67808
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)
                  : (c <= 67826 || (c >= 67828 && c <= 67829)))))))
            : (c <= 67861 || (c < 68288
              ? (c < 68112
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || c == 68096))
                : (c <= 68115 || (c < 68192
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68220 || (c >= 68224 && c <= 68252)))))
              : (c <= 68295 || (c < 68480
                ? (c < 68416
                  ? (c < 68352
                    ? (c >= 68297 && c <= 68324)
                    : c <= 68405)
                  : (c <= 68437 || (c >= 68448 && c <= 68466)))
                : (c <= 68497 || (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c >= 68864 && c <= 68899)))))))))
          : (c <= 69289 || (c < 70108
            ? (c < 69763
              ? (c < 69552
                ? (c < 69415
                  ? (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)
                  : (c <= 69415 || (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)))
                : (c <= 69572 || (c < 69745
                  ? (c < 69635
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69687)
                  : (c <= 69746 || c == 69749))))
              : (c <= 69807 || (c < 69968
                ? (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))
                : (c <= 70002 || (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))))))
            : (c <= 70108 || (c < 70415
              ? (c < 70282
                ? (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))
                : (c <= 70285 || (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))))
              : (c <= 70416 || (c < 70461
                ? (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c >= 70453 && c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c >= 70727 && c <= 70730)))))))))))))
      : (c <= 70753 || (c < 119966
        ? (c < 73063
          ? (c < 72096
            ? (c < 71488
              ? (c < 71168
                ? (c < 70855
                  ? (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)
                  : (c <= 70855 || (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)))
                : (c <= 71215 || (c < 71352
                  ? (c < 71296
                    ? c == 71236
                    : c <= 71338)
                  : (c <= 71352 || (c >= 71424 && c <= 71450)))))
              : (c <= 71494 || (c < 71948
                ? (c < 71935
                  ? (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)
                  : (c <= 71942 || c == 71945))
                : (c <= 71955 || (c < 71999
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71983)
                  : (c <= 71999 || c == 72001))))))
            : (c <= 72103 || (c < 72368
              ? (c < 72203
                ? (c < 72163
                  ? (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)
                  : (c <= 72163 || c == 72192))
                : (c <= 72242 || (c < 72284
                  ? (c < 72272
                    ? c == 72250
                    : c <= 72272)
                  : (c <= 72329 || c == 72349))))
              : (c <= 72440 || (c < 72960
                ? (c < 72768
                  ? (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72750)
                  : (c <= 72768 || (c >= 72818 && c <= 72847)))
                : (c <= 72966 || (c < 73030
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)
                  : (c <= 73030 || (c >= 73056 && c <= 73061)))))))))
          : (c <= 73064 || (c < 94032
            ? (c < 92160
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73112
                    ? (c >= 73066 && c <= 73097)
                    : c <= 73112)
                  : (c <= 73458 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 77824
                  ? (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)
                  : (c <= 78894 || (c >= 82944 && c <= 83526)))))
              : (c <= 92728 || (c < 92992
                ? (c < 92880
                  ? (c < 92784
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92862)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))
                : (c <= 92995 || (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))))))
            : (c <= 94032 || (c < 110592
              ? (c < 100352
                ? (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))
                : (c <= 101589 || (c < 110581
                  ? (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)
                  : (c <= 110587 || (c >= 110589 && c <= 110590)))))
              : (c <= 110882 || (c < 113776
                ? (c < 110960
                  ? (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)
                  : (c <= 111355 || (c >= 113664 && c <= 113770)))
                : (c <= 113788 || (c < 119808
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 119892 || (c >= 119894 && c <= 119964)))))))))))
        : (c <= 119967 || (c < 126464
          ? (c < 120598
            ? (c < 120094
              ? (c < 119997
                ? (c < 119977
                  ? (c < 119973
                    ? c == 119970
                    : c <= 119974)
                  : (c <= 119980 || (c < 119995
                    ? (c >= 119982 && c <= 119993)
                    : c <= 119995)))
                : (c <= 120003 || (c < 120077
                  ? (c < 120071
                    ? (c >= 120005 && c <= 120069)
                    : c <= 120074)
                  : (c <= 120084 || (c >= 120086 && c <= 120092)))))
              : (c <= 120121 || (c < 120146
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c >= 120138 && c <= 120144)))
                : (c <= 120485 || (c < 120540
                  ? (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)
                  : (c <= 120570 || (c >= 120572 && c <= 120596)))))))
            : (c <= 120628 || (c < 123214
              ? (c < 120746
                ? (c < 120688
                  ? (c < 120656
                    ? (c >= 120630 && c <= 120654)
                    : c <= 120686)
                  : (c <= 120712 || (c >= 120714 && c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c >= 123191 && c <= 123197)))))
              : (c <= 123214 || (c < 124909
                ? (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123565)
                    : c <= 123627)
                  : (c <= 124902 || (c >= 124904 && c <= 124907)))
                : (c <= 124910 || (c < 125184
                  ? (c < 124928
                    ? (c >= 124912 && c <= 124926)
                    : c <= 125124)
                  : (c <= 125251 || c == 125259))))))))
          : (c <= 126467 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126500
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)
                  : (c <= 126500 || c == 126503))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_3(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'a'
                  ? (c < 'A'
                    ? c == '.'
                    : c <= 'Z')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_4(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '.'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_5(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '.'
                    : c <= '9')
                  : (c <= 'Z' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_6(int32_t c) {
  return (c < 43642
    ? (c < 3784
      ? (c < 2759
        ? (c < 2048
          ? (c < 1155
            ? (c < 736
              ? (c < 183
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 183 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)))))
              : (c <= 740 || (c < 895
                ? (c < 768
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 910
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)))))))
            : (c <= 1159 || (c < 1552
              ? (c < 1471
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)))
                : (c <= 1471 || (c < 1479
                  ? (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)
                  : (c <= 1479 || (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)))))
              : (c <= 1562 || (c < 1791
                ? (c < 1749
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)
                  : (c <= 1756 || (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)))
                : (c <= 1791 || (c < 1984
                  ? (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)
                  : (c <= 2037 || (c < 2045
                    ? c == 2042
                    : c <= 2045)))))))))
          : (c <= 2093 || (c < 2561
            ? (c < 2474
              ? (c < 2275
                ? (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)
                  : (c <= 2183 || (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)))
                : (c <= 2403 || (c < 2437
                  ? (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)))))
              : (c <= 2480 || (c < 2519
                ? (c < 2492
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2500 || (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)))
                : (c <= 2519 || (c < 2534
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)
                  : (c <= 2545 || (c < 2558
                    ? c == 2556
                    : c <= 2558)))))))
            : (c <= 2563 || (c < 2641
              ? (c < 2613
                ? (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))
                : (c <= 2614 || (c < 2622
                  ? (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)
                  : (c <= 2626 || (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)))))
              : (c <= 2641 || (c < 2703
                ? (c < 2662
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2677 || (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))))))))
        : (c <= 2761 || (c < 3174
          ? (c < 2962
            ? (c < 2869
              ? (c < 2817
                ? (c < 2784
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)
                  : (c <= 2787 || (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)))
                : (c <= 2819 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)))))
              : (c <= 2873 || (c < 2911
                ? (c < 2891
                  ? (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)
                  : (c <= 2893 || (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)))
                : (c <= 2915 || (c < 2946
                  ? (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)
                  : (c <= 2947 || (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)))))))
            : (c <= 2965 || (c < 3046
              ? (c < 2990
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)))
                : (c <= 3001 || (c < 3018
                  ? (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))))
              : (c <= 3055 || (c < 3142
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)))
                : (c <= 3144 || (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3171)))))))))
          : (c <= 3183 || (c < 3457
            ? (c < 3296
              ? (c < 3253
                ? (c < 3214
                  ? (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))
                : (c <= 3257 || (c < 3274
                  ? (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)
                  : (c <= 3277 || (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)))))
              : (c <= 3299 || (c < 3398
                ? (c < 3328
                  ? (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)))
                : (c <= 3400 || (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))))))
            : (c <= 3459 || (c < 3585
              ? (c < 3530
                ? (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))
                : (c <= 3530 || (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))))
              : (c <= 3642 || (c < 3724
                ? (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || (c < 3718
                    ? c == 3716
                    : c <= 3722)))
                : (c <= 3747 || (c < 3776
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))))))))))
      : (c <= 3789 || (c < 8027
        ? (c < 5919
          ? (c < 4696
            ? (c < 3974
              ? (c < 3893
                ? (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))
                : (c <= 3893 || (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))))
              : (c <= 3991 || (c < 4295
                ? (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)))))))
            : (c <= 4696 || (c < 4888
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))
              : (c <= 4954 || (c < 5121
                ? (c < 4992
                  ? (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : c <= 4977)
                  : (c <= 5007 || (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)))
                : (c <= 5740 || (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))))))
          : (c <= 5940 || (c < 6752
            ? (c < 6272
              ? (c < 6103
                ? (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)
                  : (c <= 6000 || (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)))
                : (c <= 6103 || (c < 6155
                  ? (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)
                  : (c <= 6157 || (c < 6176
                    ? (c >= 6159 && c <= 6169)
                    : c <= 6264)))))
              : (c <= 6314 || (c < 6512
                ? (c < 6432
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6443 || (c < 6470
                    ? (c >= 6448 && c <= 6459)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6608
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6618 || (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)))))))
            : (c <= 6780 || (c < 7245
              ? (c < 6912
                ? (c < 6823
                  ? (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : c <= 6809)
                  : (c <= 6823 || (c < 6847
                    ? (c >= 6832 && c <= 6845)
                    : c <= 6862)))
                : (c <= 6988 || (c < 7040
                  ? (c < 7019
                    ? (c >= 6992 && c <= 7001)
                    : c <= 7027)
                  : (c <= 7155 || (c < 7232
                    ? (c >= 7168 && c <= 7223)
                    : c <= 7241)))))
              : (c <= 7293 || (c < 7424
                ? (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))))))))
        : (c <= 8027 || (c < 11728
          ? (c < 8469
            ? (c < 8182
              ? (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))))
              : (c <= 8188 || (c < 8400
                ? (c < 8305
                  ? (c < 8276
                    ? (c >= 8255 && c <= 8256)
                    : c <= 8276)
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8412 || (c < 8450
                  ? (c < 8421
                    ? c == 8417
                    : c <= 8432)
                  : (c <= 8450 || (c < 8458
                    ? c == 8455
                    : c <= 8467)))))))
            : (c <= 8469 || (c < 11520
              ? (c < 8508
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || (c < 8490
                    ? c == 8488
                    : c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11507)))))
              : (c <= 11557 || (c < 11680
                ? (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))))))
          : (c <= 11734 || (c < 42775
            ? (c < 12549
              ? (c < 12344
                ? (c < 12293
                  ? (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)
                  : (c <= 12295 || (c < 12337
                    ? (c >= 12321 && c <= 12335)
                    : c <= 12341)))
                : (c <= 12348 || (c < 12445
                  ? (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))))
              : (c <= 12591 || (c < 42192
                ? (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)))
                : (c <= 42237 || (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))))))
            : (c <= 42783 || (c < 43259
              ? (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43047 || (c < 43136
                  ? (c < 43072
                    ? c == 43052
                    : c <= 43123)
                  : (c <= 43205 || (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)))))
              : (c <= 43259 || (c < 43488
                ? (c < 43360
                  ? (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)))
                : (c <= 43518 || (c < 43600
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)
                  : (c <= 43609 || (c >= 43616 && c <= 43638)))))))))))))))
    : (c <= 43714 || (c < 71472
      ? (c < 67644
        ? (c < 65382
          ? (c < 64318
            ? (c < 44012
              ? (c < 43793
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)
                  : (c <= 43766 || (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)))))
              : (c <= 44013 || (c < 64112
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : c <= 55203)
                  : (c <= 55238 || (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))))))
            : (c <= 64318 || (c < 65101
              ? (c < 64848
                ? (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)))
                : (c <= 64911 || (c < 65024
                  ? (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)
                  : (c <= 65039 || (c < 65075
                    ? (c >= 65056 && c <= 65071)
                    : c <= 65076)))))
              : (c <= 65103 || (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65313
                  ? (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)
                  : (c <= 65338 || (c < 65345
                    ? c == 65343
                    : c <= 65370)))))))))
          : (c <= 65470 || (c < 66560
            ? (c < 65856
              ? (c < 65549
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)))
                : (c <= 65574 || (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66349
                ? (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))
                : (c <= 66378 || (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))))))
            : (c <= 66717 || (c < 66995
              ? (c < 66928
                ? (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)))
                : (c <= 66938 || (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))))
              : (c <= 67001 || (c < 67463
                ? (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)))
                : (c <= 67504 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))))))))))
        : (c <= 67644 || (c < 69968
          ? (c < 68480
            ? (c < 68108
              ? (c < 67840
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))
                : (c <= 67861 || (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)))))
              : (c <= 68115 || (c < 68224
                ? (c < 68152
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68154 || (c < 68192
                    ? c == 68159
                    : c <= 68220)))
                : (c <= 68252 || (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)
                  : (c <= 68405 || (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)))))))
            : (c <= 68497 || (c < 69488
              ? (c < 69248
                ? (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)))
                : (c <= 69289 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69456)))))
              : (c <= 69509 || (c < 69826
                ? (c < 69632
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69888
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)
                  : (c <= 69940 || (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)))))))))
          : (c <= 70003 || (c < 70471
            ? (c < 70287
              ? (c < 70144
                ? (c < 70089
                  ? (c < 70016
                    ? c == 70006
                    : c <= 70084)
                  : (c <= 70092 || (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)))
                : (c <= 70161 || (c < 70272
                  ? (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)
                  : (c <= 70278 || (c < 70282
                    ? c == 70280
                    : c <= 70285)))))
              : (c <= 70301 || (c < 70415
                ? (c < 70384
                  ? (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)
                  : (c <= 70393 || (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)))
                : (c <= 70416 || (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)))))))
            : (c <= 70472 || (c < 70864
              ? (c < 70512
                ? (c < 70487
                  ? (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))
                : (c <= 70516 || (c < 70750
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)
                  : (c <= 70753 || (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)))))
              : (c <= 70873 || (c < 71248
                ? (c < 71128
                  ? (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)
                  : (c <= 71133 || (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)))
                : (c <= 71257 || (c < 71424
                  ? (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)
                  : (c <= 71450 || (c >= 71453 && c <= 71467)))))))))))))
      : (c <= 71481 || (c < 119973
        ? (c < 82944
          ? (c < 72784
            ? (c < 72096
              ? (c < 71948
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71738)
                  : (c <= 71913 || (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)))
                : (c <= 71955 || (c < 71991
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71989)
                  : (c <= 71992 || (c < 72016
                    ? (c >= 71995 && c <= 72003)
                    : c <= 72025)))))
              : (c <= 72103 || (c < 72272
                ? (c < 72163
                  ? (c < 72154
                    ? (c >= 72106 && c <= 72151)
                    : c <= 72161)
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)))))))
            : (c <= 72793 || (c < 73063
              ? (c < 72971
                ? (c < 72873
                  ? (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)
                  : (c <= 72886 || (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)))
                : (c <= 73014 || (c < 73023
                  ? (c < 73020
                    ? c == 73018
                    : c <= 73021)
                  : (c <= 73031 || (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)))))
              : (c <= 73064 || (c < 73648
                ? (c < 73107
                  ? (c < 73104
                    ? (c >= 73066 && c <= 73102)
                    : c <= 73105)
                  : (c <= 73112 || (c < 73440
                    ? (c >= 73120 && c <= 73129)
                    : c <= 73462)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))))
          : (c <= 83526 || (c < 110581
            ? (c < 93053
              ? (c < 92880
                ? (c < 92768
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))
                : (c <= 92909 || (c < 92992
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : c <= 92982)
                  : (c <= 92995 || (c < 93027
                    ? (c >= 93008 && c <= 93017)
                    : c <= 93047)))))
              : (c <= 93071 || (c < 94179
                ? (c < 94031
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94087 || (c < 94176
                    ? (c >= 94095 && c <= 94111)
                    : c <= 94177)))
                : (c <= 94180 || (c < 100352
                  ? (c < 94208
                    ? (c >= 94192 && c <= 94193)
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))))))
            : (c <= 110587 || (c < 118576
              ? (c < 113664
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c < 118528
                    ? (c >= 113821 && c <= 113822)
                    : c <= 118573)))))
              : (c <= 118598 || (c < 119362
                ? (c < 119163
                  ? (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)
                  : (c <= 119170 || (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)))
                : (c <= 119364 || (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_7(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_8(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'B'
                  ? (c < '0'
                    ? c == '.'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_9(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'B'
                  ? (c < '0'
                    ? c == '.'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'b'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_10(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '.'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'b'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_11(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? c == '.'
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(196);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '\r') ADVANCE(224);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(229);
      if (lookahead != 0) ADVANCE(223);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '\r') ADVANCE(225);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(229);
      if (lookahead != 0) ADVANCE(223);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '\r') ADVANCE(226);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(229);
      if (lookahead != 0) ADVANCE(223);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '\r') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(229);
      if (lookahead != 0) ADVANCE(223);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(212);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '\r') ADVANCE(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(198);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(198);
      if (lookahead == '\r') ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(216);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '\r') ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(220);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\r') ADVANCE(11);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(214);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(213);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(214);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(213);
      if (lookahead != 0) ADVANCE(214);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(199);
      if (lookahead != 0) ADVANCE(200);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(199);
      if (lookahead != 0) ADVANCE(200);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(218);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(217);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(218);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(217);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(221);
      if (lookahead != 0) ADVANCE(222);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(221);
      if (lookahead != 0) ADVANCE(222);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(208);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(196);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '.') ADVANCE(120);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(73);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 33:
      if (lookahead == ']') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == '}') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(223);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 47:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 48:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 49:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 50:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(209);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 51:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(90);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '#') ADVANCE(210);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(219);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '\'') ADVANCE(215);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(88);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(203);
      if (lookahead == ':') ADVANCE(105);
      if (lookahead == '<') ADVANCE(95);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(84);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(122);
      if (lookahead == 'I') ADVANCE(172);
      if (lookahead == 'N') ADVANCE(123);
      if (lookahead == 'T') ADVANCE(130);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(94);
      if (lookahead == '_') ADVANCE(86);
      if (lookahead == '`') ADVANCE(197);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'f') ADVANCE(176);
      if (lookahead == 'i') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(147);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 'w') ADVANCE(161);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(196);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '0') ADVANCE(203);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_function);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_if);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_else);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_while);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_for);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_switch);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(78);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(83);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_dots);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(75);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '|') ADVANCE(101);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(103);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_break);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_next);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_true);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_false);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_null);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_inf);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_nan);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(142);
      if (aux_sym_identifier_token1_character_set_5(lookahead)) ADVANCE(196);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      if (aux_sym_identifier_token1_character_set_6(lookahead)) ADVANCE(196);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(121);
      if (aux_sym_identifier_token1_character_set_7(lookahead)) ADVANCE(196);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(85);
      if (aux_sym_identifier_token1_character_set_7(lookahead)) ADVANCE(196);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(126);
      if (aux_sym_identifier_token1_character_set_8(lookahead)) ADVANCE(196);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(114);
      if (lookahead == 'U') ADVANCE(128);
      if (lookahead == 'a') ADVANCE(129);
      if (aux_sym_identifier_token1_character_set_9(lookahead)) ADVANCE(196);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(109);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(110);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(131);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(111);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(127);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N') ADVANCE(113);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R') ADVANCE(132);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S') ADVANCE(125);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U') ADVANCE(124);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(118);
      if (aux_sym_identifier_token1_character_set_5(lookahead)) ADVANCE(196);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(116);
      if (aux_sym_identifier_token1_character_set_5(lookahead)) ADVANCE(196);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(117);
      if (aux_sym_identifier_token1_character_set_5(lookahead)) ADVANCE(196);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(115);
      if (aux_sym_identifier_token1_character_set_5(lookahead)) ADVANCE(196);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(166);
      if (aux_sym_identifier_token1_character_set_10(lookahead)) ADVANCE(196);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(184);
      if (aux_sym_identifier_token1_character_set_10(lookahead)) ADVANCE(196);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(168);
      if (aux_sym_identifier_token1_character_set_10(lookahead)) ADVANCE(196);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(187);
      if (aux_sym_identifier_token1_character_set_10(lookahead)) ADVANCE(196);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(145);
      if (aux_sym_identifier_token1_character_set_10(lookahead)) ADVANCE(196);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(162);
      if (lookahead == 'i') ADVANCE(175);
      if (lookahead == 'r') ADVANCE(155);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(160);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(189);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(191);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(193);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(179);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(137);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(61);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(62);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(159);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(194);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(140);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(182);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(139);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(183);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(57);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(112);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'g') ADVANCE(154);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(66);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(164);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(138);
      if (lookahead == 'o') ADVANCE(171);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(177);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(169);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(188);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'k') ADVANCE(107);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(185);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(133);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(150);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(152);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'm') ADVANCE(178);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(158);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(144);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(55);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(190);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(180);
      if (lookahead == 'u') ADVANCE(173);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(174);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(170);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(153);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(64);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(148);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(135);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(136);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(141);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(149);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(108);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(63);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(143);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(163);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(151);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(156);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'w') ADVANCE(165);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(186);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(134);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      if (aux_sym_identifier_token1_character_set_11(lookahead)) ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '`') ADVANCE(200);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(205);
      if (lookahead == 'L') ADVANCE(201);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(205);
      if (lookahead == 'L') ADVANCE(201);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'L') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_i);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(57);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(214);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(213);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(214);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '#') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(217);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(218);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_special_token1);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(221);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%') ADVANCE(222);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(222);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(212);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(198);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(216);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(220);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(223);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(228);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 51, .external_lex_state = 1},
  [2] = {.lex_state = 51, .external_lex_state = 1},
  [3] = {.lex_state = 51, .external_lex_state = 1},
  [4] = {.lex_state = 51, .external_lex_state = 1},
  [5] = {.lex_state = 51, .external_lex_state = 1},
  [6] = {.lex_state = 51, .external_lex_state = 1},
  [7] = {.lex_state = 51, .external_lex_state = 1},
  [8] = {.lex_state = 51, .external_lex_state = 1},
  [9] = {.lex_state = 51, .external_lex_state = 1},
  [10] = {.lex_state = 51, .external_lex_state = 1},
  [11] = {.lex_state = 51, .external_lex_state = 1},
  [12] = {.lex_state = 51, .external_lex_state = 1},
  [13] = {.lex_state = 24, .external_lex_state = 1},
  [14] = {.lex_state = 51, .external_lex_state = 1},
  [15] = {.lex_state = 24, .external_lex_state = 1},
  [16] = {.lex_state = 51, .external_lex_state = 1},
  [17] = {.lex_state = 51, .external_lex_state = 1},
  [18] = {.lex_state = 51, .external_lex_state = 1},
  [19] = {.lex_state = 51, .external_lex_state = 1},
  [20] = {.lex_state = 51, .external_lex_state = 1},
  [21] = {.lex_state = 51, .external_lex_state = 1},
  [22] = {.lex_state = 51, .external_lex_state = 1},
  [23] = {.lex_state = 24, .external_lex_state = 1},
  [24] = {.lex_state = 51, .external_lex_state = 1},
  [25] = {.lex_state = 51, .external_lex_state = 1},
  [26] = {.lex_state = 24, .external_lex_state = 1},
  [27] = {.lex_state = 51, .external_lex_state = 1},
  [28] = {.lex_state = 24, .external_lex_state = 1},
  [29] = {.lex_state = 24, .external_lex_state = 1},
  [30] = {.lex_state = 51, .external_lex_state = 1},
  [31] = {.lex_state = 51, .external_lex_state = 1},
  [32] = {.lex_state = 24, .external_lex_state = 1},
  [33] = {.lex_state = 51, .external_lex_state = 1},
  [34] = {.lex_state = 24, .external_lex_state = 1},
  [35] = {.lex_state = 51, .external_lex_state = 1},
  [36] = {.lex_state = 51, .external_lex_state = 1},
  [37] = {.lex_state = 51, .external_lex_state = 1},
  [38] = {.lex_state = 24, .external_lex_state = 1},
  [39] = {.lex_state = 51, .external_lex_state = 1},
  [40] = {.lex_state = 51, .external_lex_state = 1},
  [41] = {.lex_state = 51, .external_lex_state = 1},
  [42] = {.lex_state = 51, .external_lex_state = 1},
  [43] = {.lex_state = 51, .external_lex_state = 1},
  [44] = {.lex_state = 51, .external_lex_state = 1},
  [45] = {.lex_state = 51, .external_lex_state = 1},
  [46] = {.lex_state = 51, .external_lex_state = 1},
  [47] = {.lex_state = 51, .external_lex_state = 1},
  [48] = {.lex_state = 51, .external_lex_state = 1},
  [49] = {.lex_state = 51, .external_lex_state = 1},
  [50] = {.lex_state = 24, .external_lex_state = 1},
  [51] = {.lex_state = 51, .external_lex_state = 1},
  [52] = {.lex_state = 24, .external_lex_state = 1},
  [53] = {.lex_state = 51, .external_lex_state = 1},
  [54] = {.lex_state = 51, .external_lex_state = 1},
  [55] = {.lex_state = 51, .external_lex_state = 1},
  [56] = {.lex_state = 51, .external_lex_state = 1},
  [57] = {.lex_state = 51, .external_lex_state = 1},
  [58] = {.lex_state = 51, .external_lex_state = 1},
  [59] = {.lex_state = 51, .external_lex_state = 1},
  [60] = {.lex_state = 51, .external_lex_state = 1},
  [61] = {.lex_state = 51, .external_lex_state = 1},
  [62] = {.lex_state = 51, .external_lex_state = 1},
  [63] = {.lex_state = 51, .external_lex_state = 1},
  [64] = {.lex_state = 51, .external_lex_state = 1},
  [65] = {.lex_state = 51, .external_lex_state = 1},
  [66] = {.lex_state = 51, .external_lex_state = 1},
  [67] = {.lex_state = 51, .external_lex_state = 1},
  [68] = {.lex_state = 51, .external_lex_state = 1},
  [69] = {.lex_state = 51, .external_lex_state = 1},
  [70] = {.lex_state = 51, .external_lex_state = 1},
  [71] = {.lex_state = 51, .external_lex_state = 1},
  [72] = {.lex_state = 51, .external_lex_state = 1},
  [73] = {.lex_state = 51, .external_lex_state = 1},
  [74] = {.lex_state = 51, .external_lex_state = 1},
  [75] = {.lex_state = 51, .external_lex_state = 1},
  [76] = {.lex_state = 51, .external_lex_state = 1},
  [77] = {.lex_state = 51, .external_lex_state = 1},
  [78] = {.lex_state = 51, .external_lex_state = 1},
  [79] = {.lex_state = 51, .external_lex_state = 1},
  [80] = {.lex_state = 51, .external_lex_state = 1},
  [81] = {.lex_state = 51, .external_lex_state = 1},
  [82] = {.lex_state = 51, .external_lex_state = 1},
  [83] = {.lex_state = 51, .external_lex_state = 1},
  [84] = {.lex_state = 51, .external_lex_state = 1},
  [85] = {.lex_state = 51, .external_lex_state = 1},
  [86] = {.lex_state = 51, .external_lex_state = 1},
  [87] = {.lex_state = 51, .external_lex_state = 1},
  [88] = {.lex_state = 51, .external_lex_state = 1},
  [89] = {.lex_state = 51, .external_lex_state = 1},
  [90] = {.lex_state = 51, .external_lex_state = 1},
  [91] = {.lex_state = 51, .external_lex_state = 1},
  [92] = {.lex_state = 51, .external_lex_state = 1},
  [93] = {.lex_state = 51, .external_lex_state = 1},
  [94] = {.lex_state = 51, .external_lex_state = 1},
  [95] = {.lex_state = 24, .external_lex_state = 1},
  [96] = {.lex_state = 51, .external_lex_state = 1},
  [97] = {.lex_state = 51, .external_lex_state = 1},
  [98] = {.lex_state = 51, .external_lex_state = 1},
  [99] = {.lex_state = 51, .external_lex_state = 1},
  [100] = {.lex_state = 51, .external_lex_state = 1},
  [101] = {.lex_state = 51, .external_lex_state = 1},
  [102] = {.lex_state = 51, .external_lex_state = 1},
  [103] = {.lex_state = 51, .external_lex_state = 1},
  [104] = {.lex_state = 51, .external_lex_state = 1},
  [105] = {.lex_state = 51, .external_lex_state = 1},
  [106] = {.lex_state = 51, .external_lex_state = 1},
  [107] = {.lex_state = 51, .external_lex_state = 1},
  [108] = {.lex_state = 51, .external_lex_state = 1},
  [109] = {.lex_state = 51, .external_lex_state = 1},
  [110] = {.lex_state = 51, .external_lex_state = 1},
  [111] = {.lex_state = 51, .external_lex_state = 1},
  [112] = {.lex_state = 51, .external_lex_state = 1},
  [113] = {.lex_state = 51, .external_lex_state = 1},
  [114] = {.lex_state = 51, .external_lex_state = 1},
  [115] = {.lex_state = 51, .external_lex_state = 1},
  [116] = {.lex_state = 51, .external_lex_state = 1},
  [117] = {.lex_state = 51, .external_lex_state = 1},
  [118] = {.lex_state = 51, .external_lex_state = 1},
  [119] = {.lex_state = 51, .external_lex_state = 1},
  [120] = {.lex_state = 51, .external_lex_state = 1},
  [121] = {.lex_state = 51, .external_lex_state = 1},
  [122] = {.lex_state = 51, .external_lex_state = 1},
  [123] = {.lex_state = 51, .external_lex_state = 1},
  [124] = {.lex_state = 51, .external_lex_state = 1},
  [125] = {.lex_state = 51, .external_lex_state = 1},
  [126] = {.lex_state = 51, .external_lex_state = 1},
  [127] = {.lex_state = 51, .external_lex_state = 1},
  [128] = {.lex_state = 51, .external_lex_state = 1},
  [129] = {.lex_state = 51, .external_lex_state = 1},
  [130] = {.lex_state = 51, .external_lex_state = 1},
  [131] = {.lex_state = 51, .external_lex_state = 1},
  [132] = {.lex_state = 51, .external_lex_state = 1},
  [133] = {.lex_state = 51, .external_lex_state = 1},
  [134] = {.lex_state = 51, .external_lex_state = 1},
  [135] = {.lex_state = 51, .external_lex_state = 1},
  [136] = {.lex_state = 51, .external_lex_state = 1},
  [137] = {.lex_state = 51, .external_lex_state = 1},
  [138] = {.lex_state = 51, .external_lex_state = 1},
  [139] = {.lex_state = 51, .external_lex_state = 1},
  [140] = {.lex_state = 51, .external_lex_state = 1},
  [141] = {.lex_state = 51, .external_lex_state = 1},
  [142] = {.lex_state = 51, .external_lex_state = 1},
  [143] = {.lex_state = 51, .external_lex_state = 1},
  [144] = {.lex_state = 51, .external_lex_state = 1},
  [145] = {.lex_state = 51, .external_lex_state = 1},
  [146] = {.lex_state = 51, .external_lex_state = 1},
  [147] = {.lex_state = 51, .external_lex_state = 1},
  [148] = {.lex_state = 51, .external_lex_state = 1},
  [149] = {.lex_state = 51, .external_lex_state = 1},
  [150] = {.lex_state = 51, .external_lex_state = 1},
  [151] = {.lex_state = 51, .external_lex_state = 1},
  [152] = {.lex_state = 51, .external_lex_state = 1},
  [153] = {.lex_state = 51, .external_lex_state = 1},
  [154] = {.lex_state = 51, .external_lex_state = 1},
  [155] = {.lex_state = 51, .external_lex_state = 1},
  [156] = {.lex_state = 51, .external_lex_state = 1},
  [157] = {.lex_state = 51, .external_lex_state = 1},
  [158] = {.lex_state = 51, .external_lex_state = 1},
  [159] = {.lex_state = 51, .external_lex_state = 1},
  [160] = {.lex_state = 51, .external_lex_state = 1},
  [161] = {.lex_state = 51, .external_lex_state = 1},
  [162] = {.lex_state = 51, .external_lex_state = 1},
  [163] = {.lex_state = 51, .external_lex_state = 1},
  [164] = {.lex_state = 51, .external_lex_state = 1},
  [165] = {.lex_state = 51, .external_lex_state = 1},
  [166] = {.lex_state = 51, .external_lex_state = 1},
  [167] = {.lex_state = 51, .external_lex_state = 1},
  [168] = {.lex_state = 51, .external_lex_state = 1},
  [169] = {.lex_state = 51, .external_lex_state = 1},
  [170] = {.lex_state = 51, .external_lex_state = 1},
  [171] = {.lex_state = 51, .external_lex_state = 1},
  [172] = {.lex_state = 51, .external_lex_state = 1},
  [173] = {.lex_state = 51, .external_lex_state = 1},
  [174] = {.lex_state = 51, .external_lex_state = 1},
  [175] = {.lex_state = 51, .external_lex_state = 1},
  [176] = {.lex_state = 51, .external_lex_state = 1},
  [177] = {.lex_state = 51, .external_lex_state = 1},
  [178] = {.lex_state = 51, .external_lex_state = 1},
  [179] = {.lex_state = 51, .external_lex_state = 1},
  [180] = {.lex_state = 51, .external_lex_state = 1},
  [181] = {.lex_state = 51, .external_lex_state = 1},
  [182] = {.lex_state = 51, .external_lex_state = 1},
  [183] = {.lex_state = 51, .external_lex_state = 1},
  [184] = {.lex_state = 51, .external_lex_state = 1},
  [185] = {.lex_state = 51, .external_lex_state = 1},
  [186] = {.lex_state = 51, .external_lex_state = 1},
  [187] = {.lex_state = 51, .external_lex_state = 1},
  [188] = {.lex_state = 51, .external_lex_state = 1},
  [189] = {.lex_state = 51, .external_lex_state = 1},
  [190] = {.lex_state = 51, .external_lex_state = 1},
  [191] = {.lex_state = 51, .external_lex_state = 1},
  [192] = {.lex_state = 51, .external_lex_state = 1},
  [193] = {.lex_state = 51, .external_lex_state = 1},
  [194] = {.lex_state = 51, .external_lex_state = 1},
  [195] = {.lex_state = 51, .external_lex_state = 1},
  [196] = {.lex_state = 51, .external_lex_state = 1},
  [197] = {.lex_state = 51, .external_lex_state = 1},
  [198] = {.lex_state = 51, .external_lex_state = 1},
  [199] = {.lex_state = 51, .external_lex_state = 1},
  [200] = {.lex_state = 51, .external_lex_state = 1},
  [201] = {.lex_state = 51, .external_lex_state = 1},
  [202] = {.lex_state = 51, .external_lex_state = 1},
  [203] = {.lex_state = 51, .external_lex_state = 1},
  [204] = {.lex_state = 51, .external_lex_state = 1},
  [205] = {.lex_state = 51, .external_lex_state = 1},
  [206] = {.lex_state = 51, .external_lex_state = 1},
  [207] = {.lex_state = 51, .external_lex_state = 1},
  [208] = {.lex_state = 51, .external_lex_state = 1},
  [209] = {.lex_state = 51, .external_lex_state = 1},
  [210] = {.lex_state = 51, .external_lex_state = 1},
  [211] = {.lex_state = 51, .external_lex_state = 1},
  [212] = {.lex_state = 51, .external_lex_state = 1},
  [213] = {.lex_state = 51, .external_lex_state = 1},
  [214] = {.lex_state = 51, .external_lex_state = 1},
  [215] = {.lex_state = 51, .external_lex_state = 1},
  [216] = {.lex_state = 51, .external_lex_state = 1},
  [217] = {.lex_state = 51, .external_lex_state = 1},
  [218] = {.lex_state = 51, .external_lex_state = 1},
  [219] = {.lex_state = 51, .external_lex_state = 1},
  [220] = {.lex_state = 51, .external_lex_state = 1},
  [221] = {.lex_state = 51, .external_lex_state = 1},
  [222] = {.lex_state = 51, .external_lex_state = 1},
  [223] = {.lex_state = 51, .external_lex_state = 1},
  [224] = {.lex_state = 51, .external_lex_state = 1},
  [225] = {.lex_state = 51, .external_lex_state = 1},
  [226] = {.lex_state = 51, .external_lex_state = 1},
  [227] = {.lex_state = 51, .external_lex_state = 1},
  [228] = {.lex_state = 51, .external_lex_state = 1},
  [229] = {.lex_state = 51, .external_lex_state = 1},
  [230] = {.lex_state = 51, .external_lex_state = 1},
  [231] = {.lex_state = 51, .external_lex_state = 1},
  [232] = {.lex_state = 51, .external_lex_state = 1},
  [233] = {.lex_state = 51, .external_lex_state = 1},
  [234] = {.lex_state = 51, .external_lex_state = 1},
  [235] = {.lex_state = 51, .external_lex_state = 1},
  [236] = {.lex_state = 51, .external_lex_state = 1},
  [237] = {.lex_state = 51, .external_lex_state = 1},
  [238] = {.lex_state = 51, .external_lex_state = 1},
  [239] = {.lex_state = 51, .external_lex_state = 1},
  [240] = {.lex_state = 51, .external_lex_state = 1},
  [241] = {.lex_state = 51, .external_lex_state = 1},
  [242] = {.lex_state = 51, .external_lex_state = 1},
  [243] = {.lex_state = 51, .external_lex_state = 1},
  [244] = {.lex_state = 51, .external_lex_state = 1},
  [245] = {.lex_state = 51, .external_lex_state = 1},
  [246] = {.lex_state = 51, .external_lex_state = 1},
  [247] = {.lex_state = 51, .external_lex_state = 1},
  [248] = {.lex_state = 51, .external_lex_state = 1},
  [249] = {.lex_state = 51, .external_lex_state = 1},
  [250] = {.lex_state = 51, .external_lex_state = 1},
  [251] = {.lex_state = 51, .external_lex_state = 1},
  [252] = {.lex_state = 51, .external_lex_state = 1},
  [253] = {.lex_state = 51, .external_lex_state = 1},
  [254] = {.lex_state = 51, .external_lex_state = 1},
  [255] = {.lex_state = 51, .external_lex_state = 1},
  [256] = {.lex_state = 51, .external_lex_state = 1},
  [257] = {.lex_state = 51, .external_lex_state = 1},
  [258] = {.lex_state = 51, .external_lex_state = 1},
  [259] = {.lex_state = 51, .external_lex_state = 1},
  [260] = {.lex_state = 51, .external_lex_state = 1},
  [261] = {.lex_state = 51, .external_lex_state = 1},
  [262] = {.lex_state = 51, .external_lex_state = 1},
  [263] = {.lex_state = 51, .external_lex_state = 1},
  [264] = {.lex_state = 51, .external_lex_state = 1},
  [265] = {.lex_state = 51, .external_lex_state = 1},
  [266] = {.lex_state = 51, .external_lex_state = 1},
  [267] = {.lex_state = 51, .external_lex_state = 1},
  [268] = {.lex_state = 51, .external_lex_state = 1},
  [269] = {.lex_state = 51, .external_lex_state = 1},
  [270] = {.lex_state = 51, .external_lex_state = 1},
  [271] = {.lex_state = 51, .external_lex_state = 1},
  [272] = {.lex_state = 51, .external_lex_state = 1},
  [273] = {.lex_state = 51, .external_lex_state = 1},
  [274] = {.lex_state = 51, .external_lex_state = 1},
  [275] = {.lex_state = 51, .external_lex_state = 1},
  [276] = {.lex_state = 51, .external_lex_state = 1},
  [277] = {.lex_state = 51, .external_lex_state = 1},
  [278] = {.lex_state = 51, .external_lex_state = 1},
  [279] = {.lex_state = 51, .external_lex_state = 1},
  [280] = {.lex_state = 51, .external_lex_state = 1},
  [281] = {.lex_state = 51, .external_lex_state = 1},
  [282] = {.lex_state = 51, .external_lex_state = 1},
  [283] = {.lex_state = 51, .external_lex_state = 1},
  [284] = {.lex_state = 51, .external_lex_state = 1},
  [285] = {.lex_state = 51, .external_lex_state = 1},
  [286] = {.lex_state = 51, .external_lex_state = 1},
  [287] = {.lex_state = 51, .external_lex_state = 1},
  [288] = {.lex_state = 51, .external_lex_state = 1},
  [289] = {.lex_state = 51, .external_lex_state = 1},
  [290] = {.lex_state = 51, .external_lex_state = 1},
  [291] = {.lex_state = 51, .external_lex_state = 1},
  [292] = {.lex_state = 51, .external_lex_state = 1},
  [293] = {.lex_state = 51, .external_lex_state = 1},
  [294] = {.lex_state = 51, .external_lex_state = 1},
  [295] = {.lex_state = 51, .external_lex_state = 1},
  [296] = {.lex_state = 47, .external_lex_state = 1},
  [297] = {.lex_state = 51, .external_lex_state = 1},
  [298] = {.lex_state = 51, .external_lex_state = 1},
  [299] = {.lex_state = 51, .external_lex_state = 1},
  [300] = {.lex_state = 47, .external_lex_state = 1},
  [301] = {.lex_state = 51, .external_lex_state = 1},
  [302] = {.lex_state = 51, .external_lex_state = 1},
  [303] = {.lex_state = 51, .external_lex_state = 1},
  [304] = {.lex_state = 51, .external_lex_state = 1},
  [305] = {.lex_state = 51, .external_lex_state = 1},
  [306] = {.lex_state = 51, .external_lex_state = 1},
  [307] = {.lex_state = 47, .external_lex_state = 1},
  [308] = {.lex_state = 47, .external_lex_state = 1},
  [309] = {.lex_state = 51, .external_lex_state = 1},
  [310] = {.lex_state = 51, .external_lex_state = 1},
  [311] = {.lex_state = 51, .external_lex_state = 1},
  [312] = {.lex_state = 21, .external_lex_state = 1},
  [313] = {.lex_state = 51, .external_lex_state = 1},
  [314] = {.lex_state = 51, .external_lex_state = 1},
  [315] = {.lex_state = 51, .external_lex_state = 1},
  [316] = {.lex_state = 51, .external_lex_state = 1},
  [317] = {.lex_state = 51, .external_lex_state = 1},
  [318] = {.lex_state = 51, .external_lex_state = 1},
  [319] = {.lex_state = 51, .external_lex_state = 1},
  [320] = {.lex_state = 51, .external_lex_state = 1},
  [321] = {.lex_state = 51, .external_lex_state = 1},
  [322] = {.lex_state = 51, .external_lex_state = 1},
  [323] = {.lex_state = 51, .external_lex_state = 1},
  [324] = {.lex_state = 51, .external_lex_state = 1},
  [325] = {.lex_state = 51, .external_lex_state = 1},
  [326] = {.lex_state = 51, .external_lex_state = 1},
  [327] = {.lex_state = 51, .external_lex_state = 1},
  [328] = {.lex_state = 51, .external_lex_state = 1},
  [329] = {.lex_state = 21, .external_lex_state = 1},
  [330] = {.lex_state = 51, .external_lex_state = 1},
  [331] = {.lex_state = 51, .external_lex_state = 1},
  [332] = {.lex_state = 21, .external_lex_state = 1},
  [333] = {.lex_state = 21, .external_lex_state = 1},
  [334] = {.lex_state = 51, .external_lex_state = 1},
  [335] = {.lex_state = 51, .external_lex_state = 1},
  [336] = {.lex_state = 51, .external_lex_state = 1},
  [337] = {.lex_state = 51, .external_lex_state = 1},
  [338] = {.lex_state = 51, .external_lex_state = 1},
  [339] = {.lex_state = 51, .external_lex_state = 1},
  [340] = {.lex_state = 51, .external_lex_state = 1},
  [341] = {.lex_state = 51, .external_lex_state = 1},
  [342] = {.lex_state = 51, .external_lex_state = 1},
  [343] = {.lex_state = 47, .external_lex_state = 1},
  [344] = {.lex_state = 51, .external_lex_state = 1},
  [345] = {.lex_state = 51, .external_lex_state = 1},
  [346] = {.lex_state = 51, .external_lex_state = 1},
  [347] = {.lex_state = 51, .external_lex_state = 1},
  [348] = {.lex_state = 51, .external_lex_state = 1},
  [349] = {.lex_state = 51, .external_lex_state = 1},
  [350] = {.lex_state = 51, .external_lex_state = 1},
  [351] = {.lex_state = 51, .external_lex_state = 1},
  [352] = {.lex_state = 51, .external_lex_state = 1},
  [353] = {.lex_state = 51, .external_lex_state = 1},
  [354] = {.lex_state = 51, .external_lex_state = 1},
  [355] = {.lex_state = 51, .external_lex_state = 1},
  [356] = {.lex_state = 51, .external_lex_state = 1},
  [357] = {.lex_state = 51, .external_lex_state = 1},
  [358] = {.lex_state = 51, .external_lex_state = 1},
  [359] = {.lex_state = 51, .external_lex_state = 1},
  [360] = {.lex_state = 51, .external_lex_state = 1},
  [361] = {.lex_state = 51, .external_lex_state = 1},
  [362] = {.lex_state = 51, .external_lex_state = 1},
  [363] = {.lex_state = 51, .external_lex_state = 1},
  [364] = {.lex_state = 51, .external_lex_state = 1},
  [365] = {.lex_state = 51, .external_lex_state = 1},
  [366] = {.lex_state = 51, .external_lex_state = 1},
  [367] = {.lex_state = 51, .external_lex_state = 1},
  [368] = {.lex_state = 51, .external_lex_state = 1},
  [369] = {.lex_state = 47, .external_lex_state = 1},
  [370] = {.lex_state = 51, .external_lex_state = 1},
  [371] = {.lex_state = 51, .external_lex_state = 1},
  [372] = {.lex_state = 47, .external_lex_state = 1},
  [373] = {.lex_state = 47, .external_lex_state = 1},
  [374] = {.lex_state = 51, .external_lex_state = 1},
  [375] = {.lex_state = 51, .external_lex_state = 1},
  [376] = {.lex_state = 51, .external_lex_state = 1},
  [377] = {.lex_state = 51, .external_lex_state = 1},
  [378] = {.lex_state = 51, .external_lex_state = 1},
  [379] = {.lex_state = 51, .external_lex_state = 1},
  [380] = {.lex_state = 51, .external_lex_state = 1},
  [381] = {.lex_state = 51, .external_lex_state = 1},
  [382] = {.lex_state = 51, .external_lex_state = 1},
  [383] = {.lex_state = 51, .external_lex_state = 1},
  [384] = {.lex_state = 51, .external_lex_state = 1},
  [385] = {.lex_state = 51, .external_lex_state = 1},
  [386] = {.lex_state = 51, .external_lex_state = 1},
  [387] = {.lex_state = 51, .external_lex_state = 1},
  [388] = {.lex_state = 51, .external_lex_state = 1},
  [389] = {.lex_state = 51, .external_lex_state = 1},
  [390] = {.lex_state = 51, .external_lex_state = 1},
  [391] = {.lex_state = 51, .external_lex_state = 1},
  [392] = {.lex_state = 51, .external_lex_state = 1},
  [393] = {.lex_state = 51, .external_lex_state = 1},
  [394] = {.lex_state = 51, .external_lex_state = 1},
  [395] = {.lex_state = 51, .external_lex_state = 1},
  [396] = {.lex_state = 51, .external_lex_state = 1},
  [397] = {.lex_state = 47, .external_lex_state = 1},
  [398] = {.lex_state = 47, .external_lex_state = 1},
  [399] = {.lex_state = 51, .external_lex_state = 1},
  [400] = {.lex_state = 51, .external_lex_state = 1},
  [401] = {.lex_state = 51, .external_lex_state = 1},
  [402] = {.lex_state = 21, .external_lex_state = 1},
  [403] = {.lex_state = 51, .external_lex_state = 1},
  [404] = {.lex_state = 48, .external_lex_state = 1},
  [405] = {.lex_state = 48, .external_lex_state = 1},
  [406] = {.lex_state = 48, .external_lex_state = 1},
  [407] = {.lex_state = 47, .external_lex_state = 1},
  [408] = {.lex_state = 21, .external_lex_state = 1},
  [409] = {.lex_state = 47, .external_lex_state = 1},
  [410] = {.lex_state = 51, .external_lex_state = 1},
  [411] = {.lex_state = 48, .external_lex_state = 1},
  [412] = {.lex_state = 23, .external_lex_state = 1},
  [413] = {.lex_state = 23, .external_lex_state = 1},
  [414] = {.lex_state = 23, .external_lex_state = 1},
  [415] = {.lex_state = 23, .external_lex_state = 1},
  [416] = {.lex_state = 47, .external_lex_state = 1},
  [417] = {.lex_state = 47, .external_lex_state = 1},
  [418] = {.lex_state = 47, .external_lex_state = 1},
  [419] = {.lex_state = 47, .external_lex_state = 1},
  [420] = {.lex_state = 47, .external_lex_state = 1},
  [421] = {.lex_state = 47, .external_lex_state = 1},
  [422] = {.lex_state = 47, .external_lex_state = 1},
  [423] = {.lex_state = 47, .external_lex_state = 1},
  [424] = {.lex_state = 47, .external_lex_state = 1},
  [425] = {.lex_state = 47, .external_lex_state = 1},
  [426] = {.lex_state = 47, .external_lex_state = 1},
  [427] = {.lex_state = 47, .external_lex_state = 1},
  [428] = {.lex_state = 47, .external_lex_state = 1},
  [429] = {.lex_state = 47, .external_lex_state = 1},
  [430] = {.lex_state = 47, .external_lex_state = 1},
  [431] = {.lex_state = 47, .external_lex_state = 1},
  [432] = {.lex_state = 47, .external_lex_state = 1},
  [433] = {.lex_state = 47, .external_lex_state = 1},
  [434] = {.lex_state = 48, .external_lex_state = 1},
  [435] = {.lex_state = 47, .external_lex_state = 1},
  [436] = {.lex_state = 47, .external_lex_state = 1},
  [437] = {.lex_state = 47, .external_lex_state = 1},
  [438] = {.lex_state = 47, .external_lex_state = 1},
  [439] = {.lex_state = 21, .external_lex_state = 1},
  [440] = {.lex_state = 21, .external_lex_state = 1},
  [441] = {.lex_state = 48, .external_lex_state = 1},
  [442] = {.lex_state = 21, .external_lex_state = 1},
  [443] = {.lex_state = 21, .external_lex_state = 1},
  [444] = {.lex_state = 21, .external_lex_state = 1},
  [445] = {.lex_state = 49, .external_lex_state = 1},
  [446] = {.lex_state = 21, .external_lex_state = 1},
  [447] = {.lex_state = 21, .external_lex_state = 1},
  [448] = {.lex_state = 21, .external_lex_state = 1},
  [449] = {.lex_state = 21, .external_lex_state = 1},
  [450] = {.lex_state = 47, .external_lex_state = 1},
  [451] = {.lex_state = 21, .external_lex_state = 1},
  [452] = {.lex_state = 47, .external_lex_state = 1},
  [453] = {.lex_state = 47, .external_lex_state = 1},
  [454] = {.lex_state = 47, .external_lex_state = 1},
  [455] = {.lex_state = 47, .external_lex_state = 1},
  [456] = {.lex_state = 21, .external_lex_state = 1},
  [457] = {.lex_state = 21, .external_lex_state = 1},
  [458] = {.lex_state = 21, .external_lex_state = 1},
  [459] = {.lex_state = 21, .external_lex_state = 1},
  [460] = {.lex_state = 21, .external_lex_state = 1},
  [461] = {.lex_state = 21, .external_lex_state = 1},
  [462] = {.lex_state = 21, .external_lex_state = 1},
  [463] = {.lex_state = 21, .external_lex_state = 1},
  [464] = {.lex_state = 21, .external_lex_state = 1},
  [465] = {.lex_state = 21, .external_lex_state = 1},
  [466] = {.lex_state = 47, .external_lex_state = 1},
  [467] = {.lex_state = 47, .external_lex_state = 1},
  [468] = {.lex_state = 47, .external_lex_state = 1},
  [469] = {.lex_state = 47, .external_lex_state = 1},
  [470] = {.lex_state = 47, .external_lex_state = 1},
  [471] = {.lex_state = 49, .external_lex_state = 1},
  [472] = {.lex_state = 47, .external_lex_state = 1},
  [473] = {.lex_state = 47, .external_lex_state = 1},
  [474] = {.lex_state = 47, .external_lex_state = 1},
  [475] = {.lex_state = 47, .external_lex_state = 1},
  [476] = {.lex_state = 47, .external_lex_state = 1},
  [477] = {.lex_state = 47, .external_lex_state = 1},
  [478] = {.lex_state = 47, .external_lex_state = 1},
  [479] = {.lex_state = 47, .external_lex_state = 1},
  [480] = {.lex_state = 47, .external_lex_state = 1},
  [481] = {.lex_state = 47, .external_lex_state = 1},
  [482] = {.lex_state = 47, .external_lex_state = 1},
  [483] = {.lex_state = 47, .external_lex_state = 1},
  [484] = {.lex_state = 47, .external_lex_state = 1},
  [485] = {.lex_state = 47, .external_lex_state = 1},
  [486] = {.lex_state = 47, .external_lex_state = 1},
  [487] = {.lex_state = 47, .external_lex_state = 1},
  [488] = {.lex_state = 21, .external_lex_state = 1},
  [489] = {.lex_state = 47, .external_lex_state = 1},
  [490] = {.lex_state = 47, .external_lex_state = 1},
  [491] = {.lex_state = 48, .external_lex_state = 1},
  [492] = {.lex_state = 47, .external_lex_state = 1},
  [493] = {.lex_state = 47, .external_lex_state = 1},
  [494] = {.lex_state = 48, .external_lex_state = 1},
  [495] = {.lex_state = 21, .external_lex_state = 1},
  [496] = {.lex_state = 21, .external_lex_state = 1},
  [497] = {.lex_state = 21, .external_lex_state = 1},
  [498] = {.lex_state = 21, .external_lex_state = 1},
  [499] = {.lex_state = 21, .external_lex_state = 1},
  [500] = {.lex_state = 0, .external_lex_state = 1},
  [501] = {.lex_state = 47, .external_lex_state = 1},
  [502] = {.lex_state = 21, .external_lex_state = 1},
  [503] = {.lex_state = 51, .external_lex_state = 1},
  [504] = {.lex_state = 51, .external_lex_state = 1},
  [505] = {.lex_state = 23, .external_lex_state = 1},
  [506] = {.lex_state = 51, .external_lex_state = 1},
  [507] = {.lex_state = 51, .external_lex_state = 1},
  [508] = {.lex_state = 47, .external_lex_state = 1},
  [509] = {.lex_state = 47, .external_lex_state = 1},
  [510] = {.lex_state = 47, .external_lex_state = 1},
  [511] = {.lex_state = 47, .external_lex_state = 1},
  [512] = {.lex_state = 47, .external_lex_state = 1},
  [513] = {.lex_state = 23, .external_lex_state = 1},
  [514] = {.lex_state = 48, .external_lex_state = 1},
  [515] = {.lex_state = 47, .external_lex_state = 1},
  [516] = {.lex_state = 48, .external_lex_state = 1},
  [517] = {.lex_state = 48, .external_lex_state = 1},
  [518] = {.lex_state = 47, .external_lex_state = 1},
  [519] = {.lex_state = 47, .external_lex_state = 1},
  [520] = {.lex_state = 24, .external_lex_state = 1},
  [521] = {.lex_state = 51, .external_lex_state = 1},
  [522] = {.lex_state = 21, .external_lex_state = 1},
  [523] = {.lex_state = 51, .external_lex_state = 1},
  [524] = {.lex_state = 51, .external_lex_state = 1},
  [525] = {.lex_state = 51, .external_lex_state = 1},
  [526] = {.lex_state = 48, .external_lex_state = 1},
  [527] = {.lex_state = 48, .external_lex_state = 1},
  [528] = {.lex_state = 21, .external_lex_state = 1},
  [529] = {.lex_state = 48, .external_lex_state = 1},
  [530] = {.lex_state = 51, .external_lex_state = 1},
  [531] = {.lex_state = 48, .external_lex_state = 1},
  [532] = {.lex_state = 48, .external_lex_state = 1},
  [533] = {.lex_state = 48, .external_lex_state = 1},
  [534] = {.lex_state = 21, .external_lex_state = 1},
  [535] = {.lex_state = 51, .external_lex_state = 1},
  [536] = {.lex_state = 21, .external_lex_state = 1},
  [537] = {.lex_state = 51, .external_lex_state = 1},
  [538] = {.lex_state = 51, .external_lex_state = 1},
  [539] = {.lex_state = 47, .external_lex_state = 1},
  [540] = {.lex_state = 51, .external_lex_state = 1},
  [541] = {.lex_state = 48, .external_lex_state = 1},
  [542] = {.lex_state = 21, .external_lex_state = 1},
  [543] = {.lex_state = 21, .external_lex_state = 1},
  [544] = {.lex_state = 48, .external_lex_state = 1},
  [545] = {.lex_state = 48, .external_lex_state = 1},
  [546] = {.lex_state = 51, .external_lex_state = 1},
  [547] = {.lex_state = 48, .external_lex_state = 1},
  [548] = {.lex_state = 51, .external_lex_state = 1},
  [549] = {.lex_state = 51, .external_lex_state = 1},
  [550] = {.lex_state = 48, .external_lex_state = 1},
  [551] = {.lex_state = 48, .external_lex_state = 1},
  [552] = {.lex_state = 51, .external_lex_state = 1},
  [553] = {.lex_state = 51, .external_lex_state = 1},
  [554] = {.lex_state = 48, .external_lex_state = 1},
  [555] = {.lex_state = 48, .external_lex_state = 1},
  [556] = {.lex_state = 48, .external_lex_state = 1},
  [557] = {.lex_state = 48, .external_lex_state = 1},
  [558] = {.lex_state = 48, .external_lex_state = 1},
  [559] = {.lex_state = 48, .external_lex_state = 1},
  [560] = {.lex_state = 51, .external_lex_state = 1},
  [561] = {.lex_state = 51, .external_lex_state = 1},
  [562] = {.lex_state = 47, .external_lex_state = 1},
  [563] = {.lex_state = 51, .external_lex_state = 1},
  [564] = {.lex_state = 47, .external_lex_state = 1},
  [565] = {.lex_state = 47, .external_lex_state = 1},
  [566] = {.lex_state = 21, .external_lex_state = 1},
  [567] = {.lex_state = 21, .external_lex_state = 1},
  [568] = {.lex_state = 47, .external_lex_state = 1},
  [569] = {.lex_state = 21, .external_lex_state = 1},
  [570] = {.lex_state = 21, .external_lex_state = 1},
  [571] = {.lex_state = 48, .external_lex_state = 1},
  [572] = {.lex_state = 48, .external_lex_state = 1},
  [573] = {.lex_state = 48, .external_lex_state = 1},
  [574] = {.lex_state = 51, .external_lex_state = 1},
  [575] = {.lex_state = 48, .external_lex_state = 1},
  [576] = {.lex_state = 51, .external_lex_state = 1},
  [577] = {.lex_state = 21, .external_lex_state = 1},
  [578] = {.lex_state = 21, .external_lex_state = 1},
  [579] = {.lex_state = 21, .external_lex_state = 1},
  [580] = {.lex_state = 21, .external_lex_state = 1},
  [581] = {.lex_state = 47, .external_lex_state = 1},
  [582] = {.lex_state = 21, .external_lex_state = 1},
  [583] = {.lex_state = 47, .external_lex_state = 1},
  [584] = {.lex_state = 48, .external_lex_state = 1},
  [585] = {.lex_state = 47, .external_lex_state = 1},
  [586] = {.lex_state = 47, .external_lex_state = 1},
  [587] = {.lex_state = 51, .external_lex_state = 1},
  [588] = {.lex_state = 51, .external_lex_state = 1},
  [589] = {.lex_state = 48, .external_lex_state = 1},
  [590] = {.lex_state = 48, .external_lex_state = 1},
  [591] = {.lex_state = 51, .external_lex_state = 1},
  [592] = {.lex_state = 21, .external_lex_state = 1},
  [593] = {.lex_state = 21, .external_lex_state = 1},
  [594] = {.lex_state = 50, .external_lex_state = 1},
  [595] = {.lex_state = 21, .external_lex_state = 1},
  [596] = {.lex_state = 23, .external_lex_state = 1},
  [597] = {.lex_state = 21, .external_lex_state = 1},
  [598] = {.lex_state = 48, .external_lex_state = 1},
  [599] = {.lex_state = 21, .external_lex_state = 1},
  [600] = {.lex_state = 48, .external_lex_state = 1},
  [601] = {.lex_state = 48, .external_lex_state = 1},
  [602] = {.lex_state = 21, .external_lex_state = 1},
  [603] = {.lex_state = 21, .external_lex_state = 1},
  [604] = {.lex_state = 48, .external_lex_state = 1},
  [605] = {.lex_state = 48, .external_lex_state = 1},
  [606] = {.lex_state = 47, .external_lex_state = 1},
  [607] = {.lex_state = 47, .external_lex_state = 1},
  [608] = {.lex_state = 48, .external_lex_state = 1},
  [609] = {.lex_state = 48, .external_lex_state = 1},
  [610] = {.lex_state = 48, .external_lex_state = 1},
  [611] = {.lex_state = 47, .external_lex_state = 1},
  [612] = {.lex_state = 48, .external_lex_state = 1},
  [613] = {.lex_state = 47, .external_lex_state = 1},
  [614] = {.lex_state = 48, .external_lex_state = 1},
  [615] = {.lex_state = 48, .external_lex_state = 1},
  [616] = {.lex_state = 48, .external_lex_state = 1},
  [617] = {.lex_state = 23, .external_lex_state = 1},
  [618] = {.lex_state = 48, .external_lex_state = 1},
  [619] = {.lex_state = 47, .external_lex_state = 1},
  [620] = {.lex_state = 47, .external_lex_state = 1},
  [621] = {.lex_state = 48, .external_lex_state = 1},
  [622] = {.lex_state = 22, .external_lex_state = 1},
  [623] = {.lex_state = 47, .external_lex_state = 1},
  [624] = {.lex_state = 47, .external_lex_state = 1},
  [625] = {.lex_state = 47, .external_lex_state = 1},
  [626] = {.lex_state = 47, .external_lex_state = 1},
  [627] = {.lex_state = 47, .external_lex_state = 1},
  [628] = {.lex_state = 48, .external_lex_state = 1},
  [629] = {.lex_state = 48, .external_lex_state = 1},
  [630] = {.lex_state = 48, .external_lex_state = 1},
  [631] = {.lex_state = 48, .external_lex_state = 1},
  [632] = {.lex_state = 48, .external_lex_state = 1},
  [633] = {.lex_state = 48, .external_lex_state = 1},
  [634] = {.lex_state = 47, .external_lex_state = 1},
  [635] = {.lex_state = 47, .external_lex_state = 1},
  [636] = {.lex_state = 47, .external_lex_state = 1},
  [637] = {.lex_state = 47, .external_lex_state = 1},
  [638] = {.lex_state = 47, .external_lex_state = 1},
  [639] = {.lex_state = 48, .external_lex_state = 1},
  [640] = {.lex_state = 51, .external_lex_state = 1},
  [641] = {.lex_state = 51, .external_lex_state = 1},
  [642] = {.lex_state = 23, .external_lex_state = 1},
  [643] = {.lex_state = 47, .external_lex_state = 1},
  [644] = {.lex_state = 47, .external_lex_state = 1},
  [645] = {.lex_state = 23, .external_lex_state = 1},
  [646] = {.lex_state = 23, .external_lex_state = 1},
  [647] = {.lex_state = 23, .external_lex_state = 1},
  [648] = {.lex_state = 51, .external_lex_state = 1},
  [649] = {.lex_state = 47, .external_lex_state = 1},
  [650] = {.lex_state = 47, .external_lex_state = 1},
  [651] = {.lex_state = 47, .external_lex_state = 1},
  [652] = {.lex_state = 47, .external_lex_state = 1},
  [653] = {.lex_state = 47, .external_lex_state = 1},
  [654] = {.lex_state = 47, .external_lex_state = 1},
  [655] = {.lex_state = 47, .external_lex_state = 1},
  [656] = {.lex_state = 47, .external_lex_state = 1},
  [657] = {.lex_state = 47, .external_lex_state = 1},
  [658] = {.lex_state = 48, .external_lex_state = 1},
  [659] = {.lex_state = 48, .external_lex_state = 1},
  [660] = {.lex_state = 23, .external_lex_state = 1},
  [661] = {.lex_state = 23, .external_lex_state = 1},
  [662] = {.lex_state = 24, .external_lex_state = 1},
  [663] = {.lex_state = 23, .external_lex_state = 1},
  [664] = {.lex_state = 24, .external_lex_state = 1},
  [665] = {.lex_state = 23, .external_lex_state = 1},
  [666] = {.lex_state = 23, .external_lex_state = 1},
  [667] = {.lex_state = 23, .external_lex_state = 1},
  [668] = {.lex_state = 23, .external_lex_state = 1},
  [669] = {.lex_state = 23, .external_lex_state = 1},
  [670] = {.lex_state = 23, .external_lex_state = 1},
  [671] = {.lex_state = 48, .external_lex_state = 1},
  [672] = {.lex_state = 24, .external_lex_state = 1},
  [673] = {.lex_state = 23, .external_lex_state = 1},
  [674] = {.lex_state = 23, .external_lex_state = 1},
  [675] = {.lex_state = 50, .external_lex_state = 1},
  [676] = {.lex_state = 23, .external_lex_state = 1},
  [677] = {.lex_state = 23, .external_lex_state = 1},
  [678] = {.lex_state = 48, .external_lex_state = 1},
  [679] = {.lex_state = 24, .external_lex_state = 1},
  [680] = {.lex_state = 23, .external_lex_state = 1},
  [681] = {.lex_state = 23, .external_lex_state = 1},
  [682] = {.lex_state = 47, .external_lex_state = 1},
  [683] = {.lex_state = 23, .external_lex_state = 1},
  [684] = {.lex_state = 48, .external_lex_state = 1},
  [685] = {.lex_state = 23, .external_lex_state = 1},
  [686] = {.lex_state = 23, .external_lex_state = 1},
  [687] = {.lex_state = 25, .external_lex_state = 1},
  [688] = {.lex_state = 23, .external_lex_state = 1},
  [689] = {.lex_state = 23, .external_lex_state = 1},
  [690] = {.lex_state = 48, .external_lex_state = 1},
  [691] = {.lex_state = 48, .external_lex_state = 1},
  [692] = {.lex_state = 24, .external_lex_state = 1},
  [693] = {.lex_state = 48, .external_lex_state = 1},
  [694] = {.lex_state = 48, .external_lex_state = 1},
  [695] = {.lex_state = 24, .external_lex_state = 1},
  [696] = {.lex_state = 24, .external_lex_state = 1},
  [697] = {.lex_state = 24, .external_lex_state = 1},
  [698] = {.lex_state = 51, .external_lex_state = 1},
  [699] = {.lex_state = 51, .external_lex_state = 1},
  [700] = {.lex_state = 51, .external_lex_state = 1},
  [701] = {.lex_state = 24, .external_lex_state = 1},
  [702] = {.lex_state = 24, .external_lex_state = 1},
  [703] = {.lex_state = 48, .external_lex_state = 1},
  [704] = {.lex_state = 51, .external_lex_state = 1},
  [705] = {.lex_state = 24, .external_lex_state = 1},
  [706] = {.lex_state = 51, .external_lex_state = 1},
  [707] = {.lex_state = 51, .external_lex_state = 1},
  [708] = {.lex_state = 24, .external_lex_state = 1},
  [709] = {.lex_state = 24, .external_lex_state = 1},
  [710] = {.lex_state = 48, .external_lex_state = 1},
  [711] = {.lex_state = 48, .external_lex_state = 1},
  [712] = {.lex_state = 48, .external_lex_state = 1},
  [713] = {.lex_state = 48, .external_lex_state = 1},
  [714] = {.lex_state = 48, .external_lex_state = 1},
  [715] = {.lex_state = 24, .external_lex_state = 1},
  [716] = {.lex_state = 24, .external_lex_state = 1},
  [717] = {.lex_state = 51, .external_lex_state = 1},
  [718] = {.lex_state = 51, .external_lex_state = 1},
  [719] = {.lex_state = 51, .external_lex_state = 1},
  [720] = {.lex_state = 51, .external_lex_state = 1},
  [721] = {.lex_state = 24, .external_lex_state = 1},
  [722] = {.lex_state = 51, .external_lex_state = 1},
  [723] = {.lex_state = 24, .external_lex_state = 1},
  [724] = {.lex_state = 48, .external_lex_state = 1},
  [725] = {.lex_state = 48, .external_lex_state = 1},
  [726] = {.lex_state = 48, .external_lex_state = 1},
  [727] = {.lex_state = 23, .external_lex_state = 1},
  [728] = {.lex_state = 23, .external_lex_state = 1},
  [729] = {.lex_state = 48, .external_lex_state = 1},
  [730] = {.lex_state = 48, .external_lex_state = 1},
  [731] = {.lex_state = 23, .external_lex_state = 1},
  [732] = {.lex_state = 23, .external_lex_state = 1},
  [733] = {.lex_state = 48, .external_lex_state = 1},
  [734] = {.lex_state = 23, .external_lex_state = 1},
  [735] = {.lex_state = 23, .external_lex_state = 1},
  [736] = {.lex_state = 23, .external_lex_state = 1},
  [737] = {.lex_state = 23, .external_lex_state = 1},
  [738] = {.lex_state = 48, .external_lex_state = 1},
  [739] = {.lex_state = 23, .external_lex_state = 1},
  [740] = {.lex_state = 23, .external_lex_state = 1},
  [741] = {.lex_state = 48, .external_lex_state = 1},
  [742] = {.lex_state = 51, .external_lex_state = 1},
  [743] = {.lex_state = 23, .external_lex_state = 1},
  [744] = {.lex_state = 23, .external_lex_state = 1},
  [745] = {.lex_state = 23, .external_lex_state = 1},
  [746] = {.lex_state = 23, .external_lex_state = 1},
  [747] = {.lex_state = 23, .external_lex_state = 1},
  [748] = {.lex_state = 51, .external_lex_state = 1},
  [749] = {.lex_state = 24, .external_lex_state = 1},
  [750] = {.lex_state = 24, .external_lex_state = 1},
  [751] = {.lex_state = 51, .external_lex_state = 1},
  [752] = {.lex_state = 24, .external_lex_state = 1},
  [753] = {.lex_state = 24, .external_lex_state = 1},
  [754] = {.lex_state = 26, .external_lex_state = 1},
  [755] = {.lex_state = 24, .external_lex_state = 1},
  [756] = {.lex_state = 51, .external_lex_state = 1},
  [757] = {.lex_state = 23, .external_lex_state = 1},
  [758] = {.lex_state = 23, .external_lex_state = 1},
  [759] = {.lex_state = 23, .external_lex_state = 1},
  [760] = {.lex_state = 23, .external_lex_state = 1},
  [761] = {.lex_state = 23, .external_lex_state = 1},
  [762] = {.lex_state = 48, .external_lex_state = 1},
  [763] = {.lex_state = 23, .external_lex_state = 1},
  [764] = {.lex_state = 23, .external_lex_state = 1},
  [765] = {.lex_state = 23, .external_lex_state = 1},
  [766] = {.lex_state = 48, .external_lex_state = 1},
  [767] = {.lex_state = 48, .external_lex_state = 1},
  [768] = {.lex_state = 24, .external_lex_state = 1},
  [769] = {.lex_state = 48, .external_lex_state = 1},
  [770] = {.lex_state = 48, .external_lex_state = 1},
  [771] = {.lex_state = 48, .external_lex_state = 1},
  [772] = {.lex_state = 24, .external_lex_state = 1},
  [773] = {.lex_state = 48, .external_lex_state = 1},
  [774] = {.lex_state = 48, .external_lex_state = 1},
  [775] = {.lex_state = 48, .external_lex_state = 1},
  [776] = {.lex_state = 51, .external_lex_state = 1},
  [777] = {.lex_state = 24, .external_lex_state = 1},
  [778] = {.lex_state = 24, .external_lex_state = 1},
  [779] = {.lex_state = 24, .external_lex_state = 1},
  [780] = {.lex_state = 48, .external_lex_state = 1},
  [781] = {.lex_state = 51, .external_lex_state = 1},
  [782] = {.lex_state = 24, .external_lex_state = 1},
  [783] = {.lex_state = 24, .external_lex_state = 1},
  [784] = {.lex_state = 51, .external_lex_state = 1},
  [785] = {.lex_state = 48, .external_lex_state = 1},
  [786] = {.lex_state = 51, .external_lex_state = 1},
  [787] = {.lex_state = 51, .external_lex_state = 1},
  [788] = {.lex_state = 51, .external_lex_state = 1},
  [789] = {.lex_state = 51, .external_lex_state = 1},
  [790] = {.lex_state = 48, .external_lex_state = 1},
  [791] = {.lex_state = 48, .external_lex_state = 1},
  [792] = {.lex_state = 48, .external_lex_state = 1},
  [793] = {.lex_state = 24, .external_lex_state = 1},
  [794] = {.lex_state = 48, .external_lex_state = 1},
  [795] = {.lex_state = 24, .external_lex_state = 1},
  [796] = {.lex_state = 48, .external_lex_state = 1},
  [797] = {.lex_state = 48, .external_lex_state = 1},
  [798] = {.lex_state = 48, .external_lex_state = 1},
  [799] = {.lex_state = 24, .external_lex_state = 1},
  [800] = {.lex_state = 51, .external_lex_state = 1},
  [801] = {.lex_state = 48, .external_lex_state = 1},
  [802] = {.lex_state = 48, .external_lex_state = 1},
  [803] = {.lex_state = 48, .external_lex_state = 1},
  [804] = {.lex_state = 48, .external_lex_state = 1},
  [805] = {.lex_state = 48, .external_lex_state = 1},
  [806] = {.lex_state = 51, .external_lex_state = 1},
  [807] = {.lex_state = 48, .external_lex_state = 1},
  [808] = {.lex_state = 51, .external_lex_state = 1},
  [809] = {.lex_state = 48, .external_lex_state = 1},
  [810] = {.lex_state = 51, .external_lex_state = 1},
  [811] = {.lex_state = 48, .external_lex_state = 1},
  [812] = {.lex_state = 48, .external_lex_state = 1},
  [813] = {.lex_state = 48, .external_lex_state = 1},
  [814] = {.lex_state = 51, .external_lex_state = 1},
  [815] = {.lex_state = 24, .external_lex_state = 1},
  [816] = {.lex_state = 24, .external_lex_state = 1},
  [817] = {.lex_state = 24, .external_lex_state = 1},
  [818] = {.lex_state = 24, .external_lex_state = 1},
  [819] = {.lex_state = 24, .external_lex_state = 1},
  [820] = {.lex_state = 24, .external_lex_state = 1},
  [821] = {.lex_state = 24, .external_lex_state = 1},
  [822] = {.lex_state = 24, .external_lex_state = 1},
  [823] = {.lex_state = 24, .external_lex_state = 1},
  [824] = {.lex_state = 24, .external_lex_state = 1},
  [825] = {.lex_state = 24, .external_lex_state = 1},
  [826] = {.lex_state = 24, .external_lex_state = 1},
  [827] = {.lex_state = 24, .external_lex_state = 1},
  [828] = {.lex_state = 24, .external_lex_state = 1},
  [829] = {.lex_state = 24, .external_lex_state = 1},
  [830] = {.lex_state = 24, .external_lex_state = 1},
  [831] = {.lex_state = 24, .external_lex_state = 1},
  [832] = {.lex_state = 24, .external_lex_state = 1},
  [833] = {.lex_state = 24, .external_lex_state = 1},
  [834] = {.lex_state = 24, .external_lex_state = 1},
  [835] = {.lex_state = 24, .external_lex_state = 1},
  [836] = {.lex_state = 24, .external_lex_state = 1},
  [837] = {.lex_state = 24, .external_lex_state = 1},
  [838] = {.lex_state = 24, .external_lex_state = 1},
  [839] = {.lex_state = 27},
  [840] = {.lex_state = 27},
  [841] = {.lex_state = 27},
  [842] = {.lex_state = 51, .external_lex_state = 1},
  [843] = {.lex_state = 51, .external_lex_state = 1},
  [844] = {.lex_state = 51, .external_lex_state = 1},
  [845] = {.lex_state = 27},
  [846] = {.lex_state = 27},
  [847] = {.lex_state = 27},
  [848] = {.lex_state = 27},
  [849] = {.lex_state = 27},
  [850] = {.lex_state = 27},
  [851] = {.lex_state = 27},
  [852] = {.lex_state = 27},
  [853] = {.lex_state = 27},
  [854] = {.lex_state = 27},
  [855] = {.lex_state = 27},
  [856] = {.lex_state = 27},
  [857] = {.lex_state = 27},
  [858] = {.lex_state = 27},
  [859] = {.lex_state = 27},
  [860] = {.lex_state = 27},
  [861] = {.lex_state = 27},
  [862] = {.lex_state = 27},
  [863] = {.lex_state = 27},
  [864] = {.lex_state = 51, .external_lex_state = 1},
  [865] = {.lex_state = 27},
  [866] = {.lex_state = 27},
  [867] = {.lex_state = 27},
  [868] = {.lex_state = 27},
  [869] = {.lex_state = 27},
  [870] = {.lex_state = 51, .external_lex_state = 1},
  [871] = {.lex_state = 27},
  [872] = {.lex_state = 27},
  [873] = {.lex_state = 27},
  [874] = {.lex_state = 28},
  [875] = {.lex_state = 27},
  [876] = {.lex_state = 27},
  [877] = {.lex_state = 27},
  [878] = {.lex_state = 27},
  [879] = {.lex_state = 27},
  [880] = {.lex_state = 27},
  [881] = {.lex_state = 51, .external_lex_state = 1},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 51, .external_lex_state = 1},
  [884] = {.lex_state = 51, .external_lex_state = 1},
  [885] = {.lex_state = 27},
  [886] = {.lex_state = 27},
  [887] = {.lex_state = 27},
  [888] = {.lex_state = 27},
  [889] = {.lex_state = 27},
  [890] = {.lex_state = 27},
  [891] = {.lex_state = 27},
  [892] = {.lex_state = 27},
  [893] = {.lex_state = 27},
  [894] = {.lex_state = 27},
  [895] = {.lex_state = 27},
  [896] = {.lex_state = 51, .external_lex_state = 1},
  [897] = {.lex_state = 51, .external_lex_state = 1},
  [898] = {.lex_state = 27},
  [899] = {.lex_state = 51, .external_lex_state = 1},
  [900] = {.lex_state = 27},
  [901] = {.lex_state = 27},
  [902] = {.lex_state = 27},
  [903] = {.lex_state = 27},
  [904] = {.lex_state = 27},
  [905] = {.lex_state = 27},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 29, .external_lex_state = 1},
  [952] = {.lex_state = 30},
  [953] = {.lex_state = 29, .external_lex_state = 1},
  [954] = {.lex_state = 29, .external_lex_state = 1},
  [955] = {.lex_state = 29, .external_lex_state = 1},
  [956] = {.lex_state = 29, .external_lex_state = 1},
  [957] = {.lex_state = 29, .external_lex_state = 1},
  [958] = {.lex_state = 29, .external_lex_state = 1},
  [959] = {.lex_state = 30},
  [960] = {.lex_state = 29, .external_lex_state = 1},
  [961] = {.lex_state = 30},
  [962] = {.lex_state = 29, .external_lex_state = 1},
  [963] = {.lex_state = 30},
  [964] = {.lex_state = 13},
  [965] = {.lex_state = 16},
  [966] = {.lex_state = 13},
  [967] = {.lex_state = 18},
  [968] = {.lex_state = 13},
  [969] = {.lex_state = 18},
  [970] = {.lex_state = 16},
  [971] = {.lex_state = 13},
  [972] = {.lex_state = 18},
  [973] = {.lex_state = 16},
  [974] = {.lex_state = 18},
  [975] = {.lex_state = 18},
  [976] = {.lex_state = 16},
  [977] = {.lex_state = 18},
  [978] = {.lex_state = 13},
  [979] = {.lex_state = 16},
  [980] = {.lex_state = 16},
  [981] = {.lex_state = 18},
  [982] = {.lex_state = 13},
  [983] = {.lex_state = 16},
  [984] = {.lex_state = 13},
  [985] = {.lex_state = 18},
  [986] = {.lex_state = 16},
  [987] = {.lex_state = 16},
  [988] = {.lex_state = 13},
  [989] = {.lex_state = 18},
  [990] = {.lex_state = 13},
  [991] = {.lex_state = 18},
  [992] = {.lex_state = 16},
  [993] = {.lex_state = 16},
  [994] = {.lex_state = 20},
  [995] = {.lex_state = 18},
  [996] = {.lex_state = 13},
  [997] = {.lex_state = 16},
  [998] = {.lex_state = 20},
  [999] = {.lex_state = 18},
  [1000] = {.lex_state = 13},
  [1001] = {.lex_state = 16},
  [1002] = {.lex_state = 13},
  [1003] = {.lex_state = 18},
  [1004] = {.lex_state = 13},
  [1005] = {.lex_state = 16},
  [1006] = {.lex_state = 16},
  [1007] = {.lex_state = 13},
  [1008] = {.lex_state = 18},
  [1009] = {.lex_state = 18},
  [1010] = {.lex_state = 13},
  [1011] = {.lex_state = 16},
  [1012] = {.lex_state = 20},
  [1013] = {.lex_state = 18},
  [1014] = {.lex_state = 18},
  [1015] = {.lex_state = 13},
  [1016] = {.lex_state = 16},
  [1017] = {.lex_state = 13},
  [1018] = {.lex_state = 18},
  [1019] = {.lex_state = 13},
  [1020] = {.lex_state = 16},
  [1021] = {.lex_state = 16},
  [1022] = {.lex_state = 13},
  [1023] = {.lex_state = 18},
  [1024] = {.lex_state = 29},
  [1025] = {.lex_state = 29},
  [1026] = {.lex_state = 29},
  [1027] = {.lex_state = 29},
  [1028] = {.lex_state = 29},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 29},
  [1032] = {.lex_state = 29},
  [1033] = {.lex_state = 29},
  [1034] = {.lex_state = 29},
  [1035] = {.lex_state = 29},
  [1036] = {.lex_state = 29},
  [1037] = {.lex_state = 29},
  [1038] = {.lex_state = 29},
  [1039] = {.lex_state = 29},
  [1040] = {.lex_state = 29},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 29},
  [1043] = {.lex_state = 29},
  [1044] = {.lex_state = 29},
  [1045] = {.lex_state = 29},
  [1046] = {.lex_state = 29},
  [1047] = {.lex_state = 29},
  [1048] = {.lex_state = 29},
  [1049] = {.lex_state = 29},
  [1050] = {.lex_state = 29},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 29},
  [1053] = {.lex_state = 29},
  [1054] = {.lex_state = 29},
  [1055] = {.lex_state = 29},
  [1056] = {.lex_state = 29},
  [1057] = {.lex_state = 29},
  [1058] = {.lex_state = 29},
  [1059] = {.lex_state = 29},
  [1060] = {.lex_state = 29},
  [1061] = {.lex_state = 29},
  [1062] = {.lex_state = 29},
  [1063] = {.lex_state = 29},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 24},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 24},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 27},
  [1105] = {.lex_state = 24},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 27},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 27},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 27},
  [1117] = {.lex_state = 24},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 27},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 27},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 24},
  [1128] = {.lex_state = 27},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 27},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 24},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 24},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 27},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 24},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 24},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
};

enum {
  ts_external_token__raw_string_literal = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__raw_string_literal] = sym__raw_string_literal,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__raw_string_literal] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym__raw_string_literal] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1085),
    [sym_function_definition] = STATE(659),
    [sym_lambda_function] = STATE(659),
    [sym_if] = STATE(659),
    [sym_while] = STATE(659),
    [sym_repeat] = STATE(659),
    [sym_for] = STATE(659),
    [sym_switch] = STATE(659),
    [sym_call] = STATE(659),
    [sym__assignment] = STATE(659),
    [sym_left_assignment] = STATE(659),
    [sym_left_assignment2] = STATE(659),
    [sym_equals_assignment] = STATE(659),
    [sym_super_assignment] = STATE(659),
    [sym_super_right_assignment] = STATE(659),
    [sym_right_assignment] = STATE(659),
    [sym_brace_list] = STATE(659),
    [sym_paren_list] = STATE(659),
    [sym_subset] = STATE(659),
    [sym_subset2] = STATE(659),
    [sym_dollar] = STATE(659),
    [sym_slot] = STATE(659),
    [sym_namespace_get] = STATE(659),
    [sym_namespace_get_internal] = STATE(659),
    [sym_help] = STATE(659),
    [sym_pipe] = STATE(659),
    [sym_unary] = STATE(659),
    [sym_binary] = STATE(659),
    [sym_na] = STATE(659),
    [sym__expression] = STATE(659),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(659),
    [sym_string] = STATE(659),
    [aux_sym_program_repeat1] = STATE(55),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(27),
    [sym_next] = ACTIONS(27),
    [sym_true] = ACTIONS(27),
    [sym_false] = ACTIONS(27),
    [sym_null] = ACTIONS(27),
    [sym_inf] = ACTIONS(27),
    [sym_nan] = ACTIONS(27),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(41),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [2] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1141),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(59),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [3] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1094),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [4] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1134),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [5] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1113),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [6] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1151),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [7] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1102),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [8] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1123),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [9] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1097),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(113),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [10] = {
    [sym_function_definition] = STATE(742),
    [sym_lambda_function] = STATE(742),
    [sym_if] = STATE(742),
    [sym_while] = STATE(742),
    [sym_repeat] = STATE(742),
    [sym_for] = STATE(742),
    [sym_switch] = STATE(742),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(842),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(742),
    [sym__assignment] = STATE(742),
    [sym_left_assignment] = STATE(742),
    [sym_left_assignment2] = STATE(742),
    [sym_equals_assignment] = STATE(742),
    [sym_super_assignment] = STATE(742),
    [sym_super_right_assignment] = STATE(742),
    [sym_right_assignment] = STATE(742),
    [sym_brace_list] = STATE(742),
    [sym_paren_list] = STATE(742),
    [sym_subset] = STATE(742),
    [sym_subset2] = STATE(742),
    [sym_dollar] = STATE(742),
    [sym_slot] = STATE(742),
    [sym_namespace_get] = STATE(742),
    [sym_namespace_get_internal] = STATE(742),
    [sym_help] = STATE(742),
    [sym_pipe_placeholder_argument] = STATE(18),
    [sym__pipe_rhs_argument] = STATE(18),
    [sym_pipe_rhs_arguments] = STATE(1111),
    [sym_pipe] = STATE(742),
    [sym_unary] = STATE(742),
    [sym_binary] = STATE(742),
    [sym_na] = STATE(742),
    [sym__expression] = STATE(742),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(742),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(18),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(115),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(83),
    [sym_next] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_inf] = ACTIONS(83),
    [sym_nan] = ACTIONS(83),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [11] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1119),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(119),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [12] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1087),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(125),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [13] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1127),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(147),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [14] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_default_argument] = STATE(14),
    [sym__argument] = STATE(14),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_function] = ACTIONS(177),
    [anon_sym_BSLASH] = ACTIONS(180),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_RPAREN] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_repeat] = ACTIONS(194),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_switch] = ACTIONS(200),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_LBRACE] = ACTIONS(206),
    [anon_sym_RBRACK] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(209),
    [sym_dots] = ACTIONS(212),
    [anon_sym_DASH] = ACTIONS(215),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(218),
    [anon_sym_TILDE] = ACTIONS(221),
    [sym_break] = ACTIONS(224),
    [sym_next] = ACTIONS(224),
    [sym_true] = ACTIONS(224),
    [sym_false] = ACTIONS(224),
    [sym_null] = ACTIONS(224),
    [sym_inf] = ACTIONS(224),
    [sym_nan] = ACTIONS(224),
    [anon_sym_NA] = ACTIONS(227),
    [anon_sym_NA_character_] = ACTIONS(227),
    [anon_sym_NA_complex_] = ACTIONS(227),
    [anon_sym_NA_integer_] = ACTIONS(227),
    [anon_sym_NA_real_] = ACTIONS(227),
    [aux_sym_identifier_token1] = ACTIONS(230),
    [anon_sym_BQUOTE] = ACTIONS(233),
    [sym_integer] = ACTIONS(236),
    [sym_float] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(242),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__raw_string_literal] = ACTIONS(248),
  },
  [15] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1093),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(251),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [16] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1092),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [17] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1089),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(255),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [18] = {
    [sym_function_definition] = STATE(776),
    [sym_lambda_function] = STATE(776),
    [sym_if] = STATE(776),
    [sym_while] = STATE(776),
    [sym_repeat] = STATE(776),
    [sym_for] = STATE(776),
    [sym_switch] = STATE(776),
    [sym_default_argument] = STATE(20),
    [sym_call] = STATE(776),
    [sym__assignment] = STATE(776),
    [sym_left_assignment] = STATE(776),
    [sym_left_assignment2] = STATE(776),
    [sym_equals_assignment] = STATE(776),
    [sym_super_assignment] = STATE(776),
    [sym_super_right_assignment] = STATE(776),
    [sym_right_assignment] = STATE(776),
    [sym_brace_list] = STATE(776),
    [sym_paren_list] = STATE(776),
    [sym_subset] = STATE(776),
    [sym_subset2] = STATE(776),
    [sym_dollar] = STATE(776),
    [sym_slot] = STATE(776),
    [sym_namespace_get] = STATE(776),
    [sym_namespace_get_internal] = STATE(776),
    [sym_help] = STATE(776),
    [sym_pipe_placeholder_argument] = STATE(20),
    [sym__pipe_rhs_argument] = STATE(20),
    [sym_pipe] = STATE(776),
    [sym_unary] = STATE(776),
    [sym_binary] = STATE(776),
    [sym_na] = STATE(776),
    [sym__expression] = STATE(776),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(776),
    [sym_string] = STATE(700),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(20),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(257),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(261),
    [sym_next] = ACTIONS(261),
    [sym_true] = ACTIONS(261),
    [sym_false] = ACTIONS(261),
    [sym_null] = ACTIONS(261),
    [sym_inf] = ACTIONS(261),
    [sym_nan] = ACTIONS(261),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(263),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [19] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1132),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [20] = {
    [sym_function_definition] = STATE(776),
    [sym_lambda_function] = STATE(776),
    [sym_if] = STATE(776),
    [sym_while] = STATE(776),
    [sym_repeat] = STATE(776),
    [sym_for] = STATE(776),
    [sym_switch] = STATE(776),
    [sym_default_argument] = STATE(20),
    [sym_call] = STATE(776),
    [sym__assignment] = STATE(776),
    [sym_left_assignment] = STATE(776),
    [sym_left_assignment2] = STATE(776),
    [sym_equals_assignment] = STATE(776),
    [sym_super_assignment] = STATE(776),
    [sym_super_right_assignment] = STATE(776),
    [sym_right_assignment] = STATE(776),
    [sym_brace_list] = STATE(776),
    [sym_paren_list] = STATE(776),
    [sym_subset] = STATE(776),
    [sym_subset2] = STATE(776),
    [sym_dollar] = STATE(776),
    [sym_slot] = STATE(776),
    [sym_namespace_get] = STATE(776),
    [sym_namespace_get_internal] = STATE(776),
    [sym_help] = STATE(776),
    [sym_pipe_placeholder_argument] = STATE(20),
    [sym__pipe_rhs_argument] = STATE(20),
    [sym_pipe] = STATE(776),
    [sym_unary] = STATE(776),
    [sym_binary] = STATE(776),
    [sym_na] = STATE(776),
    [sym__expression] = STATE(776),
    [sym_identifier] = STATE(640),
    [sym_complex] = STATE(776),
    [sym_string] = STATE(700),
    [aux_sym_pipe_rhs_arguments_repeat1] = STATE(20),
    [anon_sym_function] = ACTIONS(267),
    [anon_sym_BSLASH] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_RPAREN] = ACTIONS(279),
    [anon_sym_while] = ACTIONS(281),
    [anon_sym_repeat] = ACTIONS(284),
    [anon_sym_for] = ACTIONS(287),
    [anon_sym_switch] = ACTIONS(290),
    [anon_sym_COMMA] = ACTIONS(293),
    [anon_sym_LBRACE] = ACTIONS(296),
    [anon_sym_QMARK] = ACTIONS(299),
    [sym_dots] = ACTIONS(302),
    [anon_sym_DASH] = ACTIONS(305),
    [anon_sym_PLUS] = ACTIONS(305),
    [anon_sym_BANG] = ACTIONS(308),
    [anon_sym_TILDE] = ACTIONS(311),
    [sym_break] = ACTIONS(314),
    [sym_next] = ACTIONS(314),
    [sym_true] = ACTIONS(314),
    [sym_false] = ACTIONS(314),
    [sym_null] = ACTIONS(314),
    [sym_inf] = ACTIONS(314),
    [sym_nan] = ACTIONS(314),
    [anon_sym_NA] = ACTIONS(317),
    [anon_sym_NA_character_] = ACTIONS(317),
    [anon_sym_NA_complex_] = ACTIONS(317),
    [anon_sym_NA_integer_] = ACTIONS(317),
    [anon_sym_NA_real_] = ACTIONS(317),
    [aux_sym_identifier_token1] = ACTIONS(320),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [sym_integer] = ACTIONS(326),
    [sym_float] = ACTIONS(329),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(332),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [sym__raw_string_literal] = ACTIONS(338),
  },
  [21] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_default_argument] = STATE(14),
    [sym__argument] = STATE(14),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(343),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(341),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [22] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1139),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(345),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [23] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1098),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(347),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [24] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1095),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(349),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [25] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1155),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(351),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [26] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1117),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(353),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [27] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1150),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [28] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1156),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(357),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [29] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1136),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(359),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [30] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1121),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(361),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [31] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1083),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(363),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [32] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1154),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(365),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [33] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1147),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [34] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1105),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(369),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [35] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1107),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(371),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [36] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1109),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [37] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1145),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(375),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [38] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_arguments] = STATE(1144),
    [sym_default_argument] = STATE(52),
    [sym__argument] = STATE(52),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(52),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [39] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1129),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(379),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [40] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [41] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1138),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(383),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [42] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1125),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [43] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1096),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [44] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1153),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [45] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1135),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [46] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1142),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [47] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1115),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [48] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1088),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [49] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1103),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [50] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_default_argument] = STATE(50),
    [sym__argument] = STATE(50),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(50),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(388),
    [anon_sym_if] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(394),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(403),
    [anon_sym_switch] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(412),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(189),
    [anon_sym_QMARK] = ACTIONS(415),
    [sym_dots] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(424),
    [anon_sym_TILDE] = ACTIONS(427),
    [sym_break] = ACTIONS(430),
    [sym_next] = ACTIONS(430),
    [sym_true] = ACTIONS(430),
    [sym_false] = ACTIONS(430),
    [sym_null] = ACTIONS(430),
    [sym_inf] = ACTIONS(430),
    [sym_nan] = ACTIONS(430),
    [anon_sym_NA] = ACTIONS(433),
    [anon_sym_NA_character_] = ACTIONS(433),
    [anon_sym_NA_complex_] = ACTIONS(433),
    [anon_sym_NA_integer_] = ACTIONS(433),
    [anon_sym_NA_real_] = ACTIONS(433),
    [aux_sym_identifier_token1] = ACTIONS(436),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [sym_integer] = ACTIONS(442),
    [sym_float] = ACTIONS(445),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(448),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [sym__raw_string_literal] = ACTIONS(454),
  },
  [51] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_arguments] = STATE(1100),
    [sym_default_argument] = STATE(21),
    [sym__argument] = STATE(21),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_help] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(401),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(700),
    [aux_sym_arguments_repeat1] = STATE(21),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(117),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(123),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [52] = {
    [sym_function_definition] = STATE(708),
    [sym_lambda_function] = STATE(708),
    [sym_if] = STATE(708),
    [sym_while] = STATE(708),
    [sym_repeat] = STATE(708),
    [sym_for] = STATE(708),
    [sym_switch] = STATE(708),
    [sym_default_argument] = STATE(50),
    [sym__argument] = STATE(50),
    [sym_call] = STATE(708),
    [sym__assignment] = STATE(708),
    [sym_left_assignment] = STATE(708),
    [sym_left_assignment2] = STATE(708),
    [sym_equals_assignment] = STATE(708),
    [sym_super_assignment] = STATE(708),
    [sym_super_right_assignment] = STATE(708),
    [sym_right_assignment] = STATE(708),
    [sym_brace_list] = STATE(708),
    [sym_paren_list] = STATE(708),
    [sym_subset] = STATE(708),
    [sym_subset2] = STATE(708),
    [sym_dollar] = STATE(708),
    [sym_slot] = STATE(708),
    [sym_namespace_get] = STATE(708),
    [sym_namespace_get_internal] = STATE(708),
    [sym_help] = STATE(708),
    [sym_pipe] = STATE(708),
    [sym_unary] = STATE(708),
    [sym_binary] = STATE(708),
    [sym_na] = STATE(708),
    [sym__expression] = STATE(708),
    [sym_identifier] = STATE(520),
    [sym_complex] = STATE(708),
    [sym_string] = STATE(837),
    [aux_sym_arguments_repeat1] = STATE(50),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(457),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(341),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(159),
    [sym_next] = ACTIONS(159),
    [sym_true] = ACTIONS(159),
    [sym_false] = ACTIONS(159),
    [sym_null] = ACTIONS(159),
    [sym_inf] = ACTIONS(159),
    [sym_nan] = ACTIONS(159),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(167),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [53] = {
    [sym_function_definition] = STATE(648),
    [sym_lambda_function] = STATE(648),
    [sym_if] = STATE(648),
    [sym_while] = STATE(648),
    [sym_repeat] = STATE(648),
    [sym_for] = STATE(648),
    [sym_switch] = STATE(648),
    [sym_call] = STATE(648),
    [sym__assignment] = STATE(648),
    [sym_left_assignment] = STATE(648),
    [sym_left_assignment2] = STATE(648),
    [sym_equals_assignment] = STATE(648),
    [sym_super_assignment] = STATE(648),
    [sym_super_right_assignment] = STATE(648),
    [sym_right_assignment] = STATE(648),
    [sym_brace_list] = STATE(648),
    [sym_paren_list] = STATE(648),
    [sym_subset] = STATE(648),
    [sym_subset2] = STATE(648),
    [sym_dollar] = STATE(648),
    [sym_slot] = STATE(648),
    [sym_namespace_get] = STATE(648),
    [sym_namespace_get_internal] = STATE(648),
    [sym_help] = STATE(648),
    [sym_pipe] = STATE(648),
    [sym_unary] = STATE(648),
    [sym_binary] = STATE(648),
    [sym_na] = STATE(648),
    [sym__expression] = STATE(648),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(648),
    [sym_string] = STATE(648),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(461),
    [sym_next] = ACTIONS(461),
    [sym_true] = ACTIONS(461),
    [sym_false] = ACTIONS(461),
    [sym_null] = ACTIONS(461),
    [sym_inf] = ACTIONS(461),
    [sym_nan] = ACTIONS(461),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(463),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [54] = {
    [sym_function_definition] = STATE(648),
    [sym_lambda_function] = STATE(648),
    [sym_if] = STATE(648),
    [sym_while] = STATE(648),
    [sym_repeat] = STATE(648),
    [sym_for] = STATE(648),
    [sym_switch] = STATE(648),
    [sym_call] = STATE(648),
    [sym__assignment] = STATE(648),
    [sym_left_assignment] = STATE(648),
    [sym_left_assignment2] = STATE(648),
    [sym_equals_assignment] = STATE(648),
    [sym_super_assignment] = STATE(648),
    [sym_super_right_assignment] = STATE(648),
    [sym_right_assignment] = STATE(648),
    [sym_brace_list] = STATE(648),
    [sym_paren_list] = STATE(648),
    [sym_subset] = STATE(648),
    [sym_subset2] = STATE(648),
    [sym_dollar] = STATE(648),
    [sym_slot] = STATE(648),
    [sym_namespace_get] = STATE(648),
    [sym_namespace_get_internal] = STATE(648),
    [sym_help] = STATE(648),
    [sym_pipe] = STATE(648),
    [sym_unary] = STATE(648),
    [sym_binary] = STATE(648),
    [sym_na] = STATE(648),
    [sym__expression] = STATE(648),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(648),
    [sym_string] = STATE(648),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(461),
    [sym_placeholder] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(461),
    [sym_next] = ACTIONS(461),
    [sym_true] = ACTIONS(461),
    [sym_false] = ACTIONS(461),
    [sym_null] = ACTIONS(461),
    [sym_inf] = ACTIONS(461),
    [sym_nan] = ACTIONS(461),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(463),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [55] = {
    [sym_function_definition] = STATE(659),
    [sym_lambda_function] = STATE(659),
    [sym_if] = STATE(659),
    [sym_while] = STATE(659),
    [sym_repeat] = STATE(659),
    [sym_for] = STATE(659),
    [sym_switch] = STATE(659),
    [sym_call] = STATE(659),
    [sym__assignment] = STATE(659),
    [sym_left_assignment] = STATE(659),
    [sym_left_assignment2] = STATE(659),
    [sym_equals_assignment] = STATE(659),
    [sym_super_assignment] = STATE(659),
    [sym_super_right_assignment] = STATE(659),
    [sym_right_assignment] = STATE(659),
    [sym_brace_list] = STATE(659),
    [sym_paren_list] = STATE(659),
    [sym_subset] = STATE(659),
    [sym_subset2] = STATE(659),
    [sym_dollar] = STATE(659),
    [sym_slot] = STATE(659),
    [sym_namespace_get] = STATE(659),
    [sym_namespace_get_internal] = STATE(659),
    [sym_help] = STATE(659),
    [sym_pipe] = STATE(659),
    [sym_unary] = STATE(659),
    [sym_binary] = STATE(659),
    [sym_na] = STATE(659),
    [sym__expression] = STATE(659),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(659),
    [sym_string] = STATE(659),
    [aux_sym_program_repeat1] = STATE(75),
    [ts_builtin_sym_end] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(27),
    [sym_next] = ACTIONS(27),
    [sym_true] = ACTIONS(27),
    [sym_false] = ACTIONS(27),
    [sym_null] = ACTIONS(27),
    [sym_inf] = ACTIONS(27),
    [sym_nan] = ACTIONS(27),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(41),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [56] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(90),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [57] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(78),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [58] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(66),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(517),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [59] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [60] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(525),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [61] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(59),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [62] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [63] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(60),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(531),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [64] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(67),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [65] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(535),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [66] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [67] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [68] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(62),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [69] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(543),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [70] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(545),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [71] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(69),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(547),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [72] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(70),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(549),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [73] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(77),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(551),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [74] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(553),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [75] = {
    [sym_function_definition] = STATE(659),
    [sym_lambda_function] = STATE(659),
    [sym_if] = STATE(659),
    [sym_while] = STATE(659),
    [sym_repeat] = STATE(659),
    [sym_for] = STATE(659),
    [sym_switch] = STATE(659),
    [sym_call] = STATE(659),
    [sym__assignment] = STATE(659),
    [sym_left_assignment] = STATE(659),
    [sym_left_assignment2] = STATE(659),
    [sym_equals_assignment] = STATE(659),
    [sym_super_assignment] = STATE(659),
    [sym_super_right_assignment] = STATE(659),
    [sym_right_assignment] = STATE(659),
    [sym_brace_list] = STATE(659),
    [sym_paren_list] = STATE(659),
    [sym_subset] = STATE(659),
    [sym_subset2] = STATE(659),
    [sym_dollar] = STATE(659),
    [sym_slot] = STATE(659),
    [sym_namespace_get] = STATE(659),
    [sym_namespace_get_internal] = STATE(659),
    [sym_help] = STATE(659),
    [sym_pipe] = STATE(659),
    [sym_unary] = STATE(659),
    [sym_binary] = STATE(659),
    [sym_na] = STATE(659),
    [sym__expression] = STATE(659),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(659),
    [sym_string] = STATE(659),
    [aux_sym_program_repeat1] = STATE(75),
    [ts_builtin_sym_end] = ACTIONS(555),
    [anon_sym_function] = ACTIONS(557),
    [anon_sym_BSLASH] = ACTIONS(560),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_LPAREN] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_repeat] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(575),
    [anon_sym_switch] = ACTIONS(578),
    [anon_sym_LBRACE] = ACTIONS(581),
    [anon_sym_QMARK] = ACTIONS(584),
    [sym_dots] = ACTIONS(587),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(590),
    [anon_sym_BANG] = ACTIONS(593),
    [anon_sym_TILDE] = ACTIONS(596),
    [sym_break] = ACTIONS(587),
    [sym_next] = ACTIONS(587),
    [sym_true] = ACTIONS(587),
    [sym_false] = ACTIONS(587),
    [sym_null] = ACTIONS(587),
    [sym_inf] = ACTIONS(587),
    [sym_nan] = ACTIONS(587),
    [anon_sym_NA] = ACTIONS(599),
    [anon_sym_NA_character_] = ACTIONS(599),
    [anon_sym_NA_complex_] = ACTIONS(599),
    [anon_sym_NA_integer_] = ACTIONS(599),
    [anon_sym_NA_real_] = ACTIONS(599),
    [aux_sym_identifier_token1] = ACTIONS(602),
    [anon_sym_BQUOTE] = ACTIONS(605),
    [sym_integer] = ACTIONS(608),
    [sym_float] = ACTIONS(611),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(614),
    [anon_sym_SQUOTE] = ACTIONS(617),
    [sym__raw_string_literal] = ACTIONS(620),
  },
  [76] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(65),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(623),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [77] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(625),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [78] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(627),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [79] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(629),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [80] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(631),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [81] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [82] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(635),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [83] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(637),
    [anon_sym_BSLASH] = ACTIONS(640),
    [anon_sym_if] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(646),
    [anon_sym_RPAREN] = ACTIONS(649),
    [anon_sym_while] = ACTIONS(651),
    [anon_sym_repeat] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(657),
    [anon_sym_switch] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_QMARK] = ACTIONS(666),
    [sym_dots] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(672),
    [anon_sym_BANG] = ACTIONS(675),
    [anon_sym_TILDE] = ACTIONS(678),
    [sym_break] = ACTIONS(669),
    [sym_next] = ACTIONS(669),
    [sym_true] = ACTIONS(669),
    [sym_false] = ACTIONS(669),
    [sym_null] = ACTIONS(669),
    [sym_inf] = ACTIONS(669),
    [sym_nan] = ACTIONS(669),
    [anon_sym_NA] = ACTIONS(681),
    [anon_sym_NA_character_] = ACTIONS(681),
    [anon_sym_NA_complex_] = ACTIONS(681),
    [anon_sym_NA_integer_] = ACTIONS(681),
    [anon_sym_NA_real_] = ACTIONS(681),
    [aux_sym_identifier_token1] = ACTIONS(684),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(690),
    [sym_float] = ACTIONS(693),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_SQUOTE] = ACTIONS(699),
    [sym__raw_string_literal] = ACTIONS(702),
  },
  [84] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(81),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(705),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [85] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(707),
    [anon_sym_BSLASH] = ACTIONS(710),
    [anon_sym_if] = ACTIONS(713),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(719),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(725),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(731),
    [anon_sym_RBRACE] = ACTIONS(555),
    [anon_sym_QMARK] = ACTIONS(734),
    [sym_dots] = ACTIONS(737),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(743),
    [anon_sym_TILDE] = ACTIONS(746),
    [sym_break] = ACTIONS(737),
    [sym_next] = ACTIONS(737),
    [sym_true] = ACTIONS(737),
    [sym_false] = ACTIONS(737),
    [sym_null] = ACTIONS(737),
    [sym_inf] = ACTIONS(737),
    [sym_nan] = ACTIONS(737),
    [anon_sym_NA] = ACTIONS(749),
    [anon_sym_NA_character_] = ACTIONS(749),
    [anon_sym_NA_complex_] = ACTIONS(749),
    [anon_sym_NA_integer_] = ACTIONS(749),
    [anon_sym_NA_real_] = ACTIONS(749),
    [aux_sym_identifier_token1] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(755),
    [sym_integer] = ACTIONS(758),
    [sym_float] = ACTIONS(761),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(764),
    [anon_sym_SQUOTE] = ACTIONS(767),
    [sym__raw_string_literal] = ACTIONS(770),
  },
  [86] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(773),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [87] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(775),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [88] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(94),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(777),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [89] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(86),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(779),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [90] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_help] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(405),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_BSLASH] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(781),
    [anon_sym_QMARK] = ACTIONS(489),
    [sym_dots] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(497),
    [sym_break] = ACTIONS(491),
    [sym_next] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_inf] = ACTIONS(491),
    [sym_nan] = ACTIONS(491),
    [anon_sym_NA] = ACTIONS(499),
    [anon_sym_NA_character_] = ACTIONS(499),
    [anon_sym_NA_complex_] = ACTIONS(499),
    [anon_sym_NA_integer_] = ACTIONS(499),
    [anon_sym_NA_real_] = ACTIONS(499),
    [aux_sym_identifier_token1] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_integer] = ACTIONS(505),
    [sym_float] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(513),
  },
  [91] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(783),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [92] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(87),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(785),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [93] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(91),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(787),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [94] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_help] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [aux_sym_block_repeat1] = STATE(83),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(789),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_inf] = ACTIONS(519),
    [sym_nan] = ACTIONS(519),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(521),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [95] = {
    [sym_function_definition] = STATE(799),
    [sym_lambda_function] = STATE(799),
    [sym_if] = STATE(799),
    [sym_while] = STATE(799),
    [sym_repeat] = STATE(799),
    [sym_for] = STATE(799),
    [sym_switch] = STATE(799),
    [sym_call] = STATE(799),
    [sym__assignment] = STATE(799),
    [sym_left_assignment] = STATE(799),
    [sym_left_assignment2] = STATE(799),
    [sym_equals_assignment] = STATE(799),
    [sym_super_assignment] = STATE(799),
    [sym_super_right_assignment] = STATE(799),
    [sym_right_assignment] = STATE(799),
    [sym_brace_list] = STATE(799),
    [sym_paren_list] = STATE(799),
    [sym_subset] = STATE(799),
    [sym_subset2] = STATE(799),
    [sym_dollar] = STATE(799),
    [sym_slot] = STATE(799),
    [sym_namespace_get] = STATE(799),
    [sym_namespace_get_internal] = STATE(799),
    [sym_help] = STATE(799),
    [sym_pipe] = STATE(799),
    [sym_unary] = STATE(799),
    [sym_binary] = STATE(799),
    [sym_na] = STATE(799),
    [sym__expression] = STATE(799),
    [sym_identifier] = STATE(664),
    [sym_complex] = STATE(799),
    [sym_string] = STATE(799),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(791),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(791),
    [sym_next] = ACTIONS(791),
    [sym_true] = ACTIONS(791),
    [sym_false] = ACTIONS(791),
    [sym_null] = ACTIONS(791),
    [sym_inf] = ACTIONS(791),
    [sym_nan] = ACTIONS(791),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(793),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [96] = {
    [sym_function_definition] = STATE(944),
    [sym_lambda_function] = STATE(944),
    [sym_if] = STATE(944),
    [sym_while] = STATE(944),
    [sym_repeat] = STATE(944),
    [sym_for] = STATE(944),
    [sym_switch] = STATE(944),
    [sym_call] = STATE(944),
    [sym__assignment] = STATE(944),
    [sym_left_assignment] = STATE(944),
    [sym_left_assignment2] = STATE(944),
    [sym_equals_assignment] = STATE(944),
    [sym_super_assignment] = STATE(944),
    [sym_super_right_assignment] = STATE(944),
    [sym_right_assignment] = STATE(944),
    [sym_brace_list] = STATE(944),
    [sym_paren_list] = STATE(944),
    [sym_subset] = STATE(944),
    [sym_subset2] = STATE(944),
    [sym_dollar] = STATE(944),
    [sym_slot] = STATE(944),
    [sym_namespace_get] = STATE(944),
    [sym_namespace_get_internal] = STATE(944),
    [sym_help] = STATE(944),
    [sym_pipe_rhs] = STATE(722),
    [sym_pipe] = STATE(944),
    [sym_unary] = STATE(944),
    [sym_binary] = STATE(944),
    [sym_na] = STATE(944),
    [sym__expression] = STATE(944),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(944),
    [sym_string] = STATE(944),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(815),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(815),
    [sym_next] = ACTIONS(815),
    [sym_true] = ACTIONS(815),
    [sym_false] = ACTIONS(815),
    [sym_null] = ACTIONS(815),
    [sym_inf] = ACTIONS(815),
    [sym_nan] = ACTIONS(815),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(829),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [97] = {
    [sym_function_definition] = STATE(949),
    [sym_lambda_function] = STATE(949),
    [sym_if] = STATE(949),
    [sym_while] = STATE(949),
    [sym_repeat] = STATE(949),
    [sym_for] = STATE(949),
    [sym_switch] = STATE(949),
    [sym_call] = STATE(949),
    [sym__assignment] = STATE(949),
    [sym_left_assignment] = STATE(949),
    [sym_left_assignment2] = STATE(949),
    [sym_equals_assignment] = STATE(949),
    [sym_super_assignment] = STATE(949),
    [sym_super_right_assignment] = STATE(949),
    [sym_right_assignment] = STATE(949),
    [sym_brace_list] = STATE(949),
    [sym_paren_list] = STATE(949),
    [sym_subset] = STATE(949),
    [sym_subset2] = STATE(949),
    [sym_dollar] = STATE(949),
    [sym_slot] = STATE(949),
    [sym_namespace_get] = STATE(949),
    [sym_namespace_get_internal] = STATE(949),
    [sym_help] = STATE(949),
    [sym_pipe_rhs] = STATE(582),
    [sym_pipe] = STATE(949),
    [sym_unary] = STATE(949),
    [sym_binary] = STATE(949),
    [sym_na] = STATE(949),
    [sym__expression] = STATE(949),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(949),
    [sym_string] = STATE(949),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(839),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(839),
    [sym_next] = ACTIONS(839),
    [sym_true] = ACTIONS(839),
    [sym_false] = ACTIONS(839),
    [sym_null] = ACTIONS(839),
    [sym_inf] = ACTIONS(839),
    [sym_nan] = ACTIONS(839),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(841),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [98] = {
    [sym_function_definition] = STATE(945),
    [sym_lambda_function] = STATE(945),
    [sym_if] = STATE(945),
    [sym_while] = STATE(945),
    [sym_repeat] = STATE(945),
    [sym_for] = STATE(945),
    [sym_switch] = STATE(945),
    [sym_call] = STATE(945),
    [sym__assignment] = STATE(945),
    [sym_left_assignment] = STATE(945),
    [sym_left_assignment2] = STATE(945),
    [sym_equals_assignment] = STATE(945),
    [sym_super_assignment] = STATE(945),
    [sym_super_right_assignment] = STATE(945),
    [sym_right_assignment] = STATE(945),
    [sym_brace_list] = STATE(945),
    [sym_paren_list] = STATE(945),
    [sym_subset] = STATE(945),
    [sym_subset2] = STATE(945),
    [sym_dollar] = STATE(945),
    [sym_slot] = STATE(945),
    [sym_namespace_get] = STATE(945),
    [sym_namespace_get_internal] = STATE(945),
    [sym_help] = STATE(945),
    [sym_pipe_rhs] = STATE(625),
    [sym_pipe] = STATE(945),
    [sym_unary] = STATE(945),
    [sym_binary] = STATE(945),
    [sym_na] = STATE(945),
    [sym__expression] = STATE(945),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(945),
    [sym_string] = STATE(945),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(843),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(843),
    [sym_next] = ACTIONS(843),
    [sym_true] = ACTIONS(843),
    [sym_false] = ACTIONS(843),
    [sym_null] = ACTIONS(843),
    [sym_inf] = ACTIONS(843),
    [sym_nan] = ACTIONS(843),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(845),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [99] = {
    [sym_function_definition] = STATE(950),
    [sym_lambda_function] = STATE(950),
    [sym_if] = STATE(950),
    [sym_while] = STATE(950),
    [sym_repeat] = STATE(950),
    [sym_for] = STATE(950),
    [sym_switch] = STATE(950),
    [sym_call] = STATE(950),
    [sym__assignment] = STATE(950),
    [sym_left_assignment] = STATE(950),
    [sym_left_assignment2] = STATE(950),
    [sym_equals_assignment] = STATE(950),
    [sym_super_assignment] = STATE(950),
    [sym_super_right_assignment] = STATE(950),
    [sym_right_assignment] = STATE(950),
    [sym_brace_list] = STATE(950),
    [sym_paren_list] = STATE(950),
    [sym_subset] = STATE(950),
    [sym_subset2] = STATE(950),
    [sym_dollar] = STATE(950),
    [sym_slot] = STATE(950),
    [sym_namespace_get] = STATE(950),
    [sym_namespace_get_internal] = STATE(950),
    [sym_help] = STATE(950),
    [sym_pipe_rhs] = STATE(724),
    [sym_pipe] = STATE(950),
    [sym_unary] = STATE(950),
    [sym_binary] = STATE(950),
    [sym_na] = STATE(950),
    [sym__expression] = STATE(950),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(950),
    [sym_string] = STATE(950),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(847),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(847),
    [sym_next] = ACTIONS(847),
    [sym_true] = ACTIONS(847),
    [sym_false] = ACTIONS(847),
    [sym_null] = ACTIONS(847),
    [sym_inf] = ACTIONS(847),
    [sym_nan] = ACTIONS(847),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(849),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [100] = {
    [sym_function_definition] = STATE(948),
    [sym_lambda_function] = STATE(948),
    [sym_if] = STATE(948),
    [sym_while] = STATE(948),
    [sym_repeat] = STATE(948),
    [sym_for] = STATE(948),
    [sym_switch] = STATE(948),
    [sym_call] = STATE(948),
    [sym__assignment] = STATE(948),
    [sym_left_assignment] = STATE(948),
    [sym_left_assignment2] = STATE(948),
    [sym_equals_assignment] = STATE(948),
    [sym_super_assignment] = STATE(948),
    [sym_super_right_assignment] = STATE(948),
    [sym_right_assignment] = STATE(948),
    [sym_brace_list] = STATE(948),
    [sym_paren_list] = STATE(948),
    [sym_subset] = STATE(948),
    [sym_subset2] = STATE(948),
    [sym_dollar] = STATE(948),
    [sym_slot] = STATE(948),
    [sym_namespace_get] = STATE(948),
    [sym_namespace_get_internal] = STATE(948),
    [sym_help] = STATE(948),
    [sym_pipe_rhs] = STATE(539),
    [sym_pipe] = STATE(948),
    [sym_unary] = STATE(948),
    [sym_binary] = STATE(948),
    [sym_na] = STATE(948),
    [sym__expression] = STATE(948),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(948),
    [sym_string] = STATE(948),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(851),
    [sym_next] = ACTIONS(851),
    [sym_true] = ACTIONS(851),
    [sym_false] = ACTIONS(851),
    [sym_null] = ACTIONS(851),
    [sym_inf] = ACTIONS(851),
    [sym_nan] = ACTIONS(851),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(853),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [101] = {
    [sym_function_definition] = STATE(942),
    [sym_lambda_function] = STATE(942),
    [sym_if] = STATE(942),
    [sym_while] = STATE(942),
    [sym_repeat] = STATE(942),
    [sym_for] = STATE(942),
    [sym_switch] = STATE(942),
    [sym_call] = STATE(942),
    [sym__assignment] = STATE(942),
    [sym_left_assignment] = STATE(942),
    [sym_left_assignment2] = STATE(942),
    [sym_equals_assignment] = STATE(942),
    [sym_super_assignment] = STATE(942),
    [sym_super_right_assignment] = STATE(942),
    [sym_right_assignment] = STATE(942),
    [sym_brace_list] = STATE(942),
    [sym_paren_list] = STATE(942),
    [sym_subset] = STATE(942),
    [sym_subset2] = STATE(942),
    [sym_dollar] = STATE(942),
    [sym_slot] = STATE(942),
    [sym_namespace_get] = STATE(942),
    [sym_namespace_get_internal] = STATE(942),
    [sym_help] = STATE(942),
    [sym_pipe_rhs] = STATE(903),
    [sym_pipe] = STATE(942),
    [sym_unary] = STATE(942),
    [sym_binary] = STATE(942),
    [sym_na] = STATE(942),
    [sym__expression] = STATE(942),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(942),
    [sym_string] = STATE(942),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(855),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(855),
    [sym_next] = ACTIONS(855),
    [sym_true] = ACTIONS(855),
    [sym_false] = ACTIONS(855),
    [sym_null] = ACTIONS(855),
    [sym_inf] = ACTIONS(855),
    [sym_nan] = ACTIONS(855),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(857),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [102] = {
    [sym_function_definition] = STATE(943),
    [sym_lambda_function] = STATE(943),
    [sym_if] = STATE(943),
    [sym_while] = STATE(943),
    [sym_repeat] = STATE(943),
    [sym_for] = STATE(943),
    [sym_switch] = STATE(943),
    [sym_call] = STATE(943),
    [sym__assignment] = STATE(943),
    [sym_left_assignment] = STATE(943),
    [sym_left_assignment2] = STATE(943),
    [sym_equals_assignment] = STATE(943),
    [sym_super_assignment] = STATE(943),
    [sym_super_right_assignment] = STATE(943),
    [sym_right_assignment] = STATE(943),
    [sym_brace_list] = STATE(943),
    [sym_paren_list] = STATE(943),
    [sym_subset] = STATE(943),
    [sym_subset2] = STATE(943),
    [sym_dollar] = STATE(943),
    [sym_slot] = STATE(943),
    [sym_namespace_get] = STATE(943),
    [sym_namespace_get_internal] = STATE(943),
    [sym_help] = STATE(943),
    [sym_pipe_rhs] = STATE(767),
    [sym_pipe] = STATE(943),
    [sym_unary] = STATE(943),
    [sym_binary] = STATE(943),
    [sym_na] = STATE(943),
    [sym__expression] = STATE(943),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(943),
    [sym_string] = STATE(943),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(859),
    [sym_next] = ACTIONS(859),
    [sym_true] = ACTIONS(859),
    [sym_false] = ACTIONS(859),
    [sym_null] = ACTIONS(859),
    [sym_inf] = ACTIONS(859),
    [sym_nan] = ACTIONS(859),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(861),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [103] = {
    [sym_function_definition] = STATE(947),
    [sym_lambda_function] = STATE(947),
    [sym_if] = STATE(947),
    [sym_while] = STATE(947),
    [sym_repeat] = STATE(947),
    [sym_for] = STATE(947),
    [sym_switch] = STATE(947),
    [sym_call] = STATE(947),
    [sym__assignment] = STATE(947),
    [sym_left_assignment] = STATE(947),
    [sym_left_assignment2] = STATE(947),
    [sym_equals_assignment] = STATE(947),
    [sym_super_assignment] = STATE(947),
    [sym_super_right_assignment] = STATE(947),
    [sym_right_assignment] = STATE(947),
    [sym_brace_list] = STATE(947),
    [sym_paren_list] = STATE(947),
    [sym_subset] = STATE(947),
    [sym_subset2] = STATE(947),
    [sym_dollar] = STATE(947),
    [sym_slot] = STATE(947),
    [sym_namespace_get] = STATE(947),
    [sym_namespace_get_internal] = STATE(947),
    [sym_help] = STATE(947),
    [sym_pipe_rhs] = STATE(747),
    [sym_pipe] = STATE(947),
    [sym_unary] = STATE(947),
    [sym_binary] = STATE(947),
    [sym_na] = STATE(947),
    [sym__expression] = STATE(947),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(947),
    [sym_string] = STATE(947),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(863),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(863),
    [sym_next] = ACTIONS(863),
    [sym_true] = ACTIONS(863),
    [sym_false] = ACTIONS(863),
    [sym_null] = ACTIONS(863),
    [sym_inf] = ACTIONS(863),
    [sym_nan] = ACTIONS(863),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(865),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [104] = {
    [sym_function_definition] = STATE(946),
    [sym_lambda_function] = STATE(946),
    [sym_if] = STATE(946),
    [sym_while] = STATE(946),
    [sym_repeat] = STATE(946),
    [sym_for] = STATE(946),
    [sym_switch] = STATE(946),
    [sym_call] = STATE(946),
    [sym__assignment] = STATE(946),
    [sym_left_assignment] = STATE(946),
    [sym_left_assignment2] = STATE(946),
    [sym_equals_assignment] = STATE(946),
    [sym_super_assignment] = STATE(946),
    [sym_super_right_assignment] = STATE(946),
    [sym_right_assignment] = STATE(946),
    [sym_brace_list] = STATE(946),
    [sym_paren_list] = STATE(946),
    [sym_subset] = STATE(946),
    [sym_subset2] = STATE(946),
    [sym_dollar] = STATE(946),
    [sym_slot] = STATE(946),
    [sym_namespace_get] = STATE(946),
    [sym_namespace_get_internal] = STATE(946),
    [sym_help] = STATE(946),
    [sym_pipe_rhs] = STATE(836),
    [sym_pipe] = STATE(946),
    [sym_unary] = STATE(946),
    [sym_binary] = STATE(946),
    [sym_na] = STATE(946),
    [sym__expression] = STATE(946),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(946),
    [sym_string] = STATE(946),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(867),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(867),
    [sym_next] = ACTIONS(867),
    [sym_true] = ACTIONS(867),
    [sym_false] = ACTIONS(867),
    [sym_null] = ACTIONS(867),
    [sym_inf] = ACTIONS(867),
    [sym_nan] = ACTIONS(867),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(869),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [105] = {
    [sym_function_definition] = STATE(417),
    [sym_lambda_function] = STATE(417),
    [sym_if] = STATE(417),
    [sym_while] = STATE(417),
    [sym_repeat] = STATE(417),
    [sym_for] = STATE(417),
    [sym_switch] = STATE(417),
    [sym_call] = STATE(417),
    [sym__assignment] = STATE(417),
    [sym_left_assignment] = STATE(417),
    [sym_left_assignment2] = STATE(417),
    [sym_equals_assignment] = STATE(417),
    [sym_super_assignment] = STATE(417),
    [sym_super_right_assignment] = STATE(417),
    [sym_right_assignment] = STATE(417),
    [sym_brace_list] = STATE(417),
    [sym_paren_list] = STATE(417),
    [sym_subset] = STATE(417),
    [sym_subset2] = STATE(417),
    [sym_dollar] = STATE(417),
    [sym_slot] = STATE(417),
    [sym_namespace_get] = STATE(417),
    [sym_namespace_get_internal] = STATE(417),
    [sym_help] = STATE(417),
    [sym_pipe] = STATE(417),
    [sym_unary] = STATE(417),
    [sym_binary] = STATE(417),
    [sym_na] = STATE(417),
    [sym__expression] = STATE(417),
    [sym_identifier] = STATE(307),
    [sym_complex] = STATE(417),
    [sym_string] = STATE(417),
    [anon_sym_function] = ACTIONS(871),
    [anon_sym_BSLASH] = ACTIONS(873),
    [anon_sym_if] = ACTIONS(875),
    [anon_sym_LPAREN] = ACTIONS(877),
    [anon_sym_while] = ACTIONS(879),
    [anon_sym_repeat] = ACTIONS(881),
    [anon_sym_for] = ACTIONS(883),
    [anon_sym_switch] = ACTIONS(885),
    [anon_sym_LBRACE] = ACTIONS(887),
    [anon_sym_QMARK] = ACTIONS(889),
    [sym_dots] = ACTIONS(891),
    [anon_sym_DASH] = ACTIONS(893),
    [anon_sym_PLUS] = ACTIONS(893),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(897),
    [sym_break] = ACTIONS(891),
    [sym_next] = ACTIONS(891),
    [sym_true] = ACTIONS(891),
    [sym_false] = ACTIONS(891),
    [sym_null] = ACTIONS(891),
    [sym_inf] = ACTIONS(891),
    [sym_nan] = ACTIONS(891),
    [anon_sym_NA] = ACTIONS(899),
    [anon_sym_NA_character_] = ACTIONS(899),
    [anon_sym_NA_complex_] = ACTIONS(899),
    [anon_sym_NA_integer_] = ACTIONS(899),
    [anon_sym_NA_real_] = ACTIONS(899),
    [aux_sym_identifier_token1] = ACTIONS(901),
    [anon_sym_BQUOTE] = ACTIONS(903),
    [sym_integer] = ACTIONS(905),
    [sym_float] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(909),
    [anon_sym_SQUOTE] = ACTIONS(911),
    [sym__raw_string_literal] = ACTIONS(913),
  },
  [106] = {
    [sym_function_definition] = STATE(749),
    [sym_lambda_function] = STATE(749),
    [sym_if] = STATE(749),
    [sym_while] = STATE(749),
    [sym_repeat] = STATE(749),
    [sym_for] = STATE(749),
    [sym_switch] = STATE(749),
    [sym_call] = STATE(749),
    [sym__assignment] = STATE(749),
    [sym_left_assignment] = STATE(749),
    [sym_left_assignment2] = STATE(749),
    [sym_equals_assignment] = STATE(749),
    [sym_super_assignment] = STATE(749),
    [sym_super_right_assignment] = STATE(749),
    [sym_right_assignment] = STATE(749),
    [sym_brace_list] = STATE(749),
    [sym_paren_list] = STATE(749),
    [sym_subset] = STATE(749),
    [sym_subset2] = STATE(749),
    [sym_dollar] = STATE(749),
    [sym_slot] = STATE(749),
    [sym_namespace_get] = STATE(749),
    [sym_namespace_get_internal] = STATE(749),
    [sym_help] = STATE(749),
    [sym_pipe] = STATE(749),
    [sym_unary] = STATE(749),
    [sym_binary] = STATE(749),
    [sym_na] = STATE(749),
    [sym__expression] = STATE(749),
    [sym_identifier] = STATE(664),
    [sym_complex] = STATE(749),
    [sym_string] = STATE(749),
    [anon_sym_function] = ACTIONS(127),
    [anon_sym_BSLASH] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(139),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_QMARK] = ACTIONS(149),
    [sym_dots] = ACTIONS(915),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [sym_break] = ACTIONS(915),
    [sym_next] = ACTIONS(915),
    [sym_true] = ACTIONS(915),
    [sym_false] = ACTIONS(915),
    [sym_null] = ACTIONS(915),
    [sym_inf] = ACTIONS(915),
    [sym_nan] = ACTIONS(915),
    [anon_sym_NA] = ACTIONS(161),
    [anon_sym_NA_character_] = ACTIONS(161),
    [anon_sym_NA_complex_] = ACTIONS(161),
    [anon_sym_NA_integer_] = ACTIONS(161),
    [anon_sym_NA_real_] = ACTIONS(161),
    [aux_sym_identifier_token1] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym_integer] = ACTIONS(917),
    [sym_float] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [anon_sym_SQUOTE] = ACTIONS(173),
    [sym__raw_string_literal] = ACTIONS(175),
  },
  [107] = {
    [sym_function_definition] = STATE(910),
    [sym_lambda_function] = STATE(910),
    [sym_if] = STATE(910),
    [sym_while] = STATE(910),
    [sym_repeat] = STATE(910),
    [sym_for] = STATE(910),
    [sym_switch] = STATE(910),
    [sym_call] = STATE(910),
    [sym__assignment] = STATE(910),
    [sym_left_assignment] = STATE(910),
    [sym_left_assignment2] = STATE(910),
    [sym_equals_assignment] = STATE(910),
    [sym_super_assignment] = STATE(910),
    [sym_super_right_assignment] = STATE(910),
    [sym_right_assignment] = STATE(910),
    [sym_brace_list] = STATE(910),
    [sym_paren_list] = STATE(910),
    [sym_subset] = STATE(910),
    [sym_subset2] = STATE(910),
    [sym_dollar] = STATE(910),
    [sym_slot] = STATE(910),
    [sym_namespace_get] = STATE(910),
    [sym_namespace_get_internal] = STATE(910),
    [sym_help] = STATE(910),
    [sym_pipe] = STATE(910),
    [sym_unary] = STATE(910),
    [sym_binary] = STATE(910),
    [sym_na] = STATE(910),
    [sym__expression] = STATE(910),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(910),
    [sym_string] = STATE(910),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(919),
    [sym_next] = ACTIONS(919),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [sym_null] = ACTIONS(919),
    [sym_inf] = ACTIONS(919),
    [sym_nan] = ACTIONS(919),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(921),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [108] = {
    [sym_function_definition] = STATE(927),
    [sym_lambda_function] = STATE(927),
    [sym_if] = STATE(927),
    [sym_while] = STATE(927),
    [sym_repeat] = STATE(927),
    [sym_for] = STATE(927),
    [sym_switch] = STATE(927),
    [sym_call] = STATE(927),
    [sym__assignment] = STATE(927),
    [sym_left_assignment] = STATE(927),
    [sym_left_assignment2] = STATE(927),
    [sym_equals_assignment] = STATE(927),
    [sym_super_assignment] = STATE(927),
    [sym_super_right_assignment] = STATE(927),
    [sym_right_assignment] = STATE(927),
    [sym_brace_list] = STATE(927),
    [sym_paren_list] = STATE(927),
    [sym_subset] = STATE(927),
    [sym_subset2] = STATE(927),
    [sym_dollar] = STATE(927),
    [sym_slot] = STATE(927),
    [sym_namespace_get] = STATE(927),
    [sym_namespace_get_internal] = STATE(927),
    [sym_help] = STATE(927),
    [sym_pipe] = STATE(927),
    [sym_unary] = STATE(927),
    [sym_binary] = STATE(927),
    [sym_na] = STATE(927),
    [sym__expression] = STATE(927),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(927),
    [sym_string] = STATE(927),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(923),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(923),
    [sym_next] = ACTIONS(923),
    [sym_true] = ACTIONS(923),
    [sym_false] = ACTIONS(923),
    [sym_null] = ACTIONS(923),
    [sym_inf] = ACTIONS(923),
    [sym_nan] = ACTIONS(923),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(925),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [109] = {
    [sym_function_definition] = STATE(926),
    [sym_lambda_function] = STATE(926),
    [sym_if] = STATE(926),
    [sym_while] = STATE(926),
    [sym_repeat] = STATE(926),
    [sym_for] = STATE(926),
    [sym_switch] = STATE(926),
    [sym_call] = STATE(926),
    [sym__assignment] = STATE(926),
    [sym_left_assignment] = STATE(926),
    [sym_left_assignment2] = STATE(926),
    [sym_equals_assignment] = STATE(926),
    [sym_super_assignment] = STATE(926),
    [sym_super_right_assignment] = STATE(926),
    [sym_right_assignment] = STATE(926),
    [sym_brace_list] = STATE(926),
    [sym_paren_list] = STATE(926),
    [sym_subset] = STATE(926),
    [sym_subset2] = STATE(926),
    [sym_dollar] = STATE(926),
    [sym_slot] = STATE(926),
    [sym_namespace_get] = STATE(926),
    [sym_namespace_get_internal] = STATE(926),
    [sym_help] = STATE(926),
    [sym_pipe] = STATE(926),
    [sym_unary] = STATE(926),
    [sym_binary] = STATE(926),
    [sym_na] = STATE(926),
    [sym__expression] = STATE(926),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(926),
    [sym_string] = STATE(926),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(927),
    [sym_next] = ACTIONS(927),
    [sym_true] = ACTIONS(927),
    [sym_false] = ACTIONS(927),
    [sym_null] = ACTIONS(927),
    [sym_inf] = ACTIONS(927),
    [sym_nan] = ACTIONS(927),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(929),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [110] = {
    [sym_function_definition] = STATE(914),
    [sym_lambda_function] = STATE(914),
    [sym_if] = STATE(914),
    [sym_while] = STATE(914),
    [sym_repeat] = STATE(914),
    [sym_for] = STATE(914),
    [sym_switch] = STATE(914),
    [sym_call] = STATE(914),
    [sym__assignment] = STATE(914),
    [sym_left_assignment] = STATE(914),
    [sym_left_assignment2] = STATE(914),
    [sym_equals_assignment] = STATE(914),
    [sym_super_assignment] = STATE(914),
    [sym_super_right_assignment] = STATE(914),
    [sym_right_assignment] = STATE(914),
    [sym_brace_list] = STATE(914),
    [sym_paren_list] = STATE(914),
    [sym_subset] = STATE(914),
    [sym_subset2] = STATE(914),
    [sym_dollar] = STATE(914),
    [sym_slot] = STATE(914),
    [sym_namespace_get] = STATE(914),
    [sym_namespace_get_internal] = STATE(914),
    [sym_help] = STATE(914),
    [sym_pipe] = STATE(914),
    [sym_unary] = STATE(914),
    [sym_binary] = STATE(914),
    [sym_na] = STATE(914),
    [sym__expression] = STATE(914),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(914),
    [sym_string] = STATE(914),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(931),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(931),
    [sym_next] = ACTIONS(931),
    [sym_true] = ACTIONS(931),
    [sym_false] = ACTIONS(931),
    [sym_null] = ACTIONS(931),
    [sym_inf] = ACTIONS(931),
    [sym_nan] = ACTIONS(931),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(933),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [111] = {
    [sym_function_definition] = STATE(941),
    [sym_lambda_function] = STATE(941),
    [sym_if] = STATE(941),
    [sym_while] = STATE(941),
    [sym_repeat] = STATE(941),
    [sym_for] = STATE(941),
    [sym_switch] = STATE(941),
    [sym_call] = STATE(941),
    [sym__assignment] = STATE(941),
    [sym_left_assignment] = STATE(941),
    [sym_left_assignment2] = STATE(941),
    [sym_equals_assignment] = STATE(941),
    [sym_super_assignment] = STATE(941),
    [sym_super_right_assignment] = STATE(941),
    [sym_right_assignment] = STATE(941),
    [sym_brace_list] = STATE(941),
    [sym_paren_list] = STATE(941),
    [sym_subset] = STATE(941),
    [sym_subset2] = STATE(941),
    [sym_dollar] = STATE(941),
    [sym_slot] = STATE(941),
    [sym_namespace_get] = STATE(941),
    [sym_namespace_get_internal] = STATE(941),
    [sym_help] = STATE(941),
    [sym_pipe] = STATE(941),
    [sym_unary] = STATE(941),
    [sym_binary] = STATE(941),
    [sym_na] = STATE(941),
    [sym__expression] = STATE(941),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(941),
    [sym_string] = STATE(941),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(935),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(935),
    [sym_next] = ACTIONS(935),
    [sym_true] = ACTIONS(935),
    [sym_false] = ACTIONS(935),
    [sym_null] = ACTIONS(935),
    [sym_inf] = ACTIONS(935),
    [sym_nan] = ACTIONS(935),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(937),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [112] = {
    [sym_function_definition] = STATE(939),
    [sym_lambda_function] = STATE(939),
    [sym_if] = STATE(939),
    [sym_while] = STATE(939),
    [sym_repeat] = STATE(939),
    [sym_for] = STATE(939),
    [sym_switch] = STATE(939),
    [sym_call] = STATE(939),
    [sym__assignment] = STATE(939),
    [sym_left_assignment] = STATE(939),
    [sym_left_assignment2] = STATE(939),
    [sym_equals_assignment] = STATE(939),
    [sym_super_assignment] = STATE(939),
    [sym_super_right_assignment] = STATE(939),
    [sym_right_assignment] = STATE(939),
    [sym_brace_list] = STATE(939),
    [sym_paren_list] = STATE(939),
    [sym_subset] = STATE(939),
    [sym_subset2] = STATE(939),
    [sym_dollar] = STATE(939),
    [sym_slot] = STATE(939),
    [sym_namespace_get] = STATE(939),
    [sym_namespace_get_internal] = STATE(939),
    [sym_help] = STATE(939),
    [sym_pipe] = STATE(939),
    [sym_unary] = STATE(939),
    [sym_binary] = STATE(939),
    [sym_na] = STATE(939),
    [sym__expression] = STATE(939),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(939),
    [sym_string] = STATE(939),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(939),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(939),
    [sym_next] = ACTIONS(939),
    [sym_true] = ACTIONS(939),
    [sym_false] = ACTIONS(939),
    [sym_null] = ACTIONS(939),
    [sym_inf] = ACTIONS(939),
    [sym_nan] = ACTIONS(939),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(941),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [113] = {
    [sym_function_definition] = STATE(937),
    [sym_lambda_function] = STATE(937),
    [sym_if] = STATE(937),
    [sym_while] = STATE(937),
    [sym_repeat] = STATE(937),
    [sym_for] = STATE(937),
    [sym_switch] = STATE(937),
    [sym_call] = STATE(937),
    [sym__assignment] = STATE(937),
    [sym_left_assignment] = STATE(937),
    [sym_left_assignment2] = STATE(937),
    [sym_equals_assignment] = STATE(937),
    [sym_super_assignment] = STATE(937),
    [sym_super_right_assignment] = STATE(937),
    [sym_right_assignment] = STATE(937),
    [sym_brace_list] = STATE(937),
    [sym_paren_list] = STATE(937),
    [sym_subset] = STATE(937),
    [sym_subset2] = STATE(937),
    [sym_dollar] = STATE(937),
    [sym_slot] = STATE(937),
    [sym_namespace_get] = STATE(937),
    [sym_namespace_get_internal] = STATE(937),
    [sym_help] = STATE(937),
    [sym_pipe] = STATE(937),
    [sym_unary] = STATE(937),
    [sym_binary] = STATE(937),
    [sym_na] = STATE(937),
    [sym__expression] = STATE(937),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(937),
    [sym_string] = STATE(937),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(943),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(943),
    [sym_next] = ACTIONS(943),
    [sym_true] = ACTIONS(943),
    [sym_false] = ACTIONS(943),
    [sym_null] = ACTIONS(943),
    [sym_inf] = ACTIONS(943),
    [sym_nan] = ACTIONS(943),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(945),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [114] = {
    [sym_function_definition] = STATE(906),
    [sym_lambda_function] = STATE(906),
    [sym_if] = STATE(906),
    [sym_while] = STATE(906),
    [sym_repeat] = STATE(906),
    [sym_for] = STATE(906),
    [sym_switch] = STATE(906),
    [sym_call] = STATE(906),
    [sym__assignment] = STATE(906),
    [sym_left_assignment] = STATE(906),
    [sym_left_assignment2] = STATE(906),
    [sym_equals_assignment] = STATE(906),
    [sym_super_assignment] = STATE(906),
    [sym_super_right_assignment] = STATE(906),
    [sym_right_assignment] = STATE(906),
    [sym_brace_list] = STATE(906),
    [sym_paren_list] = STATE(906),
    [sym_subset] = STATE(906),
    [sym_subset2] = STATE(906),
    [sym_dollar] = STATE(906),
    [sym_slot] = STATE(906),
    [sym_namespace_get] = STATE(906),
    [sym_namespace_get_internal] = STATE(906),
    [sym_help] = STATE(906),
    [sym_pipe] = STATE(906),
    [sym_unary] = STATE(906),
    [sym_binary] = STATE(906),
    [sym_na] = STATE(906),
    [sym__expression] = STATE(906),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(906),
    [sym_string] = STATE(906),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(947),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(947),
    [sym_next] = ACTIONS(947),
    [sym_true] = ACTIONS(947),
    [sym_false] = ACTIONS(947),
    [sym_null] = ACTIONS(947),
    [sym_inf] = ACTIONS(947),
    [sym_nan] = ACTIONS(947),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(949),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [115] = {
    [sym_function_definition] = STATE(918),
    [sym_lambda_function] = STATE(918),
    [sym_if] = STATE(918),
    [sym_while] = STATE(918),
    [sym_repeat] = STATE(918),
    [sym_for] = STATE(918),
    [sym_switch] = STATE(918),
    [sym_call] = STATE(918),
    [sym__assignment] = STATE(918),
    [sym_left_assignment] = STATE(918),
    [sym_left_assignment2] = STATE(918),
    [sym_equals_assignment] = STATE(918),
    [sym_super_assignment] = STATE(918),
    [sym_super_right_assignment] = STATE(918),
    [sym_right_assignment] = STATE(918),
    [sym_brace_list] = STATE(918),
    [sym_paren_list] = STATE(918),
    [sym_subset] = STATE(918),
    [sym_subset2] = STATE(918),
    [sym_dollar] = STATE(918),
    [sym_slot] = STATE(918),
    [sym_namespace_get] = STATE(918),
    [sym_namespace_get_internal] = STATE(918),
    [sym_help] = STATE(918),
    [sym_pipe] = STATE(918),
    [sym_unary] = STATE(918),
    [sym_binary] = STATE(918),
    [sym_na] = STATE(918),
    [sym__expression] = STATE(918),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(918),
    [sym_string] = STATE(918),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(951),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(951),
    [sym_next] = ACTIONS(951),
    [sym_true] = ACTIONS(951),
    [sym_false] = ACTIONS(951),
    [sym_null] = ACTIONS(951),
    [sym_inf] = ACTIONS(951),
    [sym_nan] = ACTIONS(951),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(953),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [116] = {
    [sym_function_definition] = STATE(911),
    [sym_lambda_function] = STATE(911),
    [sym_if] = STATE(911),
    [sym_while] = STATE(911),
    [sym_repeat] = STATE(911),
    [sym_for] = STATE(911),
    [sym_switch] = STATE(911),
    [sym_call] = STATE(911),
    [sym__assignment] = STATE(911),
    [sym_left_assignment] = STATE(911),
    [sym_left_assignment2] = STATE(911),
    [sym_equals_assignment] = STATE(911),
    [sym_super_assignment] = STATE(911),
    [sym_super_right_assignment] = STATE(911),
    [sym_right_assignment] = STATE(911),
    [sym_brace_list] = STATE(911),
    [sym_paren_list] = STATE(911),
    [sym_subset] = STATE(911),
    [sym_subset2] = STATE(911),
    [sym_dollar] = STATE(911),
    [sym_slot] = STATE(911),
    [sym_namespace_get] = STATE(911),
    [sym_namespace_get_internal] = STATE(911),
    [sym_help] = STATE(911),
    [sym_pipe] = STATE(911),
    [sym_unary] = STATE(911),
    [sym_binary] = STATE(911),
    [sym_na] = STATE(911),
    [sym__expression] = STATE(911),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(911),
    [sym_string] = STATE(911),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(955),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(955),
    [sym_next] = ACTIONS(955),
    [sym_true] = ACTIONS(955),
    [sym_false] = ACTIONS(955),
    [sym_null] = ACTIONS(955),
    [sym_inf] = ACTIONS(955),
    [sym_nan] = ACTIONS(955),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(957),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [117] = {
    [sym_function_definition] = STATE(935),
    [sym_lambda_function] = STATE(935),
    [sym_if] = STATE(935),
    [sym_while] = STATE(935),
    [sym_repeat] = STATE(935),
    [sym_for] = STATE(935),
    [sym_switch] = STATE(935),
    [sym_call] = STATE(935),
    [sym__assignment] = STATE(935),
    [sym_left_assignment] = STATE(935),
    [sym_left_assignment2] = STATE(935),
    [sym_equals_assignment] = STATE(935),
    [sym_super_assignment] = STATE(935),
    [sym_super_right_assignment] = STATE(935),
    [sym_right_assignment] = STATE(935),
    [sym_brace_list] = STATE(935),
    [sym_paren_list] = STATE(935),
    [sym_subset] = STATE(935),
    [sym_subset2] = STATE(935),
    [sym_dollar] = STATE(935),
    [sym_slot] = STATE(935),
    [sym_namespace_get] = STATE(935),
    [sym_namespace_get_internal] = STATE(935),
    [sym_help] = STATE(935),
    [sym_pipe] = STATE(935),
    [sym_unary] = STATE(935),
    [sym_binary] = STATE(935),
    [sym_na] = STATE(935),
    [sym__expression] = STATE(935),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(935),
    [sym_string] = STATE(935),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(959),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(959),
    [sym_next] = ACTIONS(959),
    [sym_true] = ACTIONS(959),
    [sym_false] = ACTIONS(959),
    [sym_null] = ACTIONS(959),
    [sym_inf] = ACTIONS(959),
    [sym_nan] = ACTIONS(959),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(961),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [118] = {
    [sym_function_definition] = STATE(908),
    [sym_lambda_function] = STATE(908),
    [sym_if] = STATE(908),
    [sym_while] = STATE(908),
    [sym_repeat] = STATE(908),
    [sym_for] = STATE(908),
    [sym_switch] = STATE(908),
    [sym_call] = STATE(908),
    [sym__assignment] = STATE(908),
    [sym_left_assignment] = STATE(908),
    [sym_left_assignment2] = STATE(908),
    [sym_equals_assignment] = STATE(908),
    [sym_super_assignment] = STATE(908),
    [sym_super_right_assignment] = STATE(908),
    [sym_right_assignment] = STATE(908),
    [sym_brace_list] = STATE(908),
    [sym_paren_list] = STATE(908),
    [sym_subset] = STATE(908),
    [sym_subset2] = STATE(908),
    [sym_dollar] = STATE(908),
    [sym_slot] = STATE(908),
    [sym_namespace_get] = STATE(908),
    [sym_namespace_get_internal] = STATE(908),
    [sym_help] = STATE(908),
    [sym_pipe] = STATE(908),
    [sym_unary] = STATE(908),
    [sym_binary] = STATE(908),
    [sym_na] = STATE(908),
    [sym__expression] = STATE(908),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(908),
    [sym_string] = STATE(908),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(963),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(963),
    [sym_next] = ACTIONS(963),
    [sym_true] = ACTIONS(963),
    [sym_false] = ACTIONS(963),
    [sym_null] = ACTIONS(963),
    [sym_inf] = ACTIONS(963),
    [sym_nan] = ACTIONS(963),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(965),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [119] = {
    [sym_function_definition] = STATE(916),
    [sym_lambda_function] = STATE(916),
    [sym_if] = STATE(916),
    [sym_while] = STATE(916),
    [sym_repeat] = STATE(916),
    [sym_for] = STATE(916),
    [sym_switch] = STATE(916),
    [sym_call] = STATE(916),
    [sym__assignment] = STATE(916),
    [sym_left_assignment] = STATE(916),
    [sym_left_assignment2] = STATE(916),
    [sym_equals_assignment] = STATE(916),
    [sym_super_assignment] = STATE(916),
    [sym_super_right_assignment] = STATE(916),
    [sym_right_assignment] = STATE(916),
    [sym_brace_list] = STATE(916),
    [sym_paren_list] = STATE(916),
    [sym_subset] = STATE(916),
    [sym_subset2] = STATE(916),
    [sym_dollar] = STATE(916),
    [sym_slot] = STATE(916),
    [sym_namespace_get] = STATE(916),
    [sym_namespace_get_internal] = STATE(916),
    [sym_help] = STATE(916),
    [sym_pipe] = STATE(916),
    [sym_unary] = STATE(916),
    [sym_binary] = STATE(916),
    [sym_na] = STATE(916),
    [sym__expression] = STATE(916),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(916),
    [sym_string] = STATE(916),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(967),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(967),
    [sym_next] = ACTIONS(967),
    [sym_true] = ACTIONS(967),
    [sym_false] = ACTIONS(967),
    [sym_null] = ACTIONS(967),
    [sym_inf] = ACTIONS(967),
    [sym_nan] = ACTIONS(967),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(969),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [120] = {
    [sym_function_definition] = STATE(907),
    [sym_lambda_function] = STATE(907),
    [sym_if] = STATE(907),
    [sym_while] = STATE(907),
    [sym_repeat] = STATE(907),
    [sym_for] = STATE(907),
    [sym_switch] = STATE(907),
    [sym_call] = STATE(907),
    [sym__assignment] = STATE(907),
    [sym_left_assignment] = STATE(907),
    [sym_left_assignment2] = STATE(907),
    [sym_equals_assignment] = STATE(907),
    [sym_super_assignment] = STATE(907),
    [sym_super_right_assignment] = STATE(907),
    [sym_right_assignment] = STATE(907),
    [sym_brace_list] = STATE(907),
    [sym_paren_list] = STATE(907),
    [sym_subset] = STATE(907),
    [sym_subset2] = STATE(907),
    [sym_dollar] = STATE(907),
    [sym_slot] = STATE(907),
    [sym_namespace_get] = STATE(907),
    [sym_namespace_get_internal] = STATE(907),
    [sym_help] = STATE(907),
    [sym_pipe] = STATE(907),
    [sym_unary] = STATE(907),
    [sym_binary] = STATE(907),
    [sym_na] = STATE(907),
    [sym__expression] = STATE(907),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(907),
    [sym_string] = STATE(907),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(971),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(971),
    [sym_next] = ACTIONS(971),
    [sym_true] = ACTIONS(971),
    [sym_false] = ACTIONS(971),
    [sym_null] = ACTIONS(971),
    [sym_inf] = ACTIONS(971),
    [sym_nan] = ACTIONS(971),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(973),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [121] = {
    [sym_function_definition] = STATE(928),
    [sym_lambda_function] = STATE(928),
    [sym_if] = STATE(928),
    [sym_while] = STATE(928),
    [sym_repeat] = STATE(928),
    [sym_for] = STATE(928),
    [sym_switch] = STATE(928),
    [sym_call] = STATE(928),
    [sym__assignment] = STATE(928),
    [sym_left_assignment] = STATE(928),
    [sym_left_assignment2] = STATE(928),
    [sym_equals_assignment] = STATE(928),
    [sym_super_assignment] = STATE(928),
    [sym_super_right_assignment] = STATE(928),
    [sym_right_assignment] = STATE(928),
    [sym_brace_list] = STATE(928),
    [sym_paren_list] = STATE(928),
    [sym_subset] = STATE(928),
    [sym_subset2] = STATE(928),
    [sym_dollar] = STATE(928),
    [sym_slot] = STATE(928),
    [sym_namespace_get] = STATE(928),
    [sym_namespace_get_internal] = STATE(928),
    [sym_help] = STATE(928),
    [sym_pipe] = STATE(928),
    [sym_unary] = STATE(928),
    [sym_binary] = STATE(928),
    [sym_na] = STATE(928),
    [sym__expression] = STATE(928),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(928),
    [sym_string] = STATE(928),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(975),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(975),
    [sym_next] = ACTIONS(975),
    [sym_true] = ACTIONS(975),
    [sym_false] = ACTIONS(975),
    [sym_null] = ACTIONS(975),
    [sym_inf] = ACTIONS(975),
    [sym_nan] = ACTIONS(975),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(977),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [122] = {
    [sym_function_definition] = STATE(923),
    [sym_lambda_function] = STATE(923),
    [sym_if] = STATE(923),
    [sym_while] = STATE(923),
    [sym_repeat] = STATE(923),
    [sym_for] = STATE(923),
    [sym_switch] = STATE(923),
    [sym_call] = STATE(923),
    [sym__assignment] = STATE(923),
    [sym_left_assignment] = STATE(923),
    [sym_left_assignment2] = STATE(923),
    [sym_equals_assignment] = STATE(923),
    [sym_super_assignment] = STATE(923),
    [sym_super_right_assignment] = STATE(923),
    [sym_right_assignment] = STATE(923),
    [sym_brace_list] = STATE(923),
    [sym_paren_list] = STATE(923),
    [sym_subset] = STATE(923),
    [sym_subset2] = STATE(923),
    [sym_dollar] = STATE(923),
    [sym_slot] = STATE(923),
    [sym_namespace_get] = STATE(923),
    [sym_namespace_get_internal] = STATE(923),
    [sym_help] = STATE(923),
    [sym_pipe] = STATE(923),
    [sym_unary] = STATE(923),
    [sym_binary] = STATE(923),
    [sym_na] = STATE(923),
    [sym__expression] = STATE(923),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(923),
    [sym_string] = STATE(923),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(979),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(979),
    [sym_next] = ACTIONS(979),
    [sym_true] = ACTIONS(979),
    [sym_false] = ACTIONS(979),
    [sym_null] = ACTIONS(979),
    [sym_inf] = ACTIONS(979),
    [sym_nan] = ACTIONS(979),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(981),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [123] = {
    [sym_function_definition] = STATE(913),
    [sym_lambda_function] = STATE(913),
    [sym_if] = STATE(913),
    [sym_while] = STATE(913),
    [sym_repeat] = STATE(913),
    [sym_for] = STATE(913),
    [sym_switch] = STATE(913),
    [sym_call] = STATE(913),
    [sym__assignment] = STATE(913),
    [sym_left_assignment] = STATE(913),
    [sym_left_assignment2] = STATE(913),
    [sym_equals_assignment] = STATE(913),
    [sym_super_assignment] = STATE(913),
    [sym_super_right_assignment] = STATE(913),
    [sym_right_assignment] = STATE(913),
    [sym_brace_list] = STATE(913),
    [sym_paren_list] = STATE(913),
    [sym_subset] = STATE(913),
    [sym_subset2] = STATE(913),
    [sym_dollar] = STATE(913),
    [sym_slot] = STATE(913),
    [sym_namespace_get] = STATE(913),
    [sym_namespace_get_internal] = STATE(913),
    [sym_help] = STATE(913),
    [sym_pipe] = STATE(913),
    [sym_unary] = STATE(913),
    [sym_binary] = STATE(913),
    [sym_na] = STATE(913),
    [sym__expression] = STATE(913),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(913),
    [sym_string] = STATE(913),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(983),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(983),
    [sym_next] = ACTIONS(983),
    [sym_true] = ACTIONS(983),
    [sym_false] = ACTIONS(983),
    [sym_null] = ACTIONS(983),
    [sym_inf] = ACTIONS(983),
    [sym_nan] = ACTIONS(983),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(985),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [124] = {
    [sym_function_definition] = STATE(919),
    [sym_lambda_function] = STATE(919),
    [sym_if] = STATE(919),
    [sym_while] = STATE(919),
    [sym_repeat] = STATE(919),
    [sym_for] = STATE(919),
    [sym_switch] = STATE(919),
    [sym_call] = STATE(919),
    [sym__assignment] = STATE(919),
    [sym_left_assignment] = STATE(919),
    [sym_left_assignment2] = STATE(919),
    [sym_equals_assignment] = STATE(919),
    [sym_super_assignment] = STATE(919),
    [sym_super_right_assignment] = STATE(919),
    [sym_right_assignment] = STATE(919),
    [sym_brace_list] = STATE(919),
    [sym_paren_list] = STATE(919),
    [sym_subset] = STATE(919),
    [sym_subset2] = STATE(919),
    [sym_dollar] = STATE(919),
    [sym_slot] = STATE(919),
    [sym_namespace_get] = STATE(919),
    [sym_namespace_get_internal] = STATE(919),
    [sym_help] = STATE(919),
    [sym_pipe] = STATE(919),
    [sym_unary] = STATE(919),
    [sym_binary] = STATE(919),
    [sym_na] = STATE(919),
    [sym__expression] = STATE(919),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(919),
    [sym_string] = STATE(919),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(987),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(987),
    [sym_next] = ACTIONS(987),
    [sym_true] = ACTIONS(987),
    [sym_false] = ACTIONS(987),
    [sym_null] = ACTIONS(987),
    [sym_inf] = ACTIONS(987),
    [sym_nan] = ACTIONS(987),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(989),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [125] = {
    [sym_function_definition] = STATE(925),
    [sym_lambda_function] = STATE(925),
    [sym_if] = STATE(925),
    [sym_while] = STATE(925),
    [sym_repeat] = STATE(925),
    [sym_for] = STATE(925),
    [sym_switch] = STATE(925),
    [sym_call] = STATE(925),
    [sym__assignment] = STATE(925),
    [sym_left_assignment] = STATE(925),
    [sym_left_assignment2] = STATE(925),
    [sym_equals_assignment] = STATE(925),
    [sym_super_assignment] = STATE(925),
    [sym_super_right_assignment] = STATE(925),
    [sym_right_assignment] = STATE(925),
    [sym_brace_list] = STATE(925),
    [sym_paren_list] = STATE(925),
    [sym_subset] = STATE(925),
    [sym_subset2] = STATE(925),
    [sym_dollar] = STATE(925),
    [sym_slot] = STATE(925),
    [sym_namespace_get] = STATE(925),
    [sym_namespace_get_internal] = STATE(925),
    [sym_help] = STATE(925),
    [sym_pipe] = STATE(925),
    [sym_unary] = STATE(925),
    [sym_binary] = STATE(925),
    [sym_na] = STATE(925),
    [sym__expression] = STATE(925),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(925),
    [sym_string] = STATE(925),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(991),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(991),
    [sym_next] = ACTIONS(991),
    [sym_true] = ACTIONS(991),
    [sym_false] = ACTIONS(991),
    [sym_null] = ACTIONS(991),
    [sym_inf] = ACTIONS(991),
    [sym_nan] = ACTIONS(991),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(993),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [126] = {
    [sym_function_definition] = STATE(933),
    [sym_lambda_function] = STATE(933),
    [sym_if] = STATE(933),
    [sym_while] = STATE(933),
    [sym_repeat] = STATE(933),
    [sym_for] = STATE(933),
    [sym_switch] = STATE(933),
    [sym_call] = STATE(933),
    [sym__assignment] = STATE(933),
    [sym_left_assignment] = STATE(933),
    [sym_left_assignment2] = STATE(933),
    [sym_equals_assignment] = STATE(933),
    [sym_super_assignment] = STATE(933),
    [sym_super_right_assignment] = STATE(933),
    [sym_right_assignment] = STATE(933),
    [sym_brace_list] = STATE(933),
    [sym_paren_list] = STATE(933),
    [sym_subset] = STATE(933),
    [sym_subset2] = STATE(933),
    [sym_dollar] = STATE(933),
    [sym_slot] = STATE(933),
    [sym_namespace_get] = STATE(933),
    [sym_namespace_get_internal] = STATE(933),
    [sym_help] = STATE(933),
    [sym_pipe] = STATE(933),
    [sym_unary] = STATE(933),
    [sym_binary] = STATE(933),
    [sym_na] = STATE(933),
    [sym__expression] = STATE(933),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(933),
    [sym_string] = STATE(933),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(995),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(995),
    [sym_next] = ACTIONS(995),
    [sym_true] = ACTIONS(995),
    [sym_false] = ACTIONS(995),
    [sym_null] = ACTIONS(995),
    [sym_inf] = ACTIONS(995),
    [sym_nan] = ACTIONS(995),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(997),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [127] = {
    [sym_function_definition] = STATE(915),
    [sym_lambda_function] = STATE(915),
    [sym_if] = STATE(915),
    [sym_while] = STATE(915),
    [sym_repeat] = STATE(915),
    [sym_for] = STATE(915),
    [sym_switch] = STATE(915),
    [sym_call] = STATE(915),
    [sym__assignment] = STATE(915),
    [sym_left_assignment] = STATE(915),
    [sym_left_assignment2] = STATE(915),
    [sym_equals_assignment] = STATE(915),
    [sym_super_assignment] = STATE(915),
    [sym_super_right_assignment] = STATE(915),
    [sym_right_assignment] = STATE(915),
    [sym_brace_list] = STATE(915),
    [sym_paren_list] = STATE(915),
    [sym_subset] = STATE(915),
    [sym_subset2] = STATE(915),
    [sym_dollar] = STATE(915),
    [sym_slot] = STATE(915),
    [sym_namespace_get] = STATE(915),
    [sym_namespace_get_internal] = STATE(915),
    [sym_help] = STATE(915),
    [sym_pipe] = STATE(915),
    [sym_unary] = STATE(915),
    [sym_binary] = STATE(915),
    [sym_na] = STATE(915),
    [sym__expression] = STATE(915),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(915),
    [sym_string] = STATE(915),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(999),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(999),
    [sym_next] = ACTIONS(999),
    [sym_true] = ACTIONS(999),
    [sym_false] = ACTIONS(999),
    [sym_null] = ACTIONS(999),
    [sym_inf] = ACTIONS(999),
    [sym_nan] = ACTIONS(999),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1001),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [128] = {
    [sym_function_definition] = STATE(934),
    [sym_lambda_function] = STATE(934),
    [sym_if] = STATE(934),
    [sym_while] = STATE(934),
    [sym_repeat] = STATE(934),
    [sym_for] = STATE(934),
    [sym_switch] = STATE(934),
    [sym_call] = STATE(934),
    [sym__assignment] = STATE(934),
    [sym_left_assignment] = STATE(934),
    [sym_left_assignment2] = STATE(934),
    [sym_equals_assignment] = STATE(934),
    [sym_super_assignment] = STATE(934),
    [sym_super_right_assignment] = STATE(934),
    [sym_right_assignment] = STATE(934),
    [sym_brace_list] = STATE(934),
    [sym_paren_list] = STATE(934),
    [sym_subset] = STATE(934),
    [sym_subset2] = STATE(934),
    [sym_dollar] = STATE(934),
    [sym_slot] = STATE(934),
    [sym_namespace_get] = STATE(934),
    [sym_namespace_get_internal] = STATE(934),
    [sym_help] = STATE(934),
    [sym_pipe] = STATE(934),
    [sym_unary] = STATE(934),
    [sym_binary] = STATE(934),
    [sym_na] = STATE(934),
    [sym__expression] = STATE(934),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(934),
    [sym_string] = STATE(934),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1003),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1003),
    [sym_next] = ACTIONS(1003),
    [sym_true] = ACTIONS(1003),
    [sym_false] = ACTIONS(1003),
    [sym_null] = ACTIONS(1003),
    [sym_inf] = ACTIONS(1003),
    [sym_nan] = ACTIONS(1003),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1005),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [129] = {
    [sym_function_definition] = STATE(940),
    [sym_lambda_function] = STATE(940),
    [sym_if] = STATE(940),
    [sym_while] = STATE(940),
    [sym_repeat] = STATE(940),
    [sym_for] = STATE(940),
    [sym_switch] = STATE(940),
    [sym_call] = STATE(940),
    [sym__assignment] = STATE(940),
    [sym_left_assignment] = STATE(940),
    [sym_left_assignment2] = STATE(940),
    [sym_equals_assignment] = STATE(940),
    [sym_super_assignment] = STATE(940),
    [sym_super_right_assignment] = STATE(940),
    [sym_right_assignment] = STATE(940),
    [sym_brace_list] = STATE(940),
    [sym_paren_list] = STATE(940),
    [sym_subset] = STATE(940),
    [sym_subset2] = STATE(940),
    [sym_dollar] = STATE(940),
    [sym_slot] = STATE(940),
    [sym_namespace_get] = STATE(940),
    [sym_namespace_get_internal] = STATE(940),
    [sym_help] = STATE(940),
    [sym_pipe] = STATE(940),
    [sym_unary] = STATE(940),
    [sym_binary] = STATE(940),
    [sym_na] = STATE(940),
    [sym__expression] = STATE(940),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(940),
    [sym_string] = STATE(940),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1007),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1007),
    [sym_next] = ACTIONS(1007),
    [sym_true] = ACTIONS(1007),
    [sym_false] = ACTIONS(1007),
    [sym_null] = ACTIONS(1007),
    [sym_inf] = ACTIONS(1007),
    [sym_nan] = ACTIONS(1007),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1009),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [130] = {
    [sym_function_definition] = STATE(882),
    [sym_lambda_function] = STATE(882),
    [sym_if] = STATE(882),
    [sym_while] = STATE(882),
    [sym_repeat] = STATE(882),
    [sym_for] = STATE(882),
    [sym_switch] = STATE(882),
    [sym_call] = STATE(882),
    [sym__assignment] = STATE(882),
    [sym_left_assignment] = STATE(882),
    [sym_left_assignment2] = STATE(882),
    [sym_equals_assignment] = STATE(882),
    [sym_super_assignment] = STATE(882),
    [sym_super_right_assignment] = STATE(882),
    [sym_right_assignment] = STATE(882),
    [sym_brace_list] = STATE(882),
    [sym_paren_list] = STATE(882),
    [sym_subset] = STATE(882),
    [sym_subset2] = STATE(882),
    [sym_dollar] = STATE(882),
    [sym_slot] = STATE(882),
    [sym_namespace_get] = STATE(882),
    [sym_namespace_get_internal] = STATE(882),
    [sym_help] = STATE(882),
    [sym_pipe] = STATE(882),
    [sym_unary] = STATE(882),
    [sym_binary] = STATE(882),
    [sym_na] = STATE(882),
    [sym__expression] = STATE(882),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(882),
    [sym_string] = STATE(882),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1011),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1011),
    [sym_next] = ACTIONS(1011),
    [sym_true] = ACTIONS(1011),
    [sym_false] = ACTIONS(1011),
    [sym_null] = ACTIONS(1011),
    [sym_inf] = ACTIONS(1011),
    [sym_nan] = ACTIONS(1011),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1013),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [131] = {
    [sym_function_definition] = STATE(427),
    [sym_lambda_function] = STATE(427),
    [sym_if] = STATE(427),
    [sym_while] = STATE(427),
    [sym_repeat] = STATE(427),
    [sym_for] = STATE(427),
    [sym_switch] = STATE(427),
    [sym_call] = STATE(427),
    [sym__assignment] = STATE(427),
    [sym_left_assignment] = STATE(427),
    [sym_left_assignment2] = STATE(427),
    [sym_equals_assignment] = STATE(427),
    [sym_super_assignment] = STATE(427),
    [sym_super_right_assignment] = STATE(427),
    [sym_right_assignment] = STATE(427),
    [sym_brace_list] = STATE(427),
    [sym_paren_list] = STATE(427),
    [sym_subset] = STATE(427),
    [sym_subset2] = STATE(427),
    [sym_dollar] = STATE(427),
    [sym_slot] = STATE(427),
    [sym_namespace_get] = STATE(427),
    [sym_namespace_get_internal] = STATE(427),
    [sym_help] = STATE(427),
    [sym_pipe] = STATE(427),
    [sym_unary] = STATE(427),
    [sym_binary] = STATE(427),
    [sym_na] = STATE(427),
    [sym__expression] = STATE(427),
    [sym_identifier] = STATE(372),
    [sym_complex] = STATE(427),
    [sym_string] = STATE(427),
    [anon_sym_function] = ACTIONS(1015),
    [anon_sym_BSLASH] = ACTIONS(1017),
    [anon_sym_if] = ACTIONS(1019),
    [anon_sym_LPAREN] = ACTIONS(1021),
    [anon_sym_while] = ACTIONS(1023),
    [anon_sym_repeat] = ACTIONS(1025),
    [anon_sym_for] = ACTIONS(1027),
    [anon_sym_switch] = ACTIONS(1029),
    [anon_sym_LBRACE] = ACTIONS(1031),
    [anon_sym_QMARK] = ACTIONS(1033),
    [sym_dots] = ACTIONS(1035),
    [anon_sym_DASH] = ACTIONS(1037),
    [anon_sym_PLUS] = ACTIONS(1037),
    [anon_sym_BANG] = ACTIONS(1039),
    [anon_sym_TILDE] = ACTIONS(1041),
    [sym_break] = ACTIONS(1035),
    [sym_next] = ACTIONS(1035),
    [sym_true] = ACTIONS(1035),
    [sym_false] = ACTIONS(1035),
    [sym_null] = ACTIONS(1035),
    [sym_inf] = ACTIONS(1035),
    [sym_nan] = ACTIONS(1035),
    [anon_sym_NA] = ACTIONS(1043),
    [anon_sym_NA_character_] = ACTIONS(1043),
    [anon_sym_NA_complex_] = ACTIONS(1043),
    [anon_sym_NA_integer_] = ACTIONS(1043),
    [anon_sym_NA_real_] = ACTIONS(1043),
    [aux_sym_identifier_token1] = ACTIONS(1045),
    [anon_sym_BQUOTE] = ACTIONS(1047),
    [sym_integer] = ACTIONS(1049),
    [sym_float] = ACTIONS(1051),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1053),
    [anon_sym_SQUOTE] = ACTIONS(1055),
    [sym__raw_string_literal] = ACTIONS(1057),
  },
  [132] = {
    [sym_function_definition] = STATE(671),
    [sym_lambda_function] = STATE(671),
    [sym_if] = STATE(671),
    [sym_while] = STATE(671),
    [sym_repeat] = STATE(671),
    [sym_for] = STATE(671),
    [sym_switch] = STATE(671),
    [sym_call] = STATE(671),
    [sym__assignment] = STATE(671),
    [sym_left_assignment] = STATE(671),
    [sym_left_assignment2] = STATE(671),
    [sym_equals_assignment] = STATE(671),
    [sym_super_assignment] = STATE(671),
    [sym_super_right_assignment] = STATE(671),
    [sym_right_assignment] = STATE(671),
    [sym_brace_list] = STATE(671),
    [sym_paren_list] = STATE(671),
    [sym_subset] = STATE(671),
    [sym_subset2] = STATE(671),
    [sym_dollar] = STATE(671),
    [sym_slot] = STATE(671),
    [sym_namespace_get] = STATE(671),
    [sym_namespace_get_internal] = STATE(671),
    [sym_help] = STATE(671),
    [sym_pipe] = STATE(671),
    [sym_unary] = STATE(671),
    [sym_binary] = STATE(671),
    [sym_na] = STATE(671),
    [sym__expression] = STATE(671),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(671),
    [sym_string] = STATE(671),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1059),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1059),
    [sym_next] = ACTIONS(1059),
    [sym_true] = ACTIONS(1059),
    [sym_false] = ACTIONS(1059),
    [sym_null] = ACTIONS(1059),
    [sym_inf] = ACTIONS(1059),
    [sym_nan] = ACTIONS(1059),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1061),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [133] = {
    [sym_function_definition] = STATE(921),
    [sym_lambda_function] = STATE(921),
    [sym_if] = STATE(921),
    [sym_while] = STATE(921),
    [sym_repeat] = STATE(921),
    [sym_for] = STATE(921),
    [sym_switch] = STATE(921),
    [sym_call] = STATE(921),
    [sym__assignment] = STATE(921),
    [sym_left_assignment] = STATE(921),
    [sym_left_assignment2] = STATE(921),
    [sym_equals_assignment] = STATE(921),
    [sym_super_assignment] = STATE(921),
    [sym_super_right_assignment] = STATE(921),
    [sym_right_assignment] = STATE(921),
    [sym_brace_list] = STATE(921),
    [sym_paren_list] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_dollar] = STATE(921),
    [sym_slot] = STATE(921),
    [sym_namespace_get] = STATE(921),
    [sym_namespace_get_internal] = STATE(921),
    [sym_help] = STATE(921),
    [sym_pipe] = STATE(921),
    [sym_unary] = STATE(921),
    [sym_binary] = STATE(921),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(921),
    [sym_string] = STATE(921),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1063),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1063),
    [sym_next] = ACTIONS(1063),
    [sym_true] = ACTIONS(1063),
    [sym_false] = ACTIONS(1063),
    [sym_null] = ACTIONS(1063),
    [sym_inf] = ACTIONS(1063),
    [sym_nan] = ACTIONS(1063),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1065),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [134] = {
    [sym_function_definition] = STATE(936),
    [sym_lambda_function] = STATE(936),
    [sym_if] = STATE(936),
    [sym_while] = STATE(936),
    [sym_repeat] = STATE(936),
    [sym_for] = STATE(936),
    [sym_switch] = STATE(936),
    [sym_call] = STATE(936),
    [sym__assignment] = STATE(936),
    [sym_left_assignment] = STATE(936),
    [sym_left_assignment2] = STATE(936),
    [sym_equals_assignment] = STATE(936),
    [sym_super_assignment] = STATE(936),
    [sym_super_right_assignment] = STATE(936),
    [sym_right_assignment] = STATE(936),
    [sym_brace_list] = STATE(936),
    [sym_paren_list] = STATE(936),
    [sym_subset] = STATE(936),
    [sym_subset2] = STATE(936),
    [sym_dollar] = STATE(936),
    [sym_slot] = STATE(936),
    [sym_namespace_get] = STATE(936),
    [sym_namespace_get_internal] = STATE(936),
    [sym_help] = STATE(936),
    [sym_pipe] = STATE(936),
    [sym_unary] = STATE(936),
    [sym_binary] = STATE(936),
    [sym_na] = STATE(936),
    [sym__expression] = STATE(936),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(936),
    [sym_string] = STATE(936),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1067),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1067),
    [sym_next] = ACTIONS(1067),
    [sym_true] = ACTIONS(1067),
    [sym_false] = ACTIONS(1067),
    [sym_null] = ACTIONS(1067),
    [sym_inf] = ACTIONS(1067),
    [sym_nan] = ACTIONS(1067),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1069),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [135] = {
    [sym_function_definition] = STATE(614),
    [sym_lambda_function] = STATE(614),
    [sym_if] = STATE(614),
    [sym_while] = STATE(614),
    [sym_repeat] = STATE(614),
    [sym_for] = STATE(614),
    [sym_switch] = STATE(614),
    [sym_call] = STATE(614),
    [sym__assignment] = STATE(614),
    [sym_left_assignment] = STATE(614),
    [sym_left_assignment2] = STATE(614),
    [sym_equals_assignment] = STATE(614),
    [sym_super_assignment] = STATE(614),
    [sym_super_right_assignment] = STATE(614),
    [sym_right_assignment] = STATE(614),
    [sym_brace_list] = STATE(614),
    [sym_paren_list] = STATE(614),
    [sym_subset] = STATE(614),
    [sym_subset2] = STATE(614),
    [sym_dollar] = STATE(614),
    [sym_slot] = STATE(614),
    [sym_namespace_get] = STATE(614),
    [sym_namespace_get_internal] = STATE(614),
    [sym_help] = STATE(614),
    [sym_pipe] = STATE(614),
    [sym_unary] = STATE(614),
    [sym_binary] = STATE(614),
    [sym_na] = STATE(614),
    [sym__expression] = STATE(614),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(614),
    [sym_string] = STATE(614),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1071),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1071),
    [sym_next] = ACTIONS(1071),
    [sym_true] = ACTIONS(1071),
    [sym_false] = ACTIONS(1071),
    [sym_null] = ACTIONS(1071),
    [sym_inf] = ACTIONS(1071),
    [sym_nan] = ACTIONS(1071),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1073),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [136] = {
    [sym_function_definition] = STATE(920),
    [sym_lambda_function] = STATE(920),
    [sym_if] = STATE(920),
    [sym_while] = STATE(920),
    [sym_repeat] = STATE(920),
    [sym_for] = STATE(920),
    [sym_switch] = STATE(920),
    [sym_call] = STATE(920),
    [sym__assignment] = STATE(920),
    [sym_left_assignment] = STATE(920),
    [sym_left_assignment2] = STATE(920),
    [sym_equals_assignment] = STATE(920),
    [sym_super_assignment] = STATE(920),
    [sym_super_right_assignment] = STATE(920),
    [sym_right_assignment] = STATE(920),
    [sym_brace_list] = STATE(920),
    [sym_paren_list] = STATE(920),
    [sym_subset] = STATE(920),
    [sym_subset2] = STATE(920),
    [sym_dollar] = STATE(920),
    [sym_slot] = STATE(920),
    [sym_namespace_get] = STATE(920),
    [sym_namespace_get_internal] = STATE(920),
    [sym_help] = STATE(920),
    [sym_pipe] = STATE(920),
    [sym_unary] = STATE(920),
    [sym_binary] = STATE(920),
    [sym_na] = STATE(920),
    [sym__expression] = STATE(920),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(920),
    [sym_string] = STATE(920),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1075),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1075),
    [sym_next] = ACTIONS(1075),
    [sym_true] = ACTIONS(1075),
    [sym_false] = ACTIONS(1075),
    [sym_null] = ACTIONS(1075),
    [sym_inf] = ACTIONS(1075),
    [sym_nan] = ACTIONS(1075),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1077),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [137] = {
    [sym_function_definition] = STATE(931),
    [sym_lambda_function] = STATE(931),
    [sym_if] = STATE(931),
    [sym_while] = STATE(931),
    [sym_repeat] = STATE(931),
    [sym_for] = STATE(931),
    [sym_switch] = STATE(931),
    [sym_call] = STATE(931),
    [sym__assignment] = STATE(931),
    [sym_left_assignment] = STATE(931),
    [sym_left_assignment2] = STATE(931),
    [sym_equals_assignment] = STATE(931),
    [sym_super_assignment] = STATE(931),
    [sym_super_right_assignment] = STATE(931),
    [sym_right_assignment] = STATE(931),
    [sym_brace_list] = STATE(931),
    [sym_paren_list] = STATE(931),
    [sym_subset] = STATE(931),
    [sym_subset2] = STATE(931),
    [sym_dollar] = STATE(931),
    [sym_slot] = STATE(931),
    [sym_namespace_get] = STATE(931),
    [sym_namespace_get_internal] = STATE(931),
    [sym_help] = STATE(931),
    [sym_pipe] = STATE(931),
    [sym_unary] = STATE(931),
    [sym_binary] = STATE(931),
    [sym_na] = STATE(931),
    [sym__expression] = STATE(931),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(931),
    [sym_string] = STATE(931),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1079),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1079),
    [sym_next] = ACTIONS(1079),
    [sym_true] = ACTIONS(1079),
    [sym_false] = ACTIONS(1079),
    [sym_null] = ACTIONS(1079),
    [sym_inf] = ACTIONS(1079),
    [sym_nan] = ACTIONS(1079),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1081),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [138] = {
    [sym_function_definition] = STATE(909),
    [sym_lambda_function] = STATE(909),
    [sym_if] = STATE(909),
    [sym_while] = STATE(909),
    [sym_repeat] = STATE(909),
    [sym_for] = STATE(909),
    [sym_switch] = STATE(909),
    [sym_call] = STATE(909),
    [sym__assignment] = STATE(909),
    [sym_left_assignment] = STATE(909),
    [sym_left_assignment2] = STATE(909),
    [sym_equals_assignment] = STATE(909),
    [sym_super_assignment] = STATE(909),
    [sym_super_right_assignment] = STATE(909),
    [sym_right_assignment] = STATE(909),
    [sym_brace_list] = STATE(909),
    [sym_paren_list] = STATE(909),
    [sym_subset] = STATE(909),
    [sym_subset2] = STATE(909),
    [sym_dollar] = STATE(909),
    [sym_slot] = STATE(909),
    [sym_namespace_get] = STATE(909),
    [sym_namespace_get_internal] = STATE(909),
    [sym_help] = STATE(909),
    [sym_pipe] = STATE(909),
    [sym_unary] = STATE(909),
    [sym_binary] = STATE(909),
    [sym_na] = STATE(909),
    [sym__expression] = STATE(909),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(909),
    [sym_string] = STATE(909),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1083),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1083),
    [sym_next] = ACTIONS(1083),
    [sym_true] = ACTIONS(1083),
    [sym_false] = ACTIONS(1083),
    [sym_null] = ACTIONS(1083),
    [sym_inf] = ACTIONS(1083),
    [sym_nan] = ACTIONS(1083),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1085),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [139] = {
    [sym_function_definition] = STATE(932),
    [sym_lambda_function] = STATE(932),
    [sym_if] = STATE(932),
    [sym_while] = STATE(932),
    [sym_repeat] = STATE(932),
    [sym_for] = STATE(932),
    [sym_switch] = STATE(932),
    [sym_call] = STATE(932),
    [sym__assignment] = STATE(932),
    [sym_left_assignment] = STATE(932),
    [sym_left_assignment2] = STATE(932),
    [sym_equals_assignment] = STATE(932),
    [sym_super_assignment] = STATE(932),
    [sym_super_right_assignment] = STATE(932),
    [sym_right_assignment] = STATE(932),
    [sym_brace_list] = STATE(932),
    [sym_paren_list] = STATE(932),
    [sym_subset] = STATE(932),
    [sym_subset2] = STATE(932),
    [sym_dollar] = STATE(932),
    [sym_slot] = STATE(932),
    [sym_namespace_get] = STATE(932),
    [sym_namespace_get_internal] = STATE(932),
    [sym_help] = STATE(932),
    [sym_pipe] = STATE(932),
    [sym_unary] = STATE(932),
    [sym_binary] = STATE(932),
    [sym_na] = STATE(932),
    [sym__expression] = STATE(932),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(932),
    [sym_string] = STATE(932),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1087),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1087),
    [sym_next] = ACTIONS(1087),
    [sym_true] = ACTIONS(1087),
    [sym_false] = ACTIONS(1087),
    [sym_null] = ACTIONS(1087),
    [sym_inf] = ACTIONS(1087),
    [sym_nan] = ACTIONS(1087),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1089),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [140] = {
    [sym_function_definition] = STATE(912),
    [sym_lambda_function] = STATE(912),
    [sym_if] = STATE(912),
    [sym_while] = STATE(912),
    [sym_repeat] = STATE(912),
    [sym_for] = STATE(912),
    [sym_switch] = STATE(912),
    [sym_call] = STATE(912),
    [sym__assignment] = STATE(912),
    [sym_left_assignment] = STATE(912),
    [sym_left_assignment2] = STATE(912),
    [sym_equals_assignment] = STATE(912),
    [sym_super_assignment] = STATE(912),
    [sym_super_right_assignment] = STATE(912),
    [sym_right_assignment] = STATE(912),
    [sym_brace_list] = STATE(912),
    [sym_paren_list] = STATE(912),
    [sym_subset] = STATE(912),
    [sym_subset2] = STATE(912),
    [sym_dollar] = STATE(912),
    [sym_slot] = STATE(912),
    [sym_namespace_get] = STATE(912),
    [sym_namespace_get_internal] = STATE(912),
    [sym_help] = STATE(912),
    [sym_pipe] = STATE(912),
    [sym_unary] = STATE(912),
    [sym_binary] = STATE(912),
    [sym_na] = STATE(912),
    [sym__expression] = STATE(912),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(912),
    [sym_string] = STATE(912),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1091),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1091),
    [sym_next] = ACTIONS(1091),
    [sym_true] = ACTIONS(1091),
    [sym_false] = ACTIONS(1091),
    [sym_null] = ACTIONS(1091),
    [sym_inf] = ACTIONS(1091),
    [sym_nan] = ACTIONS(1091),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1093),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [141] = {
    [sym_function_definition] = STATE(938),
    [sym_lambda_function] = STATE(938),
    [sym_if] = STATE(938),
    [sym_while] = STATE(938),
    [sym_repeat] = STATE(938),
    [sym_for] = STATE(938),
    [sym_switch] = STATE(938),
    [sym_call] = STATE(938),
    [sym__assignment] = STATE(938),
    [sym_left_assignment] = STATE(938),
    [sym_left_assignment2] = STATE(938),
    [sym_equals_assignment] = STATE(938),
    [sym_super_assignment] = STATE(938),
    [sym_super_right_assignment] = STATE(938),
    [sym_right_assignment] = STATE(938),
    [sym_brace_list] = STATE(938),
    [sym_paren_list] = STATE(938),
    [sym_subset] = STATE(938),
    [sym_subset2] = STATE(938),
    [sym_dollar] = STATE(938),
    [sym_slot] = STATE(938),
    [sym_namespace_get] = STATE(938),
    [sym_namespace_get_internal] = STATE(938),
    [sym_help] = STATE(938),
    [sym_pipe] = STATE(938),
    [sym_unary] = STATE(938),
    [sym_binary] = STATE(938),
    [sym_na] = STATE(938),
    [sym__expression] = STATE(938),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(938),
    [sym_string] = STATE(938),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1095),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1095),
    [sym_next] = ACTIONS(1095),
    [sym_true] = ACTIONS(1095),
    [sym_false] = ACTIONS(1095),
    [sym_null] = ACTIONS(1095),
    [sym_inf] = ACTIONS(1095),
    [sym_nan] = ACTIONS(1095),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1097),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [142] = {
    [sym_function_definition] = STATE(677),
    [sym_lambda_function] = STATE(677),
    [sym_if] = STATE(677),
    [sym_while] = STATE(677),
    [sym_repeat] = STATE(677),
    [sym_for] = STATE(677),
    [sym_switch] = STATE(677),
    [sym_call] = STATE(677),
    [sym__assignment] = STATE(677),
    [sym_left_assignment] = STATE(677),
    [sym_left_assignment2] = STATE(677),
    [sym_equals_assignment] = STATE(677),
    [sym_super_assignment] = STATE(677),
    [sym_super_right_assignment] = STATE(677),
    [sym_right_assignment] = STATE(677),
    [sym_brace_list] = STATE(677),
    [sym_paren_list] = STATE(677),
    [sym_subset] = STATE(677),
    [sym_subset2] = STATE(677),
    [sym_dollar] = STATE(677),
    [sym_slot] = STATE(677),
    [sym_namespace_get] = STATE(677),
    [sym_namespace_get_internal] = STATE(677),
    [sym_help] = STATE(677),
    [sym_pipe] = STATE(677),
    [sym_unary] = STATE(677),
    [sym_binary] = STATE(677),
    [sym_na] = STATE(677),
    [sym__expression] = STATE(677),
    [sym_identifier] = STATE(414),
    [sym_complex] = STATE(677),
    [sym_string] = STATE(677),
    [anon_sym_function] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1101),
    [anon_sym_if] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1107),
    [anon_sym_repeat] = ACTIONS(1109),
    [anon_sym_for] = ACTIONS(1111),
    [anon_sym_switch] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_QMARK] = ACTIONS(1117),
    [sym_dots] = ACTIONS(1119),
    [anon_sym_DASH] = ACTIONS(1121),
    [anon_sym_PLUS] = ACTIONS(1121),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1125),
    [sym_break] = ACTIONS(1119),
    [sym_next] = ACTIONS(1119),
    [sym_true] = ACTIONS(1119),
    [sym_false] = ACTIONS(1119),
    [sym_null] = ACTIONS(1119),
    [sym_inf] = ACTIONS(1119),
    [sym_nan] = ACTIONS(1119),
    [anon_sym_NA] = ACTIONS(1127),
    [anon_sym_NA_character_] = ACTIONS(1127),
    [anon_sym_NA_complex_] = ACTIONS(1127),
    [anon_sym_NA_integer_] = ACTIONS(1127),
    [anon_sym_NA_real_] = ACTIONS(1127),
    [aux_sym_identifier_token1] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1131),
    [sym_integer] = ACTIONS(1133),
    [sym_float] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1139),
    [sym__raw_string_literal] = ACTIONS(1141),
  },
  [143] = {
    [sym_function_definition] = STATE(590),
    [sym_lambda_function] = STATE(590),
    [sym_if] = STATE(590),
    [sym_while] = STATE(590),
    [sym_repeat] = STATE(590),
    [sym_for] = STATE(590),
    [sym_switch] = STATE(590),
    [sym_call] = STATE(590),
    [sym__assignment] = STATE(590),
    [sym_left_assignment] = STATE(590),
    [sym_left_assignment2] = STATE(590),
    [sym_equals_assignment] = STATE(590),
    [sym_super_assignment] = STATE(590),
    [sym_super_right_assignment] = STATE(590),
    [sym_right_assignment] = STATE(590),
    [sym_brace_list] = STATE(590),
    [sym_paren_list] = STATE(590),
    [sym_subset] = STATE(590),
    [sym_subset2] = STATE(590),
    [sym_dollar] = STATE(590),
    [sym_slot] = STATE(590),
    [sym_namespace_get] = STATE(590),
    [sym_namespace_get_internal] = STATE(590),
    [sym_help] = STATE(590),
    [sym_pipe] = STATE(590),
    [sym_unary] = STATE(590),
    [sym_binary] = STATE(590),
    [sym_na] = STATE(590),
    [sym__expression] = STATE(590),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(590),
    [sym_string] = STATE(590),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1143),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1143),
    [sym_next] = ACTIONS(1143),
    [sym_true] = ACTIONS(1143),
    [sym_false] = ACTIONS(1143),
    [sym_null] = ACTIONS(1143),
    [sym_inf] = ACTIONS(1143),
    [sym_nan] = ACTIONS(1143),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1145),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [144] = {
    [sym_function_definition] = STATE(929),
    [sym_lambda_function] = STATE(929),
    [sym_if] = STATE(929),
    [sym_while] = STATE(929),
    [sym_repeat] = STATE(929),
    [sym_for] = STATE(929),
    [sym_switch] = STATE(929),
    [sym_call] = STATE(929),
    [sym__assignment] = STATE(929),
    [sym_left_assignment] = STATE(929),
    [sym_left_assignment2] = STATE(929),
    [sym_equals_assignment] = STATE(929),
    [sym_super_assignment] = STATE(929),
    [sym_super_right_assignment] = STATE(929),
    [sym_right_assignment] = STATE(929),
    [sym_brace_list] = STATE(929),
    [sym_paren_list] = STATE(929),
    [sym_subset] = STATE(929),
    [sym_subset2] = STATE(929),
    [sym_dollar] = STATE(929),
    [sym_slot] = STATE(929),
    [sym_namespace_get] = STATE(929),
    [sym_namespace_get_internal] = STATE(929),
    [sym_help] = STATE(929),
    [sym_pipe] = STATE(929),
    [sym_unary] = STATE(929),
    [sym_binary] = STATE(929),
    [sym_na] = STATE(929),
    [sym__expression] = STATE(929),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(929),
    [sym_string] = STATE(929),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1147),
    [sym_next] = ACTIONS(1147),
    [sym_true] = ACTIONS(1147),
    [sym_false] = ACTIONS(1147),
    [sym_null] = ACTIONS(1147),
    [sym_inf] = ACTIONS(1147),
    [sym_nan] = ACTIONS(1147),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1149),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [145] = {
    [sym_function_definition] = STATE(409),
    [sym_lambda_function] = STATE(409),
    [sym_if] = STATE(409),
    [sym_while] = STATE(409),
    [sym_repeat] = STATE(409),
    [sym_for] = STATE(409),
    [sym_switch] = STATE(409),
    [sym_call] = STATE(409),
    [sym__assignment] = STATE(409),
    [sym_left_assignment] = STATE(409),
    [sym_left_assignment2] = STATE(409),
    [sym_equals_assignment] = STATE(409),
    [sym_super_assignment] = STATE(409),
    [sym_super_right_assignment] = STATE(409),
    [sym_right_assignment] = STATE(409),
    [sym_brace_list] = STATE(409),
    [sym_paren_list] = STATE(409),
    [sym_subset] = STATE(409),
    [sym_subset2] = STATE(409),
    [sym_dollar] = STATE(409),
    [sym_slot] = STATE(409),
    [sym_namespace_get] = STATE(409),
    [sym_namespace_get_internal] = STATE(409),
    [sym_help] = STATE(409),
    [sym_pipe] = STATE(409),
    [sym_unary] = STATE(409),
    [sym_binary] = STATE(409),
    [sym_na] = STATE(409),
    [sym__expression] = STATE(409),
    [sym_identifier] = STATE(372),
    [sym_complex] = STATE(409),
    [sym_string] = STATE(409),
    [anon_sym_function] = ACTIONS(1015),
    [anon_sym_BSLASH] = ACTIONS(1017),
    [anon_sym_if] = ACTIONS(1019),
    [anon_sym_LPAREN] = ACTIONS(1021),
    [anon_sym_while] = ACTIONS(1023),
    [anon_sym_repeat] = ACTIONS(1025),
    [anon_sym_for] = ACTIONS(1027),
    [anon_sym_switch] = ACTIONS(1029),
    [anon_sym_LBRACE] = ACTIONS(1031),
    [anon_sym_QMARK] = ACTIONS(1033),
    [sym_dots] = ACTIONS(1151),
    [anon_sym_DASH] = ACTIONS(1037),
    [anon_sym_PLUS] = ACTIONS(1037),
    [anon_sym_BANG] = ACTIONS(1039),
    [anon_sym_TILDE] = ACTIONS(1041),
    [sym_break] = ACTIONS(1151),
    [sym_next] = ACTIONS(1151),
    [sym_true] = ACTIONS(1151),
    [sym_false] = ACTIONS(1151),
    [sym_null] = ACTIONS(1151),
    [sym_inf] = ACTIONS(1151),
    [sym_nan] = ACTIONS(1151),
    [anon_sym_NA] = ACTIONS(1043),
    [anon_sym_NA_character_] = ACTIONS(1043),
    [anon_sym_NA_complex_] = ACTIONS(1043),
    [anon_sym_NA_integer_] = ACTIONS(1043),
    [anon_sym_NA_real_] = ACTIONS(1043),
    [aux_sym_identifier_token1] = ACTIONS(1045),
    [anon_sym_BQUOTE] = ACTIONS(1047),
    [sym_integer] = ACTIONS(1153),
    [sym_float] = ACTIONS(1051),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1053),
    [anon_sym_SQUOTE] = ACTIONS(1055),
    [sym__raw_string_literal] = ACTIONS(1057),
  },
  [146] = {
    [sym_function_definition] = STATE(922),
    [sym_lambda_function] = STATE(922),
    [sym_if] = STATE(922),
    [sym_while] = STATE(922),
    [sym_repeat] = STATE(922),
    [sym_for] = STATE(922),
    [sym_switch] = STATE(922),
    [sym_call] = STATE(922),
    [sym__assignment] = STATE(922),
    [sym_left_assignment] = STATE(922),
    [sym_left_assignment2] = STATE(922),
    [sym_equals_assignment] = STATE(922),
    [sym_super_assignment] = STATE(922),
    [sym_super_right_assignment] = STATE(922),
    [sym_right_assignment] = STATE(922),
    [sym_brace_list] = STATE(922),
    [sym_paren_list] = STATE(922),
    [sym_subset] = STATE(922),
    [sym_subset2] = STATE(922),
    [sym_dollar] = STATE(922),
    [sym_slot] = STATE(922),
    [sym_namespace_get] = STATE(922),
    [sym_namespace_get_internal] = STATE(922),
    [sym_help] = STATE(922),
    [sym_pipe] = STATE(922),
    [sym_unary] = STATE(922),
    [sym_binary] = STATE(922),
    [sym_na] = STATE(922),
    [sym__expression] = STATE(922),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(922),
    [sym_string] = STATE(922),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1155),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1155),
    [sym_next] = ACTIONS(1155),
    [sym_true] = ACTIONS(1155),
    [sym_false] = ACTIONS(1155),
    [sym_null] = ACTIONS(1155),
    [sym_inf] = ACTIONS(1155),
    [sym_nan] = ACTIONS(1155),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1157),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [147] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_help] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1159),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1159),
    [sym_next] = ACTIONS(1159),
    [sym_true] = ACTIONS(1159),
    [sym_false] = ACTIONS(1159),
    [sym_null] = ACTIONS(1159),
    [sym_inf] = ACTIONS(1159),
    [sym_nan] = ACTIONS(1159),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1161),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [148] = {
    [sym_function_definition] = STATE(517),
    [sym_lambda_function] = STATE(517),
    [sym_if] = STATE(517),
    [sym_while] = STATE(517),
    [sym_repeat] = STATE(517),
    [sym_for] = STATE(517),
    [sym_switch] = STATE(517),
    [sym_call] = STATE(517),
    [sym__assignment] = STATE(517),
    [sym_left_assignment] = STATE(517),
    [sym_left_assignment2] = STATE(517),
    [sym_equals_assignment] = STATE(517),
    [sym_super_assignment] = STATE(517),
    [sym_super_right_assignment] = STATE(517),
    [sym_right_assignment] = STATE(517),
    [sym_brace_list] = STATE(517),
    [sym_paren_list] = STATE(517),
    [sym_subset] = STATE(517),
    [sym_subset2] = STATE(517),
    [sym_dollar] = STATE(517),
    [sym_slot] = STATE(517),
    [sym_namespace_get] = STATE(517),
    [sym_namespace_get_internal] = STATE(517),
    [sym_help] = STATE(517),
    [sym_pipe] = STATE(517),
    [sym_unary] = STATE(517),
    [sym_binary] = STATE(517),
    [sym_na] = STATE(517),
    [sym__expression] = STATE(517),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(517),
    [sym_string] = STATE(517),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1163),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1163),
    [sym_next] = ACTIONS(1163),
    [sym_true] = ACTIONS(1163),
    [sym_false] = ACTIONS(1163),
    [sym_null] = ACTIONS(1163),
    [sym_inf] = ACTIONS(1163),
    [sym_nan] = ACTIONS(1163),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1165),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [149] = {
    [sym_function_definition] = STATE(550),
    [sym_lambda_function] = STATE(550),
    [sym_if] = STATE(550),
    [sym_while] = STATE(550),
    [sym_repeat] = STATE(550),
    [sym_for] = STATE(550),
    [sym_switch] = STATE(550),
    [sym_call] = STATE(550),
    [sym__assignment] = STATE(550),
    [sym_left_assignment] = STATE(550),
    [sym_left_assignment2] = STATE(550),
    [sym_equals_assignment] = STATE(550),
    [sym_super_assignment] = STATE(550),
    [sym_super_right_assignment] = STATE(550),
    [sym_right_assignment] = STATE(550),
    [sym_brace_list] = STATE(550),
    [sym_paren_list] = STATE(550),
    [sym_subset] = STATE(550),
    [sym_subset2] = STATE(550),
    [sym_dollar] = STATE(550),
    [sym_slot] = STATE(550),
    [sym_namespace_get] = STATE(550),
    [sym_namespace_get_internal] = STATE(550),
    [sym_help] = STATE(550),
    [sym_pipe] = STATE(550),
    [sym_unary] = STATE(550),
    [sym_binary] = STATE(550),
    [sym_na] = STATE(550),
    [sym__expression] = STATE(550),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(550),
    [sym_string] = STATE(550),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1167),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1167),
    [sym_next] = ACTIONS(1167),
    [sym_true] = ACTIONS(1167),
    [sym_false] = ACTIONS(1167),
    [sym_null] = ACTIONS(1167),
    [sym_inf] = ACTIONS(1167),
    [sym_nan] = ACTIONS(1167),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1169),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [150] = {
    [sym_function_definition] = STATE(572),
    [sym_lambda_function] = STATE(572),
    [sym_if] = STATE(572),
    [sym_while] = STATE(572),
    [sym_repeat] = STATE(572),
    [sym_for] = STATE(572),
    [sym_switch] = STATE(572),
    [sym_call] = STATE(572),
    [sym__assignment] = STATE(572),
    [sym_left_assignment] = STATE(572),
    [sym_left_assignment2] = STATE(572),
    [sym_equals_assignment] = STATE(572),
    [sym_super_assignment] = STATE(572),
    [sym_super_right_assignment] = STATE(572),
    [sym_right_assignment] = STATE(572),
    [sym_brace_list] = STATE(572),
    [sym_paren_list] = STATE(572),
    [sym_subset] = STATE(572),
    [sym_subset2] = STATE(572),
    [sym_dollar] = STATE(572),
    [sym_slot] = STATE(572),
    [sym_namespace_get] = STATE(572),
    [sym_namespace_get_internal] = STATE(572),
    [sym_help] = STATE(572),
    [sym_pipe] = STATE(572),
    [sym_unary] = STATE(572),
    [sym_binary] = STATE(572),
    [sym_na] = STATE(572),
    [sym__expression] = STATE(572),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(572),
    [sym_string] = STATE(572),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1171),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1171),
    [sym_next] = ACTIONS(1171),
    [sym_true] = ACTIONS(1171),
    [sym_false] = ACTIONS(1171),
    [sym_null] = ACTIONS(1171),
    [sym_inf] = ACTIONS(1171),
    [sym_nan] = ACTIONS(1171),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1173),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [151] = {
    [sym_function_definition] = STATE(573),
    [sym_lambda_function] = STATE(573),
    [sym_if] = STATE(573),
    [sym_while] = STATE(573),
    [sym_repeat] = STATE(573),
    [sym_for] = STATE(573),
    [sym_switch] = STATE(573),
    [sym_call] = STATE(573),
    [sym__assignment] = STATE(573),
    [sym_left_assignment] = STATE(573),
    [sym_left_assignment2] = STATE(573),
    [sym_equals_assignment] = STATE(573),
    [sym_super_assignment] = STATE(573),
    [sym_super_right_assignment] = STATE(573),
    [sym_right_assignment] = STATE(573),
    [sym_brace_list] = STATE(573),
    [sym_paren_list] = STATE(573),
    [sym_subset] = STATE(573),
    [sym_subset2] = STATE(573),
    [sym_dollar] = STATE(573),
    [sym_slot] = STATE(573),
    [sym_namespace_get] = STATE(573),
    [sym_namespace_get_internal] = STATE(573),
    [sym_help] = STATE(573),
    [sym_pipe] = STATE(573),
    [sym_unary] = STATE(573),
    [sym_binary] = STATE(573),
    [sym_na] = STATE(573),
    [sym__expression] = STATE(573),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(573),
    [sym_string] = STATE(573),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1175),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1175),
    [sym_next] = ACTIONS(1175),
    [sym_true] = ACTIONS(1175),
    [sym_false] = ACTIONS(1175),
    [sym_null] = ACTIONS(1175),
    [sym_inf] = ACTIONS(1175),
    [sym_nan] = ACTIONS(1175),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1177),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [152] = {
    [sym_function_definition] = STATE(917),
    [sym_lambda_function] = STATE(917),
    [sym_if] = STATE(917),
    [sym_while] = STATE(917),
    [sym_repeat] = STATE(917),
    [sym_for] = STATE(917),
    [sym_switch] = STATE(917),
    [sym_call] = STATE(917),
    [sym__assignment] = STATE(917),
    [sym_left_assignment] = STATE(917),
    [sym_left_assignment2] = STATE(917),
    [sym_equals_assignment] = STATE(917),
    [sym_super_assignment] = STATE(917),
    [sym_super_right_assignment] = STATE(917),
    [sym_right_assignment] = STATE(917),
    [sym_brace_list] = STATE(917),
    [sym_paren_list] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_dollar] = STATE(917),
    [sym_slot] = STATE(917),
    [sym_namespace_get] = STATE(917),
    [sym_namespace_get_internal] = STATE(917),
    [sym_help] = STATE(917),
    [sym_pipe] = STATE(917),
    [sym_unary] = STATE(917),
    [sym_binary] = STATE(917),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(917),
    [sym_string] = STATE(917),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1179),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1179),
    [sym_next] = ACTIONS(1179),
    [sym_true] = ACTIONS(1179),
    [sym_false] = ACTIONS(1179),
    [sym_null] = ACTIONS(1179),
    [sym_inf] = ACTIONS(1179),
    [sym_nan] = ACTIONS(1179),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1181),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [153] = {
    [sym_function_definition] = STATE(924),
    [sym_lambda_function] = STATE(924),
    [sym_if] = STATE(924),
    [sym_while] = STATE(924),
    [sym_repeat] = STATE(924),
    [sym_for] = STATE(924),
    [sym_switch] = STATE(924),
    [sym_call] = STATE(924),
    [sym__assignment] = STATE(924),
    [sym_left_assignment] = STATE(924),
    [sym_left_assignment2] = STATE(924),
    [sym_equals_assignment] = STATE(924),
    [sym_super_assignment] = STATE(924),
    [sym_super_right_assignment] = STATE(924),
    [sym_right_assignment] = STATE(924),
    [sym_brace_list] = STATE(924),
    [sym_paren_list] = STATE(924),
    [sym_subset] = STATE(924),
    [sym_subset2] = STATE(924),
    [sym_dollar] = STATE(924),
    [sym_slot] = STATE(924),
    [sym_namespace_get] = STATE(924),
    [sym_namespace_get_internal] = STATE(924),
    [sym_help] = STATE(924),
    [sym_pipe] = STATE(924),
    [sym_unary] = STATE(924),
    [sym_binary] = STATE(924),
    [sym_na] = STATE(924),
    [sym__expression] = STATE(924),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(924),
    [sym_string] = STATE(924),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1183),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1183),
    [sym_next] = ACTIONS(1183),
    [sym_true] = ACTIONS(1183),
    [sym_false] = ACTIONS(1183),
    [sym_null] = ACTIONS(1183),
    [sym_inf] = ACTIONS(1183),
    [sym_nan] = ACTIONS(1183),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1185),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [154] = {
    [sym_function_definition] = STATE(407),
    [sym_lambda_function] = STATE(407),
    [sym_if] = STATE(407),
    [sym_while] = STATE(407),
    [sym_repeat] = STATE(407),
    [sym_for] = STATE(407),
    [sym_switch] = STATE(407),
    [sym_call] = STATE(407),
    [sym__assignment] = STATE(407),
    [sym_left_assignment] = STATE(407),
    [sym_left_assignment2] = STATE(407),
    [sym_equals_assignment] = STATE(407),
    [sym_super_assignment] = STATE(407),
    [sym_super_right_assignment] = STATE(407),
    [sym_right_assignment] = STATE(407),
    [sym_brace_list] = STATE(407),
    [sym_paren_list] = STATE(407),
    [sym_subset] = STATE(407),
    [sym_subset2] = STATE(407),
    [sym_dollar] = STATE(407),
    [sym_slot] = STATE(407),
    [sym_namespace_get] = STATE(407),
    [sym_namespace_get_internal] = STATE(407),
    [sym_help] = STATE(407),
    [sym_pipe] = STATE(407),
    [sym_unary] = STATE(407),
    [sym_binary] = STATE(407),
    [sym_na] = STATE(407),
    [sym__expression] = STATE(407),
    [sym_identifier] = STATE(307),
    [sym_complex] = STATE(407),
    [sym_string] = STATE(407),
    [anon_sym_function] = ACTIONS(871),
    [anon_sym_BSLASH] = ACTIONS(873),
    [anon_sym_if] = ACTIONS(875),
    [anon_sym_LPAREN] = ACTIONS(877),
    [anon_sym_while] = ACTIONS(879),
    [anon_sym_repeat] = ACTIONS(881),
    [anon_sym_for] = ACTIONS(883),
    [anon_sym_switch] = ACTIONS(885),
    [anon_sym_LBRACE] = ACTIONS(887),
    [anon_sym_QMARK] = ACTIONS(889),
    [sym_dots] = ACTIONS(1187),
    [anon_sym_DASH] = ACTIONS(893),
    [anon_sym_PLUS] = ACTIONS(893),
    [anon_sym_BANG] = ACTIONS(895),
    [anon_sym_TILDE] = ACTIONS(897),
    [sym_break] = ACTIONS(1187),
    [sym_next] = ACTIONS(1187),
    [sym_true] = ACTIONS(1187),
    [sym_false] = ACTIONS(1187),
    [sym_null] = ACTIONS(1187),
    [sym_inf] = ACTIONS(1187),
    [sym_nan] = ACTIONS(1187),
    [anon_sym_NA] = ACTIONS(899),
    [anon_sym_NA_character_] = ACTIONS(899),
    [anon_sym_NA_complex_] = ACTIONS(899),
    [anon_sym_NA_integer_] = ACTIONS(899),
    [anon_sym_NA_real_] = ACTIONS(899),
    [aux_sym_identifier_token1] = ACTIONS(901),
    [anon_sym_BQUOTE] = ACTIONS(903),
    [sym_integer] = ACTIONS(1189),
    [sym_float] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(909),
    [anon_sym_SQUOTE] = ACTIONS(911),
    [sym__raw_string_literal] = ACTIONS(913),
  },
  [155] = {
    [sym_function_definition] = STATE(930),
    [sym_lambda_function] = STATE(930),
    [sym_if] = STATE(930),
    [sym_while] = STATE(930),
    [sym_repeat] = STATE(930),
    [sym_for] = STATE(930),
    [sym_switch] = STATE(930),
    [sym_call] = STATE(930),
    [sym__assignment] = STATE(930),
    [sym_left_assignment] = STATE(930),
    [sym_left_assignment2] = STATE(930),
    [sym_equals_assignment] = STATE(930),
    [sym_super_assignment] = STATE(930),
    [sym_super_right_assignment] = STATE(930),
    [sym_right_assignment] = STATE(930),
    [sym_brace_list] = STATE(930),
    [sym_paren_list] = STATE(930),
    [sym_subset] = STATE(930),
    [sym_subset2] = STATE(930),
    [sym_dollar] = STATE(930),
    [sym_slot] = STATE(930),
    [sym_namespace_get] = STATE(930),
    [sym_namespace_get_internal] = STATE(930),
    [sym_help] = STATE(930),
    [sym_pipe] = STATE(930),
    [sym_unary] = STATE(930),
    [sym_binary] = STATE(930),
    [sym_na] = STATE(930),
    [sym__expression] = STATE(930),
    [sym_identifier] = STATE(845),
    [sym_complex] = STATE(930),
    [sym_string] = STATE(930),
    [anon_sym_function] = ACTIONS(795),
    [anon_sym_BSLASH] = ACTIONS(797),
    [anon_sym_if] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(803),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_for] = ACTIONS(807),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_QMARK] = ACTIONS(813),
    [sym_dots] = ACTIONS(1191),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_TILDE] = ACTIONS(821),
    [sym_break] = ACTIONS(1191),
    [sym_next] = ACTIONS(1191),
    [sym_true] = ACTIONS(1191),
    [sym_false] = ACTIONS(1191),
    [sym_null] = ACTIONS(1191),
    [sym_inf] = ACTIONS(1191),
    [sym_nan] = ACTIONS(1191),
    [anon_sym_NA] = ACTIONS(823),
    [anon_sym_NA_character_] = ACTIONS(823),
    [anon_sym_NA_complex_] = ACTIONS(823),
    [anon_sym_NA_integer_] = ACTIONS(823),
    [anon_sym_NA_real_] = ACTIONS(823),
    [aux_sym_identifier_token1] = ACTIONS(825),
    [anon_sym_BQUOTE] = ACTIONS(827),
    [sym_integer] = ACTIONS(1193),
    [sym_float] = ACTIONS(831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_SQUOTE] = ACTIONS(835),
    [sym__raw_string_literal] = ACTIONS(837),
  },
  [156] = {
    [sym_function_definition] = STATE(408),
    [sym_lambda_function] = STATE(408),
    [sym_if] = STATE(408),
    [sym_while] = STATE(408),
    [sym_repeat] = STATE(408),
    [sym_for] = STATE(408),
    [sym_switch] = STATE(408),
    [sym_call] = STATE(408),
    [sym__assignment] = STATE(408),
    [sym_left_assignment] = STATE(408),
    [sym_left_assignment2] = STATE(408),
    [sym_equals_assignment] = STATE(408),
    [sym_super_assignment] = STATE(408),
    [sym_super_right_assignment] = STATE(408),
    [sym_right_assignment] = STATE(408),
    [sym_brace_list] = STATE(408),
    [sym_paren_list] = STATE(408),
    [sym_subset] = STATE(408),
    [sym_subset2] = STATE(408),
    [sym_dollar] = STATE(408),
    [sym_slot] = STATE(408),
    [sym_namespace_get] = STATE(408),
    [sym_namespace_get_internal] = STATE(408),
    [sym_help] = STATE(408),
    [sym_pipe] = STATE(408),
    [sym_unary] = STATE(408),
    [sym_binary] = STATE(408),
    [sym_na] = STATE(408),
    [sym__expression] = STATE(408),
    [sym_identifier] = STATE(332),
    [sym_complex] = STATE(408),
    [sym_string] = STATE(408),
    [anon_sym_function] = ACTIONS(1195),
    [anon_sym_BSLASH] = ACTIONS(1197),
    [anon_sym_if] = ACTIONS(1199),
    [anon_sym_LPAREN] = ACTIONS(1201),
    [anon_sym_while] = ACTIONS(1203),
    [anon_sym_repeat] = ACTIONS(1205),
    [anon_sym_for] = ACTIONS(1207),
    [anon_sym_switch] = ACTIONS(1209),
    [anon_sym_LBRACE] = ACTIONS(1211),
    [anon_sym_QMARK] = ACTIONS(1213),
    [sym_dots] = ACTIONS(1215),
    [anon_sym_DASH] = ACTIONS(1217),
    [anon_sym_PLUS] = ACTIONS(1217),
    [anon_sym_BANG] = ACTIONS(1219),
    [anon_sym_TILDE] = ACTIONS(1221),
    [sym_break] = ACTIONS(1215),
    [sym_next] = ACTIONS(1215),
    [sym_true] = ACTIONS(1215),
    [sym_false] = ACTIONS(1215),
    [sym_null] = ACTIONS(1215),
    [sym_inf] = ACTIONS(1215),
    [sym_nan] = ACTIONS(1215),
    [anon_sym_NA] = ACTIONS(1223),
    [anon_sym_NA_character_] = ACTIONS(1223),
    [anon_sym_NA_complex_] = ACTIONS(1223),
    [anon_sym_NA_integer_] = ACTIONS(1223),
    [anon_sym_NA_real_] = ACTIONS(1223),
    [aux_sym_identifier_token1] = ACTIONS(1225),
    [anon_sym_BQUOTE] = ACTIONS(1227),
    [sym_integer] = ACTIONS(1229),
    [sym_float] = ACTIONS(1231),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1233),
    [anon_sym_SQUOTE] = ACTIONS(1235),
    [sym__raw_string_literal] = ACTIONS(1237),
  },
  [157] = {
    [sym_function_definition] = STATE(616),
    [sym_lambda_function] = STATE(616),
    [sym_if] = STATE(616),
    [sym_while] = STATE(616),
    [sym_repeat] = STATE(616),
    [sym_for] = STATE(616),
    [sym_switch] = STATE(616),
    [sym_call] = STATE(616),
    [sym__assignment] = STATE(616),
    [sym_left_assignment] = STATE(616),
    [sym_left_assignment2] = STATE(616),
    [sym_equals_assignment] = STATE(616),
    [sym_super_assignment] = STATE(616),
    [sym_super_right_assignment] = STATE(616),
    [sym_right_assignment] = STATE(616),
    [sym_brace_list] = STATE(616),
    [sym_paren_list] = STATE(616),
    [sym_subset] = STATE(616),
    [sym_subset2] = STATE(616),
    [sym_dollar] = STATE(616),
    [sym_slot] = STATE(616),
    [sym_namespace_get] = STATE(616),
    [sym_namespace_get_internal] = STATE(616),
    [sym_help] = STATE(616),
    [sym_pipe] = STATE(616),
    [sym_unary] = STATE(616),
    [sym_binary] = STATE(616),
    [sym_na] = STATE(616),
    [sym__expression] = STATE(616),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(616),
    [sym_string] = STATE(616),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1239),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1239),
    [sym_next] = ACTIONS(1239),
    [sym_true] = ACTIONS(1239),
    [sym_false] = ACTIONS(1239),
    [sym_null] = ACTIONS(1239),
    [sym_inf] = ACTIONS(1239),
    [sym_nan] = ACTIONS(1239),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1241),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [158] = {
    [sym_function_definition] = STATE(630),
    [sym_lambda_function] = STATE(630),
    [sym_if] = STATE(630),
    [sym_while] = STATE(630),
    [sym_repeat] = STATE(630),
    [sym_for] = STATE(630),
    [sym_switch] = STATE(630),
    [sym_call] = STATE(630),
    [sym__assignment] = STATE(630),
    [sym_left_assignment] = STATE(630),
    [sym_left_assignment2] = STATE(630),
    [sym_equals_assignment] = STATE(630),
    [sym_super_assignment] = STATE(630),
    [sym_super_right_assignment] = STATE(630),
    [sym_right_assignment] = STATE(630),
    [sym_brace_list] = STATE(630),
    [sym_paren_list] = STATE(630),
    [sym_subset] = STATE(630),
    [sym_subset2] = STATE(630),
    [sym_dollar] = STATE(630),
    [sym_slot] = STATE(630),
    [sym_namespace_get] = STATE(630),
    [sym_namespace_get_internal] = STATE(630),
    [sym_help] = STATE(630),
    [sym_pipe] = STATE(630),
    [sym_unary] = STATE(630),
    [sym_binary] = STATE(630),
    [sym_na] = STATE(630),
    [sym__expression] = STATE(630),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(630),
    [sym_string] = STATE(630),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1243),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1243),
    [sym_next] = ACTIONS(1243),
    [sym_true] = ACTIONS(1243),
    [sym_false] = ACTIONS(1243),
    [sym_null] = ACTIONS(1243),
    [sym_inf] = ACTIONS(1243),
    [sym_nan] = ACTIONS(1243),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1245),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [159] = {
    [sym_function_definition] = STATE(631),
    [sym_lambda_function] = STATE(631),
    [sym_if] = STATE(631),
    [sym_while] = STATE(631),
    [sym_repeat] = STATE(631),
    [sym_for] = STATE(631),
    [sym_switch] = STATE(631),
    [sym_call] = STATE(631),
    [sym__assignment] = STATE(631),
    [sym_left_assignment] = STATE(631),
    [sym_left_assignment2] = STATE(631),
    [sym_equals_assignment] = STATE(631),
    [sym_super_assignment] = STATE(631),
    [sym_super_right_assignment] = STATE(631),
    [sym_right_assignment] = STATE(631),
    [sym_brace_list] = STATE(631),
    [sym_paren_list] = STATE(631),
    [sym_subset] = STATE(631),
    [sym_subset2] = STATE(631),
    [sym_dollar] = STATE(631),
    [sym_slot] = STATE(631),
    [sym_namespace_get] = STATE(631),
    [sym_namespace_get_internal] = STATE(631),
    [sym_help] = STATE(631),
    [sym_pipe] = STATE(631),
    [sym_unary] = STATE(631),
    [sym_binary] = STATE(631),
    [sym_na] = STATE(631),
    [sym__expression] = STATE(631),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(631),
    [sym_string] = STATE(631),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1247),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1247),
    [sym_next] = ACTIONS(1247),
    [sym_true] = ACTIONS(1247),
    [sym_false] = ACTIONS(1247),
    [sym_null] = ACTIONS(1247),
    [sym_inf] = ACTIONS(1247),
    [sym_nan] = ACTIONS(1247),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1249),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [160] = {
    [sym_function_definition] = STATE(513),
    [sym_lambda_function] = STATE(513),
    [sym_if] = STATE(513),
    [sym_while] = STATE(513),
    [sym_repeat] = STATE(513),
    [sym_for] = STATE(513),
    [sym_switch] = STATE(513),
    [sym_call] = STATE(513),
    [sym__assignment] = STATE(513),
    [sym_left_assignment] = STATE(513),
    [sym_left_assignment2] = STATE(513),
    [sym_equals_assignment] = STATE(513),
    [sym_super_assignment] = STATE(513),
    [sym_super_right_assignment] = STATE(513),
    [sym_right_assignment] = STATE(513),
    [sym_brace_list] = STATE(513),
    [sym_paren_list] = STATE(513),
    [sym_subset] = STATE(513),
    [sym_subset2] = STATE(513),
    [sym_dollar] = STATE(513),
    [sym_slot] = STATE(513),
    [sym_namespace_get] = STATE(513),
    [sym_namespace_get_internal] = STATE(513),
    [sym_help] = STATE(513),
    [sym_pipe] = STATE(513),
    [sym_unary] = STATE(513),
    [sym_binary] = STATE(513),
    [sym_na] = STATE(513),
    [sym__expression] = STATE(513),
    [sym_identifier] = STATE(414),
    [sym_complex] = STATE(513),
    [sym_string] = STATE(513),
    [anon_sym_function] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1101),
    [anon_sym_if] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1107),
    [anon_sym_repeat] = ACTIONS(1109),
    [anon_sym_for] = ACTIONS(1111),
    [anon_sym_switch] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_QMARK] = ACTIONS(1117),
    [sym_dots] = ACTIONS(1251),
    [anon_sym_DASH] = ACTIONS(1121),
    [anon_sym_PLUS] = ACTIONS(1121),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1125),
    [sym_break] = ACTIONS(1251),
    [sym_next] = ACTIONS(1251),
    [sym_true] = ACTIONS(1251),
    [sym_false] = ACTIONS(1251),
    [sym_null] = ACTIONS(1251),
    [sym_inf] = ACTIONS(1251),
    [sym_nan] = ACTIONS(1251),
    [anon_sym_NA] = ACTIONS(1127),
    [anon_sym_NA_character_] = ACTIONS(1127),
    [anon_sym_NA_complex_] = ACTIONS(1127),
    [anon_sym_NA_integer_] = ACTIONS(1127),
    [anon_sym_NA_real_] = ACTIONS(1127),
    [aux_sym_identifier_token1] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1131),
    [sym_integer] = ACTIONS(1253),
    [sym_float] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1139),
    [sym__raw_string_literal] = ACTIONS(1141),
  },
  [161] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_help] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1255),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1255),
    [sym_next] = ACTIONS(1255),
    [sym_true] = ACTIONS(1255),
    [sym_false] = ACTIONS(1255),
    [sym_null] = ACTIONS(1255),
    [sym_inf] = ACTIONS(1255),
    [sym_nan] = ACTIONS(1255),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1257),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [162] = {
    [sym_function_definition] = STATE(629),
    [sym_lambda_function] = STATE(629),
    [sym_if] = STATE(629),
    [sym_while] = STATE(629),
    [sym_repeat] = STATE(629),
    [sym_for] = STATE(629),
    [sym_switch] = STATE(629),
    [sym_call] = STATE(629),
    [sym__assignment] = STATE(629),
    [sym_left_assignment] = STATE(629),
    [sym_left_assignment2] = STATE(629),
    [sym_equals_assignment] = STATE(629),
    [sym_super_assignment] = STATE(629),
    [sym_super_right_assignment] = STATE(629),
    [sym_right_assignment] = STATE(629),
    [sym_brace_list] = STATE(629),
    [sym_paren_list] = STATE(629),
    [sym_subset] = STATE(629),
    [sym_subset2] = STATE(629),
    [sym_dollar] = STATE(629),
    [sym_slot] = STATE(629),
    [sym_namespace_get] = STATE(629),
    [sym_namespace_get_internal] = STATE(629),
    [sym_help] = STATE(629),
    [sym_pipe] = STATE(629),
    [sym_unary] = STATE(629),
    [sym_binary] = STATE(629),
    [sym_na] = STATE(629),
    [sym__expression] = STATE(629),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(629),
    [sym_string] = STATE(629),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1259),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1259),
    [sym_next] = ACTIONS(1259),
    [sym_true] = ACTIONS(1259),
    [sym_false] = ACTIONS(1259),
    [sym_null] = ACTIONS(1259),
    [sym_inf] = ACTIONS(1259),
    [sym_nan] = ACTIONS(1259),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1261),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [163] = {
    [sym_function_definition] = STATE(628),
    [sym_lambda_function] = STATE(628),
    [sym_if] = STATE(628),
    [sym_while] = STATE(628),
    [sym_repeat] = STATE(628),
    [sym_for] = STATE(628),
    [sym_switch] = STATE(628),
    [sym_call] = STATE(628),
    [sym__assignment] = STATE(628),
    [sym_left_assignment] = STATE(628),
    [sym_left_assignment2] = STATE(628),
    [sym_equals_assignment] = STATE(628),
    [sym_super_assignment] = STATE(628),
    [sym_super_right_assignment] = STATE(628),
    [sym_right_assignment] = STATE(628),
    [sym_brace_list] = STATE(628),
    [sym_paren_list] = STATE(628),
    [sym_subset] = STATE(628),
    [sym_subset2] = STATE(628),
    [sym_dollar] = STATE(628),
    [sym_slot] = STATE(628),
    [sym_namespace_get] = STATE(628),
    [sym_namespace_get_internal] = STATE(628),
    [sym_help] = STATE(628),
    [sym_pipe] = STATE(628),
    [sym_unary] = STATE(628),
    [sym_binary] = STATE(628),
    [sym_na] = STATE(628),
    [sym__expression] = STATE(628),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(628),
    [sym_string] = STATE(628),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1263),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1263),
    [sym_next] = ACTIONS(1263),
    [sym_true] = ACTIONS(1263),
    [sym_false] = ACTIONS(1263),
    [sym_null] = ACTIONS(1263),
    [sym_inf] = ACTIONS(1263),
    [sym_nan] = ACTIONS(1263),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1265),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [164] = {
    [sym_function_definition] = STATE(678),
    [sym_lambda_function] = STATE(678),
    [sym_if] = STATE(678),
    [sym_while] = STATE(678),
    [sym_repeat] = STATE(678),
    [sym_for] = STATE(678),
    [sym_switch] = STATE(678),
    [sym_call] = STATE(678),
    [sym__assignment] = STATE(678),
    [sym_left_assignment] = STATE(678),
    [sym_left_assignment2] = STATE(678),
    [sym_equals_assignment] = STATE(678),
    [sym_super_assignment] = STATE(678),
    [sym_super_right_assignment] = STATE(678),
    [sym_right_assignment] = STATE(678),
    [sym_brace_list] = STATE(678),
    [sym_paren_list] = STATE(678),
    [sym_subset] = STATE(678),
    [sym_subset2] = STATE(678),
    [sym_dollar] = STATE(678),
    [sym_slot] = STATE(678),
    [sym_namespace_get] = STATE(678),
    [sym_namespace_get_internal] = STATE(678),
    [sym_help] = STATE(678),
    [sym_pipe] = STATE(678),
    [sym_unary] = STATE(678),
    [sym_binary] = STATE(678),
    [sym_na] = STATE(678),
    [sym__expression] = STATE(678),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(678),
    [sym_string] = STATE(678),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1267),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1267),
    [sym_next] = ACTIONS(1267),
    [sym_true] = ACTIONS(1267),
    [sym_false] = ACTIONS(1267),
    [sym_null] = ACTIONS(1267),
    [sym_inf] = ACTIONS(1267),
    [sym_nan] = ACTIONS(1267),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1269),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [165] = {
    [sym_function_definition] = STATE(621),
    [sym_lambda_function] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_repeat] = STATE(621),
    [sym_for] = STATE(621),
    [sym_switch] = STATE(621),
    [sym_call] = STATE(621),
    [sym__assignment] = STATE(621),
    [sym_left_assignment] = STATE(621),
    [sym_left_assignment2] = STATE(621),
    [sym_equals_assignment] = STATE(621),
    [sym_super_assignment] = STATE(621),
    [sym_super_right_assignment] = STATE(621),
    [sym_right_assignment] = STATE(621),
    [sym_brace_list] = STATE(621),
    [sym_paren_list] = STATE(621),
    [sym_subset] = STATE(621),
    [sym_subset2] = STATE(621),
    [sym_dollar] = STATE(621),
    [sym_slot] = STATE(621),
    [sym_namespace_get] = STATE(621),
    [sym_namespace_get_internal] = STATE(621),
    [sym_help] = STATE(621),
    [sym_pipe] = STATE(621),
    [sym_unary] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_na] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(621),
    [sym_string] = STATE(621),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1271),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1271),
    [sym_next] = ACTIONS(1271),
    [sym_true] = ACTIONS(1271),
    [sym_false] = ACTIONS(1271),
    [sym_null] = ACTIONS(1271),
    [sym_inf] = ACTIONS(1271),
    [sym_nan] = ACTIONS(1271),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1273),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [166] = {
    [sym_function_definition] = STATE(575),
    [sym_lambda_function] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_repeat] = STATE(575),
    [sym_for] = STATE(575),
    [sym_switch] = STATE(575),
    [sym_call] = STATE(575),
    [sym__assignment] = STATE(575),
    [sym_left_assignment] = STATE(575),
    [sym_left_assignment2] = STATE(575),
    [sym_equals_assignment] = STATE(575),
    [sym_super_assignment] = STATE(575),
    [sym_super_right_assignment] = STATE(575),
    [sym_right_assignment] = STATE(575),
    [sym_brace_list] = STATE(575),
    [sym_paren_list] = STATE(575),
    [sym_subset] = STATE(575),
    [sym_subset2] = STATE(575),
    [sym_dollar] = STATE(575),
    [sym_slot] = STATE(575),
    [sym_namespace_get] = STATE(575),
    [sym_namespace_get_internal] = STATE(575),
    [sym_help] = STATE(575),
    [sym_pipe] = STATE(575),
    [sym_unary] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_na] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(575),
    [sym_string] = STATE(575),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1275),
    [sym_next] = ACTIONS(1275),
    [sym_true] = ACTIONS(1275),
    [sym_false] = ACTIONS(1275),
    [sym_null] = ACTIONS(1275),
    [sym_inf] = ACTIONS(1275),
    [sym_nan] = ACTIONS(1275),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1277),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [167] = {
    [sym_function_definition] = STATE(571),
    [sym_lambda_function] = STATE(571),
    [sym_if] = STATE(571),
    [sym_while] = STATE(571),
    [sym_repeat] = STATE(571),
    [sym_for] = STATE(571),
    [sym_switch] = STATE(571),
    [sym_call] = STATE(571),
    [sym__assignment] = STATE(571),
    [sym_left_assignment] = STATE(571),
    [sym_left_assignment2] = STATE(571),
    [sym_equals_assignment] = STATE(571),
    [sym_super_assignment] = STATE(571),
    [sym_super_right_assignment] = STATE(571),
    [sym_right_assignment] = STATE(571),
    [sym_brace_list] = STATE(571),
    [sym_paren_list] = STATE(571),
    [sym_subset] = STATE(571),
    [sym_subset2] = STATE(571),
    [sym_dollar] = STATE(571),
    [sym_slot] = STATE(571),
    [sym_namespace_get] = STATE(571),
    [sym_namespace_get_internal] = STATE(571),
    [sym_help] = STATE(571),
    [sym_pipe] = STATE(571),
    [sym_unary] = STATE(571),
    [sym_binary] = STATE(571),
    [sym_na] = STATE(571),
    [sym__expression] = STATE(571),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(571),
    [sym_string] = STATE(571),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1279),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1279),
    [sym_next] = ACTIONS(1279),
    [sym_true] = ACTIONS(1279),
    [sym_false] = ACTIONS(1279),
    [sym_null] = ACTIONS(1279),
    [sym_inf] = ACTIONS(1279),
    [sym_nan] = ACTIONS(1279),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1281),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [168] = {
    [sym_function_definition] = STATE(516),
    [sym_lambda_function] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_super_right_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_help] = STATE(516),
    [sym_pipe] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(441),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(516),
    [anon_sym_function] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_QMARK] = ACTIONS(25),
    [sym_dots] = ACTIONS(1283),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1283),
    [sym_next] = ACTIONS(1283),
    [sym_true] = ACTIONS(1283),
    [sym_false] = ACTIONS(1283),
    [sym_null] = ACTIONS(1283),
    [sym_inf] = ACTIONS(1283),
    [sym_nan] = ACTIONS(1283),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1285),
    [sym_float] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_SQUOTE] = ACTIONS(47),
    [sym__raw_string_literal] = ACTIONS(49),
  },
  [169] = {
    [sym_function_definition] = STATE(642),
    [sym_lambda_function] = STATE(642),
    [sym_if] = STATE(642),
    [sym_while] = STATE(642),
    [sym_repeat] = STATE(642),
    [sym_for] = STATE(642),
    [sym_switch] = STATE(642),
    [sym_call] = STATE(642),
    [sym__assignment] = STATE(642),
    [sym_left_assignment] = STATE(642),
    [sym_left_assignment2] = STATE(642),
    [sym_equals_assignment] = STATE(642),
    [sym_super_assignment] = STATE(642),
    [sym_super_right_assignment] = STATE(642),
    [sym_right_assignment] = STATE(642),
    [sym_brace_list] = STATE(642),
    [sym_paren_list] = STATE(642),
    [sym_subset] = STATE(642),
    [sym_subset2] = STATE(642),
    [sym_dollar] = STATE(642),
    [sym_slot] = STATE(642),
    [sym_namespace_get] = STATE(642),
    [sym_namespace_get_internal] = STATE(642),
    [sym_help] = STATE(642),
    [sym_pipe] = STATE(642),
    [sym_unary] = STATE(642),
    [sym_binary] = STATE(642),
    [sym_na] = STATE(642),
    [sym__expression] = STATE(642),
    [sym_identifier] = STATE(414),
    [sym_complex] = STATE(642),
    [sym_string] = STATE(642),
    [anon_sym_function] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1101),
    [anon_sym_if] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1107),
    [anon_sym_repeat] = ACTIONS(1109),
    [anon_sym_for] = ACTIONS(1111),
    [anon_sym_switch] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_QMARK] = ACTIONS(1117),
    [sym_dots] = ACTIONS(1287),
    [anon_sym_DASH] = ACTIONS(1121),
    [anon_sym_PLUS] = ACTIONS(1121),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1125),
    [sym_break] = ACTIONS(1287),
    [sym_next] = ACTIONS(1287),
    [sym_true] = ACTIONS(1287),
    [sym_false] = ACTIONS(1287),
    [sym_null] = ACTIONS(1287),
    [sym_inf] = ACTIONS(1287),
    [sym_nan] = ACTIONS(1287),
    [anon_sym_NA] = ACTIONS(1127),
    [anon_sym_NA_character_] = ACTIONS(1127),
    [anon_sym_NA_complex_] = ACTIONS(1127),
    [anon_sym_NA_integer_] = ACTIONS(1127),
    [anon_sym_NA_real_] = ACTIONS(1127),
    [aux_sym_identifier_token1] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1131),
    [sym_integer] = ACTIONS(1289),
    [sym_float] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1139),
    [sym__raw_string_literal] = ACTIONS(1141),
  },
  [170] = {
    [sym_function_definition] = STATE(645),
    [sym_lambda_function] = STATE(645),
    [sym_if] = STATE(645),
    [sym_while] = STATE(645),
    [sym_repeat] = STATE(645),
    [sym_for] = STATE(645),
    [sym_switch] = STATE(645),
    [sym_call] = STATE(645),
    [sym__assignment] = STATE(645),
    [sym_left_assignment] = STATE(645),
    [sym_left_assignment2] = STATE(645),
    [sym_equals_assignment] = STATE(645),
    [sym_super_assignment] = STATE(645),
    [sym_super_right_assignment] = STATE(645),
    [sym_right_assignment] = STATE(645),
    [sym_brace_list] = STATE(645),
    [sym_paren_list] = STATE(645),
    [sym_subset] = STATE(645),
    [sym_subset2] = STATE(645),
    [sym_dollar] = STATE(645),
    [sym_slot] = STATE(645),
    [sym_namespace_get] = STATE(645),
    [sym_namespace_get_internal] = STATE(645),
    [sym_help] = STATE(645),
    [sym_pipe] = STATE(645),
    [sym_unary] = STATE(645),
    [sym_binary] = STATE(645),
    [sym_na] = STATE(645),
    [sym__expression] = STATE(645),
    [sym_identifier] = STATE(414),
    [sym_complex] = STATE(645),
    [sym_string] = STATE(645),
    [anon_sym_function] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1101),
    [anon_sym_if] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1107),
    [anon_sym_repeat] = ACTIONS(1109),
    [anon_sym_for] = ACTIONS(1111),
    [anon_sym_switch] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_QMARK] = ACTIONS(1117),
    [sym_dots] = ACTIONS(1291),
    [anon_sym_DASH] = ACTIONS(1121),
    [anon_sym_PLUS] = ACTIONS(1121),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1125),
    [sym_break] = ACTIONS(1291),
    [sym_next] = ACTIONS(1291),
    [sym_true] = ACTIONS(1291),
    [sym_false] = ACTIONS(1291),
    [sym_null] = ACTIONS(1291),
    [sym_inf] = ACTIONS(1291),
    [sym_nan] = ACTIONS(1291),
    [anon_sym_NA] = ACTIONS(1127),
    [anon_sym_NA_character_] = ACTIONS(1127),
    [anon_sym_NA_complex_] = ACTIONS(1127),
    [anon_sym_NA_integer_] = ACTIONS(1127),
    [anon_sym_NA_real_] = ACTIONS(1127),
    [aux_sym_identifier_token1] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1131),
    [sym_integer] = ACTIONS(1293),
    [sym_float] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1139),
    [sym__raw_string_literal] = ACTIONS(1141),
  },
  [171] = {
    [sym_function_definition] = STATE(646),
    [sym_lambda_function] = STATE(646),
    [sym_if] = STATE(646),
    [sym_while] = STATE(646),
    [sym_repeat] = STATE(646),
    [sym_for] = STATE(646),
    [sym_switch] = STATE(646),
    [sym_call] = STATE(646),
    [sym__assignment] = STATE(646),
    [sym_left_assignment] = STATE(646),
    [sym_left_assignment2] = STATE(646),
    [sym_equals_assignment] = STATE(646),
    [sym_super_assignment] = STATE(646),
    [sym_super_right_assignment] = STATE(646),
    [sym_right_assignment] = STATE(646),
    [sym_brace_list] = STATE(646),
    [sym_paren_list] = STATE(646),
    [sym_subset] = STATE(646),
    [sym_subset2] = STATE(646),
    [sym_dollar] = STATE(646),
    [sym_slot] = STATE(646),
    [sym_namespace_get] = STATE(646),
    [sym_namespace_get_internal] = STATE(646),
    [sym_help] = STATE(646),
    [sym_pipe] = STATE(646),
    [sym_unary] = STATE(646),
    [sym_binary] = STATE(646),
    [sym_na] = STATE(646),
    [sym__expression] = STATE(646),
    [sym_identifier] = STATE(414),
    [sym_complex] = STATE(646),
    [sym_string] = STATE(646),
    [anon_sym_function] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1101),
    [anon_sym_if] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1107),
    [anon_sym_repeat] = ACTIONS(1109),
    [anon_sym_for] = ACTIONS(1111),
    [anon_sym_switch] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_QMARK] = ACTIONS(1117),
    [sym_dots] = ACTIONS(1295),
    [anon_sym_DASH] = ACTIONS(1121),
    [anon_sym_PLUS] = ACTIONS(1121),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1125),
    [sym_break] = ACTIONS(1295),
    [sym_next] = ACTIONS(1295),
    [sym_true] = ACTIONS(1295),
    [sym_false] = ACTIONS(1295),
    [sym_null] = ACTIONS(1295),
    [sym_inf] = ACTIONS(1295),
    [sym_nan] = ACTIONS(1295),
    [anon_sym_NA] = ACTIONS(1127),
    [anon_sym_NA_character_] = ACTIONS(1127),
    [anon_sym_NA_complex_] = ACTIONS(1127),
    [anon_sym_NA_integer_] = ACTIONS(1127),
    [anon_sym_NA_real_] = ACTIONS(1127),
    [aux_sym_identifier_token1] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1131),
    [sym_integer] = ACTIONS(1297),
    [sym_float] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1139),
    [sym__raw_string_literal] = ACTIONS(1141),
  },
  [172] = {
    [sym_function_definition] = STATE(647),
    [sym_lambda_function] = STATE(647),
    [sym_if] = STATE(647),
    [sym_while] = STATE(647),
    [sym_repeat] = STATE(647),
    [sym_for] = STATE(647),
    [sym_switch] = STATE(647),
    [sym_call] = STATE(647),
    [sym__assignment] = STATE(647),
    [sym_left_assignment] = STATE(647),
    [sym_left_assignment2] = STATE(647),
    [sym_equals_assignment] = STATE(647),
    [sym_super_assignment] = STATE(647),
    [sym_super_right_assignment] = STATE(647),
    [sym_right_assignment] = STATE(647),
    [sym_brace_list] = STATE(647),
    [sym_paren_list] = STATE(647),
    [sym_subset] = STATE(647),
    [sym_subset2] = STATE(647),
    [sym_dollar] = STATE(647),
    [sym_slot] = STATE(647),
    [sym_namespace_get] = STATE(647),
    [sym_namespace_get_internal] = STATE(647),
    [sym_help] = STATE(647),
    [sym_pipe] = STATE(647),
    [sym_unary] = STATE(647),
    [sym_binary] = STATE(647),
    [sym_na] = STATE(647),
    [sym__expression] = STATE(647),
    [sym_identifier] = STATE(414),
    [sym_complex] = STATE(647),
    [sym_string] = STATE(647),
    [anon_sym_function] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1101),
    [anon_sym_if] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1107),
    [anon_sym_repeat] = ACTIONS(1109),
    [anon_sym_for] = ACTIONS(1111),
    [anon_sym_switch] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_QMARK] = ACTIONS(1117),
    [sym_dots] = ACTIONS(1299),
    [anon_sym_DASH] = ACTIONS(1121),
    [anon_sym_PLUS] = ACTIONS(1121),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1125),
    [sym_break] = ACTIONS(1299),
    [sym_next] = ACTIONS(1299),
    [sym_true] = ACTIONS(1299),
    [sym_false] = ACTIONS(1299),
    [sym_null] = ACTIONS(1299),
    [sym_inf] = ACTIONS(1299),
    [sym_nan] = ACTIONS(1299),
    [anon_sym_NA] = ACTIONS(1127),
    [anon_sym_NA_character_] = ACTIONS(1127),
    [anon_sym_NA_complex_] = ACTIONS(1127),
    [anon_sym_NA_integer_] = ACTIONS(1127),
    [anon_sym_NA_real_] = ACTIONS(1127),
    [aux_sym_identifier_token1] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1131),
    [sym_integer] = ACTIONS(1301),
    [sym_float] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1139),
    [sym__raw_string_literal] = ACTIONS(1141),
  },
  [173] = {
    [sym_function_definition] = STATE(576),
    [sym_lambda_function] = STATE(576),
    [sym_if] = STATE(576),
    [sym_while] = STATE(576),
    [sym_repeat] = STATE(576),
    [sym_for] = STATE(576),
    [sym_switch] = STATE(576),
    [sym_call] = STATE(576),
    [sym__assignment] = STATE(576),
    [sym_left_assignment] = STATE(576),
    [sym_left_assignment2] = STATE(576),
    [sym_equals_assignment] = STATE(576),
    [sym_super_assignment] = STATE(576),
    [sym_super_right_assignment] = STATE(576),
    [sym_right_assignment] = STATE(576),
    [sym_brace_list] = STATE(576),
    [sym_paren_list] = STATE(576),
    [sym_subset] = STATE(576),
    [sym_subset2] = STATE(576),
    [sym_dollar] = STATE(576),
    [sym_slot] = STATE(576),
    [sym_namespace_get] = STATE(576),
    [sym_namespace_get_internal] = STATE(576),
    [sym_help] = STATE(576),
    [sym_pipe] = STATE(576),
    [sym_unary] = STATE(576),
    [sym_binary] = STATE(576),
    [sym_na] = STATE(576),
    [sym__expression] = STATE(576),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(576),
    [sym_string] = STATE(576),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(1303),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(1303),
    [sym_next] = ACTIONS(1303),
    [sym_true] = ACTIONS(1303),
    [sym_false] = ACTIONS(1303),
    [sym_null] = ACTIONS(1303),
    [sym_inf] = ACTIONS(1303),
    [sym_nan] = ACTIONS(1303),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(1305),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [174] = {
    [sym_function_definition] = STATE(574),
    [sym_lambda_function] = STATE(574),
    [sym_if] = STATE(574),
    [sym_while] = STATE(574),
    [sym_repeat] = STATE(574),
    [sym_for] = STATE(574),
    [sym_switch] = STATE(574),
    [sym_call] = STATE(574),
    [sym__assignment] = STATE(574),
    [sym_left_assignment] = STATE(574),
    [sym_left_assignment2] = STATE(574),
    [sym_equals_assignment] = STATE(574),
    [sym_super_assignment] = STATE(574),
    [sym_super_right_assignment] = STATE(574),
    [sym_right_assignment] = STATE(574),
    [sym_brace_list] = STATE(574),
    [sym_paren_list] = STATE(574),
    [sym_subset] = STATE(574),
    [sym_subset2] = STATE(574),
    [sym_dollar] = STATE(574),
    [sym_slot] = STATE(574),
    [sym_namespace_get] = STATE(574),
    [sym_namespace_get_internal] = STATE(574),
    [sym_help] = STATE(574),
    [sym_pipe] = STATE(574),
    [sym_unary] = STATE(574),
    [sym_binary] = STATE(574),
    [sym_na] = STATE(574),
    [sym__expression] = STATE(574),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(574),
    [sym_string] = STATE(574),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(1307),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(1307),
    [sym_next] = ACTIONS(1307),
    [sym_true] = ACTIONS(1307),
    [sym_false] = ACTIONS(1307),
    [sym_null] = ACTIONS(1307),
    [sym_inf] = ACTIONS(1307),
    [sym_nan] = ACTIONS(1307),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(1309),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [175] = {
    [sym_function_definition] = STATE(641),
    [sym_lambda_function] = STATE(641),
    [sym_if] = STATE(641),
    [sym_while] = STATE(641),
    [sym_repeat] = STATE(641),
    [sym_for] = STATE(641),
    [sym_switch] = STATE(641),
    [sym_call] = STATE(641),
    [sym__assignment] = STATE(641),
    [sym_left_assignment] = STATE(641),
    [sym_left_assignment2] = STATE(641),
    [sym_equals_assignment] = STATE(641),
    [sym_super_assignment] = STATE(641),
    [sym_super_right_assignment] = STATE(641),
    [sym_right_assignment] = STATE(641),
    [sym_brace_list] = STATE(641),
    [sym_paren_list] = STATE(641),
    [sym_subset] = STATE(641),
    [sym_subset2] = STATE(641),
    [sym_dollar] = STATE(641),
    [sym_slot] = STATE(641),
    [sym_namespace_get] = STATE(641),
    [sym_namespace_get_internal] = STATE(641),
    [sym_help] = STATE(641),
    [sym_pipe] = STATE(641),
    [sym_unary] = STATE(641),
    [sym_binary] = STATE(641),
    [sym_na] = STATE(641),
    [sym__expression] = STATE(641),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(641),
    [sym_string] = STATE(641),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(1311),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(1311),
    [sym_next] = ACTIONS(1311),
    [sym_true] = ACTIONS(1311),
    [sym_false] = ACTIONS(1311),
    [sym_null] = ACTIONS(1311),
    [sym_inf] = ACTIONS(1311),
    [sym_nan] = ACTIONS(1311),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(1313),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [176] = {
    [sym_function_definition] = STATE(503),
    [sym_lambda_function] = STATE(503),
    [sym_if] = STATE(503),
    [sym_while] = STATE(503),
    [sym_repeat] = STATE(503),
    [sym_for] = STATE(503),
    [sym_switch] = STATE(503),
    [sym_call] = STATE(503),
    [sym__assignment] = STATE(503),
    [sym_left_assignment] = STATE(503),
    [sym_left_assignment2] = STATE(503),
    [sym_equals_assignment] = STATE(503),
    [sym_super_assignment] = STATE(503),
    [sym_super_right_assignment] = STATE(503),
    [sym_right_assignment] = STATE(503),
    [sym_brace_list] = STATE(503),
    [sym_paren_list] = STATE(503),
    [sym_subset] = STATE(503),
    [sym_subset2] = STATE(503),
    [sym_dollar] = STATE(503),
    [sym_slot] = STATE(503),
    [sym_namespace_get] = STATE(503),
    [sym_namespace_get_internal] = STATE(503),
    [sym_help] = STATE(503),
    [sym_pipe] = STATE(503),
    [sym_unary] = STATE(503),
    [sym_binary] = STATE(503),
    [sym_na] = STATE(503),
    [sym__expression] = STATE(503),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(503),
    [sym_string] = STATE(503),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(1315),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(1315),
    [sym_next] = ACTIONS(1315),
    [sym_true] = ACTIONS(1315),
    [sym_false] = ACTIONS(1315),
    [sym_null] = ACTIONS(1315),
    [sym_inf] = ACTIONS(1315),
    [sym_nan] = ACTIONS(1315),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(1317),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [177] = {
    [sym_function_definition] = STATE(504),
    [sym_lambda_function] = STATE(504),
    [sym_if] = STATE(504),
    [sym_while] = STATE(504),
    [sym_repeat] = STATE(504),
    [sym_for] = STATE(504),
    [sym_switch] = STATE(504),
    [sym_call] = STATE(504),
    [sym__assignment] = STATE(504),
    [sym_left_assignment] = STATE(504),
    [sym_left_assignment2] = STATE(504),
    [sym_equals_assignment] = STATE(504),
    [sym_super_assignment] = STATE(504),
    [sym_super_right_assignment] = STATE(504),
    [sym_right_assignment] = STATE(504),
    [sym_brace_list] = STATE(504),
    [sym_paren_list] = STATE(504),
    [sym_subset] = STATE(504),
    [sym_subset2] = STATE(504),
    [sym_dollar] = STATE(504),
    [sym_slot] = STATE(504),
    [sym_namespace_get] = STATE(504),
    [sym_namespace_get_internal] = STATE(504),
    [sym_help] = STATE(504),
    [sym_pipe] = STATE(504),
    [sym_unary] = STATE(504),
    [sym_binary] = STATE(504),
    [sym_na] = STATE(504),
    [sym__expression] = STATE(504),
    [sym_identifier] = STATE(403),
    [sym_complex] = STATE(504),
    [sym_string] = STATE(504),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_while] = ACTIONS(61),
    [anon_sym_repeat] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [anon_sym_switch] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(73),
    [sym_dots] = ACTIONS(1319),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(81),
    [sym_break] = ACTIONS(1319),
    [sym_next] = ACTIONS(1319),
    [sym_true] = ACTIONS(1319),
    [sym_false] = ACTIONS(1319),
    [sym_null] = ACTIONS(1319),
    [sym_inf] = ACTIONS(1319),
    [sym_nan] = ACTIONS(1319),
    [anon_sym_NA] = ACTIONS(85),
    [anon_sym_NA_character_] = ACTIONS(85),
    [anon_sym_NA_complex_] = ACTIONS(85),
    [anon_sym_NA_integer_] = ACTIONS(85),
    [anon_sym_NA_real_] = ACTIONS(85),
    [aux_sym_identifier_token1] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_integer] = ACTIONS(1321),
    [sym_float] = ACTIONS(93),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_SQUOTE] = ACTIONS(97),
    [sym__raw_string_literal] = ACTIONS(99),
  },
  [178] = {
    [sym_function_definition] = STATE(660),
    [sym_lambda_function] = STATE(660),
    [sym_if] = STATE(660),
    [sym_while] = STATE(660),
    [sym_repeat] = STATE(660),
    [sym_for] = STATE(660),
    [sym_switch] = STATE(660),
    [sym_call] = STATE(660),
    [sym__assignment] = STATE(660),
    [sym_left_assignment] = STATE(660),
    [sym_left_assignment2] = STATE(660),
    [sym_equals_assignment] = STATE(660),
    [sym_super_assignment] = STATE(660),
    [sym_super_right_assignment] = STATE(660),
    [sym_right_assignment] = STATE(660),
    [sym_brace_list] = STATE(660),
    [sym_paren_list] = STATE(660),
    [sym_subset] = STATE(660),
    [sym_subset2] = STATE(660),
    [sym_dollar] = STATE(660),
    [sym_slot] = STATE(660),
    [sym_namespace_get] = STATE(660),
    [sym_namespace_get_internal] = STATE(660),
    [sym_help] = STATE(660),
    [sym_pipe] = STATE(660),
    [sym_unary] = STATE(660),
    [sym_binary] = STATE(660),
    [sym_na] = STATE(660),
    [sym__expression] = STATE(660),
    [sym_identifier] = STATE(414),
    [sym_complex] = STATE(660),
    [sym_string] = STATE(660),
    [anon_sym_function] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1101),
    [anon_sym_if] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1105),
    [anon_sym_while] = ACTIONS(1107),
    [anon_sym_repeat] = ACTIONS(1109),
    [anon_sym_for] = ACTIONS(1111),
    [anon_sym_switch] = ACTIONS(1113),
    [anon_sym_LBRACE] = ACTIONS(1115),
    [anon_sym_QMARK] = ACTIONS(1117),
    [sym_dots] = ACTIONS(1323),
    [anon_sym_DASH] = ACTIONS(1121),
    [anon_sym_PLUS] = ACTIONS(1121),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1125),
    [sym_break] = ACTIONS(1323),
    [sym_next] = ACTIONS(1323),
    [sym_true] = ACTIONS(1323),
    [sym_false] = ACTIONS(1323),
    [sym_null] = ACTIONS(1323),
    [sym_inf] = ACTIONS(1323),
    [sym_nan] = ACTIONS(1323),
    [anon_sym_NA] = ACTIONS(1127),
    [anon_sym_NA_character_] = ACTIONS(1127),
    [anon_sym_NA_complex_] = ACTIONS(1127),
    [anon_sym_NA_integer_] = ACTIONS(1127),
    [anon_sym_NA_real_] = ACTIONS(1127),
    [aux_sym_identifier_token1] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1131),
    [sym_integer] = ACTIONS(1325),
    [sym_float] = ACTIONS(1135),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1139),
    [sym__raw_string_literal] = ACTIONS(1141),
  },
  [179] = {
    [sym_function_definition] = STATE(661),
    [sym_lambda_function] = STATE(661),
    [sym_if] = STATE(661),
    [sym_while] = STATE(661),
    [sym_repeat] = STATE(661),
    [sym_for] = STATE(661),
    [sym_switch] = STATE(661),
    [sym_call] = STATE(661),
    [sym__assignment] = STATE(661),
    [sym_left_assignment] = STATE(661),
    [sym_left_assignment2] = STATE(661),
    [sym_equals_assignment] = STATE(661),
    [sym_super_assignment] = STATE(661),
    [sym_super_right_assignment] = STATE(661),
    [sym_right_assignment] = STATE(661),
    [sym_brace_list] = STATE(661),
    [sym_paren_list] = STATE(661),
    [sym_subset] = STATE(661),
    [sym_subset2] = STATE(661),
    [sym_dollar] = STATE(661),
    [sym_slot] = STATE(661),
    [sym_namespace_get] = STATE(661),
    [sym_namespace_get_internal] = STATE(661),
    [sym_help] = STATE(661),
    [sym_pipe] = STATE(661),
    [sym_unary] = STATE(661),
    [sym_binary] = STATE(661),
    [sym_na] = STATE(661),
    [sym__expression