package attachments

import (
	"encoding/base64"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestAudioVisualization(t *testing.T) {
	amps := []float64{-72.559235, -112.861091, -79.747206, -52.525702, -50.956500, -82.418769, -7.876442, -18.782311, -11.636342, -36.109423, -61.825515, -97.636795, -25.711665, -45.678863, -38.166981, -56.266781, -33.964098, -35.172223, -81.490161, -26.226366, -24.382425, -43.304570, -68.480793, -103.498972, -35.173709, -35.649908, -90.308764, -24.789919, -103.840202, -83.606300, -62.858437, -3.396370, -18.999393, -72.870413, -117.028994, -9.534435, -71.377032, -7.094478, -83.042950, -36.182722, -20.791949, -64.931983, -65.298669, -33.420915, -50.778264, -63.670286, -30.424860, -33.849719, -94.632590, -43.416658, -105.665175, -35.653471, -107.323408, -11.694554, -117.230024, -8.914920, -26.674730, -81.729397, -28.981811, -37.382693, -111.941571, -89.021875, -96.126605, -87.627777}
	desired := "iVBORw0KGgoAAAANSUhEUgAAAIAAAABACAIAAABdtOgoAAABZklEQVR4nOybwYqDQBAF17D//8vmkEvAKDM6Y3XbVYdlIaDt1LynAfO/ruufcLzoAaqjABgFwCQWsCwLPcIAEgt4BgqAebiA+DXVJCD+ZeTlgQmgtsu58z5QQC66BVhH31xfDRMAowAYBcAoAEYBMB0CYj7/xJyqnXIJiCasnIBoKAAGE9BeBdFKYyzDBLig57CCBtO7vRQAo4CJtKRBAT+48y6lABgFwE9l0wXkfei8Z/KTAnqH6/2WMOPiRx1z7GxW0HSOhU0RkLd27scEwCgARgEwsIAsd4t5c5oAmMECsuzoOJgAGAXAKABmV0C1Nqeu1wTA/BBQbe+zmAAYBcBMFGCVtWACYBQAowCYSwJs+eukTMA88fdvqZQCrhMnu0UFfIigobSACIQQEGEnUoQQUBkFwLy+X4bdVkFLOYz6ed7x2Y9f2t1+uvd/Ly3HbFm37Tp//poAGAXAKABGATDvAAAA///A4wRAawkUAgAAAABJRU5ErkJggg=="

	v := newAudioVisualizer(amps)
	dat, _ := v.visualize()
	require.Equal(t, desired, base64.StdEncoding.EncodeToString(dat))
}
