# Cantera 2.2.1

Published on January 26, 2016 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.2.1)

- Maintenance release fixing issues identified since Cantera 2.2.0.
- Now includes Windows binaries for Python 3.5.

# Cantera 2.2.0

Published on June 5, 2015 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.2.0)

New major version. Highlights include:

- Reformulated multicomponent diffusion calculation to improve 1D solver convergence.
- Introduction of `Species` and `Reaction` classes which can be used to construct and modify `ThermoPhase` / `Kinetics` objects on-the-fly, without necessarily using CTI/XML input files. See the new examples [`extract_submechanism.py`](https://cantera.org/2.2/sphinx/html/cython/examples/kinetics_extract_submechanism.html) and [`mechanism_reduction.py`](https://cantera.org/2.2/sphinx/html/cython/examples/kinetics_mechanism_reduction.html).
- Better handling of CTI and XML files: Parsed CTI and XML files are cached based on modification time and file content, and implicit conversions are done without generating `.xml` files. Phases can be imported directly from XML or CTI strings. Both CTI and XML files can import species and reactions from other CTI or XML files.
- Enable re-initialization of reactor networks, which improves efficiency for integration with CFD-like codes - see the example [`surf_pfr.py`](https://cantera.org/2.2/sphinx/html/cython/examples/reactors_surf_pfr.html).
- Introduction of a simple radiation model for flames (optically thin, gray gas for CO2 and H2O) - see the example [`diffusion_flame.py`](https://cantera.org/2.2/sphinx/html/cython/examples/onedim_diffusion_flame.html).
- Efficient sensitivity analysis of 1D flame solutions (see [`flamespeed_sensitivity.py`](https://cantera.org/2.2/sphinx/html/cython/examples/onedim_flamespeed_sensitivity.html)).
- Added strain rate calculations for diffusion flames (see [`diffusion_flame_extinction.py`](https://cantera.org/2.2/sphinx/html/cython/examples/onedim_diffusion_flame_extinction.html) and [`diffusion_flame_batch.py`](https://cantera.org/2.2/sphinx/html/cython/examples/onedim_diffusion_flame_batch.html)).
- Added premixed counterflow flame configuration to Python module (see [`premixed_counterflow_flame.py`](https://cantera.org/2.2/sphinx/html/cython/examples/onedim_premixed_counterflow_flame.html)).
- Allow Sundials to link to external (optimized) BLAS/LAPACK libraries.
- Support for Sundials 2.6.
- Updated Matlab toolbox documentation, which is included in the [online HTML documentation](https://cantera.org/2.2/sphinx/html/matlab/index.html).

## Downloads available

- Source code (all platforms) - Download `cantera-2.2.0.tar.gz` from GitHub, and see the [compilation guide](https://cantera.org/2.2/sphinx/html/compiling.html).
- Windows MSI installers for x86 and x64 systems, including Python modules for Python 2.7, 3.3, and 3.4. See [installation instructions](https://cantera.org/2.2/sphinx/html/install.html#windows) for details.
- Ubuntu packages for Trusty (14.04 LTS), Utopic, and Vivid via a Launchpad PPA; see [installation instructions](https://cantera.org/2.2/sphinx/html/install.html#ubuntu)
- OS X Homebrew formula; see [installation instructions](https://cantera.org/2.2/sphinx/html/install.html#mac-os-x)
