# Cantera 2.5.1

Published on February 12, 2021 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.5.1)

The Cantera development team is pleased to announce the availability of Cantera 2.5.1. There have been 1000 commits to Cantera since the release of Cantera 2.4.0 in August 2018. We have closed or merged more than [250 pull requests](https://github.com/Cantera/cantera/pulls?q=is%3Apr+is%3Aclosed+updated%3A%3E%3D2018-08-24) and [100 issues](https://github.com/Cantera/cantera/issues?q=is%3Aissue+is%3Aclosed+updated%3A%3E%3D2018-08-24). The complete list of changes can be found on the [Cantera Wiki page](https://github.com/Cantera/cantera/wiki/Complete-git-log-between-v2.4.0-and-v2.5.1), and a summary of new features, changes, and bugs fixed in this release is included below, with links to the associated Pull Requests on GitHub.


Cantera 2.5 introduces a new input file format, based on the [YAML](https://yaml.org/) data format. This format supersedes the CTI and XML (sometimes called CTML) formats that Cantera has used for many years. Converter scripts from CTI and XML to YAML (`cti2yaml` and `ctml2yaml`), as well as from CHEMKIN (CK) format to YAML (`ck2yaml`), are provided with this release. You can use these scripts in the same way that the old `ck2cti` script was used. All users are encouraged to switch their input files to the new format.

Instructions for installing Cantera 2.5 are available on the [Cantera website](https://github.com/Cantera/cantera-website/tree/v2.5.1/pages/install). Available options include Conda, native installers for Windows and macOS, Ubuntu packages, and compiling from source.

Thank you to the following contributors to Cantera 2.5:

[@12Chao](https://github.com/12Chao), [@agarwalrounak](https://github.com/agarwalrounak), [@arghdos](https://github.com/arghdos), [@band-a-prend](https://github.com/band-a-prend), [@BangShiuh](https://github.com/BangShiuh), [@bryanwweber](https://github.com/bryanwweber),  [@CyberDrudge](https://github.com/CyberDrudge), [@decaluwe](https://github.com/decaluwe), [@dholland88](https://github.com/dholland88), [@g3bk47](https://github.com/g3bk47), [@inducer](https://github.com/inducer), [@ischoegl](https://github.com/ischoegl), [@jsantner](https://github.com/jsantner), [@korffdm](https://github.com/korffdm), [@kyleniemeyer](https://github.com/kyleniemeyer), [@lavdwall](https://github.com/lavdwall), [@lionkey](https://github.com/lionkey), [@manikmayur](https://github.com/manikmayur), [@mgashwinkumar](https://github.com/mgashwinkumar), [@paulblum](https://github.com/paulblum), [@rwest](https://github.com/rwest), [@sameshl](https://github.com/sameshl), [@sin-ha](https://github.com/sin-ha), [@speth](https://github.com/speth), [@spinnau](https://github.com/spinnau), [@ThanasisMattas](https://github.com/ThanasisMattas), [@tsikes](https://github.com/tsikes), [@wbessler](https://github.com/wbessler)


## New Features

- Added a new, YAML-based input file format ([#584](https://github.com/Cantera/cantera/pull/584), [#663](https://github.com/Cantera/cantera/pull/663), [#664](https://github.com/Cantera/cantera/pull/664), [#671](https://github.com/Cantera/cantera/pull/671), [#693](https://github.com/Cantera/cantera/pull/693), [#707](https://github.com/Cantera/cantera/pull/707), [#708](https://github.com/Cantera/cantera/pull/708), [#716](https://github.com/Cantera/cantera/pull/716), [#723](https://github.com/Cantera/cantera/pull/723), [#738](https://github.com/Cantera/cantera/pull/738), [#750](https://github.com/Cantera/cantera/pull/750), [#764](https://github.com/Cantera/cantera/pull/764), [#768](https://github.com/Cantera/cantera/pull/768), [#773](https://github.com/Cantera/cantera/pull/773), [#784](https://github.com/Cantera/cantera/pull/784), [#794](https://github.com/Cantera/cantera/pull/794), [#795](https://github.com/Cantera/cantera/pull/795), [#813](https://github.com/Cantera/cantera/pull/813), [#855](https://github.com/Cantera/cantera/pull/855), [#857](https://github.com/Cantera/cantera/pull/857), [#866](https://github.com/Cantera/cantera/pull/866), [#869](https://github.com/Cantera/cantera/pull/869), [#880](https://github.com/Cantera/cantera/pull/880), [#897](https://github.com/Cantera/cantera/pull/897), [#899](https://github.com/Cantera/cantera/pull/899), [#961](https://github.com/Cantera/cantera/pull/961), [#970](https://github.com/Cantera/cantera/pull/970), [#941](https://github.com/Cantera/cantera/pull/941), [#974](https://github.com/Cantera/cantera/pull/974))
- Add interface for reading and writing 1D Flame and `SolutionArray` objects from/to HDF5 files ([#680](https://github.com/Cantera/cantera/pull/680), [#687](https://github.com/Cantera/cantera/pull/687), [#805](https://github.com/Cantera/cantera/pull/805), [#840](https://github.com/Cantera/cantera/pull/840), [#860](https://github.com/Cantera/cantera/pull/860), [#871](https://github.com/Cantera/cantera/pull/871), [#900](https://github.com/Cantera/cantera/pull/900), [#943](https://github.com/Cantera/cantera/pull/943), [#931](https://github.com/Cantera/cantera/pull/931))
- Add `BinarySolutionTabulatedThermo` class, which implements implements tabulated standard state thermodynamics in a binary solution. ([#563](https://github.com/Cantera/cantera/pull/563), [#606](https://github.com/Cantera/cantera/pull/606), [#637](https://github.com/Cantera/cantera/pull/637), [#640](https://github.com/Cantera/cantera/pull/640), [#725](https://github.com/Cantera/cantera/pull/725))
- Introduce C++ `Solution` class to simplify creation of coupled `ThermoPhase`, `Kinetics`, and `Transport` objects ([#696](https://github.com/Cantera/cantera/pull/696), [#735](https://github.com/Cantera/cantera/pull/735))
- Determine Redlich-Kwong parameters from a database of critical property data ([#574](https://github.com/Cantera/cantera/pull/574), [#576](https://github.com/Cantera/cantera/pull/576), [`33e198f7e`](https://github.com/Cantera/cantera/commit/33e198f7e527dee6a97869d6677d2da9b58247b1), [`ebb93cb5a`](https://github.com/Cantera/cantera/commit/ebb93cb5a23591ca3badb186940e5b1a89e8a411))
- Make transport property calculations available for pure fluid water phases ([#558](https://github.com/Cantera/cantera/pull/558))
- Make `InterfaceKinetics.advance_coverages_to_steady_state` available in the Python interface ([#592](https://github.com/Cantera/cantera/pull/592), [#610](https://github.com/Cantera/cantera/pull/610))
- Add functions for returning the phase of matter for `ThermoPhase` objects ([#722](https://github.com/Cantera/cantera/pull/722), [#839](https://github.com/Cantera/cantera/pull/839))
- Add new `ReactorNet::advanceTowards` method to combine benefits of both the 'step' and 'advance' methods; see 'reactor3.py' example ([#629](https://github.com/Cantera/cantera/pull/629), [#756](https://github.com/Cantera/cantera/pull/756))
- Enable setting the maximum number of CVODEs steps in the Python interface ([#581](https://github.com/Cantera/cantera/pull/581))
- Add factories for `FlowDevice` and `Wall` objects, to enable creation of user-defined derived classes ([#632](https://github.com/Cantera/cantera/pull/632))
- Allow classes derived from `StFlow` to have additional state variables ([#624](https://github.com/Cantera/cantera/pull/624))
- Add wrappers to make `piecewise-Gibbs` and `NASA9` species thermo objects accessible in Python ([#711](https://github.com/Cantera/cantera/pull/711))
- Add `set_equivalence_ratio` function to `SolutionArray` objects ([#677](https://github.com/Cantera/cantera/pull/677))
- Add ability to sort `SolutionArray` objects ([#688](https://github.com/Cantera/cantera/pull/688))
- Support use of Sundials versions up to 5.7 ([`5e226535d`](https://github.com/Cantera/cantera/commit/5e226535de33a73dd59429eb54ef5d157d0afaa1), [#672](https://github.com/Cantera/cantera/pull/672), [#780](https://github.com/Cantera/cantera/pull/780), [#814](https://github.com/Cantera/cantera/pull/814), [#974](https://github.com/Cantera/cantera/pull/974))
- Add functions for setting species aliases and finding isomers ([#714](https://github.com/Cantera/cantera/pull/714), [#876](https://github.com/Cantera/cantera/pull/876))
- Added `warn_user` function as a consistent way of issuing warnings from C++ ([#741](https://github.com/Cantera/cantera/pull/741))
- Add get/set equivalenceRatio/mixtureFraction functions to C++ ([#851](https://github.com/Cantera/cantera/pull/851))
- Make `getDeltaEnthalpies` available in the Matlab interface ([#659](https://github.com/Cantera/cantera/pull/659))
- Add `TabulatedFunction` class for providing time-varying reactor inputs specified by tabular input ([#797](https://github.com/Cantera/cantera/pull/797))
- Add plug flow reactor example in MATLAB ([#701](https://github.com/Cantera/cantera/pull/701))
- Make `liquid-water-IAPWS95` available as a phase model ([#921](https://github.com/Cantera/cantera/pull/921))
- Make species charge information available in Python ([#863](https://github.com/Cantera/cantera/pull/863))
- Add `kinetics_species_name` and `kinetics_species_names` functions to Python interface ([`5601ee906`](https://github.com/Cantera/cantera/commit/5601ee906741a539b8316ad9dad0cc7dbf4d6d68))
- Added `list_data_files` function to Python module ([#589](https://github.com/Cantera/cantera/pull/589))
- Add `fast_fail_tests` option to SCons ([#772](https://github.com/Cantera/cantera/pull/772))
- Add some functions which were missing from the Fortran interface ([#828](https://github.com/Cantera/cantera/pull/828), [#858](https://github.com/Cantera/cantera/pull/858), [#870](https://github.com/Cantera/cantera/pull/870))
- Provide `const` versions of certain functions ([#850](https://github.com/Cantera/cantera/pull/850), [`9aa507a09`](https://github.com/Cantera/cantera/commit/9aa507a0988e9b12724f1c25ef23a67f4b04cd27))
- Expand `~` as user homedir shortcut when adding data directories ([`ca8700fdd`](https://github.com/Cantera/cantera/commit/ca8700fdd406f148dd27bb238fc748f00ede69f4))

## Changes to existing features

- Remove support for Python 2 ([#560](https://github.com/Cantera/cantera/pull/560), [#611](https://github.com/Cantera/cantera/pull/611))
- Update physical constants based on 2018 CODATA values, and atomic weights to 2018 IUPAC/CIAAW values ([#653](https://github.com/Cantera/cantera/pull/653))
- Deprecated some redundant or rarely-used classes and functions. See the deprecation lists for <a href="https://cantera.org/2.5/doxygen/html/da/d58/deprecated.html">C++</a> and <a href="https://cantera.org/2.5/sphinx/html/search.html?q=deprecated&check_keywords=yes&area=default">Python / Matlab / Input files</a>. ([#580](https://github.com/Cantera/cantera/pull/580), [#588](https://github.com/Cantera/cantera/pull/588), [#645](https://github.com/Cantera/cantera/pull/645), [#643](https://github.com/Cantera/cantera/pull/643), [#660](https://github.com/Cantera/cantera/pull/660), [#733](https://github.com/Cantera/cantera/pull/733), [#735](https://github.com/Cantera/cantera/pull/735), [#762](https://github.com/Cantera/cantera/pull/762), [#787](https://github.com/Cantera/cantera/pull/787), [#790](https://github.com/Cantera/cantera/pull/790), [#806](https://github.com/Cantera/cantera/pull/806), [#815](https://github.com/Cantera/cantera/pull/815), [#864](https://github.com/Cantera/cantera/pull/864), [`35be561d9`](https://github.com/Cantera/cantera/commit/35be561d99c4ee8f544db4016849d94bf26b4df6), [`27d9b6413`](https://github.com/Cantera/cantera/commit/27d9b6413a6b12a84947db72658c1785e8c1393f))
- Build and test the sample programs / scripts as part of the CI process ([`1ec9ce2c0`](https://github.com/Cantera/cantera/commit/1ec9ce2c01da81479952dcc12140634d9bd4d9ff), [#649](https://github.com/Cantera/cantera/pull/649), [#776](https://github.com/Cantera/cantera/pull/776), [#874](https://github.com/Cantera/cantera/pull/874), [#883](https://github.com/Cantera/cantera/pull/883), [#905](https://github.com/Cantera/cantera/pull/905), [#923](https://github.com/Cantera/cantera/pull/923), [#927](https://github.com/Cantera/cantera/pull/927))
- Improve handling of phases where the intrinsic state variables are not temperature and density ([#720](https://github.com/Cantera/cantera/pull/720))
- Improve detection and handling of errors in Chemkin input files ([#585](https://github.com/Cantera/cantera/pull/585), [`b2acc43a8`](https://github.com/Cantera/cantera/commit/b2acc43a813fd755a4b60bca87006dc7a72a74a0), [`4f4a2bd07`](https://github.com/Cantera/cantera/commit/4f4a2bd07162a67ca96dcc9f514dbab29beedcfe), [`d04fd8cc3`](https://github.com/Cantera/cantera/commit/d04fd8cc39cb9982aafe7cac28b58174b5fd6a81))
- Consolidate and report all errors when adding reactions, instead of just failing on the first one ([#903](https://github.com/Cantera/cantera/pull/903), [#946](https://github.com/Cantera/cantera/pull/946))
- Use 'Q' instead of 'X' for the quality (vapor fraction) of two-phase mixtures in Python ([#719](https://github.com/Cantera/cantera/pull/719))
- Always use temperature of the "reacting" phase for interface kinetics ([`6c82b61c3`](https://github.com/Cantera/cantera/commit/6c82b61c3d8b6738a8a9edb5c062fa3c50423d96))
- Make interface for setting parameters for Valves and PressureControllers more intuitive ([#667](https://github.com/Cantera/cantera/pull/667), [#682](https://github.com/Cantera/cantera/pull/682))
- Add N2 to `h2o2.yaml` ([#959](https://github.com/Cantera/cantera/pull/959))
- Make CVODES integrator `max_time_step` a property in the Python module ([#731](https://github.com/Cantera/cantera/pull/731))
- Switch CI to GitHub Actions ([#775](https://github.com/Cantera/cantera/pull/775), [#884](https://github.com/Cantera/cantera/pull/884), [#889](https://github.com/Cantera/cantera/pull/889), [#957](https://github.com/Cantera/cantera/pull/957))
- Use experimentally-derived O2/O2- collision integral in ionized flames ([#552](https://github.com/Cantera/cantera/pull/552))
- Consistently use `CanteraError` in Python examples ([#596](https://github.com/Cantera/cantera/pull/596), [`05eaa0a5e`](https://github.com/Cantera/cantera/commit/05eaa0a5e4d0c73c5827f7f2c9bbd090d68e8c30))
- Add option to use case-sensitive species names ([#689](https://github.com/Cantera/cantera/pull/689))
- Treat deprecation warnings issued from Python and C++ consistently ([#796](https://github.com/Cantera/cantera/pull/796))
- Improve sample build scripts on maCOS ([#612](https://github.com/Cantera/cantera/pull/612))
- Updated the `diamond_cvd.py` example to include plotting the output ([#630](https://github.com/Cantera/cantera/pull/630))
- Make GRI-3.0 mechanisms consistent with latest online version ([#718](https://github.com/Cantera/cantera/pull/718))
- Follow Python naming convention for arguments to `ThermoPhase.equilibrate` ([#684](https://github.com/Cantera/cantera/pull/684))
- Remove unused Chemkin input files from the source distribution ([#799](https://github.com/Cantera/cantera/pull/799))
- Move `heat_release_rate` method to Python `Kinetics` class ([#810](https://github.com/Cantera/cantera/pull/810))
- Automatically add `negative_A` option for third body reactions when converting from Chemkin input ([#822](https://github.com/Cantera/cantera/pull/822))
- Allow negative pre-exponential factor for falloff reactions ([#868](https://github.com/Cantera/cantera/pull/868))
- Search current working directory before built-in data directories when using Python ([#792](https://github.com/Cantera/cantera/pull/792))
- Check for additional invalid string-to-double conversions when parsing composition strings ([`84535483f`](https://github.com/Cantera/cantera/commit/84535483f9ba768c72196fccf2e9ac2c1ee9d0dd))
- The default branch for the Cantera Git repository is now named `main` ([#890](https://github.com/Cantera/cantera/pull/890))
- Include more significant digits for Redlich-Kwong coefficients when converting from CTI to XML ([`ec7f77943`](https://github.com/Cantera/cantera/commit/ec7f779434d705ea5097abdc88a723e1dd4c96e8))

## Bugs fixed

- Fixed various compilation issues on specific platforms and with certain SCons/compiler options ([#561](https://github.com/Cantera/cantera/pull/561), [#572](https://github.com/Cantera/cantera/pull/572), [#601](https://github.com/Cantera/cantera/pull/601), [#648](https://github.com/Cantera/cantera/pull/648), [#661](https://github.com/Cantera/cantera/pull/661), [#674](https://github.com/Cantera/cantera/pull/674), [#676](https://github.com/Cantera/cantera/pull/676), [#685](https://github.com/Cantera/cantera/pull/685), [#742](https://github.com/Cantera/cantera/pull/742), [#765](https://github.com/Cantera/cantera/pull/765), [#779](https://github.com/Cantera/cantera/pull/779), [#803](https://github.com/Cantera/cantera/pull/803), [#824](https://github.com/Cantera/cantera/pull/824), [#879](https://github.com/Cantera/cantera/pull/879), [#891](https://github.com/Cantera/cantera/pull/891), [#918](https://github.com/Cantera/cantera/pull/918), [#960](https://github.com/Cantera/cantera/pull/960), [#962](https://github.com/Cantera/cantera/pull/962), [#973](https://github.com/Cantera/cantera/pull/973), [`46b7cf180`](https://github.com/Cantera/cantera/commit/46b7cf180a9c10bf27330de804353c9ded792b7f))
- Fix handling of local quantity units rate for Chebyshev rate constants when converting Chemkin input files ([#600](https://github.com/Cantera/cantera/pull/600))
- Fix setting of Soret and multicomponent diffusion options after exceptions when using the `auto` option to `Sim1D.solve` ([#631](https://github.com/Cantera/cantera/pull/631))
- Disable free flame domain width check when `auto=False` ([#690](https://github.com/Cantera/cantera/pull/690))
- Allow setting beta = 0 for electrochemical reactions ([#955](https://github.com/Cantera/cantera/pull/955))
- Fix Redlich-Kwong phase to not use the element potential equilibrium solver ([#898](https://github.com/Cantera/cantera/pull/898))
- Fix erroneously-rounded transport coefficients in input files derived from GRI 3.0 ([#598](https://github.com/Cantera/cantera/pull/598))
- Use correct phase state after `Reactor` mass flow rate evaluation ([#651](https://github.com/Cantera/cantera/pull/651))
- Avoid NaN in entropy with small negative mass fractions ([#686](https://github.com/Cantera/cantera/pull/686))
- Fix conversion of Chemkin input files with surface reactions with explicit reverse rates ([#754](https://github.com/Cantera/cantera/pull/754))
- Fix conditional property updates in `IonGasTransport` ([#568](https://github.com/Cantera/cantera/pull/568))
- Fix Chebyshev rate evaluation with only 1 point in T or P ([#706](https://github.com/Cantera/cantera/pull/706))
- Check for non-existent species in reaction orders when adding reactions ([`e4362d37e`](https://github.com/Cantera/cantera/commit/e4362d37e7cf2d527a14c6202868b5ffd76f2436))
- Fix various edge cases for saturated `PureFluid` states ([#907](https://github.com/Cantera/cantera/pull/907))
- Fix comparisons of non-numeric text in `test_problems` ([#785](https://github.com/Cantera/cantera/pull/785))
- Prevent overwriting of pre-existing extra `SolutionArray` columns ([#820](https://github.com/Cantera/cantera/pull/820))
- Fix slicing of `SolutionArray` ([#816](https://github.com/Cantera/cantera/pull/816), [#837](https://github.com/Cantera/cantera/pull/837))
- Prevent erroneous creation of standalone `Kinetics` and `Transport` objects in Python ([#845](https://github.com/Cantera/cantera/pull/845))
- Ensure that the mass flow rate returned by `FlowDevice` objects is correct after a call to `ReactorNet::advance` ([#886](https://github.com/Cantera/cantera/pull/886))
- Fix indexed assignment of 'extra' columns in `SolutionArray` ([#838](https://github.com/Cantera/cantera/pull/838))
- Fix handling of reaction units settings not on last line when convert Chemkin input files ([`540777c32`](https://github.com/Cantera/cantera/commit/540777c32b57d99c61d0bf1e2cc825353be4846b))
- Fix over-zealous detection of section 'end' labels when converting Chemkin input files ([`e3424d8ed`](https://github.com/Cantera/cantera/commit/e3424d8ed49f5f7611bc94933109292d32b732ec))
- Fix building and installing the minimal Python package ([#928](https://github.com/Cantera/cantera/pull/928), [#974](https://github.com/Cantera/cantera/pull/974))
- Check for a valid species index in `ThermoPhase::species()` ([#949](https://github.com/Cantera/cantera/pull/949))
- Fix some corner cases in `Sim1D::setFixedTemperature` ([#936](https://github.com/Cantera/cantera/pull/936))
- Retain user-specified products in counterflow premixed flame when using "auto" option ([`b63354447`](https://github.com/Cantera/cantera/commit/b633544477facbb9f4390b380a2e7edefac79010))
- Fix refinement check in `ic_engine.py` example ([`d9b95b2ef`](https://github.com/Cantera/cantera/commit/d9b95b2efbe6c512f00f72fe2e0bf4fda76ba7e6))
- Fix issues with Blasius BVP example, and install it with other C++ samples ([`dc0904027`](https://github.com/Cantera/cantera/commit/dc09040274370149c6dafb05e126e875e0db6549), [`600580ead`](https://github.com/Cantera/cantera/commit/600580ead4906339fee0bae6a80356ec5d3a4191), [`c26db356e`](https://github.com/Cantera/cantera/commit/c26db356e3523c89878e8a6f5b5cd5d64dc32b73), [`b9a5913af`](https://github.com/Cantera/cantera/commit/b9a5913af01cb316734f3742d111614fc0a957b1), [`22efbe25d`](https://github.com/Cantera/cantera/commit/22efbe25dc97c2e42960c7cf09335ca546ec8ef5), [`8c213da93`](https://github.com/Cantera/cantera/commit/8c213da93226859e741ac108333f1b08c4db7b24))

## Documentation updates

- Fix errors in equations ([#557](https://github.com/Cantera/cantera/pull/557), [#970](https://github.com/Cantera/cantera/pull/970), [`3ff5d87b8`](https://github.com/Cantera/cantera/commit/3ff5d87b815eb6c299745954947ff566e55066cc), [`c1d721dc9`](https://github.com/Cantera/cantera/commit/c1d721dc94b4f5f8dedc47a4d8066bb24d761599))
- Improve "offline" builds of API documentation ([#562](https://github.com/Cantera/cantera/pull/562))
- Document required versions of Cantera and dependencies for Python examples ([#729](https://github.com/Cantera/cantera/pull/729), [#756](https://github.com/Cantera/cantera/pull/756))
- Update `AUTHORS` list to include authors from all Cantera organization repos ([#573](https://github.com/Cantera/cantera/pull/573))
- Fix various typos and other issues ([#591](https://github.com/Cantera/cantera/pull/591), [#627](https://github.com/Cantera/cantera/pull/627), [#636](https://github.com/Cantera/cantera/pull/636), [#673](https://github.com/Cantera/cantera/pull/673), [#709](https://github.com/Cantera/cantera/pull/709), [#726](https://github.com/Cantera/cantera/pull/726), [#744](https://github.com/Cantera/cantera/pull/744), [#770](https://github.com/Cantera/cantera/pull/770), [#771](https://github.com/Cantera/cantera/pull/771), [#781](https://github.com/Cantera/cantera/pull/781), [#790](https://github.com/Cantera/cantera/pull/790), [#793](https://github.com/Cantera/cantera/pull/793), [#939](https://github.com/Cantera/cantera/pull/939), [`50997a165`](https://github.com/Cantera/cantera/commit/50997a165119ccb997206e4738750621510bbd79), [`9f5dfbdb1`](https://github.com/Cantera/cantera/commit/9f5dfbdb1273c05d176c58ab62fe7dbb12d24a94), [`442433ad3`](https://github.com/Cantera/cantera/commit/442433ad3738ecf17052811bd5751d77666b558b), [#975](https://github.com/Cantera/cantera/pull/975), [#976](https://github.com/Cantera/cantera/pull/976))
