# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from collections.abc import Callable
from pathlib import Path
from typing import Any, Literal, ParamSpec, TypeAlias, TypeVar

from pint import Quantity
from pint.registry import ApplicationRegistry

from .._types import Array, CompositionLike
from .._utils import CanteraError as CanteraError

__all__: list[str] = [
    "Q_",
    "CanteraError",
    "CarbonDioxide",
    "Heptane",
    "Hfc134a",
    "Hydrogen",
    "Methane",
    "Nitrogen",
    "Oxygen",
    "PureFluid",
    "Solution",
    "Water",
    "units",
]

# Define some helpful type aliases
_PropertyPairSetter: TypeAlias = tuple[Quantity | None, Quantity | None]
_StateSetter: TypeAlias = tuple[
    Quantity | None, Quantity | None, Quantity | CompositionLike
]

units: ApplicationRegistry
Q_: type[Quantity]

_P = ParamSpec("_P")
_T = TypeVar("_T")
def copy_doc(method: Callable[_P, _T]) -> Callable[_P, _T]: ...

class Solution:
    def __init__(
        self, infile: Path | str = "", name: str = "", *, yaml: str | None = None
    ) -> None: ...
    @copy_doc
    def report(self, *args: Any, **kwargs: Any) -> str: ...
    def __call__(self, *args: Any, **kwargs: Any) -> None: ...
    @property
    def basis_units(self) -> Literal["kg", "kmol"]: ...
    @property
    @copy_doc
    def X(self) -> Quantity: ...
    @X.setter
    def X(self, value: Quantity | CompositionLike | None) -> None: ...
    @property
    @copy_doc
    def Y(self) -> Quantity: ...
    @Y.setter
    def Y(self, value: Quantity | CompositionLike | None) -> None: ...
    @property
    @copy_doc
    def density_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def density_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def enthalpy_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def enthalpy_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def entropy_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def entropy_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def int_energy_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def int_energy_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def volume_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def volume_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def gibbs_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def gibbs_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def cp_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def cp_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def cv_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def cv_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def P(self) -> Quantity: ...
    @property
    @copy_doc
    def P_sat(self) -> Quantity: ...
    @property
    @copy_doc
    def T(self) -> Quantity: ...
    @property
    @copy_doc
    def T_sat(self) -> Quantity: ...
    @property
    @copy_doc
    def atomic_weight(self) -> Quantity: ...
    @property
    @copy_doc
    def chemical_potentials(self) -> Quantity: ...
    @property
    @copy_doc
    def concentrations(self) -> Quantity: ...
    @property
    @copy_doc
    def critical_pressure(self) -> Quantity: ...
    @property
    @copy_doc
    def critical_temperature(self) -> Quantity: ...
    @property
    @copy_doc
    def critical_density(self) -> Quantity: ...
    @property
    @copy_doc
    def electric_potential(self) -> Quantity: ...
    @property
    @copy_doc
    def electrochemical_potentials(self) -> Quantity: ...
    @property
    @copy_doc
    def isothermal_compressibility(self) -> Quantity: ...
    @property
    @copy_doc
    def sound_speed(self) -> Quantity: ...
    @property
    @copy_doc
    def max_temp(self) -> Quantity: ...
    @property
    @copy_doc
    def mean_molecular_weight(self) -> Quantity: ...
    @property
    @copy_doc
    def min_temp(self) -> Quantity: ...
    @property
    @copy_doc
    def molecular_weights(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_cp(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_enthalpies(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_entropies(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_int_energies(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_volumes(self) -> Quantity: ...
    @property
    @copy_doc
    def reference_pressure(self) -> Quantity: ...
    @property
    @copy_doc
    def thermal_expansion_coeff(self) -> Quantity: ...
    @property
    @copy_doc
    def cp(self) -> Quantity: ...
    @property
    @copy_doc
    def cv(self) -> Quantity: ...
    @property
    @copy_doc
    def density(self) -> Quantity: ...
    @property
    @copy_doc
    def h(self) -> Quantity: ...
    @property
    @copy_doc
    def s(self) -> Quantity: ...
    @property
    @copy_doc
    def g(self) -> Quantity: ...
    @property
    @copy_doc
    def u(self) -> Quantity: ...
    @property
    @copy_doc
    def v(self) -> Quantity: ...
    @property
    @copy_doc
    def TP(self) -> tuple[Quantity, Quantity]: ...
    @TP.setter
    def TP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def DP(self) -> tuple[Quantity, Quantity]: ...
    @DP.setter
    def DP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def HP(self) -> tuple[Quantity, Quantity]: ...
    @HP.setter
    def HP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def SP(self) -> tuple[Quantity, Quantity]: ...
    @SP.setter
    def SP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def SV(self) -> tuple[Quantity, Quantity]: ...
    @SV.setter
    def SV(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def TD(self) -> tuple[Quantity, Quantity]: ...
    @TD.setter
    def TD(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def UV(self) -> tuple[Quantity, Quantity]: ...
    @UV.setter
    def UV(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def TPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TPX.setter
    def TPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def TPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TPY.setter
    def TPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def DPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @DPX.setter
    def DPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def DPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @DPY.setter
    def DPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def HPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @HPX.setter
    def HPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def HPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @HPY.setter
    def HPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SPX.setter
    def SPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SPY.setter
    def SPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SVX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SVX.setter
    def SVX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SVY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SVY.setter
    def SVY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def TDX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TDX.setter
    def TDX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def TDY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TDY.setter
    def TDY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def UVX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @UVX.setter
    def UVX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def UVY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @UVY.setter
    def UVY(self, value: _StateSetter) -> None: ...

class PureFluid:
    def __init__(
        self,
        infile: Path | str,
        name: str = "",
        *,
        yaml: str | None = None,
        **kwargs: Any,
    ) -> None: ...
    @copy_doc
    def report(self, *args: Any, **kwargs: Any) -> str: ...
    def __call__(self, *args: Any, **kwargs: Any) -> None: ...
    @property
    def basis_units(self) -> Literal["kg", "kmol"]: ...
    @property
    @copy_doc
    def X(self) -> Quantity: ...
    @X.setter
    def X(self, value: Quantity | CompositionLike | None) -> None: ...
    @property
    @copy_doc
    def Y(self) -> Quantity: ...
    @Y.setter
    def Y(self, value: Quantity | CompositionLike | None) -> None: ...
    @property
    @copy_doc
    def Q(self) -> Quantity: ...
    @Q.setter
    def Q(self, value: Quantity | None) -> None: ...
    @property
    @copy_doc
    def density_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def density_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def enthalpy_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def enthalpy_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def entropy_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def entropy_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def int_energy_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def int_energy_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def volume_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def volume_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def gibbs_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def gibbs_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def cp_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def cp_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def cv_mass(self) -> Quantity: ...
    @property
    @copy_doc
    def cv_mole(self) -> Quantity: ...
    @property
    @copy_doc
    def P(self) -> Quantity: ...
    @property
    @copy_doc
    def P_sat(self) -> Quantity: ...
    @property
    @copy_doc
    def T(self) -> Quantity: ...
    @property
    @copy_doc
    def T_sat(self) -> Quantity: ...
    @property
    @copy_doc
    def atomic_weight(self) -> Quantity: ...
    @property
    @copy_doc
    def chemical_potentials(self) -> Quantity: ...
    @property
    @copy_doc
    def concentrations(self) -> Quantity: ...
    @property
    @copy_doc
    def critical_pressure(self) -> Quantity: ...
    @property
    @copy_doc
    def critical_temperature(self) -> Quantity: ...
    @property
    @copy_doc
    def critical_density(self) -> Quantity: ...
    @property
    @copy_doc
    def electric_potential(self) -> Quantity: ...
    @property
    @copy_doc
    def electrochemical_potentials(self) -> Quantity: ...
    @property
    @copy_doc
    def isothermal_compressibility(self) -> Quantity: ...
    @property
    @copy_doc
    def sound_speed(self) -> Quantity: ...
    @property
    @copy_doc
    def max_temp(self) -> Quantity: ...
    @property
    @copy_doc
    def mean_molecular_weight(self) -> Quantity: ...
    @property
    @copy_doc
    def min_temp(self) -> Quantity: ...
    @property
    @copy_doc
    def molecular_weights(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_cp(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_enthalpies(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_entropies(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_int_energies(self) -> Quantity: ...
    @property
    @copy_doc
    def partial_molar_volumes(self) -> Quantity: ...
    @property
    @copy_doc
    def reference_pressure(self) -> Quantity: ...
    @property
    @copy_doc
    def thermal_expansion_coeff(self) -> Quantity: ...
    @property
    @copy_doc
    def cp(self) -> Quantity: ...
    @property
    @copy_doc
    def cv(self) -> Quantity: ...
    @property
    @copy_doc
    def density(self) -> Quantity: ...
    @property
    @copy_doc
    def h(self) -> Quantity: ...
    @property
    @copy_doc
    def s(self) -> Quantity: ...
    @property
    @copy_doc
    def g(self) -> Quantity: ...
    @property
    @copy_doc
    def u(self) -> Quantity: ...
    @property
    @copy_doc
    def v(self) -> Quantity: ...
    @property
    @copy_doc
    def TP(self) -> tuple[Quantity, Quantity]: ...
    @TP.setter
    def TP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def DP(self) -> tuple[Quantity, Quantity]: ...
    @DP.setter
    def DP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def HP(self) -> tuple[Quantity, Quantity]: ...
    @HP.setter
    def HP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def SP(self) -> tuple[Quantity, Quantity]: ...
    @SP.setter
    def SP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def SV(self) -> tuple[Quantity, Quantity]: ...
    @SV.setter
    def SV(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def TD(self) -> tuple[Quantity, Quantity]: ...
    @TD.setter
    def TD(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def UV(self) -> tuple[Quantity, Quantity]: ...
    @UV.setter
    def UV(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def TPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TPX.setter
    def TPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def TPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TPY.setter
    def TPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def DPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @DPX.setter
    def DPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def DPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @DPY.setter
    def DPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def HPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @HPX.setter
    def HPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def HPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @HPY.setter
    def HPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SPX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SPX.setter
    def SPX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SPY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SPY.setter
    def SPY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SVX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SVX.setter
    def SVX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def SVY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @SVY.setter
    def SVY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def TDX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TDX.setter
    def TDX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def TDY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TDY.setter
    def TDY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def UVX(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @UVX.setter
    def UVX(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def UVY(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @UVY.setter
    def UVY(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def TPQ(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @TPQ.setter
    def TPQ(self, value: _StateSetter) -> None: ...
    @property
    @copy_doc
    def PQ(self) -> tuple[Quantity, Quantity]: ...
    @PQ.setter
    def PQ(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def TQ(self) -> tuple[Quantity, Quantity]: ...
    @TQ.setter
    def TQ(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def PV(self) -> tuple[Quantity, Quantity]: ...
    @PV.setter
    def PV(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def SH(self) -> tuple[Quantity, Quantity]: ...
    @SH.setter
    def SH(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def ST(self) -> tuple[Quantity, Quantity]: ...
    @ST.setter
    def ST(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def TH(self) -> tuple[Quantity, Quantity]: ...
    @TH.setter
    def TH(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def TV(self) -> tuple[Quantity, Quantity]: ...
    @TV.setter
    def TV(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def UP(self) -> tuple[Quantity, Quantity]: ...
    @UP.setter
    def UP(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def VH(self) -> tuple[Quantity, Quantity]: ...
    @VH.setter
    def VH(self, value: _PropertyPairSetter) -> None: ...
    @property
    @copy_doc
    def DPQ(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @property
    @copy_doc
    def HPQ(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @property
    @copy_doc
    def SPQ(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @property
    @copy_doc
    def SVQ(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @property
    @copy_doc
    def TDQ(self) -> tuple[Quantity, Quantity, Quantity]: ...
    @property
    @copy_doc
    def UVQ(self) -> tuple[Quantity, Quantity, Quantity]: ...

def Heptane() -> PureFluid: ...
def CarbonDioxide() -> PureFluid: ...
def Hfc134a() -> PureFluid: ...
def Hydrogen() -> PureFluid: ...
def Methane() -> PureFluid: ...
def Nitrogen() -> PureFluid: ...
def Oxygen() -> PureFluid: ...
def Water(backend: Literal["Reynolds", "IAPWS95"] = "Reynolds") -> PureFluid: ...
