/*
 * util.h - utilities
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 *
 * TODO:
 *  - make resolvebyaddr async?
 *
 */

#ifndef UTIL_H_
#define UTIL_H_

#include <stdio.h>
#include <time.h>

/*
 * convert address in network byte order of type 'type' to it's number
 * notation, this is dotted for AF_INET and ::: for AF_INET6
 */
void resolveipbyaddr(char *dst, int dlen, char *addr, int alen, int type);


/*
 * reverse resolve the address in network byte order of type 'type' to it's
 * hostname.
 *
 * Warning: This call blocks!
 */
int resolvebyaddr(char *dst, int dlen, char *addr, int alen, int type);


/*
 * return argument i as char* pointing to a static buffer
 */
char * as_string(int i);

/*
 * summarize the long long argument and shorten it to another unit. The
 * char ** argument will point to the used unit after the call.
 * e.g. input: 231323434 -> return value: 220.61 *u: MB
 */
float sumup(unsigned long long, char **u);

/*
 * summarize the time_t argument and shorten it to another time unit.
 * e.g. input 343 -> return value: 5.7167 *u: m
 */
time_t time_sumup(time_t, char **u);

#endif
