/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Ball.h"


Ball::Ball(){
	visible=false;
	special=false;
	square=new Square();
	bounced=false;
} 

Ball::Ball(bool b){
	visible=false;
	special=b;
	square=new Square();
	bounced=false;
}

Ball::~Ball(){
	delete square;
}

void Ball::set_special(bool s){
	special=s;
}

void Ball::place(Square *s){
    square->set_xy(s->get_x(),s->get_y()); 
} 

void Ball::place(int x,int y){
    square->set_xy(x,y); 
} 

Square* Ball::get_square(){
	return square;
} 

bool Ball::is_special(){
	return special;
} 

bool Ball::is_visible(){
	return visible;
}

void Ball::set_visible(bool v){
	visible=v;
}

void Ball::bounce(){
	set_visible(true);
	Dice* d8 = new Dice(D8);
	switch(d8->roll()){
		case N: move(0,-1);break; 
		case S: move(0,+1);break; 
		case E: move(+1,0);break; 
		case W: move(-1,0);break; 
		case NE: move(+1,-1);break; 
		case NW: move(-1,-1);break; 
		case SE: move(+1,+1);break; 
		case SW: move(-1,+1);break;
	}
	delete d8;
}  
  
void Ball::move(int x_diff,int y_diff){
    int x = square->get_x();
    int y = square->get_y();
    square->set_xy(x+x_diff ,y+y_diff);
}

bool Ball::has_bounced(void){
	return bounced;
}

void Ball::set_has_bounced(bool b){
	bounced = b;
}

void Ball::save_state(FILE *fd,int depth){
    char format[10];
	memset(format,0,10);
	for(int i=0;i<depth;i++)
		format[i] = ' ';
		format[depth-1] = '\0';

	fprintf(fd,"%s<special>%i</special>\n",format,special);
	fprintf(fd,"%s<visible>%i</visible>\n",format,visible);
	fprintf(fd,"%s<bounced>%i</bounced>\n",format,bounced);
	fprintf(fd,"%s<x>%i</x>\n",format,(square)?square->get_x():-1);
	fprintf(fd,"%s<y>%i</y>\n",format,(square)?square->get_y():-1);
}
