/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2002 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Config.h"

int Config::screen_w = 800;
int Config::screen_h = 600;
int Config::future_screen_w = 0;
int Config::future_screen_h = 0;
bool Config::sound_enabled = false;
bool Config::video_enabled = false;
int Config::language = 0;
bool Config::initialized = false;

Config::Config(){;}

Config::~Config(){;}

int Config::get_screen_w(){
	return screen_w;
}

int Config::get_screen_h(){
	return screen_h;
}

bool Config::is_sound_enabled(){
	return sound_enabled;
}

bool Config::is_video_enabled(){
	return video_enabled;
}

int Config::get_language(){
	return language;
}

void Config::set_sound_enabled(bool b){
	sound_enabled = b;
}

void Config::set_video_enabled(bool b){
	video_enabled = b;
}

void Config::set_language(int i){
	language = i;
}

void Config::set_future_resolution(int w,int h){
	future_screen_w = w;
	future_screen_h = h;
}

void Config::set_future_resolution(int i){
	switch(i){
	case 0:
		set_future_resolution(800,600);
		break;
	case 1:
		set_future_resolution(1024,768);
		break;
	case 2:
		set_future_resolution(1024,1054);
		break;
	default:
		break;
	}
}

int Config::load(){
	if(initialized){ return 1;}
	
	config_data_t* cd = xml_load_config(CONFIG_FILE);
	if(cd && cd->ok) {
		screen_w = cd->screen_w; 
		screen_h = cd->screen_h;
		sound_enabled = cd->sound_enabled;
		video_enabled = cd->video_enabled;
		language = cd->language;
	}
	free(cd);
	initialized = true;
	
	return 0;
}

int Config::reload(){
	config_data_t* cd = xml_load_config(CONFIG_FILE);
	if(cd && cd->ok) {
		screen_w = cd->screen_w; 
		screen_h = cd->screen_h;
		sound_enabled = cd->sound_enabled;
		video_enabled = cd->video_enabled;
		language = cd->language;
	}
	free(cd);
	return 0;
}

int Config::save(){
	config_data_t* c = (config_data_t*) malloc( sizeof(config_data_t) );
	c->screen_w = (future_screen_w==0)?(screen_w):(future_screen_w);
	c->screen_h = (future_screen_h==0)?(screen_h):(future_screen_h);
	c->sound_enabled = sound_enabled;
	c->video_enabled = video_enabled;
	c->language = language;
	int r = xml_save_config(c,CONFIG_FILE);
	free(c);
	return r;

}
